/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbd.business.retrieval.RetrievalRuleHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalParamConstants;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;

public class RetrievalRuleList
extends HRDataBaseList {
    private Boolean isUpgradeSuccess = Boolean.FALSE;

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getView().setEnable(this.isUpgradeSuccess, new String[]{"tblnew", "tblcopy", "tbldel", "tbldisable", "tblenable", "tblrefresh", "log", "tblclose"});
        if (!this.isUpgradeSuccess.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        QFilter listFilter = new QFilter("id", "not in", (Object)RetrievalParamConstants.NOT_ADAPTED_RULE_IDS);
        evt.getCustomQFilters().add(listFilter);
        evt.setOrderBy("createtime desc,modifytime desc");
        this.isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        boolean isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
        evt.getParameter().setCustomParam("isUpgradeSuccess", (Object)Boolean.toString(isUpgradeSuccess));
        if (!isUpgradeSuccess) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] pkIds;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] ruleDys;
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"disable") && WTCCollections.isNotEmpty((Collection)(listSelectedData = args.getListSelectedData())) && null != (ruleDys = (serviceHelper = new HRBaseServiceHelper("wtbd_scenerulecfg")).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)(pkIds = listSelectedData.getPrimaryKeyValues()))})) && ruleDys.length > 0) {
            for (DynamicObject ruleDy : ruleDys) {
                boolean isSysPreset = ruleDy.getBoolean("issyspreset");
                if (!isSysPreset) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u53ef\u7981\u7528\u3002", (String)"RetrievalRuleList_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        if (packageDataEvent.getSource() instanceof ColumnDesc) {
            List list;
            ColumnDesc column = (ColumnDesc)packageDataEvent.getSource();
            if (!"usecfgname".equals(column.getFieldKey())) {
                return;
            }
            DynamicObject rowData = packageDataEvent.getRowData();
            if (null == rowData) {
                return;
            }
            long ruleId = rowData.getLong("id");
            String useCfgNameMapStr = this.getPageCache().get("cacheUseCfgMap");
            if (HRStringUtils.isEmpty((String)useCfgNameMapStr)) {
                return;
            }
            Map cacheMap = (Map)SerializationUtils.fromJsonString((String)useCfgNameMapStr, Map.class);
            if (WTCCollections.isNotEmpty((Map)cacheMap) && cacheMap.containsKey(String.valueOf(ruleId)) && WTCCollections.isNotEmpty((Collection)(list = (List)cacheMap.get(String.valueOf(ruleId))))) {
                String value = list.stream().map(config -> config.get("name").toString()).collect(Collectors.joining("\uff0c"));
                packageDataEvent.setFormatValue((Object)value);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.initializeUseCfgNameMap();
    }

    private void initializeUseCfgNameMap() {
        Map map = RetrievalRuleHelper.getAllRelatedUseCfgMap();
        HashMap cacheMap = new HashMap(map.size());
        if (WTCCollections.isNotEmpty((Map)map)) {
            map.forEach((ruleId, useCfgDys) -> cacheMap.put(String.valueOf(ruleId), useCfgDys.stream().map(useCfgDy -> {
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("id", useCfgDy.getString("id"));
                dataMap.put("name", useCfgDy.getString("name"));
                return dataMap;
            }).collect(Collectors.toList())));
            this.getPageCache().put("cacheUseCfgMap", SerializationUtils.toJsonString(cacheMap));
        }
    }
}

