/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalRuleHelper;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalRuleKDString;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalRuleParamPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit paramsObject = (BasedataEdit)this.getControl("inputobject");
        if (paramsObject != null) {
            paramsObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object entityId = customParams.get("entityId");
        if (entityId != null) {
            IDataModel model = this.getModel();
            model.setValue("inputnumber", customParams.get("inputnumber"));
            model.setValue("inputname", customParams.get("inputname"));
            model.setValue("inputparamstype", customParams.get("inputparamstype"));
            model.setValue("inputobject", customParams.get("inputobject"));
            model.setValue("dynprop", customParams.get("dynprop"));
            String dynProp = (String)customParams.get("dynprop");
            if (HRStringUtils.isNotEmpty((String)dynProp)) {
                List dynPropList = SerializationUtils.fromJsonStringToList((String)dynProp, Map.class);
                this.setDynamicFieldEntry(dynPropList, false);
            }
            this.getView().updateView("contentpanel");
            this.getModel().setDataChanged(false);
            String isSysPreset = (String)customParams.get("issyspreset");
            if ("1".equals(isSysPreset)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"fieldsetpanelap"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryentity"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("inputobject".equals(name)) {
            String calcType;
            String groupType;
            List allInputObjNumbers;
            List hasItemGroupIds = RetrievalItemHelper.getGroupIdsHasItems();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("category", "in", Stream.of("2", "3").collect(Collectors.toList()));
            qFilter.and(new QFilter("grouptype", "in", Stream.of("1", "2").collect(Collectors.toList())));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object excludeEntity = formShowParameter.getCustomParam("excludeEntity");
            if (excludeEntity != null && !CollectionUtils.isEmpty((Collection)(allInputObjNumbers = (List)excludeEntity))) {
                qFilter.and("numberx", "not in", (Object)allInputObjNumbers);
            }
            if (HRStringUtils.isNotEmpty((String)(groupType = (String)formShowParameter.getCustomParam("grouptype")))) {
                qFilter.and("grouptype", "=", (Object)groupType);
            }
            if (HRStringUtils.isNotEmpty((String)(calcType = (String)formShowParameter.getCustomParam("calctype")))) {
                qFilter.and("calctype", "like", (Object)("%" + calcType + "%"));
            }
            if (!CollectionUtils.isEmpty((Collection)hasItemGroupIds)) {
                qFilter.and("id", "in", (Object)hasItemGroupIds);
            }
            qFilter.and(new QFilter("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds()));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            listShowParameter.setFormId("bos_listf7");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)"wtbd_sceneparamprop", (String)closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map returnDataStr = (Map)SerializationUtils.fromJsonString((String)((String)closedCallBackEvent.getReturnData()), Map.class);
            this.setDynamicFieldEntry((List)returnDataStr.get("refProps"), true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"importfield")) {
            DynamicObject dy = (DynamicObject)this.getModel().getValue("inputobject");
            if (dy != null) {
                this.openBasePropertyRefDialog(String.valueOf(dy.getLong("id")));
            }
        } else if ("ok".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String displayName;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String name = dataEntity.getString("inputname");
            if (!this.validateRepeatParamName(name)) {
                String errMsg = MessageFormat.format(RetrievalRuleKDString.paramsNameExists(), name);
                this.getView().showTipNotification(errMsg);
                return;
            }
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
            HashSet<String> existNames = new HashSet<String>(entries.size());
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>(entries.size());
            for (DynamicObject entry : entries) {
                displayName = entry.getString("fielddisplayname");
                String itemName = entry.getString("fieldid.name");
                if (HRStringUtils.isNotEmpty((String)displayName)) {
                    nameCountMap.put(displayName, nameCountMap.getOrDefault(displayName, 0) + 1);
                    continue;
                }
                nameCountMap.put(itemName, nameCountMap.getOrDefault(itemName, 0) + 1);
            }
            for (DynamicObject entry : entries) {
                displayName = entry.getString("fielddisplayname");
                if (!HRStringUtils.isNotEmpty((String)displayName)) continue;
                if (existNames.contains(displayName) || nameCountMap.containsKey(displayName) && ((Integer)nameCountMap.get(displayName)).compareTo(1) > 0 || !this.validateRepeatDisplayName(displayName)) {
                    String errMsg = MessageFormat.format(RetrievalRuleKDString.displayNameExists(), displayName);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                existNames.add(displayName);
            }
            if (this.presetFieldIdDeleted(entries)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u5220\u9664\u3002", (String)"RetrievalRuleParamPlugin_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject inputObjDy = dataEntity.getDynamicObject("inputobject");
            if (null != inputObjDy && HRStringUtils.equals((String)"1", (String)inputObjDy.getString("grouptype"))) {
                HashMap<String, DynamicObject> fieldListDyMap = new HashMap<String, DynamicObject>(entries.size());
                for (DynamicObject entry : entries) {
                    DynamicObject itemDy = entry.getDynamicObject("fieldid");
                    if (null == itemDy) continue;
                    String belongObjId = itemDy.getString("belongobj.id");
                    String fieldList = itemDy.getString("number");
                    String fieldListKey = belongObjId + fieldList;
                    if (fieldListDyMap.containsKey(fieldListKey)) {
                        DynamicObject itemDy1 = (DynamicObject)fieldListDyMap.get(fieldListKey);
                        String errMsg = MessageFormat.format(RetrievalRuleKDString.sameFieldListFromOneObject(), itemDy1.get("numberx"), itemDy1.get("name"), itemDy.get("numberx"), itemDy.get("name"));
                        this.getView().showTipNotification(errMsg);
                        return;
                    }
                    fieldListDyMap.put(fieldListKey, itemDy);
                }
            }
            this.getView().returnDataToParent((Object)dataEntity);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean presetFieldIdDeleted(DynamicObjectCollection entries) {
        List presetFieldIdList;
        String presetFieldIdListStr = this.getPageCache().get("presetFieldIdList");
        if (HRStringUtils.isNotEmpty((String)presetFieldIdListStr) && WTCCollections.isNotEmpty((Collection)(presetFieldIdList = SerializationUtils.fromJsonStringToList((String)presetFieldIdListStr, String.class)))) {
            List selectFieldIdList = entries.stream().filter(item -> item.getLong("fieldid.id") != 0L).map(item -> String.valueOf(item.getLong("fieldid.id"))).collect(Collectors.toList());
            for (String presetFieldId : presetFieldIdList) {
                if (selectFieldIdList.contains(presetFieldId)) continue;
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData data;
        super.propertyChanged(args);
        ChangeData changeData = data = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? (ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get() : null;
        if (data == null) {
            return;
        }
        String propName = args.getProperty().getName();
        if ("inputobject".equals(propName)) {
            DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entryColl : entryColls) {
                DynamicObject oldValue = (DynamicObject)data.getOldValue();
                String retrievalWay = entryColl.getString("fieldid.way");
                if (!WTCStringUtils.equals((String)"2", (String)retrievalWay)) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5206\u7ec4\u5305\u542b\u81ea\u5b9a\u4e49\u53d6\u6570\u9879\u76ee\uff0c\u4fee\u6539\u9879\u76ee\u5206\u7ec4\u540e\u6b64\u7c7b\u9879\u76ee\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RetrievalRuleParamPlugin_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMCHANGEGROUP", (IFormPlugin)this), null, oldValue != null ? oldValue.getString("id") : null);
                return;
            }
            this.inputObjectChanged();
        }
    }

    private void inputObjectChanged() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("inputobject");
        if (null != object) {
            this.getModel().setValue("inputnumber", object.get("numberx"));
            ILocaleString localeString = object.getLocaleString("name");
            if (localeString != null) {
                this.getModel().setValue("inputname", (Object)localeString);
            }
            this.getModel().setValue("inputname", (Object)localeString);
        } else {
            this.getModel().setValue("inputnumber", null);
        }
        this.getModel().deleteEntryData("entryentity");
        this.getView().updateView("entryentity");
    }

    private boolean validateRepeatParamName(String name) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object allInputNameObj = formShowParameter.getCustomParam("allInputParamName");
        if (allInputNameObj != null) {
            List allInputNameList = (List)allInputNameObj;
            return !allInputNameList.contains(name);
        }
        return true;
    }

    private boolean validateRepeatDisplayName(String name) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object allInputNameObj = formShowParameter.getCustomParam("allRetrievalItemDisplayName");
        if (allInputNameObj != null) {
            List allInputNameList = (List)allInputNameObj;
            return !allInputNameList.contains(name);
        }
        return true;
    }

    private void setDynamicFieldEntry(List<Map<String, Object>> dynamicFieldList, boolean isSort) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map<String, Map> dynamicFieldMap = dynamicFieldList.stream().collect(Collectors.toMap(map -> map.get("fieldid").toString(), map -> map));
        DynamicObjectCollection entryColls = model.getEntryEntity("entryentity");
        Map<String, DynamicObject> existDyMap = entryColls.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("fieldid.id")), dy -> dy));
        if (isSort) {
            HashMap<String, Integer> idToIndexMap = new HashMap<String, Integer>(entryColls.size());
            for (int i = 0; i < entryColls.size(); ++i) {
                idToIndexMap.put(((DynamicObject)entryColls.get(i)).getString("fieldid.id"), i);
            }
            dynamicFieldList = dynamicFieldList.stream().sorted(Comparator.comparingInt(map -> {
                String fieldId = map.get("fieldid").toString();
                return idToIndexMap.getOrDefault(fieldId, Integer.MAX_VALUE);
            })).collect(Collectors.toList());
        }
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fielddisplayname", new Object[0]);
        vs.addField("fieldid", new Object[0]);
        vs.addField("fieldissyspreset", new Object[0]);
        for (Map<String, Object> dynamicObjMap : dynamicFieldList) {
            if (existDyMap.containsKey((String)dynamicObjMap.get("fieldid"))) {
                DynamicObject existDy = existDyMap.get((String)dynamicObjMap.get("fieldid"));
                vs.addRow(new Object[]{existDy.get("fielddisplayname"), dynamicObjMap.get("fieldid"), existDy.get("fieldissyspreset")});
                continue;
            }
            vs.addRow(new Object[]{dynamicObjMap.get("fielddisplayname"), dynamicObjMap.get("fieldid"), dynamicObjMap.get("fieldissyspreset")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        DynamicObjectCollection entryEntities = model.getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntities) {
            String fieldId = entry.getString("fieldid.id");
            if (existDyMap.containsKey(fieldId)) {
                entry.set("id", (Object)existDyMap.get(fieldId).getString("id"));
                continue;
            }
            if (!dynamicFieldMap.containsKey(fieldId)) continue;
            entry.set("id", dynamicFieldMap.get(fieldId).get("id"));
        }
        this.getView().updateView("entryentity");
        ArrayList<String> presetFieldIdList = new ArrayList<String>(10);
        ArrayList<Integer> presetRowIndexs = new ArrayList<Integer>(10);
        for (int i = 0; i < entryEntities.size(); ++i) {
            boolean isPreset = ((DynamicObject)entryEntities.get(i)).getBoolean("fieldissyspreset");
            if (!isPreset) continue;
            presetRowIndexs.add(i);
            presetFieldIdList.add(String.valueOf(((DynamicObject)entryEntities.get(i)).getLong("fieldid.id")));
        }
        if (!presetRowIndexs.isEmpty()) {
            int[] lockRowIndexs = new int[presetRowIndexs.size()];
            for (int i = 0; i < presetRowIndexs.size(); ++i) {
                lockRowIndexs[i] = (Integer)presetRowIndexs.get(i);
            }
            ((EntryGrid)this.getControl("entryentity")).setRowLock(true, lockRowIndexs);
        }
        if (WTCCollections.isNotEmpty(presetFieldIdList)) {
            this.getPageCache().put("presetFieldIdList", SerializationUtils.toJsonString(presetFieldIdList));
        }
    }

    private void openBasePropertyRefDialog(String entityId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("wtbd_sceneparamprop");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        fsp.setStatus(status);
        fsp.setCustomParam("entityId", (Object)entityId);
        List<Map<String, Object>> list = this.getRefPropsList();
        fsp.setCustomParam("value", list);
        fsp.setCustomParam("presetFieldIdList", (Object)this.getPageCache().get("presetFieldIdList"));
        fsp.setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee", (String)"RetrievalRuleParamPlugin_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wtbd_sceneparamprop"));
        this.getView().showForm(fsp);
    }

    private List<Map<String, Object>> getRefPropsList() {
        DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)entryColls.size());
        for (DynamicObject field : entryColls) {
            HashMap fMap = Maps.newHashMapWithExpectedSize((int)4);
            DynamicObject fieldidDy = field.getDynamicObject("fieldid");
            fMap.put("Name", fieldidDy.getString("numberx"));
            fMap.put("fName", fieldidDy.getString("name"));
            fMap.put("fDName", field.getString("fielddisplayname"));
            fMap.put("type", fieldidDy.getString("type"));
            fMap.put("id", String.valueOf(fieldidDy.getLong("id")));
            fieldList.add(fMap);
        }
        return fieldList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"importfield")) {
            DynamicObject dy = (DynamicObject)this.getModel().getValue("inputobject");
            if (dy == null) {
                this.getView().showTipNotification(RetrievalRuleKDString.firstSelectObj());
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            String ruleId;
            int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RetrievalRuleParamPlugin_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
            for (int selectedRow : selectedRows) {
                boolean isSysPreset = ((DynamicObject)entryColls.get(selectedRow)).getBoolean("fieldissyspreset");
                if (!isSysPreset) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u5220\u9664\u3002", (String)"RetrievalRuleParamPlugin_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Map<String, String> paramKeyMap = this.getDeletedParamKeyMap(selectedRows);
            if (RetrievalRuleHelper.checkRetrievalItemUsedByCt(paramKeyMap, (long)Long.parseLong(ruleId = this.getView().getFormShowParameter().getCustomParams().getOrDefault("ruleId", "0")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u5df2\u88ab\u4f7f\u7528\uff0c\u7981\u6b62\u5220\u9664", (String)"RetrievalRuleParamPlugin_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int selectedRow : selectedRows) {
                String retrievalWay = ((DynamicObject)entryColls.get(selectedRow)).getString("fieldid.way");
                if (!HRStringUtils.equals((String)"2", (String)retrievalWay)) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u81ea\u5b9a\u4e49\u53d6\u6570\u9879\u76ee\uff0c\u6b64\u7c7b\u9879\u76ee\u5220\u9664\u540e\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0\u3002\r\n\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u5220\u9664\uff1f", (String)"RetrievalRuleParamPlugin_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMDELETE", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            this.getView().getModel().deleteEntryRows("entryentity", selectedRows);
        }
    }

    private Map<String, String> getDeletedParamKeyMap(int[] selectedRows) {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>(selectedRows.length);
        DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
        for (int selectedRow : selectedRows) {
            String inputNumber = this.getModel().getDataEntity().getString("inputnumber");
            String belongObjNumber = ((DynamicObject)entryColls.get(selectedRow)).getString("fieldid.belongobj.number");
            String fieldNumber = ((DynamicObject)entryColls.get(selectedRow)).getString("fieldid.number");
            String fieldType = ((DynamicObject)entryColls.get(selectedRow)).getString("fieldid.type");
            StringBuilder paramKeyBuffer = new StringBuilder();
            paramKeyBuffer.append(inputNumber);
            if (HRStringUtils.isNotEmpty((String)belongObjNumber)) {
                paramKeyBuffer.append(".").append(belongObjNumber);
            }
            paramKeyBuffer.append(".").append(fieldNumber);
            if (HRStringUtils.equals((String)"dynamicObject", (String)fieldType) && !paramKeyBuffer.toString().endsWith(".id")) {
                paramKeyBuffer.append(".id");
            }
            paramKeyMap.put(paramKeyBuffer.toString(), ((DynamicObject)entryColls.get(selectedRow)).getString("fieldid.id"));
        }
        return paramKeyMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            if ("PAGE_CALL_BACK_FROM_CONFIRMDELETE".equals(event.getCallBackId())) {
                int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
                this.getView().getModel().deleteEntryRows("entryentity", selectedRows);
            } else if ("PAGE_CALL_BACK_FROM_CONFIRMCHANGEGROUP".equals(event.getCallBackId())) {
                this.inputObjectChanged();
            }
        } else if ("PAGE_CALL_BACK_FROM_CONFIRMCHANGEGROUP".equals(event.getCallBackId())) {
            this.getModel().beginInit();
            this.getModel().setValue("inputobject", (Object)event.getCustomVaule());
            this.getModel().endInit();
            this.getView().updateView("inputobject");
        }
    }
}

