/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.scenecfg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgConstants;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class SceneRuleExpressViewPlugin
extends HRDynamicFormBasePlugin
implements SceneCfgConstants {
    private static final Log LOG = LogFactory.getLog(SceneRuleExpressViewPlugin.class);
    private static final String HTML_SPAN_END = "</span>";

    public void afterBindData(EventObject eventObject) {
        try {
            Map<String, Object> paramValues = this.getParamValues();
            String htmlStr = this.getParamExpress(paramValues);
            Html html = (Html)this.getView().getControl("htmlap");
            if (html != null) {
                html.setConent(htmlStr);
            }
        }
        catch (Exception e1) {
            LOG.error((Throwable)e1);
        }
    }

    private String getParamExpress(Map<String, Object> paramValues) {
        Object express = paramValues.get("expresses");
        List paramList = (List)express;
        StringBuilder htmlSb = new StringBuilder("<div>");
        int findex = 0;
        for (Map paramMap : paramList) {
            ++findex;
            htmlSb.append("<span class='leftBracket'>").append(this.ifNullReturnEmpty(paramMap, "leftBracket")).append(HTML_SPAN_END);
            htmlSb.append("<span>\u3010<span class='param'>").append(this.ifNullReturnEmpty(paramMap, "param")).append("</span>\u3011</span>");
            htmlSb.append("<span class='comparisonOpt'>").append(this.ifNullReturnEmpty(paramMap, "comparisonOpt")).append(HTML_SPAN_END);
            htmlSb.append("<span>");
            String value = (String)paramMap.get("value");
            if (HRStringUtils.isNotEmpty((String)value)) {
                htmlSb.append("<span class='value'>").append(value).append(HTML_SPAN_END);
            }
            htmlSb.append(HTML_SPAN_END);
            htmlSb.append("<span class='rightBracket'>").append(this.ifNullReturnEmpty(paramMap, "rightBracket")).append(HTML_SPAN_END);
            boolean addBr = Boolean.parseBoolean((String)paramMap.get("br"));
            if (addBr) {
                htmlSb.append("</br>");
            }
            String logic = (String)paramMap.get("logic");
            boolean hasNext = findex < paramList.size();
            htmlSb.append("<span class='logic'>");
            if (HRStringUtils.isNotEmpty((String)logic) && hasNext) {
                htmlSb.append(logic);
                if (addBr) {
                    htmlSb.append("</br>");
                }
            }
            htmlSb.append(HTML_SPAN_END);
        }
        htmlSb.append("</div>");
        return htmlSb.toString();
    }

    private Map<String, Object> getParamValues() {
        HashMap paramValues = Maps.newHashMapWithExpectedSize((int)16);
        String conditions = (String)this.getView().getFormShowParameter().getCustomParam("conditions");
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
        int leftBracket = 0;
        String andDesc = SceneCfgKDString.and();
        String orDesc = SceneCfgKDString.or();
        for (int i = 0; i < conditionList.size(); ++i) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            param.put("leftBracket", ((ConditionExpressInfo)conditionExpressList.get(i)).getLeftBracket());
            param.put("param", ((ConditionInfo)conditionList.get(i)).getDisplayParam());
            param.put("comparisonOpt", RuleOperatorEnum.getEnum((String)((ConditionInfo)conditionList.get(i)).getOperators()).getName());
            param.put("value", this.preventXss(((ConditionInfo)conditionList.get(i)).getDisplayValue()));
            param.put("rightBracket", ((ConditionExpressInfo)conditionExpressList.get(i)).getRightBracket());
            if (null == ((ConditionExpressInfo)conditionExpressList.get(i)).getLogical()) {
                param.put("logic", null);
            } else if ("and".equals(((ConditionExpressInfo)conditionExpressList.get(i)).getLogical().trim())) {
                param.put("logic", andDesc);
            } else {
                param.put("logic", orDesc);
            }
            if (HRStringUtils.isNotEmpty((String)((ConditionExpressInfo)conditionExpressList.get(i)).getLeftBracket())) {
                ++leftBracket;
            }
            if (HRStringUtils.isNotEmpty((String)((ConditionExpressInfo)conditionExpressList.get(i)).getRightBracket())) {
                --leftBracket;
            }
            if (leftBracket == 0) {
                param.put("br", "true");
            }
            paramList.add(param);
        }
        paramValues.put("expresses", paramList);
        return paramValues;
    }

    private String preventXss(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&#39;").replace("\"", "&quot;");
    }

    private String ifNullReturnEmpty(Map<String, Object> paramMap, String key) {
        Object obj = paramMap.get(key);
        if (obj == null) {
            return "";
        }
        return (String)obj;
    }
}

