/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.shift.breaktime;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.utils.SetMustInputLogUtil;
import kd.wtc.wtbd.fromplugin.web.shift.breaktime.BreakTimeViewHelper;

public class BreakTimeEdit
extends HRDataBaseEdit {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        super.beforeDoOperation(args);
        this.getModel().setValue("status", (Object)"C");
        if (args.getSource() instanceof FormOperate && "save".equals((operate = (FormOperate)args.getSource()).getOperateKey())) {
            boolean exist = BreakTimeViewHelper.checkReferenceOfShift(this.getView());
            args.setCancel(exist);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "brestartdate": 
            case "breenddate": 
            case "refendday": 
            case "refstartday": {
                this.countBreakMinute();
                break;
            }
        }
    }

    private void countBreakMinute() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        int breakStartTime = dynamicObject.getInt("brestartdate");
        int breakEndTime = dynamicObject.getInt("breenddate");
        if (breakEndTime == -1 || breakStartTime == -1) {
            return;
        }
        String refDayStar = dynamicObject.getString("refstartday");
        String refDayEnd = dynamicObject.getString("refendday");
        if ("C".equals(refDayStar)) {
            breakStartTime = 86400 + breakStartTime;
        }
        if ("C".equals(refDayEnd)) {
            breakEndTime = 86400 + breakEndTime;
        }
        if (breakEndTime <= breakStartTime) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f11\u606f\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u4f11\u606f\u7ed3\u675f\u65f6\u95f4\u3002", (String)"BreakTimeEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        int breakMin = (breakEndTime - breakStartTime) / 60;
        dynamicObject.set("breakminute", (Object)Math.max(breakMin, 0));
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if ("save".equals(operateKey) || "update".equals(operateKey)) {
            BillList billlistap;
            this.getView().returnDataToParent((Object)operateKey);
            if (parentView != null && (billlistap = (BillList)parentView.getControl("billlistap")) != null) {
                billlistap.refresh();
                this.getView().sendFormAction(parentView);
            }
        }
    }

    public void afterBindData(EventObject object) {
        SetMustInputLogUtil.setMustInputByTime((String)"brestartdate", (IFormView)this.getView());
        SetMustInputLogUtil.setMustInputByTime((String)"breenddate", (IFormView)this.getView());
    }
}

