/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.shift.shift.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.shift.ShiftServiceHelper;
import kd.wtc.wtbd.common.constants.shift.ShiftConstants;
import kd.wtc.wtbd.common.enums.basedata.shiftperiod.ShiftPeriodEnum;
import kd.wtc.wtbd.common.shift.ShiftEntry;
import kd.wtc.wtbd.common.shift.ShiftTypeEnum;
import kd.wtc.wtbd.fromplugin.web.shift.shift.plugin.Punch;
import kd.wtc.wtbd.fromplugin.web.shift.shift.plugin.ShiftEntryService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.predata.wtbd.PreDataShiftPeriod;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class ShiftEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("wtbd_punchcardpair");
    private static final Set<String> IS_SAVE = new HashSet<String>();

    public static void dealImport(ImportDataEventArgs eventArgs, String errorMsg) {
        if (eventArgs != null && !eventArgs.isCancel()) {
            eventArgs.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), errorMsg);
            eventArgs.setCancel(true);
        }
    }

    public void registerListener(EventObject object) {
        super.registerListener(object);
        BasedataEdit addrow = (BasedataEdit)this.getView().getControl("resttimeid");
        addrow.setF7MultipleSelect(false);
        addrow.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit clockRule = (BasedataEdit)this.getView().getControl("clockrule");
        clockRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit shiftPeriod = (BasedataEdit)this.getView().getControl("shiftperiod");
        shiftPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        this.filterRestF7(beforeF7SelectEvent, formShowParameter);
        this.filterClockRule(beforeF7SelectEvent, formShowParameter);
        this.filterShiftPeriod(beforeF7SelectEvent, formShowParameter);
    }

    private void filterShiftPeriod(BeforeF7SelectEvent beforeF7SelectEvent, ListShowParameter formShowParameter) {
        if (HRStringUtils.equals((String)beforeF7SelectEvent.getProperty().getName(), (String)"shiftperiod")) {
            QFilter filter = new QFilter("id", "in", Arrays.asList(Long.parseLong(this.getPageCache().get("shiftperiod")), PreDataShiftPeriod.PD_1020_03_01_S));
            formShowParameter.getListFilterParameter().setFilter(filter);
        }
    }

    private void filterClockRule(BeforeF7SelectEvent beforeF7SelectEvent, ListShowParameter formShowParameter) {
        if (HRStringUtils.equals((String)beforeF7SelectEvent.getProperty().getName(), (String)"clockrule")) {
            Date bsed = this.getModel().getDataEntity().getDate("bsed");
            if (Objects.isNull(bsed)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6548\u65e5\u671f\u3002", (String)"ShiftEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String offPlan = this.getModel().getDataEntity().getString("offnonplan");
            QFilter filter = new QFilter("isoff", "=", (Object)"1".equals(offPlan));
            filter.and(new QFilter("firstbsed", "<=", (Object)bsed)).and(new QFilter("bsled", ">=", (Object)bsed));
            formShowParameter.getListFilterParameter().setFilter(filter);
        }
    }

    private void filterRestF7(BeforeF7SelectEvent beforeF7SelectEvent, ListShowParameter formShowParameter) {
        if (HRStringUtils.equals((String)beforeF7SelectEvent.getProperty().getName(), (String)"resttimeid")) {
            QFilter next;
            QFilter today;
            ShiftEntry shift = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
            if (shift.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5145\u73ed\u6b21\u65f6\u95f4\u3002", (String)"ShiftEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (shift.getReferenceStartDay() == RefDateType.TODAY) {
                today = new QFilter("refstartday", "=", (Object)RefDateType.TODAY.code).and(new QFilter("brestartdate", ">", (Object)shift.getShiftStart()));
                next = new QFilter("refstartday", "=", (Object)RefDateType.NEXTDAY.code);
            } else {
                today = new QFilter("refstartday", "=", (Object)RefDateType.NEXTDAY.code).and(new QFilter("brestartdate", ">", (Object)shift.getShiftStart()));
                next = new QFilter("refstartday", "=", (Object)RefDateType.NEXTDAY.code).and(new QFilter("brestartdate", ">", (Object)shift.getShiftStart()));
            }
            if (shift.getReferenceEndDay() == RefDateType.TODAY) {
                QFilter and = new QFilter("refendday", "=", (Object)RefDateType.TODAY.code).and(new QFilter("breenddate", "<", (Object)shift.getShiftEnd()));
                today.and(and);
                next.and(and);
            } else {
                QFilter or = new QFilter("refendday", "=", (Object)RefDateType.TODAY.code).or(new QFilter("refendday", "=", (Object)RefDateType.NEXTDAY.code).and(new QFilter("breenddate", "<", (Object)shift.getShiftEnd())));
                today.and(or);
                next.and(or);
            }
            QFilter filter = today.or(next);
            formShowParameter.getListFilterParameter().setFilter(filter);
            formShowParameter.getListFilterParameter().setFilter(this.notInEntry());
        }
    }

    private QFilter notInEntry() {
        QFilter temp = null;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("restentry");
        if (!entity.isEmpty()) {
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)entity.size());
            for (DynamicObject dynamicObject : entity) {
                DynamicObject dynamicObject1 = dynamicObject.getDynamicObject("resttimeid");
                if (dynamicObject1 == null) continue;
                long id = dynamicObject1.getLong("id");
                ids.add(id);
            }
            temp = new QFilter("id", "not in", (Object)ids);
        }
        return temp;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("modifyhis".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(false);
            long id = dataEntity.getLong("id");
            String name = dataEntity.getString("name");
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("wtbd_shift");
            String editCaption = ResManager.loadKDString((String)"\u4fee\u6539\u73ed\u6b21-%s", (String)"ShiftEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{name});
            billShowParameter.setCaption(editCaption);
            if (this.getView().getParentView() != null) {
                billShowParameter.setParentPageId(this.getView().getParentView().getPageId());
            }
            billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setShowTitle(true);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wtbd_shiftviwe"));
            billShowParameter.setPkId((Object)id);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.fullRestAtt();
        String refStart = this.getModel().getDataEntity().getString("referencestartday");
        if (kd.wtc.wtbs.common.util.third.util.StringUtils.isEmpty((CharSequence)refStart) || " ".equals(refStart)) {
            this.getModel().setValue("referencestartday", (Object)RefDateType.TODAY.code);
        }
        LinkedList entryBoIds = new LinkedList();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List<ShiftEntry> sortShift = entryEntity.stream().peek(dy -> entryBoIds.add(dy.getLong("entryboid2"))).filter(dy -> dy.getDynamicObject("shiftperiod") != null).map(obj -> new ShiftEntry(this.getModel(), obj, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        pageCache.put("entryboid2", entryBoIds);
        this.initTakeCard(sortShift);
        this.lockShift(sortShift);
        this.cacheUnlock(sortShift);
        if (!sortShift.isEmpty()) {
            LinkedList<ShiftEntry> temp = new LinkedList<ShiftEntry>();
            String type = this.getModel().getDataEntity().getString("shifttype");
            ShiftEntryService.generatorShiftEntry(this.getView(), type, temp);
            this.fullShift(temp, null);
            this.getPageCache().put("shiftperiod", String.valueOf(temp.get(temp.size() - 1).getShiftPeriod()));
            ShiftEntryService.setStandardTime(new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL), this.getView());
        } else {
            this.getPageCache().put("shiftperiod", "0");
        }
        this.fullPunchCard(this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList()), null, true);
        this.setMustInput(true, ShiftConstants.MUST_INPUT_FIELD_SPECIAL);
        if (entryEntity.stream().anyMatch(dy -> dy.getDynamicObject("shiftperiod") == null)) {
            this.clearEntry();
            this.getModel().createNewEntryRow("restentry");
        }
        this.setInOtFlexVisible();
        this.getModel().setDataChanged(false);
    }

    private void setInOtFlexVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isInOt = dataEntity.getBoolean("isinot");
        this.setInOtEnd();
        this.getView().setVisible(Boolean.valueOf(isInOt || this.isLockLastShiftPeriod()), new String[]{"isinotflex"});
    }

    private void fullRestAtt() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("restentry");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            DynamicObject object = dynamicObject.getDynamicObject("resttimeid");
            if (object == null) continue;
            this.getModel().setValue("reststartday", (Object)object.getString("refstartday"), i);
            this.getModel().setValue("reststarttime", (Object)object.getString("brestartdate"), i);
            this.getModel().setValue("restendday", (Object)object.getString("refendday"), i);
            this.getModel().setValue("restendtime", (Object)object.getString("breenddate"), i);
        }
    }

    private void colorInit() {
        boolean isLock = WTCHisService.isLock((IFormView)this.getView());
        OperationStatus status = isLock ? OperationStatus.VIEW : OperationStatus.EDIT;
        CustomControl customcontrol = (CustomControl)this.getView().getControl("colorlap");
        HashMap<String, String> data = new HashMap<String, String>(2);
        String color = this.getView().getModel().getDataEntity().getString("shiftcolor");
        data.put("color", color);
        data.put("status", status.toString());
        data.put("date", new Date().toString());
        data.put("shiftcolorprompt", (String)WTCFormUtils.getPromptMap((IFormView)this.getView()).get("shiftcolor"));
        customcontrol.setData(data);
    }

    private List<Punch> getPunchList() {
        String selectProperties = "id,number,name";
        DynamicObject[] objects = SERVICE_HELPER.query(selectProperties, null, "index asc");
        return Arrays.stream(objects).map(dy -> new Punch().setId(dy.getLong("id")).setName(dy.getString("name")).setNumber(dy.getString("number"))).collect(Collectors.toList());
    }

    private boolean fullPunchCard(List<ShiftEntry> sortShift, ImportDataEventArgs eventArgs, boolean isFullCard) {
        List<Punch> punches = this.getPunchList();
        int size = punches.size();
        String punchLabelStr = this.buildPunchLabel(sortShift, punches);
        if ("error".equals(punchLabelStr)) {
            String msg = ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u8bbe\u7f6e%s\u4e2a\u6253\u5361\u70b9,\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{size * 2});
            this.getView().showErrorNotification(msg);
            ShiftEdit.dealImport(eventArgs, msg);
            return false;
        }
        if (isFullCard) {
            Label label = (Label)this.getView().getControl("punchcard");
            label.setText(punchLabelStr);
            this.fullPunchCardEntry(sortShift);
        }
        return true;
    }

    private void fullPunchCardEntry(List<ShiftEntry> sortShift) {
        DynamicObjectCollection shifts = this.getModel().getEntryEntity("entryentity");
        if (shifts.size() != sortShift.size() || shifts.isEmpty()) {
            return;
        }
        for (int i = 0; i < sortShift.size(); ++i) {
            ShiftEntry shift = sortShift.get(i);
            this.getModel().setValue("punchcardpairid", (Object)shift.getPunchCardPairId(), i);
        }
    }

    private String buildPunchLabel(List<ShiftEntry> sortShift, List<Punch> punches) {
        List hasCardShift = sortShift.stream().filter(shift -> shift.isWorkCard() || shift.isOffWorkCard()).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        boolean isWholePunch = true;
        if (!hasCardShift.isEmpty()) {
            for (ShiftEntry shift2 : hasCardShift) {
                String date;
                Punch punch;
                if (isWholePunch) {
                    if (punches.isEmpty()) {
                        return "error";
                    }
                    builder.append(punches.get(0).getName());
                    builder.append(':');
                    builder.append(' ');
                }
                if (shift2.isWorkCard()) {
                    punch = punches.get(0);
                    shift2.setPunchCardPairId(punch.getId());
                    if (shift2.getReferenceStartDay() == RefDateType.NEXTDAY) {
                        builder.append(' ');
                        builder.append(ResManager.loadKDString((String)"\u6b21\u65e5", (String)"ShiftEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        builder.append(' ');
                    }
                    date = WTCDateUtils.secondToTime((long)shift2.getShiftStart(), (String)"h:m");
                    builder.append(date);
                    if (isWholePunch) {
                        builder.append('~');
                        isWholePunch = false;
                    } else {
                        builder.append('\uff0c');
                        isWholePunch = true;
                    }
                }
                if (!shift2.isOffWorkCard()) continue;
                punch = punches.get(0);
                punches.remove(0);
                shift2.setPunchCardPairId(punch.getId());
                if (shift2.getReferenceEndDay() == RefDateType.NEXTDAY) {
                    builder.append(' ');
                    builder.append(ResManager.loadKDString((String)"\u6b21\u65e5", (String)"ShiftEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    builder.append(' ');
                }
                date = WTCDateUtils.secondToTime((long)shift2.getShiftEnd(), (String)"h:m");
                builder.append(date);
                if (isWholePunch) {
                    builder.append('~');
                    isWholePunch = false;
                    continue;
                }
                builder.append('\uff0c');
                isWholePunch = true;
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    private void cacheUnlock(List<ShiftEntry> sortShift) {
        List unLock = sortShift.stream().filter(shift -> shift.isStartCheck() || shift.isEndCheck()).collect(Collectors.toList());
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        pageCache.put("unLock", unLock);
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        String color = args.getEventArgs();
        this.getModel().setValue("shiftcolor", (Object)color);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String color = (String)closedCallBackEvent.getReturnData();
        if (!kd.wtc.wtbs.common.util.third.util.StringUtils.isBlank((CharSequence)color)) {
            this.getModel().setValue("shiftcolor", (Object)color);
            HashMap<String, String> ctrl = new HashMap<String, String>(1);
            ctrl.put("bc", color);
            this.getView().updateControlMetadata("lab_color", ctrl);
        } else {
            this.getView().updateView("billlistap");
        }
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
        this.colorInit();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("wtbd_shift".equals(formId)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String auditStatus = this.getView().getModel().getDataEntity().getString("status");
            if (OperationStatus.VIEW == status && "C".equals(auditStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_viewhis"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        if (Objects.equals("ischange", pageCache.get("ischange"))) {
            return;
        }
        String propertyName = args.getProperty().getName();
        if (kd.wtc.wtbs.common.util.third.util.StringUtils.equals((CharSequence)propertyName, (CharSequence)"resttimeid")) {
            this.breakTimePull(args);
        }
        switch (propertyName) {
            case "alldayhour": 
            case "halfdayhour": 
            case "outworktype": {
                this.changeDefaultVal();
                break;
            }
            case "shifttype": {
                this.voidEntry();
                this.getModel().deleteEntryData("workentry");
                this.getModel().deleteEntryData("restentry");
                if (this.isNonTimeSeq()) break;
                this.getModel().setValue("allday", null);
                break;
            }
            case "middlepoint": 
            case "refmiddlepoint": {
                ShiftEntry shift;
                RefDateType refMidPoint = RefDateType.from((String)this.getModel().getDataEntity().getString("refmiddlepoint"));
                int middlepoint = this.getModel().getDataEntity().getInt("middlepoint");
                if (refMidPoint == null || middlepoint == -1 || this.isPartOfShift(middlepoint = refMidPoint.getAdjustSecond(middlepoint), shift = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL))) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u73ed\u6b21\u5206\u5272\u70b9\u662f\u5426\u5728\u73ed\u6b21\u65f6\u70b9\u8303\u56f4\u5185\uff0c\u5e76\u6392\u9664\u4e0a\u73ed\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u70b9\u3002", (String)"ShiftEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            case "isworktimestart": {
                this.workStartChanged(args, pageCache);
                break;
            }
            case "isworktimeend": {
                this.workEndChanged(args, pageCache);
                break;
            }
        }
        this.propertyCheck(args);
        this.checkShift(args);
        if ("isoff".equals(propertyName) || "offnonplan".equals(propertyName)) {
            this.setMustInput(!this.isNonTimeSeq(), ShiftConstants.MUST_INPUT_FIELD_SPECIAL);
            this.getModel().setValue("clockrule", null);
        }
        if (kd.wtc.wtbs.common.util.third.util.StringUtils.equalsAny((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"isinot", "referenceendday", "shiftend"})) {
            this.setInOtEnd();
        }
    }

    private void setInOtEnd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isInOt = dataEntity.getBoolean("isinot");
        if (isInOt) {
            this.getModel().setValue("refinotendday", (Object)dataEntity.getString("referenceendday"));
            this.getModel().setValue("inotend", (Object)dataEntity.getInt("shiftend"));
        } else {
            this.getModel().setValue("refinotendday", null);
            this.getModel().setValue("inotend", (Object)-1);
            this.getModel().setValue("refinotstartday", null);
            this.getModel().setValue("inotstart", (Object)-1);
        }
        this.getView().setVisible(Boolean.valueOf(isInOt), new String[]{"isinotflexcontent"});
        this.getView().setVisible(Boolean.valueOf(isInOt), new String[]{"labelap7", "nootstandardtime"});
    }

    private boolean isPartOfShift(int middlepoint, ShiftEntry shift) {
        return !shift.isEmpty() && (middlepoint > shift.getRefShiftStart() || middlepoint < shift.getRefShiftEnd());
    }

    private void checkShift(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "shiftstart": 
            case "shiftend": 
            case "referenceendday": {
                ShiftEntry shiftEntry = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
                if (shiftEntry.isEmpty() || !shiftEntry.checkTimeDuration()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u73ed\u6b21\u6700\u665a\u4e0b\u73ed\u65f6\u70b9\u5e94\u665a\u4e8e\u6700\u65e9\u4e0a\u73ed\u65f6\u70b9\u3002", (String)"ShiftEdit_27", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void workEndChanged(PropertyChangedArgs args, WTCPageCache pageCache) {
        ShiftEntry next;
        int i;
        ChangeData changeData = args.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        List<ShiftEntry> shiftList = this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        Map<Integer, List<ShiftEntry>> indexShift = shiftList.stream().collect(Collectors.groupingBy(ShiftEntry::getIndex));
        List shifts = JSON.parseArray((String)pageCache.get("unLock"), ShiftEntry.class);
        for (i = 0; i < shifts.size(); ++i) {
            if (((ShiftEntry)shifts.get(i)).getIndex() != rowIndex || !Objects.nonNull(next = (ShiftEntry)shifts.get(i + 1))) continue;
            this.getModel().setValue("isworktimestart", changeData.getNewValue(), next.getIndex());
            List<ShiftEntry> changeShift = indexShift.get(next.getIndex());
            if (changeShift == null || changeShift.isEmpty()) break;
            changeShift.get(0).setWorkCard(((Boolean)changeData.getNewValue()).booleanValue());
            break;
        }
        if (!this.fullPunchCard(shiftList, null, true)) {
            this.getModel().setValue("isworktimeend", changeData.getOldValue(), rowIndex);
            for (i = 0; i < shifts.size(); ++i) {
                if (((ShiftEntry)shifts.get(i)).getIndex() != rowIndex || !Objects.nonNull(next = (ShiftEntry)shifts.get(i + 1))) continue;
                this.getModel().setValue("isworktimestart", changeData.getOldValue(), next.getIndex());
            }
            return;
        }
        this.changeTakeCard(args);
    }

    private void workStartChanged(PropertyChangedArgs args, WTCPageCache pageCache) {
        ShiftEntry prev;
        int i;
        ChangeData changeData = args.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        List<ShiftEntry> shiftList = this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        Map<Integer, List<ShiftEntry>> indexShift = shiftList.stream().collect(Collectors.groupingBy(ShiftEntry::getIndex));
        List shifts = JSON.parseArray((String)pageCache.get("unLock"), ShiftEntry.class);
        for (i = 0; i < shifts.size(); ++i) {
            if (((ShiftEntry)shifts.get(i)).getIndex() != rowIndex || !Objects.nonNull(prev = (ShiftEntry)shifts.get(i - 1))) continue;
            this.getModel().setValue("isworktimeend", changeData.getNewValue(), prev.getIndex());
            List<ShiftEntry> changeShift = indexShift.get(prev.getIndex());
            if (changeShift == null || changeShift.isEmpty()) continue;
            changeShift.get(0).setOffWorkCard(((Boolean)changeData.getNewValue()).booleanValue());
        }
        if (!this.fullPunchCard(shiftList, null, true)) {
            this.getModel().setValue("isworktimestart", changeData.getOldValue(), rowIndex);
            for (i = 0; i < shifts.size(); ++i) {
                if (((ShiftEntry)shifts.get(i)).getIndex() != rowIndex || !Objects.nonNull(prev = (ShiftEntry)shifts.get(i - 1))) continue;
                this.getModel().setValue("isworktimeend", changeData.getOldValue(), prev.getIndex());
            }
            return;
        }
        this.changeTakeCard(args);
    }

    private void propertyCheck(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "workstartday": 
            case "workstarttime": 
            case "workendday": 
            case "workendtime": {
                this.checkWork(args);
                break;
            }
            case "resttimeid": {
                this.checkRest(args);
                break;
            }
            case "shiftperiod": {
                this.setEntryOutWorkType(args);
                break;
            }
        }
    }

    private void setEntryOutWorkType(PropertyChangedArgs args) {
        DynamicObjectCollection shiftPeriods = this.getModel().getEntryEntity("entryentity");
        if (shiftPeriods.size() > 0 && args.getChangeSet()[0].getRowIndex() == shiftPeriods.size() - 1) {
            long shiftPeriodId = ((DynamicObject)shiftPeriods.get(shiftPeriods.size() - 1)).getLong("shiftperiod.id");
            this.getModel().setValue("outworktype", (Object)(ShiftPeriodEnum.IN_SHIFT_OVERTIME_PERIOD.getId() == shiftPeriodId ? ShiftTypeEnum.OUTWORK.getType() : ShiftTypeEnum.INTERVAL.getType()), shiftPeriods.size() - 1);
        }
    }

    private void checkRest(PropertyChangedArgs args) {
        List shifts = this.getModel().getEntryEntity("restentry").stream().map(obj -> new ShiftEntry(this.getModel(), obj.getDynamicObject("resttimeid"), ShiftTypeEnum.REST)).filter(shift -> !shift.isEmpty()).collect(Collectors.toList());
        boolean result = ShiftEntry.hasRepeat(shifts);
        if (result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f11\u606f\u65f6\u6bb5\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(args.getProperty().getName(), args.getChangeSet()[0].getOldValue(), args.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("reststartday", (Object)"", args.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("reststarttime", (Object)-1, args.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("restendday", (Object)"", args.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("restendtime", (Object)-1, args.getChangeSet()[0].getRowIndex());
        }
    }

    private void checkWork(PropertyChangedArgs args) {
        ShiftEntry shift = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
        if (shift.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5145\u73ed\u6b21\u65f6\u95f4\u3002", (String)"ShiftEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        DynamicObjectCollection workentry = this.getModel().getEntryEntity("workentry");
        ShiftEntry workShift = new ShiftEntry(this.getModel(), (DynamicObject)workentry.get(rowIndex), ShiftTypeEnum.WORK);
        if (workShift.isEmpty()) {
            return;
        }
        if (workShift.checkTimeDuration()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5f00\u59cb\u65f6\u70b9\u4e0d\u80fd\u665a\u4e8e\u6838\u5fc3\u7ed3\u675f\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (shift.getRefShiftStart() > workShift.getRefShiftStart()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u5f00\u59cb\u65f6\u70b9\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u73ed\u5f00\u59cb\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (shift.getRefShiftEnd() < workShift.getRefShiftEnd()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u7ed3\u675f\u65f6\u70b9\u4e0d\u80fd\u665a\u4e8e\u4e0b\u73ed\u7ed3\u675f\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        List workList = workentry.stream().map(work -> new ShiftEntry(this.getModel(), work, ShiftTypeEnum.WORK)).collect(Collectors.toList());
        if (ShiftEntry.hasRepeat(workList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u65f6\u6bb5\u4e0d\u5141\u8bb8\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeTakeCard(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("isworktimestart".equals(propertyName)) {
            int cardsnum = this.getModel().getDataEntity().getInt("cardsnum");
            if (Objects.nonNull(args.getChangeSet()[0].getNewValue())) {
                cardsnum = ((Boolean)args.getChangeSet()[0].getNewValue()).booleanValue() ? (cardsnum += 2) : (cardsnum -= 2);
                this.getModel().getDataEntity().set("cardsnum", (Object)cardsnum);
                this.getView().updateView("cardsnum");
            }
        }
    }

    private void changeDefaultVal() {
        BigDecimal total = new BigDecimal(0);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List workEntry = entryEntity.stream().filter(object -> {
            String outworktype = object.getString("outworktype");
            return !HRStringUtils.equals((String)outworktype, (String)ShiftTypeEnum.REST.getType());
        }).collect(Collectors.toList());
        for (DynamicObject object2 : workEntry) {
            ShiftEntry restShift = new ShiftEntry(this.getModel(), object2, ShiftTypeEnum.SHIFT);
            total = total.add(restShift.getWorkTimeHour());
        }
        BigDecimal val = (BigDecimal)this.getModel().getValue("alldayhour");
        boolean nonTimeSeq = this.isNonTimeSeq();
        if (!nonTimeSeq && val.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue("allday", (Object)total.divide(val, 2, 4));
        }
    }

    private boolean isNonTimeSeq() {
        boolean flag;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String isoff = dataEntity.getString("isoff");
        String offNonPlan = dataEntity.getString("offnonplan");
        boolean bl = flag = "1".equals(isoff) && "1".equals(offNonPlan);
        if (flag) {
            this.clearFieldValues();
        } else {
            this.getModel().setValue("referencestartday", (Object)RefDateType.TODAY.code);
        }
        return flag;
    }

    private void clearFieldValues() {
        this.getPageCache().put("ischange", "ischange");
        IDataModel dataModel = this.getModel();
        dataModel.setValue("referencestartday", (Object)" ");
        dataModel.setValue("shiftstart", (Object)-1);
        dataModel.setValue("referenceendday", (Object)" ");
        dataModel.setValue("shiftend", (Object)-1);
        dataModel.setValue("effectivetime", (Object)0);
        ((Label)this.getView().getControl("standardtime")).setText("0h");
        dataModel.setValue("workingsections", (Object)0);
        dataModel.setValue("cardsnum", (Object)0);
        dataModel.deleteEntryData("entryentity");
        dataModel.setValue("middlepoint", (Object)0);
        dataModel.setValue("refmiddlepoint", null);
        dataModel.deleteEntryData("restentry");
        dataModel.deleteEntryData("workentry");
        Label label = (Label)this.getView().getControl("punchcard");
        label.setText("");
        this.getPageCache().remove("ischange");
        dataModel.setValue("isinot", (Object)Boolean.FALSE);
        dataModel.setValue("refinotstartday", null);
        dataModel.setValue("refinotendday", null);
        dataModel.setValue("inotstart", (Object)-1);
        dataModel.setValue("inotend", (Object)-1);
    }

    private void breakTimePull(PropertyChangedArgs ec) {
        ChangeData[] changeSet;
        for (ChangeData changeData : changeSet = ec.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue == null) continue;
            this.getModel().setValue("reststartday", (Object)newValue.getString("refstartday"), rowIndex);
            this.getModel().setValue("reststarttime", (Object)newValue.getString("brestartdate"), rowIndex);
            this.getModel().setValue("restendday", (Object)newValue.getString("refendday"), rowIndex);
            this.getModel().setValue("restendtime", (Object)newValue.getString("breenddate"), rowIndex);
            return;
        }
    }

    public void beforeItemClick(BeforeItemClickEvent args) {
        super.beforeItemClick(args);
        String operateKey = args.getItemKey();
        if (this.saveValidate(null, operateKey)) {
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "newentry2": {
                List<ShiftEntry> workEntry = this.getModel().getEntryEntity("workentry").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.WORK)).collect(Collectors.toList());
                ShiftEntry shift = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
                String message = ShiftEntryService.dealWorkDoOperation(shift, workEntry);
                if (!"donothing".equals(message)) {
                    this.getView().showErrorNotification(message);
                    args.setCancel(true);
                }
                List restIds = ShiftServiceHelper.getWorkShiftPeriod((ShiftTypeEnum)ShiftTypeEnum.WORK);
                if (workEntry.size() < restIds.size()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u65f6\u6bb5\u4e0d\u80fd\u8d85\u8fc7%s\u6bb5\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{restIds.size()}));
                args.setCancel(true);
                break;
            }
            case "newentry": {
                args.setCancel(this.dealRestDoOperation());
                break;
            }
            case "genshift": {
                if (this.dealGenshiftOperation(null)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean saveValidate(ImportDataEventArgs eventArgs, String operateKey) {
        if (IS_SAVE.contains(operateKey)) {
            DynamicObject clockrule = this.getModel().getDataEntity().getDynamicObject("clockrule");
            if (clockrule != null) {
                String isOff;
                Date date = clockrule.getDate("firstbsed");
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                if (bsed == null) {
                    String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u751f\u6548\u65e5\u671f\u683c\u5f0f\u3002", (String)"ShiftEdit_14", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                    ShiftEdit.dealImport(eventArgs, msg);
                    return false;
                }
                if (date.after(bsed)) {
                    String msg = ResManager.loadKDString((String)"\u53d6\u5361\u89c4\u5219\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u73ed\u6b21\u751f\u6548\u65e5\u671f\u3002", (String)"ShiftEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                    ShiftEdit.dealImport(eventArgs, msg);
                    this.getView().showErrorNotification(msg);
                    return true;
                }
                String string = isOff = clockrule.getBoolean("isoff") ? "0" : "1";
                if (this.getModel().getDataEntity().getString("offnonplan").equals(isOff)) {
                    String msg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u53d6\u5361\u89c4\u5219\u548c\u73ed\u6b21\u201cOFF\u73ed\u65e0\u8ba1\u5212\u65f6\u6bb5\u201d\u662f\u5426\u5339\u914d\u3002", (String)"ShiftEdit_32", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                    ShiftEdit.dealImport(eventArgs, msg);
                    this.getView().showErrorNotification(msg);
                    return true;
                }
            }
            if (this.isNonTimeSeq()) {
                this.setNonTimeSeqState();
                return false;
            }
            return this.doSaveValidate(eventArgs);
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.colorInit();
        List<ShiftEntry> sortShift = this.getModel().getEntryEntity("entryentity").stream().filter(dy -> dy.getDynamicObject("shiftperiod") != null).map(obj -> new ShiftEntry(this.getModel(), obj, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        this.initTakeCard(sortShift);
        this.lockShift(sortShift);
    }

    private boolean dealGenshiftOperation(ImportDataEventArgs eventArgs) {
        this.deleteEmptyEntryRow();
        String type = this.getModel().getDataEntity().getString("shifttype");
        LinkedList<ShiftEntry> sortShift = new LinkedList<ShiftEntry>();
        boolean flag = ShiftEntryService.validateShift(this.getView(), type, eventArgs);
        if (flag) {
            ShiftEntryService.generatorShiftEntry(this.getView(), type, sortShift);
            this.voidEntry();
            if (this.fullPunchCard(sortShift, eventArgs, true)) {
                if (this.genShift(sortShift, eventArgs)) {
                    this.lockShift(sortShift);
                    this.cacheUnlock(sortShift);
                    this.genDefaultRule(sortShift);
                    this.changeDefaultVal();
                    return true;
                }
                this.fullPunchCard(new ArrayList<ShiftEntry>(), null, true);
                this.getModel().setValue("alldayhour", (Object)0);
                this.getModel().setValue("workingsections", (Object)0);
                ((Label)this.getView().getControl("standardtime")).setText("0h0m");
                this.getModel().setValue("cardsnum", (Object)0);
                this.getModel().setValue("allday", (Object)0);
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean dealRestDoOperation() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("restentry");
        List restIds = ShiftServiceHelper.getWorkShiftPeriod((ShiftTypeEnum)ShiftTypeEnum.REST);
        if (entryEntity.size() >= restIds.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f11\u606f\u65f6\u6bb5\u4e0d\u80fd\u8d85\u8fc7%s\u6bb5\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{restIds.size()}));
            return true;
        }
        return false;
    }

    private void setNonTimeSeqState() {
        this.clearEntry();
        this.setMustInput(false, ShiftConstants.MUST_INPUT_FIELD_SPECIAL);
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("restentry");
        this.getModel().deleteEntryData("workentry");
    }

    private void setMustInput(boolean nonTimeSeq, String ... field) {
        Arrays.stream(field).forEach(ee -> {
            DynamicProperty prop;
            Control control = this.getView().getControl(ee);
            if (control instanceof FieldEdit) {
                ((FieldEdit)control).setMustInput(nonTimeSeq);
            } else if (control instanceof EntryGrid && (prop = this.getModel().getDataEntityType().getProperty("entryentity")) instanceof EntryProp) {
                ((EntryProp)prop).setEntryMustInput(nonTimeSeq);
            }
        });
    }

    private boolean doSaveValidate(ImportDataEventArgs eventArgs) {
        String type = this.getModel().getDataEntity().getString("shifttype");
        LinkedList<ShiftEntry> sortShift = new LinkedList<ShiftEntry>();
        this.deleteEmptyEntryRow();
        boolean validateFlag = ShiftEntryService.validateShift(this.getView(), type, eventArgs);
        if (!validateFlag) {
            return true;
        }
        ShiftEntryService.generatorShiftEntry(this.getView(), type, sortShift);
        if (!this.fullPunchCard(sortShift, eventArgs, false) || !this.fullShift(sortShift, eventArgs)) {
            return true;
        }
        List genShift = this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        if (genShift.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u73ed\u6b21\u672a\u751f\u6210\u3002\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_17", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(eventArgs, msg);
            this.getView().showErrorNotification(msg);
            return true;
        }
        int lastIndex = genShift.size() - 1;
        if (((ShiftEntry)genShift.get(lastIndex)).getShiftPeriod() == 0L) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u73ed\u6b21\u65f6\u6bb5\u201d\u3002", (String)"ShiftEdit_18", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            ShiftEdit.dealImport(eventArgs, msg);
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u73ed\u6b21\u65f6\u70b9\u4e0e\u73ed\u6b21/\u4f11\u606f\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_19", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        if (genShift.size() != sortShift.size()) {
            this.getView().showErrorNotification(msg);
            ShiftEdit.dealImport(eventArgs, msg);
            return true;
        }
        for (int i = 0; i < sortShift.size(); ++i) {
            if (sortShift.get(i).isEqual((ShiftEntry)genShift.get(i))) continue;
            this.getView().showErrorNotification(msg);
            ShiftEdit.dealImport(eventArgs, msg);
            return true;
        }
        ShiftEntry shift = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
        if (this.clockRuleValidate(shift, eventArgs)) {
            return true;
        }
        RefDateType dateType = RefDateType.from((String)this.getModel().getDataEntity().getString("refmiddlepoint"));
        int middlepoint = this.getModel().getDataEntity().getInt("middlepoint");
        if (dateType != null) {
            middlepoint = dateType.getAdjustSecond(middlepoint);
        }
        if (middlepoint <= shift.getRefShiftStart() || middlepoint >= shift.getRefShiftEnd()) {
            msg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\u73ed\u6b21\u5206\u5272\u70b9\u662f\u5426\u5728\u73ed\u6b21\u65f6\u70b9\u8303\u56f4\u5185\uff0c\u5e76\u6392\u9664\u4e0a\u73ed\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u70b9\u3002", (String)"ShiftEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(eventArgs, msg);
            this.getView().showErrorNotification(msg);
            return true;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("revise".equals(customParams.get("fromPage"))) {
            List list = JSON.parseArray((String)new WTCPageCache(this.getView()).get("entryboid2"), Long.class);
            int size = Math.min(list.size(), this.getModel().getEntryEntity("entryentity").size());
            for (int i = 0; i < size; ++i) {
                this.getModel().setValue("entryboid2", list.get(i), i);
            }
        }
        return false;
    }

    private boolean clockRuleValidate(ShiftEntry shift, ImportDataEventArgs eventArgs) {
        List<ShiftEntry> mergeList = this.getMergeList();
        DynamicObject clockrule = this.getModel().getDataEntity().getDynamicObject("clockrule");
        if (clockrule != null) {
            DynamicObjectCollection dynamicObjectCollection = clockrule.getDynamicObjectCollection("wtbd_tcardruleentry");
            if (dynamicObjectCollection.size() != mergeList.size()) {
                String msg = ResManager.loadKDString((String)"\u73ed\u6b21\u6bb5\u6570\u4e0e\u53d6\u5361\u6bb5\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_20", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                ShiftEdit.dealImport(eventArgs, msg);
                return true;
            }
            if (this.validateCard(mergeList, dynamicObjectCollection)) {
                String msg = ResManager.loadKDString((String)"\u73ed\u6b21\u53d6\u5361\u6570\u4e0e\u53d6\u5361\u89c4\u5219\u53d6\u5361\u6570\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                ShiftEdit.dealImport(eventArgs, msg);
                return true;
            }
            BigDecimal effectivetime = this.getModel().getDataEntity().getBigDecimal("effectivetime");
            BigDecimal restTime = this.getModel().getEntryEntity("restentry").stream().map(dy -> new ShiftEntry(this.getModel(), dy.getDynamicObject("resttimeid"), ShiftTypeEnum.REST).getWorkTimeHour()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (shift.getWorkTimeHour().subtract(restTime).compareTo(effectivetime) < 0) {
                String msg = ResManager.loadKDString((String)"\u6709\u6548\u65f6\u957f\u4e0d\u80fd\u9ad8\u4e8e\u73ed\u6b21\u6807\u51c6\u65f6\u957f\u3002", (String)"ShiftEdit_22", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                ShiftEdit.dealImport(eventArgs, msg);
                return true;
            }
        }
        return false;
    }

    private List<ShiftEntry> getMergeList() {
        List entryentity = this.getModel().getEntryEntity("entryentity").stream().map(obj -> new ShiftEntry(this.getModel(), obj, ShiftTypeEnum.SHIFT)).filter(shift -> !"B".equals(shift.getType())).collect(Collectors.toList());
        ArrayList<ShiftEntry> mergeList = new ArrayList<ShiftEntry>();
        ShiftEntry begin = null;
        ShiftEntry end = null;
        for (ShiftEntry shift2 : entryentity) {
            if (end == null) {
                begin = end = shift2;
                continue;
            }
            if (end.getRefShiftEnd() != shift2.getRefShiftStart()) {
                this.mergeShift(begin, end, mergeList);
                begin = shift2;
            }
            end = shift2;
        }
        this.mergeShift(begin, end, mergeList);
        return mergeList;
    }

    private void mergeShift(ShiftEntry begin, ShiftEntry end, List<ShiftEntry> mergeList) {
        if (Objects.isNull(begin) || Objects.isNull(end)) {
            return;
        }
        ShiftEntry merged = new ShiftEntry(this.getModel(), null, ShiftTypeEnum.INTERVAL);
        merged.setShiftStartAndCheck(begin.getShiftStart()).setStartCheck(begin.isStartCheck()).setWorkCard(begin.isWorkCard()).setShiftEndAndCheck(end.getShiftEnd()).setEndCheck(end.isEndCheck()).setOffWorkCard(end.isOffWorkCard());
        mergeList.add(merged);
    }

    private boolean validateCard(List<ShiftEntry> entryentity, DynamicObjectCollection dynamicObjectCollection) {
        for (int i = 0; i < entryentity.size(); ++i) {
            ShiftEntry shift = entryentity.get(i);
            DynamicObject object = (DynamicObject)dynamicObjectCollection.get(i);
            if (HRStringUtils.isNotEmpty((String)object.getString("stakecardrule")) == shift.isWorkCard() && HRStringUtils.isNotEmpty((String)object.getString("etakecardrule")) == shift.isOffWorkCard()) continue;
            return true;
        }
        return false;
    }

    private void lockShift(List<ShiftEntry> sortShift) {
        HashMap colKeyRowMap = Maps.newHashMapWithExpectedSize((int)3);
        for (int i = 0; i < sortShift.size(); ++i) {
            List rows;
            if (!sortShift.get(i).isStartCheck() && !sortShift.get(i).isWorkCard()) {
                rows = colKeyRowMap.computeIfAbsent("isworktimestart", key -> Lists.newArrayListWithExpectedSize((int)sortShift.size()));
                rows.add(i);
            }
            if (!sortShift.get(i).isEndCheck() && !sortShift.get(i).isOffWorkCard()) {
                rows = colKeyRowMap.computeIfAbsent("isworktimeend", key -> Lists.newArrayListWithExpectedSize((int)sortShift.size()));
                rows.add(i);
            }
            this.getView().setEnable(Boolean.valueOf(sortShift.get(i).isStartCheck()), i, new String[]{"isworktimestart"});
            this.getView().setEnable(Boolean.valueOf(sortShift.get(i).isEndCheck()), i, new String[]{"isworktimeend"});
            this.getView().setEnable(Boolean.valueOf(sortShift.get(i).isLockShiftPeriod()), i, new String[]{"shiftperiod"});
        }
        WTCBillViewUtils.setEntryCellVisible((IFormView)this.getView(), (String)"advconchildpanelap", (String)"entryentity", (Map)colKeyRowMap);
    }

    private void deleteEmptyEntryRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("restentry");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject resttimeid = dynamicObject.getDynamicObject("resttimeid");
            if (!Objects.isNull(resttimeid)) continue;
            list.add(i);
        }
        int size = list.size();
        int[] list2 = new int[size];
        for (int j = 0; j < list.size(); ++j) {
            list2[j] = (Integer)list.get(j);
        }
        this.getModel().deleteEntryRows("restentry", list2);
        this.getView().updateView("restentry");
    }

    private void genDefaultRule(List<ShiftEntry> sortShift) {
        BigDecimal allDaySeconds = new BigDecimal(3600);
        List workEntry = sortShift.stream().filter(shift -> !HRStringUtils.equals((String)shift.getType(), (String)ShiftTypeEnum.REST.getType())).collect(Collectors.toList());
        int workSeconds = 0;
        for (ShiftEntry workShift : workEntry) {
            workSeconds += workShift.getTime();
        }
        BigDecimal total = new BigDecimal(workSeconds).divide(allDaySeconds, 2, 0);
        this.getModel().setValue("alldayhour", (Object)(total.compareTo(ShiftConstants.HOUROFDAY) > 0 ? ShiftConstants.HOUROFDAY : total));
    }

    private void voidEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private boolean fullShift(List<ShiftEntry> sortShift, ImportDataEventArgs eventArgs) {
        List typeEnums = sortShift.stream().map(ShiftEntry::getTypeEnum).distinct().collect(Collectors.toList());
        EnumMap<ShiftTypeEnum, List> typeMap = new EnumMap<ShiftTypeEnum, List>(ShiftTypeEnum.class);
        EnumMap<ShiftTypeEnum, Integer> typeSizeMap = new EnumMap<ShiftTypeEnum, Integer>(ShiftTypeEnum.class);
        for (ShiftTypeEnum typeEnum : typeEnums) {
            List workShiftPeriod = ShiftServiceHelper.getWorkShiftPeriod((ShiftTypeEnum)typeEnum);
            typeSizeMap.put(typeEnum, workShiftPeriod.size());
            typeMap.put(typeEnum, workShiftPeriod);
        }
        for (int i = 0; i < sortShift.size(); ++i) {
            ShiftEntry shift = sortShift.get(i);
            List shiftIds = (List)typeMap.get(shift.getTypeEnum());
            if (!shiftIds.isEmpty()) {
                Long culShiftPeriodId = (Long)shiftIds.remove(0);
                shift.setShiftPeriod(culShiftPeriodId.longValue());
                if (i == sortShift.size() - 1) {
                    this.getPageCache().put("shiftperiod", String.valueOf(culShiftPeriodId));
                }
            } else {
                switch (shift.getTypeEnum()) {
                    case REST: {
                        String msg = ResManager.loadKDString((String)"\u4f11\u606f\u65f6\u6bb5\u4e0d\u80fd\u8d85\u8fc7%s\u6bb5\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_23", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{typeSizeMap.get(shift.getTypeEnum())});
                        this.getView().showErrorNotification(msg);
                        ShiftEdit.dealImport(eventArgs, msg);
                        break;
                    }
                    case INTERVAL: {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9\uff0c\u666e\u901a\u4e0a\u73ed\u65f6\u6bb5\u5e94\u5c0f\u4e8e%s\u6bb5\u3002", (String)"ShiftEdit_24", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{typeSizeMap.get(shift.getTypeEnum())});
                        this.getView().showErrorNotification(msg);
                        ShiftEdit.dealImport(eventArgs, msg);
                        break;
                    }
                    case WORK: {
                        String msg = ResManager.loadKDString((String)"\u6838\u5fc3\u4e0a\u73ed\u65f6\u6bb5\u4e0d\u80fd\u8d85\u8fc7%s\u6bb5\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"ShiftEdit_25", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{typeSizeMap.get(shift.getTypeEnum())});
                        this.getView().showErrorNotification(msg);
                        ShiftEdit.dealImport(eventArgs, msg);
                        break;
                    }
                }
                return false;
            }
            shift.setIndex(i);
        }
        return true;
    }

    private boolean genShift(List<ShiftEntry> sortShift, ImportDataEventArgs eventArgs) {
        if (!this.fullShift(sortShift, eventArgs)) {
            return false;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        model.beginInit();
        for (int i = 0; i < sortShift.size(); ++i) {
            ShiftEntry shift = sortShift.get(i);
            tvs.set("shiftperiod", (Object)shift.getShiftPeriod(), i);
            tvs.set("outworktype", (Object)shift.getType(), i);
            tvs.set("refstartday", (Object)shift.getReferenceStartDay().code, i);
            tvs.set("shiftstartdate", (Object)shift.getShiftStart(), i);
            this.fillCheckFlag(i, sortShift, shift);
            tvs.set("isworktimestart", (Object)shift.isWorkCard(), i);
            tvs.set("isworktimeend", (Object)shift.isOffWorkCard(), i);
            tvs.set("refendday", (Object)shift.getReferenceEndDay().code, i);
            tvs.set("shiftenddate", (Object)shift.getShiftEnd(), i);
            tvs.set("worktime", (Object)shift.getWorkTimeHour(), i);
            tvs.set("punchcardpairid", (Object)shift.getPunchCardPairId(), i);
        }
        model.endInit();
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.setValue("cardsnum", (Object)2);
        this.getView().updateView("entryentity");
        return true;
    }

    private void initTakeCard(List<ShiftEntry> sortShift) {
        for (int i = 0; i < sortShift.size(); ++i) {
            ShiftEntry shift = sortShift.get(i);
            this.fillCheckFlag(i, sortShift, shift);
        }
    }

    private void fillCheckFlag(int index, List<ShiftEntry> sortShift, ShiftEntry shift) {
        if (index != 0 && this.isNeedLock(sortShift, shift, index - 1)) {
            shift.setStartCheck(true);
        }
        if (index != sortShift.size() - 1 && this.isNeedLock(sortShift, shift, index + 1)) {
            shift.setEndCheck(true);
        }
        shift.setLockShiftPeriod(false);
    }

    private boolean isLockLastShiftPeriod() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        Boolean isLock = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"inshiftot");
        return isLock == null ? false : isLock;
    }

    private boolean isNeedLock(List<ShiftEntry> sortShift, ShiftEntry shift, int index) {
        return ShiftTypeEnum.REST.getType().equals(sortShift.get(index).getType()) && !ShiftTypeEnum.REST.getType().equals(shift.getType());
    }

    public void beforeImportData(BeforeImportDataEventArgs eventArgs) {
        BigDecimal allDayHour;
        super.beforeImportData(eventArgs);
        String number = (String)eventArgs.getSourceData().get("alldayhour");
        if (StringUtils.isNumeric((String)number) && ((allDayHour = new BigDecimal(number)).compareTo(BigDecimal.ZERO) <= 0 || allDayHour.compareTo(BigDecimal.valueOf(24L)) > 0)) {
            String msg = ResManager.loadKDString((String)"\u201c\u5168\u5929\u73ed\u6b21\u65f6\u6570\u201d\u4e0d\u5141\u8bb8\u4e3a0\uff0c\u4e14\u4e0d\u80fd\u8d85\u8fc724\u5c0f\u65f6\u3002", (String)"ShiftEdit_26", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport((ImportDataEventArgs)eventArgs, msg);
        }
    }

    public void afterImportData(ImportDataEventArgs eventArgs) {
        this.getModel().setValue("offnonplan", eventArgs.getSourceData().get("offnonplan"));
        if (!this.isNonTimeSeq()) {
            if (this.dealGenshiftOperation(eventArgs)) {
                this.doFixPunchCard();
                List<ShiftEntry> sortShift = this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(this.getModel(), dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
                this.fullPunchCard(sortShift, eventArgs, true);
            }
        } else {
            this.getModel().setValue("allday", (Object)1);
        }
        this.importBeforeSaveInit(eventArgs);
        this.saveValidate(eventArgs, "bar_save");
    }

    private void importBeforeSaveInit(ImportDataEventArgs eventArgs) {
        String number;
        DynamicObject dy = this.getModel().getDataEntity().getDynamicObject("createorg");
        if (dy != null) {
            HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(AppMetadataCache.getAppInfo((String)"wtp").getId(), "wtbd_shift");
            long id = dy.getLong("id");
            if (allPermOrgs.hasAllOrgPerm() || allPermOrgs.getHasPermOrgs().contains(id)) {
                this.getModel().setValue("org", (Object)id);
                this.getModel().setValue("useorg", (Object)id);
            } else {
                String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143%s\u5df2\u4e0d\u5728\u60a8\u7684\u6743\u9650\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ShiftEdit_33", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{dy.getString("name")});
                ShiftEdit.dealImport(eventArgs, msg);
            }
        }
        if (StringUtils.isNumeric((String)(number = (String)eventArgs.getSourceData().get("alldayhour")))) {
            BigDecimal allDayHour = new BigDecimal(number);
            this.getModel().setValue("alldayhour", (Object)(allDayHour.compareTo(ShiftConstants.HOUROFDAY) > 0 ? ShiftConstants.HOUROFDAY : allDayHour));
        }
    }

    private void doFixPunchCard() {
        DynamicObject clockrule = this.getModel().getDataEntity().getDynamicObject("clockrule");
        if (clockrule == null) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = clockrule.getDynamicObjectCollection("wtbd_tcardruleentry");
        List shiftEntries = this.getModel().getEntryEntity("entryentity").stream().map(dy -> new ShiftEntry(null, dy, ShiftTypeEnum.SHIFT)).collect(Collectors.toList());
        int cardSum = 0;
        ArrayList<int[]> mergeList = new ArrayList<int[]>(dynamicObjectCollection.size());
        int begin = 0;
        for (int i = 0; i < shiftEntries.size(); ++i) {
            if (((ShiftEntry)shiftEntries.get(i)).getTypeEnum() != ShiftTypeEnum.REST) continue;
            mergeList.add(new int[]{begin, i - 1});
            begin = i + 1;
        }
        mergeList.add(new int[]{begin, shiftEntries.size() - 1});
        Iterator iterator = mergeList.iterator();
        for (DynamicObject culTCard : dynamicObjectCollection) {
            if (!iterator.hasNext()) continue;
            int[] arr = (int[])iterator.next();
            if (HRStringUtils.isNotEmpty((String)culTCard.getString("stakecardrule"))) {
                this.getModel().setValue("isworktimestart", (Object)Boolean.TRUE, arr[0]);
            }
            if (!HRStringUtils.isNotEmpty((String)culTCard.getString("etakecardrule"))) continue;
            this.getModel().setValue("isworktimeend", (Object)Boolean.TRUE, arr[1]);
            cardSum += 2;
        }
        this.getModel().setValue("cardsnum", (Object)cardSum);
    }

    static {
        IS_SAVE.add("bar_saveandnew");
        IS_SAVE.add("bar_save");
        IS_SAVE.add("bar_submit");
        IS_SAVE.add("bar_submitandaudit");
        IS_SAVE.add("confirmchange");
        IS_SAVE.add("bar_audit");
        IS_SAVE.add("save");
        IS_SAVE.add("submit");
        IS_SAVE.add("submitandaudit");
    }
}

