/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.shift.shift.plugin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.shift.ShiftKDString;
import kd.wtc.wtbd.common.shift.ShiftEntry;
import kd.wtc.wtbd.common.shift.ShiftTypeEnum;
import kd.wtc.wtbd.fromplugin.web.shift.shift.plugin.ShiftEdit;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class ShiftEntryService {
    public static boolean validateShift(IFormView view, String type, ImportDataEventArgs importDataEventArgs) {
        List<ShiftEntry> workEntry;
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        String errorMsg = "";
        ShiftEntry shift = new ShiftEntry(view.getModel(), null, ShiftTypeEnum.INTERVAL);
        if (Objects.isNull(shift.getReferenceStartDay())) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53c2\u7167\u65e5\uff08\u5f00\u59cb\uff09\u201d\u3002", (String)"ShiftEntryService_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            view.showErrorNotification(errorMsg);
            return false;
        }
        if (Objects.isNull(shift.getReferenceEndDay())) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53c2\u7167\u65e5\uff08\u7ed3\u675f\uff09\u201d\u3002", (String)"ShiftEntryService_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            view.showErrorNotification(errorMsg);
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)(errorMsg = errorMsg + shift.validate()))) {
            view.showErrorNotification(errorMsg);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            return false;
        }
        List<ShiftEntry> restShift = view.getModel().getEntryEntity("restentry").stream().map(dy -> new ShiftEntry(view.getModel(), dy.getDynamicObject("resttimeid"), ShiftTypeEnum.REST)).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)(errorMsg = errorMsg + ShiftEntryService.validateRest(restShift, shift)))) {
            view.showErrorNotification(errorMsg);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            return false;
        }
        if (restShift.stream().anyMatch(ShiftEntry::isEmpty)) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f11\u606f\u65f6\u95f4\u3002", (String)"ShiftEntryService_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            view.showErrorNotification(errorMsg);
            return false;
        }
        if (ShiftEntry.hasRepeat(restShift)) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u4f11\u606f\u65f6\u6bb5\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEntryService_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            view.showErrorNotification(errorMsg);
            return false;
        }
        if ("C".equals(type) && HRStringUtils.isNotEmpty((String)(errorMsg = ShiftEntryService.validateWorkShift(errorMsg, workEntry = view.getModel().getEntryEntity("workentry").stream().map(dy -> new ShiftEntry(view.getModel(), dy, ShiftTypeEnum.WORK)).collect(Collectors.toList()), shift)))) {
            view.showErrorNotification(errorMsg);
            ShiftEdit.dealImport(importDataEventArgs, errorMsg);
            return false;
        }
        boolean isInOt = dataEntity.getBoolean("isinot");
        if (isInOt) {
            int inOtEndSecond;
            String inOtStartDay = dataEntity.getString("refinotstartday");
            int inOtStart = dataEntity.getInt("inotstart");
            if (WTCStringUtils.isEmpty((String)inOtStartDay)) {
                String localeValue = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"refinotstartday")).getDisplayName().getLocaleValue();
                view.showErrorNotification(ShiftKDString.mustFillTip((String)localeValue));
                return false;
            }
            if (inOtStart < 0) {
                String localeValue = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"inotstart")).getDisplayName().getLocaleValue();
                view.showErrorNotification(ShiftKDString.mustFillTip((String)localeValue));
                return false;
            }
            int shiftStartSecond = shift.getRefShiftStart();
            int inOtStartSecond = RefDateType.from((String)inOtStartDay).getAdjustSecond(inOtStart);
            if (inOtStartSecond < shiftStartSecond) {
                view.showErrorNotification(ShiftKDString.shiftInOtStartBeforeShiftStartTip());
                return false;
            }
            restShift.sort(Comparator.comparingInt(ShiftEntry::getRefShiftStart));
            if (!restShift.isEmpty() && restShift.get(restShift.size() - 1).getRefShiftEnd() > inOtStartSecond) {
                view.showErrorNotification(ShiftKDString.shiftInOtStartBeforeLastRestTip());
                return false;
            }
            String refOtEndDay = dataEntity.getString("refinotendday");
            int inOtEnd = dataEntity.getInt("inotend");
            if (WTCStringUtils.isEmpty((String)refOtEndDay) || inOtEnd < 0) {
                refOtEndDay = dataEntity.getString("refinotendday");
                inOtEnd = dataEntity.getInt("shiftend");
                view.getModel().setValue("refinotendday", (Object)refOtEndDay);
                view.getModel().setValue("inotend", (Object)inOtEnd);
            }
            if (inOtStartSecond >= (inOtEndSecond = RefDateType.from((String)refOtEndDay).getAdjustSecond(inOtEnd))) {
                view.showErrorNotification(ShiftKDString.shiftInOtStartAfterShiftEndTip());
                return false;
            }
        }
        return true;
    }

    public static void generatorShiftEntry(IFormView view, String type, LinkedList<ShiftEntry> sortShift) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        boolean isInShiftOt = dataEntity.getBoolean("isinot");
        ShiftEntry shift = new ShiftEntry(view.getModel(), null, ShiftTypeEnum.INTERVAL);
        List<ShiftEntry> restShift = view.getModel().getEntryEntity("restentry").stream().map(dy -> new ShiftEntry(view.getModel(), dy.getDynamicObject("resttimeid"), ShiftTypeEnum.REST)).filter(shiftEntry -> !shiftEntry.isEmpty()).collect(Collectors.toList());
        List<ShiftEntry> workShift = view.getModel().getEntryEntity("workentry").stream().map(dy -> new ShiftEntry(view.getModel(), dy, ShiftTypeEnum.WORK)).filter(shiftEntry -> !shiftEntry.isEmpty()).collect(Collectors.toList());
        if ("C".equals(type)) {
            ShiftEntryService.mergeRestAndWork(restShift, workShift);
        }
        workShift.addAll(restShift);
        if (isInShiftOt) {
            ShiftEntry shiftEntry2 = new ShiftEntry();
            shiftEntry2.setReferenceStartDay(RefDateType.from((String)dataEntity.getString("refinotstartday")));
            shiftEntry2.setReferenceEndDay(RefDateType.from((String)dataEntity.getString("refinotendday")));
            shiftEntry2.setShiftStartAndCheck(dataEntity.getInt("inotstart"));
            shiftEntry2.setShiftEndAndCheck(dataEntity.getInt("inotend"));
            shiftEntry2.setType(ShiftTypeEnum.OUTWORK);
            ArrayList subEntryList = Lists.newArrayList((Object[])new ShiftEntry[]{shiftEntry2});
            ShiftEntryService.mergeRestAndWork(subEntryList, workShift);
            workShift.add(shiftEntry2);
        }
        ShiftEntryService.getSortShift(shift, workShift, new ArrayList<ShiftEntry>(), sortShift);
        ShiftEntryService.initShiftTable(shift, sortShift, view);
        if (!sortShift.isEmpty()) {
            sortShift.getFirst().setWorkCard(true);
            sortShift.getLast().setOffWorkCard(true);
        }
    }

    private static String validateRest(List<ShiftEntry> restShift, ShiftEntry shift) {
        for (ShiftEntry rest : restShift) {
            if (rest.getRefShiftStart() <= shift.getRefShiftStart()) {
                return ResManager.loadKDString((String)"\u6700\u65e9\u4f11\u606f\u65f6\u70b9\u4e0d\u80fd\u65e9\u4e8e\u6700\u65e9\u4e0a\u73ed\u65f6\u70b9\u3002", (String)"ShiftEntryService_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            }
            if (rest.getRefShiftEnd() < shift.getRefShiftEnd()) continue;
            return ResManager.loadKDString((String)"\u6700\u665a\u4f11\u606f\u65f6\u70b9\u4e0d\u80fd\u665a\u4e8e\u6700\u665a\u4e0b\u73ed\u65f6\u70b9\u3002", (String)"ShiftEntryService_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private static String validateWorkShift(String errorMsg, List<ShiftEntry> workEntry, ShiftEntry shift) {
        if (workEntry.isEmpty()) {
            errorMsg = ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u73ed\u5185\u81f3\u5c11\u4fdd\u7559\u4e00\u6bb5\u6838\u5fc3\u65f6\u6bb5\u3002", (String)"ShiftEntryService_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            return errorMsg;
        }
        String msg = ShiftEntryService.dealWorkDoOperation(shift, workEntry);
        if (!"donothing".equals(msg)) {
            errorMsg = msg;
        }
        return errorMsg;
    }

    private static void mergeRestAndWork(List<ShiftEntry> restShifts, List<ShiftEntry> workShifts) {
        for (ShiftEntry restShift : restShifts) {
            for (int i = 0; i < workShifts.size(); ++i) {
                ShiftEntry workShift = workShifts.get(i);
                if (restShift.contain(workShift)) {
                    workShifts.remove(i);
                    --i;
                    continue;
                }
                List splitShift = workShift.getSplitShift(restShift);
                if (splitShift.isEmpty()) continue;
                workShifts.addAll(splitShift);
                workShifts.remove(i);
                --i;
            }
        }
    }

    private static void getSortShift(ShiftEntry shift, List<ShiftEntry> workShift, List<ShiftEntry> restShift, List<ShiftEntry> sortShift) {
        workShift.addAll(restShift);
        workShift.sort(Comparator.comparingInt(ShiftEntry::getRefShiftStart));
        int startTime = shift.getRefShiftStart();
        for (ShiftEntry cul : workShift) {
            if (startTime < cul.getRefShiftStart()) {
                ShiftEntry copy = shift.clone();
                copy.setShiftStartAndCheck(startTime).setReferenceStartDay(RefDateType.fromBySeconds((int)startTime)).setShiftEndAndCheck(cul.getShiftStart()).setReferenceEndDay(cul.getReferenceStartDay());
                sortShift.add(copy);
            }
            sortShift.add(cul);
            startTime = cul.getRefShiftEnd();
        }
        if (startTime < shift.getRefShiftEnd()) {
            ShiftEntry copy = shift.clone();
            copy.setShiftStartAndCheck(startTime).setReferenceStartDay(RefDateType.fromBySeconds((int)startTime)).setShiftEndAndCheck(shift.getShiftEnd()).setReferenceEndDay(shift.getReferenceEndDay());
            sortShift.add(copy);
        }
    }

    private static void initShiftTable(ShiftEntry shift, List<ShiftEntry> sortShift, IFormView view) {
        ShiftEntryService.setStandardTime(shift, view);
        int count = 0;
        boolean isShift = false;
        for (int i = 0; i < sortShift.size(); ++i) {
            ShiftTypeEnum typeEnum = sortShift.get(i).getTypeEnum();
            if (i == 0 && ShiftTypeEnum.REST != typeEnum) {
                isShift = true;
                ++count;
                continue;
            }
            if (!isShift && ShiftTypeEnum.REST != typeEnum) {
                isShift = true;
                ++count;
                continue;
            }
            if (ShiftTypeEnum.REST != typeEnum) continue;
            isShift = false;
        }
        view.getModel().setValue("workingsections", (Object)count);
        view.updateView("workingsections");
    }

    public static void setStandardTime(ShiftEntry shift, IFormView view) {
        int restTime = Optional.of(view.getModel().getEntryEntity("restentry")).orElseGet(DynamicObjectCollection::new).stream().map(dy -> new ShiftEntry(view.getModel(), dy.getDynamicObject("resttimeid"), ShiftTypeEnum.REST)).map(ShiftEntry::getTime).reduce(Integer::sum).orElse(0);
        ((Label)view.getControl("standardtime")).setText(WTCDateUtils.secondToTime((long)(shift.getRefShiftEnd() - shift.getRefShiftStart() - restTime), (String)"hhmm"));
        view.updateView("standardtime");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String refInOtStartDay = dataEntity.getString("refinotstartday");
        int inOtStart = dataEntity.getInt("inotstart");
        if (WTCStringUtils.isNotEmpty((String)refInOtStartDay) && inOtStart >= 0) {
            RefDateType from = RefDateType.from((String)refInOtStartDay);
            from = from == null ? RefDateType.TODAY : from;
            int shiftOtStart = from.getAdjustSecond(inOtStart);
            ((Label)view.getControl("nootstandardtime")).setText(WTCDateUtils.secondToTime((long)(shiftOtStart - shift.getRefShiftStart() - restTime), (String)"hhmm"));
        }
    }

    public static String dealWorkDoOperation(ShiftEntry shift, List<ShiftEntry> workList) {
        for (ShiftEntry work : workList) {
            if (work.isEmpty()) {
                if (work.getShiftStart() == -1) {
                    return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u5fc3\u5f00\u59cb\u65f6\u70b9\u201d\u3002", (String)"ShiftEntryService_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                }
                if (work.getShiftEnd() == -1) {
                    return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u5fc3\u7ed3\u675f\u65f6\u70b9\u201d\u3002", (String)"ShiftEntryService_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                }
                if (work.getReferenceStartDay() == null) {
                    return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53c2\u7167\u65e5\uff08\u5f00\u59cb\uff09\u201d\u3002", (String)"ShiftEntryService_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                }
                if (work.getReferenceEndDay() == null) {
                    return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53c2\u7167\u65e5\uff08\u7ed3\u675f\uff09\u201d\u3002", (String)"ShiftEntryService_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                }
            }
            if (work.checkTimeDuration()) {
                return ResManager.loadKDString((String)"\u6838\u5fc3\u5f00\u59cb\u65f6\u70b9\u4e0d\u80fd\u665a\u4e8e\u6838\u5fc3\u7ed3\u675f\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            }
            if (shift.getRefShiftStart() > work.getRefShiftStart()) {
                return ResManager.loadKDString((String)"\u6838\u5fc3\u5f00\u59cb\u65f6\u70b9\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u73ed\u5f00\u59cb\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            }
            if (shift.getRefShiftEnd() >= work.getRefShiftEnd()) continue;
            return ResManager.loadKDString((String)"\u6838\u5fc3\u7ed3\u675f\u65f6\u70b9\u4e0d\u80fd\u665a\u4e8e\u4e0b\u73ed\u7ed3\u675f\u65f6\u70b9\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        if (ShiftEntry.hasRepeat(workList)) {
            return ResManager.loadKDString((String)"\u6838\u5fc3\u65f6\u6bb5\u4e0d\u5141\u8bb8\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ShiftEntryService_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        return "donothing";
    }
}

