/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.shiftmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ai.util.JsonUtil;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.shift.ShiftServiceHelper;
import kd.wtc.wtbd.business.workschedule.shiftmode.ShiftModeService;
import kd.wtc.wtbd.business.workschedule.shiftmode.ShiftModeViewService;
import kd.wtc.wtbd.common.shiftmode.ShiftModeEntry;
import kd.wtc.wtbd.common.shiftmode.ShiftModeTableSelectedIndexes;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.model.customcontrol.shiftmode.ShiftModeCell;
import kd.wtc.wtbs.common.model.customcontrol.shiftmode.ShiftModeTable;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class ShiftModeEdit
extends HRDataBaseEdit {
    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        evt.getFormShowParameter().setCustomParam("checkRightAppId", (Object)"wtp");
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection holHandleEntry = dataEntity.getDynamicObjectCollection("holhandleentry");
        if (WTCCollections.isNotEmpty((Collection)holHandleEntry)) {
            int index = 0;
            this.getModel().setValue("holhandlemethod" + index, ((DynamicObject)holHandleEntry.get(index)).get("holhandlemethod"));
            this.getModel().setValue("assignshift" + index, ((DynamicObject)holHandleEntry.get(index)).get("assignshift"));
            this.getModel().setValue("holdatetypes" + index, (Object)((DynamicObject)holHandleEntry.get(index)).getDynamicObjectCollection("holdatetypes").stream().map(dy -> dy.getLong("fbasedataid.id")).toArray());
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        BillList billlistap;
        super.beforeClosed(event);
        if (this.getView().getParentView() != null && (billlistap = (BillList)this.getView().getParentView().getControl("billlistap")) != null) {
            billlistap.clearSelection();
            billlistap.refresh();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void registerListener(EventObject object) {
        super.registerListener(object);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        ShiftModeViewService.getInstance().handleF7(this.getView(), "holdatetypes0", "assignshift0");
    }

    public void customEvent(CustomEventArgs args) {
        if ("dutyrule".equals(args.getKey()) && "select".equals(args.getEventName())) {
            ShiftModeTableSelectedIndexes selectedIndexes = this.resolveSelectedIndexes(args.getEventArgs());
            this.refreshSelectedIndexes(selectedIndexes);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldName = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        switch (fieldName) {
            case "week": 
            case "day": {
                Object data = args.getChangeSet()[0].getNewValue();
                if (data != null) {
                    ArrayList<Integer> selectedCells = new ArrayList<Integer>(1);
                    selectedCells.add(0);
                    this.initDutyRuleTable(this.getDutyRuleTableFromCache(), selectedCells);
                }
                this.setCycleModePanel();
                break;
            }
            case "cyclemode": {
                ShiftModeViewService.getInstance().handleModeChange(this.getView(), this.getModel().getDataEntity());
                break;
            }
        }
        if (fieldName.startsWith("holhandlemethod")) {
            ShiftModeViewService.getInstance().handleHolidayPanel(this.getView(), this.getModel().getDataEntity());
        }
    }

    private void setCycleModePanel() {
        String cycleMode = this.getModel().getDataEntity().getString("cyclemode");
        this.getView().setEnable(Boolean.valueOf("d".equals(cycleMode)), new String[]{"day"});
        this.getView().setEnable(Boolean.valueOf("w".equals(cycleMode)), new String[]{"week"});
    }

    public void beforeBindData(EventObject eventObject) {
        Object fromWhere;
        this.clearCacheData(eventObject);
        ArrayList<Integer> selectedCells = new ArrayList<Integer>(1);
        selectedCells.add(0);
        this.initDutyRuleTable(this.getDutyRuleTableFromEntry(), selectedCells);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ctrlstrategy"});
        }
        if ("click_from_view".equals(fromWhere = this.getView().getFormShowParameter().getCustomParam("click_from_view"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            status = OperationStatus.VIEW;
        }
        if (status == OperationStatus.EDIT) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modifyhis"});
        }
        this.setCycleModePanel();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        ShiftModeViewService.getInstance().handleHolidayPanel(this.getView(), this.getModel().getDataEntity());
    }

    private void clearCacheData(EventObject object) {
        BaseView baseView;
        BaseShowParameter formShowParameter;
        BillOperationStatus billStatus;
        Object source = object.getSource();
        if (source instanceof BaseView && BillOperationStatus.ADDNEW.equals((Object)(billStatus = (formShowParameter = (BaseShowParameter)(baseView = (BaseView)object.getSource()).getFormShowParameter()).getBillStatus()))) {
            ShiftModeTable shiftModeTable = new ShiftModeTable();
            this.refreshShiftRuleTableCache(shiftModeTable);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ShiftModeTableSelectedIndexes selectedcells;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (("addclazz".equals(itemKey) || "clearclazz".equals(itemKey)) && (selectedcells = this.getSelectedCellIndexesFromCache()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5355\u5143\u683c\u3002", (String)"ShiftModeEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addclazz": {
                this.openShiftF7();
                break;
            }
            case "clearclazz": {
                this.clearSelectedShift();
                break;
            }
            case "bar_modifyhis": {
                this.openPage(OperationStatus.EDIT);
                break;
            }
        }
    }

    protected void openPage(OperationStatus operationStatus) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String entityNumber = this.getView().getEntityId();
        BillShowParameter showParam = new BillShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.InCurrentForm);
        if (this.getView().getParentView() != null) {
            showParam.setParentPageId(this.getView().getParentView().getPageId());
        }
        showParam.setShowTitle(true);
        showParam.setFormId(entityNumber);
        showParam.setPkId(dataEntity.getPkValue());
        showParam.setStatus(operationStatus);
        String status = this.getString("status");
        if ("C".equals(status)) {
            showParam.setBillStatus(BillOperationStatus.AUDIT);
        } else if ("B".equals(status)) {
            showParam.setBillStatus(BillOperationStatus.SUBMIT);
        }
        showParam.setCustomParam("vid", this.getView().getFormShowParameter().getCustomParam("vid"));
        String toppageid = (String)this.getView().getFormShowParameter().getCustomParam("param_currentlistpageid");
        showParam.setCustomParam("param_currentlistpageid", (Object)toppageid);
        this.setCaption(showParam);
        this.getView().showForm((FormShowParameter)showParam);
    }

    protected String getString(String field) {
        return this.getModel().getDataEntity().getString(field);
    }

    protected String getCustomFormCaption() {
        return null;
    }

    protected String getTargetEntityName() {
        return this.getModel().getDataEntity().getString("name");
    }

    private void setCaption(BillShowParameter showParameter) {
        String caption = this.getCustomFormCaption();
        if (HRStringUtils.isEmpty((String)caption)) {
            caption = WtbsBusinessUtils.getFormCaption((String)showParameter.getFormId(), (OperationStatus)showParameter.getStatus(), this::getTargetEntityName);
        }
        showParameter.setCaption(caption);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("save".equals(source.getOperateKey())) {
            ShiftModeTable shiftModeTable = this.getDutyRuleTableFromCache();
            String errMsg = this.checkShiftMode(shiftModeTable);
            if (HRStringUtils.isEmpty((String)errMsg)) {
                this.setShiftRuleEntryData(shiftModeTable);
            } else {
                this.getView().showTipNotification(errMsg);
                args.setCancel(true);
            }
            this.setHolHandleData2Entry();
            this.checkMustInput(args);
        }
    }

    private void setHolHandleData2Entry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean handleHol = dataEntity.getBoolean("handleholiday");
        if (handleHol) {
            this.getModel().deleteEntryData("holhandleentry");
            this.getModel().createNewEntryRow("holhandleentry");
            int index = 0;
            this.getModel().setValue("holhandlemethod", dataEntity.get("holhandlemethod" + index), index);
            this.getModel().setValue("assignshift", dataEntity.get("assignshift" + index), index);
            this.getModel().setValue("holdatetypes", (Object)dataEntity.getDynamicObjectCollection("holdatetypes" + index).stream().map(dy -> dy.getLong("fbasedataid.id")).toArray(), index);
        } else {
            this.getModel().deleteEntryData("holhandleentry");
        }
    }

    private void checkMustInput(BeforeDoOperationEventArgs args) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (dynamicObject == null) {
            return;
        }
        String flag = dynamicObject.getString("cyclemode");
        if ("w".equals(flag) && dynamicObject.getLong("week") <= 0L) {
            String tmp = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5468\u201d\u3002", (String)"ShiftModeEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(tmp);
            args.setCancel(true);
        } else if ("d".equals(flag) && dynamicObject.getLong("day") <= 0L) {
            String tmp = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5929\u201d\u3002", (String)"ShiftModeEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(tmp);
            args.setCancel(true);
        }
    }

    private String checkShiftMode(ShiftModeTable shiftModeTable) {
        if (shiftModeTable.getCells().isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u73ed\u6b21\u3002", (String)"ShiftModeEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        int editableCells = shiftModeTable.getEndindex() - shiftModeTable.getStartindex() + 1;
        if (shiftModeTable.getCells().size() != editableCells) {
            return ResManager.loadKDString((String)"\u8bf7\u4e3a\u6240\u6709\u5355\u5143\u683c\u6dfb\u52a0\u73ed\u6b21\u3002", (String)"ShiftModeEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        return this.checkShiftOverlap(shiftModeTable);
    }

    private String checkShiftOverlap(ShiftModeTable shiftModeTable) {
        ShiftModeService.getInstance().validateShiftOverlap(shiftModeTable);
        if (shiftModeTable.getCells().stream().anyMatch(cell -> Boolean.TRUE.equals(cell.getShiftTimeOverLap()))) {
            return ResManager.loadKDString((String)"\u76f8\u90bb\u73ed\u6b21\u5b58\u5728\u65f6\u6bb5\u91cd\u53e0\uff0c\u8bf7\u5148\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u3002", (String)"ShiftModeEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void checkShiftOverlapAndShowMessage(ShiftModeTable shiftModeTable) {
        String msg = this.checkShiftOverlap(shiftModeTable);
        if (msg != null) {
            this.getView().showTipNotification(msg);
        }
    }

    private void openShiftF7() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"wtbd_shift", (boolean)false);
        showParameter.setUseOrgId(this.getModel().getDataEntity().getLong("createorg.id"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "F7_SHIFT"));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter statusEqual = new QFilter("status", "=", (Object)"C");
        QFilter statusEqualAndEnableEqual = statusEqual.and(new QFilter("enable", "=", (Object)"1"));
        listFilterParameter.setFilter(statusEqualAndEnableEqual);
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("F7_SHIFT".equals(actionId)) {
            if (event.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection row = (ListSelectedRowCollection)event.getReturnData();
            this.addShift(row);
        }
    }

    private void initDutyRuleTable(ShiftModeTable shiftModeTable, List<Integer> selectedCells) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String cycleMode = dataEntity.getString("cyclemode");
        if (StringUtils.isBlank((String)cycleMode)) {
            return;
        }
        int editableCellCount = 0;
        if ("w".equals(cycleMode)) {
            int weeks = dataEntity.getInt("week");
            if (weeks > 0) {
                editableCellCount = weeks * 7;
            }
        } else {
            int days = dataEntity.getInt("day");
            if (days > 0) {
                editableCellCount = days;
            }
        }
        if (editableCellCount < 1) {
            return;
        }
        int startIndex = 0;
        int endIndex = startIndex + editableCellCount - 1;
        int rows = (int)Math.ceil((double)(endIndex + 1) / 7.0);
        shiftModeTable.setStartindex(startIndex);
        shiftModeTable.setEndindex(endIndex);
        shiftModeTable.setRows(rows);
        if (!CollectionUtils.isEmpty((Collection)shiftModeTable.getCells())) {
            if (!cycleMode.equals(shiftModeTable.getMode())) {
                shiftModeTable.setCells(Collections.emptySet());
            } else {
                Set clearCells = shiftModeTable.getCells().stream().filter(cell -> cell.getIndex() > endIndex || cell.getIndex() < startIndex).collect(Collectors.toSet());
                shiftModeTable.removeCells(clearCells);
            }
        }
        shiftModeTable.setMode(cycleMode);
        shiftModeTable.setSelectedCells(selectedCells);
        this.checkShiftOverlapAndShowMessage(shiftModeTable);
        this.refreshShiftRuleTableCache(shiftModeTable);
        this.setCustomData("init", shiftModeTable);
        ShiftModeTableSelectedIndexes shiftModeTableSelectedIndexes = new ShiftModeTableSelectedIndexes();
        shiftModeTableSelectedIndexes.setSelected(selectedCells);
        this.refreshSelectedIndexes(shiftModeTableSelectedIndexes);
    }

    private void clearSelectedShift() {
        ShiftModeTableSelectedIndexes selectedIndexes = this.getSelectedCellIndexesFromCache();
        ShiftModeTable shiftModeTable = this.getDutyRuleTableFromCache();
        shiftModeTable.removeCellByIndex(selectedIndexes.getSelected());
        this.checkShiftOverlapAndShowMessage(shiftModeTable);
        this.setCustomData("set", shiftModeTable.getCells());
        this.refreshShiftRuleTableCache(shiftModeTable);
        this.shiftModeChange();
    }

    private void addShift(ListSelectedRowCollection selectedRow) {
        Set<ShiftModeCell> selectedCellsWithClazz = this.getSelectedCellsWithClazz(selectedRow);
        ShiftModeTable shiftModeTable = this.getDutyRuleTableFromCache();
        shiftModeTable.addCells(selectedCellsWithClazz);
        this.checkShiftOverlapAndShowMessage(shiftModeTable);
        this.setCustomData("set", shiftModeTable.getCells());
        this.refreshShiftRuleTableCache(shiftModeTable);
        this.shiftModeChange();
    }

    private void shiftModeChange() {
        this.getModel().setValue("shiftmodechange", (Object)"1");
    }

    private ShiftModeTableSelectedIndexes resolveSelectedIndexes(String selectedCells) {
        if (StringUtils.isBlank((String)selectedCells)) {
            return new ShiftModeTableSelectedIndexes();
        }
        return (ShiftModeTableSelectedIndexes)JsonUtil.decodeFromString((String)selectedCells, ShiftModeTableSelectedIndexes.class);
    }

    private void refreshShiftRuleTableCache(ShiftModeTable shiftModeTable) {
        this.getCache().put("shift_rule_data", (Object)shiftModeTable);
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void refreshSelectedIndexes(ShiftModeTableSelectedIndexes selectedIndexes) {
        this.getCache().put("selected_cells_data", (Object)selectedIndexes);
    }

    private ShiftModeTable getDutyRuleTableFromCache() {
        ShiftModeTable shiftModeTable = (ShiftModeTable)this.getCache().get("shift_rule_data", ShiftModeTable.class);
        if (shiftModeTable == null) {
            shiftModeTable = new ShiftModeTable();
        }
        return shiftModeTable;
    }

    private void setCustomData(String eventName, Object args) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("event", eventName);
        data.put("args", args);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("dutyrule");
        customcontrol.setData((Object)data);
    }

    private ShiftModeTableSelectedIndexes getSelectedCellIndexesFromCache() {
        ShiftModeTableSelectedIndexes shiftModeTableSelectedIndexes = (ShiftModeTableSelectedIndexes)this.getCache().get("selected_cells_data", ShiftModeTableSelectedIndexes.class);
        if (shiftModeTableSelectedIndexes == null) {
            shiftModeTableSelectedIndexes = new ShiftModeTableSelectedIndexes();
        }
        return shiftModeTableSelectedIndexes;
    }

    private Set<ShiftModeCell> getSelectedCellsWithClazz(ListSelectedRowCollection selectedRow) {
        ShiftModeTableSelectedIndexes selectedClazzIndexes = this.getSelectedCellIndexesFromCache();
        if (selectedClazzIndexes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"ShiftModeEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        long shiftId = Long.parseLong(selectedRow.get(0).getPrimaryKeyValue().toString());
        DynamicObject shiftDyn = this.queryShiftById(shiftId);
        if (shiftDyn == null) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u73ed\u6b21\u4fe1\u606f:%s\u3002", (String)"ShiftModeEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), shiftId));
        }
        return selectedClazzIndexes.getSelected().stream().map(index -> {
            ShiftModeCell selectedCell = new ShiftModeCell();
            selectedCell.setIndex(index.intValue());
            selectedCell.setId(shiftId);
            return ShiftModeService.getInstance().getShiftModeCell(selectedCell, shiftDyn);
        }).collect(Collectors.toSet());
    }

    private void setShiftRuleEntryData(ShiftModeTable shiftModeTable) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("wtbd_shiftmodeentry");
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        model.beginInit();
        List<ShiftModeEntry> shiftModeEntries = this.convert(shiftModeTable);
        for (int i = shiftModeEntries.size() - 1; i >= 0; --i) {
            ShiftModeEntry mode = shiftModeEntries.get(i);
            TableValueSetter tableValueSetter = tvs.addRow(new Object[0]);
            tableValueSetter.set("shiftid", (Object)mode.getShiftid(), i);
            tableValueSetter.set("weekday", (Object)mode.getWeekday(), i);
            tableValueSetter.set("nweek", (Object)mode.getNweek(), i);
            tableValueSetter.set("nday", (Object)mode.getNday(), i);
        }
        model.batchCreateNewEntryRow("wtbd_shiftmodeentry", tvs);
        this.getView().updateView("wtbd_shiftmodeentry");
        model.endInit();
    }

    private List<ShiftModeEntry> convert(ShiftModeTable shiftModeTable) {
        if (shiftModeTable.getEndindex() < shiftModeTable.getStartindex()) {
            return Collections.emptyList();
        }
        HashMap index2ShiftClazzId = Maps.newHashMapWithExpectedSize((int)shiftModeTable.getCells().size());
        shiftModeTable.getCells().forEach(cell -> index2ShiftClazzId.put(cell.getIndex(), cell.getId()));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(shiftModeTable.getEndindex() - shiftModeTable.getStartindex() + 1));
        for (int i = shiftModeTable.getStartindex(); i <= shiftModeTable.getEndindex(); ++i) {
            ShiftModeEntry shiftModeEntry = new ShiftModeEntry();
            shiftModeEntry.setShiftid((Long)index2ShiftClazzId.get(i));
            if ("w".equals(shiftModeTable.getMode())) {
                shiftModeEntry.setWeekday(Integer.valueOf(i % shiftModeTable.getCols() + 1));
                int nweek = (int)Math.ceil(((double)i + 1.0) / (double)shiftModeTable.getCols());
                shiftModeEntry.setNweek(Integer.valueOf(nweek));
            } else {
                shiftModeEntry.setNday(Integer.valueOf(i + 1));
            }
            list.add(shiftModeEntry);
        }
        return list;
    }

    private ShiftModeTable getDutyRuleTableFromEntry() {
        return ShiftModeService.getInstance().getShiftTable(this.getModel().getDataEntity(true), true);
    }

    private DynamicObject queryShiftById(Long shiftId) {
        return ShiftServiceHelper.queryShiftById((Long)shiftId);
    }
}

