/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.takeconfig;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbd.common.takecard.TakeCardKDString;
import kd.wtc.wtbd.common.vo.takeconfig.CardPointVo;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.punch.GeneratorNumberService;
import kd.wtc.wtbs.common.constants.takecard.CardConfigConstants;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class TakeCardConfigEdit
extends HRCoreBaseBillEdit {
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        this.startEndDisEnable(dyObjs.size() - 1);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        switch (operationStatus) {
            case VIEW: {
                String classTimeNumStr = (String)this.getModel().getValue("classtimenum");
                Integer classTimeNum = Integer.parseInt(classTimeNumStr);
                this.setClasstimenum(classTimeNum);
                this.initCustomControl(dyObjs, "init", this.getPageCustomStatus());
                break;
            }
            case EDIT: 
            case ADDNEW: {
                GeneratorNumberService generatorNumberService = new GeneratorNumberService();
                int currentNum = generatorNumberService.getCurrentNum();
                this.setClasstimenum(currentNum);
                this.initCustomControl(dyObjs, "init", this.getPageCustomStatus());
                break;
            }
        }
    }

    private void initCustomControl(DynamicObjectCollection dynCollection, String method, int type) {
        ArrayList<HashMap<String, CardPointVo>> phases = new ArrayList<HashMap<String, CardPointVo>>();
        int index = 0;
        int num = 0;
        boolean validDisable = false;
        for (DynamicObject dyn : dynCollection) {
            HashMap<String, CardPointVo> cardPointMap = new HashMap<String, CardPointVo>(16);
            String time = (String)dyn.get("time");
            String timeType = dyn.getString("classtimetype");
            String value = time;
            if (HRStringUtils.isNotEmpty((String)time) && time.length() <= 3) {
                value = HRStringUtils.equals((String)"1", (String)timeType) ? TakeCardKDString.workTime() + time : TakeCardKDString.restTime() + time;
            }
            cardPointMap.put("time", this.getCardPointVo(index, value, Boolean.FALSE));
            boolean isWorkTimeStart = dyn.getBoolean("isworktimestart");
            String workTimeStartValue = isWorkTimeStart ? "1" : "2";
            workTimeStartValue = this.closeRestTimeSeq(timeType, workTimeStartValue);
            boolean workTimeStartDisable = num == 0;
            cardPointMap.put("isworktimestart", this.getCardPointVo(++index, workTimeStartValue, workTimeStartDisable));
            validDisable = this.isOpenEndCard(dynCollection, ++index, num, validDisable, dyn, cardPointMap, timeType);
            validDisable = this.isOpenCheckCard(++index, validDisable, dyn, cardPointMap, timeType);
            ++index;
            ++num;
            phases.add(cardPointMap);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("cardsetpoint");
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        response.put("event", method);
        response.put("cardData", phases);
        response.put("type", type);
        response.put("isopenvalid", WTCFormUtils.getPromptMap((IFormView)this.getView()).get("isopenvalid"));
        response.put("time", WTCFormUtils.getPromptMap((IFormView)this.getView()).get("time"));
        customcontrol.setData(response);
    }

    private boolean isOpenCheckCard(int index, boolean validDisable, DynamicObject dyn, Map<String, CardPointVo> cardPointMap, String timeType) {
        boolean isOpenValid = dyn.getBoolean("isopenvalid");
        String openValidValue = isOpenValid ? "1" : "2";
        boolean openValidDisable = false;
        if (HRStringUtils.equals((String)"1", (String)timeType)) {
            openValidValue = "0";
        } else {
            openValidDisable = validDisable;
            validDisable = false;
        }
        cardPointMap.put("isopenvalid", this.getCardPointVo(index, openValidValue, openValidDisable));
        return validDisable;
    }

    private boolean isOpenEndCard(DynamicObjectCollection dynCollection, int index, int num, boolean validDisable, DynamicObject dyn, Map<String, CardPointVo> cardPointMap, String timeType) {
        boolean workTimeEndDisable;
        boolean isWorkTimeEnd = dyn.getBoolean("isworktimeend");
        String workTimeEndValue = isWorkTimeEnd ? "1" : "2";
        workTimeEndValue = this.closeRestTimeSeq(timeType, workTimeEndValue);
        boolean bl = workTimeEndDisable = num == dynCollection.size() - 1;
        if (StringUtils.equals((CharSequence)workTimeEndValue, (CharSequence)"1")) {
            validDisable = true;
        }
        cardPointMap.put("isworktimeend", this.getCardPointVo(index, workTimeEndValue, workTimeEndDisable));
        return validDisable;
    }

    private String closeRestTimeSeq(String timeType, String workTimeStartValue) {
        if (HRStringUtils.equals((String)"2", (String)timeType)) {
            workTimeStartValue = "0";
        }
        return workTimeStartValue;
    }

    private CardPointVo getCardPointVo(int index, String value, Boolean disable) {
        CardPointVo cardPointVo = new CardPointVo();
        cardPointVo.setIndex(index);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        cardPointVo.setDisable(operationStatus == OperationStatus.VIEW ? Boolean.TRUE : disable);
        cardPointVo.setValue(value);
        return cardPointVo;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        String classGetNumStr = (String)this.getModel().getValue("classgetnum");
        switch (fieldKey) {
            case "classtimenum": {
                this.setClassGetNumValue();
                this.genTimeNun();
                String clasTimeNumStr = (String)this.getModel().getValue("classtimenum");
                if (!HRStringUtils.isNotEmpty((String)classGetNumStr) || !HRStringUtils.isNotEmpty((String)clasTimeNumStr)) break;
                int classGetNum = Integer.parseInt(classGetNumStr);
                int clasTimeNum = Integer.parseInt(clasTimeNumStr);
                int temp = clasTimeNum * 2;
                if (temp < classGetNum) {
                    String getNum = clasTimeNum == 1 ? "2" : null;
                    this.getModel().setValue("classgetnum", (Object)getNum);
                    return;
                }
                this.openPunchCard(classGetNumStr);
                break;
            }
            case "classgetnum": {
                if (!HRStringUtils.isNotEmpty((String)classGetNumStr)) break;
                this.genTimeNun();
                this.openPunchCard(classGetNumStr);
                break;
            }
        }
    }

    private boolean containComboValue(List<ComboItem> list, String comboValue) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isEmpty((CharSequence)comboValue)) {
            return false;
        }
        for (ComboItem comboItem : list) {
            if (!StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)comboValue)) continue;
            return true;
        }
        return false;
    }

    private void setClassGetNumValue() {
        IDataModel iDataModel = this.getModel();
        String classTimeNum = (String)iDataModel.getValue("classtimenum");
        String classGetNum = (String)iDataModel.getValue("classgetnum");
        ComboEdit comboEdit = (ComboEdit)this.getControl("classgetnum");
        if (StringUtils.isNotBlank((CharSequence)classTimeNum)) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
            this.getComboItemList(Integer.parseInt(classTimeNum), list);
            Collections.reverse(list);
            comboEdit.setComboItems(list);
            if (list.size() == 1) {
                this.getModel().setValue("classgetnum", (Object)"2");
            } else if (!this.containComboValue(list, classGetNum)) {
                this.getModel().setValue("classgetnum", null);
            }
        }
    }

    private List<ComboItem> getComboItemList(int num, List<ComboItem> list) {
        if (list == null) {
            list = new ArrayList<ComboItem>();
        }
        String comboValue = String.valueOf(num * 2);
        list.add(new ComboItem(new LocaleString(comboValue), comboValue));
        if (num > 1) {
            this.getComboItemList(--num, list);
        }
        return list;
    }

    private void genTimeNun() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            dynamicObjects.addAll(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
        }
        this.voidEntry();
        IDataModel iDataModel = this.getModel();
        String classGetNum = (String)iDataModel.getValue("classtimenum");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (StringUtils.isNotBlank((CharSequence)classGetNum)) {
            int endGetNum = Integer.parseInt(classGetNum);
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            int j = 0;
            for (int i = 1; i <= endGetNum; ++i) {
                int rowIndex = (i - 1) * 2;
                tvs.set("time", (Object)(CardConfigConstants.WORK_TIME_SEQ + i), rowIndex);
                tvs.set("classtimetype", (Object)"1", rowIndex);
                tvs.set("isworktimestart", (Object)(i == 1 ? 1 : 0), rowIndex);
                tvs.set("isworktimeend", (Object)(i == endGetNum ? 1 : 0), rowIndex);
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects) && dynamicObjects.size() > j) {
                    tvs.set("entryboid", ((DynamicObject)dynamicObjects.get(j++)).get("entryboid"), rowIndex);
                }
                if (i == endGetNum) continue;
                tvs.set("time", (Object)(CardConfigConstants.REST_TIME_SEQ + i), rowIndex + 1);
                tvs.set("classtimetype", (Object)"2", rowIndex + 1);
                tvs.set("isopenvalid", (Object)Boolean.FALSE, rowIndex + 1);
                if (CollectionUtils.isEmpty((Collection)dynamicObjects) || dynamicObjects.size() <= j) continue;
                tvs.set("entryboid", ((DynamicObject)dynamicObjects.get(j++)).get("entryboid"), rowIndex + 1);
            }
            model.batchCreateNewEntryRow("entryentity", tvs);
            this.startEndDisEnable((endGetNum - 1) * 2);
            this.getView().updateView("entryentity");
            DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
            this.initCustomControl(dyObjs, "update", this.getPageCustomStatus());
        }
    }

    private void startEndDisEnable(int rowIndex) {
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"isworktimestart"});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"isworktimeend"});
    }

    private void workStartTimeChange(int rowIndex, String value) {
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        boolean isWorkStartTime = ((DynamicObject)dyObjs.get(rowIndex)).getBoolean("isworktimestart");
        if (!StringUtils.isEmpty((CharSequence)value)) {
            isWorkStartTime = StringUtils.equals((CharSequence)value, (CharSequence)"1");
            ((DynamicObject)dyObjs.get(rowIndex)).set("isworktimestart", (Object)isWorkStartTime);
        }
        if (rowIndex - 2 >= 0) {
            if (isWorkStartTime) {
                this.getView().setEnable(Boolean.FALSE, rowIndex - 1, new String[]{"isopenvalid"});
                this.getModel().setValue("isopenvalid", (Object)Boolean.FALSE, rowIndex - 1);
                ((DynamicObject)dyObjs.get(rowIndex - 2)).set("isworktimeend", (Object)Boolean.TRUE);
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex - 1, new String[]{"isopenvalid"});
                ((DynamicObject)dyObjs.get(rowIndex - 1)).set("isopenvalid", (Object)Boolean.FALSE);
                ((DynamicObject)dyObjs.get(rowIndex - 2)).set("isworktimeend", (Object)Boolean.FALSE);
            }
        }
        this.startEndDisEnable(dyObjs.size() - 1);
        this.getView().updateView("entryentity");
    }

    private void workEndTimeChange(int rowIndex, String value) {
        int length;
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        boolean isWorkEndTime = ((DynamicObject)dyObjs.get(rowIndex)).getBoolean("isworktimeend");
        if (!StringUtils.isEmpty((CharSequence)value)) {
            isWorkEndTime = StringUtils.equals((CharSequence)value, (CharSequence)"1");
            ((DynamicObject)dyObjs.get(rowIndex)).set("isworktimeend", (Object)isWorkEndTime);
        }
        if (rowIndex + 2 < (length = dyObjs.size())) {
            if (isWorkEndTime) {
                this.getView().setEnable(Boolean.FALSE, rowIndex + 1, new String[]{"isopenvalid"});
                this.getModel().setValue("isopenvalid", (Object)Boolean.FALSE, rowIndex + 1);
                ((DynamicObject)dyObjs.get(rowIndex + 2)).set("isworktimestart", (Object)Boolean.TRUE);
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex + 1, new String[]{"isopenvalid"});
                ((DynamicObject)dyObjs.get(rowIndex + 1)).set("isopenvalid", (Object)Boolean.FALSE);
                ((DynamicObject)dyObjs.get(rowIndex + 2)).set("isworktimestart", (Object)Boolean.FALSE);
            }
        }
        this.startEndDisEnable(dyObjs.size() - 1);
        this.getView().updateView("entryentity");
    }

    public void customEvent(CustomEventArgs evt) {
        CardPointVo cardPointVo;
        String name = evt.getEventName();
        String args = evt.getEventArgs();
        if (HRStringUtils.equals((String)name, (String)"btnClick") && (cardPointVo = (CardPointVo)JSON.parseObject((String)args, CardPointVo.class)) != null) {
            String value = cardPointVo.getValue();
            int index = cardPointVo.getIndex();
            int columnNum = index % 4;
            int rowNum = index / 4;
            if (columnNum == 1) {
                this.workStartTimeChange(rowNum, value);
            }
            if (columnNum == 2) {
                this.workEndTimeChange(rowNum, value);
            }
            if (columnNum == 3) {
                this.getModel().setValue("isopenvalid", (Object)StringUtils.equals((CharSequence)value, (CharSequence)"1"), rowNum);
            }
            DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
            this.initCustomControl(dyObjs, "update", this.getPageCustomStatus());
        }
    }

    private String getCardNum() {
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        int cardNumSum = 0;
        for (DynamicObject dynamicObject : dyObjs) {
            boolean isWorkStartTime;
            boolean isWorkEndTime = dynamicObject.getBoolean("isworktimeend");
            if (isWorkEndTime) {
                ++cardNumSum;
            }
            if (!(isWorkStartTime = dynamicObject.getBoolean("isworktimestart"))) continue;
            ++cardNumSum;
        }
        return String.valueOf(cardNumSum);
    }

    private void voidEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IDataModel iDataModel = this.getModel();
        String classTimeNum = (String)iDataModel.getValue("classtimenum");
        ComboEdit comboEdit = (ComboEdit)this.getControl("classgetnum");
        if (StringUtils.isNotBlank((CharSequence)classTimeNum)) {
            List<ComboItem> comboItemList = this.getComboItemList(Integer.parseInt(classTimeNum), null);
            Collections.reverse(comboItemList);
            comboEdit.setComboItems(comboItemList);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String operateKey;
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "submitandaudit": {
                String cardNum = this.getCardNum();
                String classGetNum = (String)this.getModel().getValue("classgetnum");
                if (!StringUtils.equals((CharSequence)cardNum, (CharSequence)classGetNum)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6253\u5361\u6570\u5fc5\u987b\u662f%s\u6b21\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TakeCardConfigEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), (String)"TakeCardConfigEdit1", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{classGetNum}));
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                GeneratorNumberService generatorNumberService = new GeneratorNumberService();
                int currentNum = generatorNumberService.getCurrentNum();
                String classTimeNumStr = (String)this.getModel().getValue("classtimenum");
                int classTimeNum = Integer.parseInt(classTimeNumStr);
                if (classTimeNum > currentNum) {
                    String msg = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5e94\u51fa\u52e4\u65f6\u6bb5\u6700\u5927\u4e3a%\u5e94\u6253\u5361\u5bf9%\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TakeCardConfigEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), (String)"TakeCardConfigEdit2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                this.setClassTimeType(dyObjs);
                this.buildTakeCardShape();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
            this.initCustomControl(dyObjs, "init", this.getPageCustomStatus());
        }
    }

    private void buildTakeCardShape() {
        StringBuilder takeCardShape = new StringBuilder();
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        dyObjs.forEach(object -> {
            String type = object.getString("classtimetype");
            if (HRStringUtils.equals((String)"1", (String)type)) {
                boolean isWorkStartTime = object.getBoolean("isworktimestart");
                if (isWorkStartTime) {
                    takeCardShape.append('\u25cf');
                } else {
                    takeCardShape.append("  ");
                }
                takeCardShape.append("\u2500\u2500");
                boolean isWorkEndTime = object.getBoolean("isworktimeend");
                if (isWorkEndTime) {
                    takeCardShape.append('\u25cf');
                } else {
                    takeCardShape.append("  ");
                }
                takeCardShape.append("\r\n");
            }
        });
        this.getModel().setValue("takecardshape", (Object)takeCardShape);
    }

    private void openPunchCard(String classGetNumStr) {
        if (HRStringUtils.isEmpty((String)classGetNumStr)) {
            return;
        }
        int classGetNum = Integer.parseInt(classGetNumStr);
        classGetNum = (classGetNum - 2) / 2;
        for (int i = 0; i < classGetNum; ++i) {
            this.workEndTimeChange(i * 2, "1");
        }
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        this.initCustomControl(dyObjs, "update", this.getPageCustomStatus());
    }

    private void setClasstimenum(Integer currentNum) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("classtimenum");
        ArrayList<ComboItem> countList = new ArrayList<ComboItem>();
        for (int i = 0; i < currentNum; ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(String.valueOf(i + 1)));
            comboItem.setValue(String.valueOf(i + 1));
            countList.add(comboItem);
        }
        comboEdit.setComboItems(countList);
    }

    private void setClassTimeType(DynamicObjectCollection dyObjs) {
        int workIndex = 1;
        int restIndex = 1;
        for (DynamicObject dynamicObject : dyObjs) {
            String classTimeType = dynamicObject.getString("classtimetype");
            if (HRStringUtils.equals((String)"1", (String)classTimeType)) {
                dynamicObject.set("time", (Object)String.valueOf(workIndex));
                ++workIndex;
                continue;
            }
            dynamicObject.set("time", (Object)String.valueOf(restIndex));
            ++restIndex;
        }
    }

    private int getPageCustomStatus() {
        boolean isLock = WTCHisService.isLock((IFormView)this.getView());
        return isLock ? 1 : 0;
    }
}

