/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.takerule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbd.business.takecard.CardtrialHelper;
import kd.wtc.wtbd.common.vo.takecard.ShiftCardVo;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.sign.MultiCardEntryDTO;
import kd.wtc.wtbs.common.model.sign.SignCardDTO;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class CardtrialEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CardtrialEdit.class);
    private static final String SHIFT_ID = "shiftid";
    private static final String PUNCHTIME = "punchtime";
    private static final String BASEDAY = "baseday";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String CARDTRIALEDIT1 = "CardtrialEdit1";

    private String getCardtrialedit1Message() {
        return ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u201c\u57fa\u51c6\u65e5\u201d\uff0c\u4e0d\u80fd\u51fa\u73b0\u540c\u4e00\u4e2a\u65f6\u95f4\u70b9\u3002", (String)"CardtrialEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap1", "close"});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(SHIFT_ID);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"trial")) {
            if (this.checkReapit()) {
                return;
            }
            this.trialCard();
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"close")) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean checkReapit() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dynamicObject : entryEntity) {
            int punchtime = dynamicObject.getInt(PUNCHTIME);
            String baseday = dynamicObject.getString(BASEDAY);
            if (set.contains(punchtime + baseday)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)this.getCardtrialedit1Message(), (String)CARDTRIALEDIT1, (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (-1 == punchtime) continue;
            set.add(punchtime + baseday);
        }
        return false;
    }

    private void trialCard() {
        List<SignCardDTO> signCardList = this.getSignCardData();
        if (signCardList == null || signCardList.isEmpty()) {
            return;
        }
        signCardList.sort(Comparator.comparing(SignCardDTO::getSignDateTime));
        DynamicObject dynamicShift = (DynamicObject)this.getModel().getValue(SHIFT_ID);
        if (dynamicShift == null) {
            return;
        }
        Long shiftId = dynamicShift.getLong("id");
        ShiftService shiftService = new ShiftService();
        ArrayList<Long> shiftIdList = new ArrayList<Long>();
        shiftIdList.add(shiftId);
        Map shiftMap = shiftService.getShiftEvalVoMapByVids(shiftIdList);
        Shift shift = (Shift)shiftMap.get(shiftId);
        Date checkDate = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        List<Object> timeSeqList = this.getTimeSeqList();
        timeSeqList = timeSeqList.stream().filter(t -> t.getStartBeforeScope() != null && t.getStartAfterScope() != null && HRStringUtils.isNotEmpty((String)t.getStartTakeCardRule()) || t.getEndAfterScope() != null && t.getEndBeforeScope() != null && HRStringUtils.isNotEmpty((String)t.getEndTakeCardRule())).collect(Collectors.toList());
        TakeCardRule takeCardRule = this.getTakeCardRule();
        takeCardRule.setTimeSeqList(timeSeqList);
        List multiCardEntryList = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getEffectiveCard", (Object[])new Object[]{signCardList, shiftId, takeCardRule, checkDate});
        this.setResultView(multiCardEntryList, checkDate);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bd5\u7b97\u5df2\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u7ed3\u679c\u3002", (String)"CardtrialEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        logger.info("CardtrialEdit.trialCard \u8bd5\u7b97\u7ed3\u679csize={}", (Object)multiCardEntryList.size());
    }

    private void setResultView(List<MultiCardEntryDTO> multiCardEntryList, Date checkDate) {
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (CollectionUtils.isEmpty(multiCardEntryList)) {
            return;
        }
        int count = 0;
        for (DynamicObject dynamicObject : entryentity1) {
            try {
                Integer timeSeqEndPoint;
                MultiCardEntryDTO multiCardEntry = multiCardEntryList.get(count);
                if (multiCardEntry == null) continue;
                Integer timeSeqStartPoint = (Integer)dynamicObject.get("timeseqstartpoint");
                if (timeSeqStartPoint != null && timeSeqStartPoint != 0) {
                    dynamicObject.set("timefield2", (Object)multiCardEntry.getRelativeEffectiveCPoint());
                    dynamicObject.set("basedaystart", (Object)this.getBaseDay(multiCardEntry.getEffectivePoint(), checkDate));
                    ++count;
                }
                if ((multiCardEntry = multiCardEntryList.get(count)) == null || (timeSeqEndPoint = (Integer)dynamicObject.get("timeseqendpoint")) == null || timeSeqEndPoint == 0) continue;
                dynamicObject.set("timefield4", (Object)multiCardEntry.getRelativeEffectiveCPoint());
                dynamicObject.set("basedayend", (Object)this.getBaseDay(multiCardEntry.getEffectivePoint(), checkDate));
                ++count;
            }
            catch (ParseException e) {
                logger.error("\u65f6\u95f4\u89e3\u6790\u9519\u8bef:" + e.getMessage());
            }
        }
        this.getView().updateView(ENTRYENTITY1);
    }

    private String getBaseDay(Date effectivePoint, Date checkDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (null == effectivePoint) {
            return "N";
        }
        String dateFormatCardPoint = simpleDateFormat.format(effectivePoint);
        String dateFormatBelongs = simpleDateFormat.format(checkDate);
        Date cardPointDate = simpleDateFormat.parse(dateFormatCardPoint);
        Date baseDate = simpleDateFormat.parse(dateFormatBelongs);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(baseDate);
        calendar.add(5, 1);
        if (cardPointDate.equals(baseDate)) {
            return "D";
        }
        if (cardPointDate.equals(calendar.getTime())) {
            return "C";
        }
        calendar.add(5, -2);
        if (cardPointDate.equals(calendar.getTime())) {
            return "Q";
        }
        logger.error("wrong effectiveCardPoint");
        throw new KDException(new ErrorCode("500", "wrong effectiveCardPoint"), new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        DynamicObject shift = (DynamicObject)this.getModel().getValue(SHIFT_ID);
        if ("textfield".equals(fieldKey)) {
            this.setTimeSeq(shift);
            return;
        }
        if (SHIFT_ID.equals(fieldKey)) {
            this.setTimeSeq(shift);
            return;
        }
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        if (null == newValue) {
            return;
        }
        if (PUNCHTIME.equals(fieldKey)) {
            if ((Integer)newValue == -1) {
                return;
            }
            this.checkPunchTime((Integer)newValue, rowIndex);
        }
        if (BASEDAY.equals(fieldKey)) {
            this.checkBaseDay((String)newValue, rowIndex);
        }
    }

    private void checkBaseDay(String newValue, int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int punchTimeOnChangeRow = ((DynamicObject)entryEntity.get(rowIndex)).getInt(PUNCHTIME);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (i == rowIndex) continue;
            int punchtime = ((DynamicObject)entryEntity.get(i)).getInt(PUNCHTIME);
            String baseday = ((DynamicObject)entryEntity.get(i)).getString(BASEDAY);
            if (punchtime != punchTimeOnChangeRow || punchTimeOnChangeRow == -1 || !baseday.equals(newValue)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)this.getCardtrialedit1Message(), (String)CARDTRIALEDIT1, (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkPunchTime(Integer newValue, int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String baseDayOnChangeRow = ((DynamicObject)entryEntity.get(rowIndex)).getString(BASEDAY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (i == rowIndex) continue;
            int punchtime = ((DynamicObject)entryEntity.get(i)).getInt(PUNCHTIME);
            String baseday = ((DynamicObject)entryEntity.get(i)).getString(BASEDAY);
            if (punchtime != newValue || !baseday.equals(baseDayOnChangeRow)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)this.getCardtrialedit1Message(), (String)CARDTRIALEDIT1, (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"newentry_1") && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() >= 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"CardtrialEdit_3", (String)"CardtrialEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setTimeSeq(DynamicObject shift) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (null == shift) {
            model.deleteEntryData(ENTRYENTITY1);
            return;
        }
        List shiftCardVoList = CardtrialHelper.getShiftInfoList((DynamicObject)shift);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData(ENTRYENTITY1);
        model.beginInit();
        int num = 0;
        for (ShiftCardVo shiftCardVo : shiftCardVoList) {
            Boolean isWorkTimeEnd;
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            int timeSeq = num + 1;
            tableValueSetter.set("timeseq", (Object)timeSeq, num);
            Boolean isWorkTimeStart = shiftCardVo.getWorkTimeStart();
            if (isWorkTimeStart.booleanValue()) {
                tableValueSetter.set("timeseqstartpoint", (Object)shiftCardVo.getShiftStartDate(), num);
            }
            if ((isWorkTimeEnd = shiftCardVo.getWorkTimeEnd()).booleanValue()) {
                tableValueSetter.set("timeseqendpoint", (Object)shiftCardVo.getShiftEndDate(), num);
            }
            ++num;
        }
        model.batchCreateNewEntryRow(ENTRYENTITY1, vs);
        this.getView().updateView(ENTRYENTITY1);
        model.endInit();
    }

    private TakeCardRule getTakeCardRule() {
        IFormView parentView = this.getView().getParentView();
        TakeCardRule takeCardRule = new TakeCardRule();
        if (parentView != null) {
            DynamicObject dataEntity = parentView.getModel().getDataEntity();
            takeCardRule.setOvertimeTakeCardMode(dataEntity.getBoolean("isotapplytakecard"));
        }
        return takeCardRule;
    }

    private List<TimeSeq> getTimeSeqList() {
        JSONArray jsonArray = null;
        Object customParam = this.getView().getFormShowParameter().getCustomParam("timeSeqList");
        if (customParam instanceof JSONArray) {
            jsonArray = (JSONArray)customParam;
        } else if (customParam instanceof String) {
            jsonArray = JSON.parseArray((String)((String)customParam));
        }
        if (jsonArray != null) {
            return JSON.parseArray((String)jsonArray.toJSONString(), TimeSeq.class);
        }
        return new ArrayList<TimeSeq>();
    }

    private List<SignCardDTO> getSignCardData() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        return this.transToSignCardList(entryentity);
    }

    private List<SignCardDTO> transToSignCardList(DynamicObjectCollection entryentity) {
        ArrayList<SignCardDTO> signCardList = new ArrayList<SignCardDTO>();
        for (DynamicObject dynamicObject : entryentity) {
            Long punchtime = Long.parseLong(dynamicObject.get(PUNCHTIME).toString());
            if (punchtime == -1L) continue;
            SignCardDTO signCard = new SignCardDTO();
            Date zero = CardtrialHelper.getZeroDate((Date)new Date());
            Calendar baseday = CardtrialHelper.getSpecificCalendar((Date)zero, (String)((String)dynamicObject.get(BASEDAY)), (int)Integer.parseInt(punchtime.toString()));
            LocalDateTime localDateTime = baseday.getTime().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
            signCard.setSignDateTime(Date.from(localDateTime.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
            signCard.setSignDateTimeUtc(Date.from(localDateTime.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
            signCardList.add(signCard);
        }
        return signCardList;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List<TimeSeq> timeSeqList = this.getTimeSeqList();
        int timeSeqNum = timeSeqList.size();
        if (timeSeqNum == 0) {
            return;
        }
        int cardGetNum = 0;
        for (TimeSeq timeSeq : timeSeqList) {
            if (!StringUtils.isEmpty((CharSequence)timeSeq.getStartTakeCardRule())) {
                ++cardGetNum;
            }
            if (StringUtils.isEmpty((CharSequence)timeSeq.getEndTakeCardRule())) continue;
            ++cardGetNum;
        }
        Map<Long, List<ShiftCardVo>> shiftCardMap = this.queryShiftCardMap(timeSeqNum, cardGetNum, "0");
        List<Long> idList = this.getIdList(shiftCardMap, timeSeqList);
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SHIFT_ID)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", idList));
        }
    }

    private List<Long> getIdList(Map<Long, List<ShiftCardVo>> shiftMap, List<TimeSeq> timeSeqList) {
        if (CollectionUtils.isEmpty(shiftMap)) {
            return new ArrayList<Long>();
        }
        int timeSeqNum = timeSeqList.size();
        LinkedList<Long> idList = new LinkedList<Long>();
        for (Map.Entry<Long, List<ShiftCardVo>> entry : shiftMap.entrySet()) {
            boolean isMatch;
            int num = 1;
            List<ShiftCardVo> shiftCardVos = entry.getValue();
            if (num > timeSeqNum || !(isMatch = CardtrialHelper.matchTakeShape(shiftCardVos, timeSeqList))) continue;
            idList.add(entry.getKey());
        }
        return idList;
    }

    private Map<Long, List<ShiftCardVo>> queryShiftCardMap(int timeSeqNum, int cardGetNum, String offnonplan) {
        HRBaseServiceHelper relateSHiftHelper = new HRBaseServiceHelper("wtbd_shift");
        DynamicObject[] dys = relateSHiftHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("workingsections", "=", (Object)timeSeqNum), new QFilter("cardsnum", "=", (Object)cardGetNum), new QFilter("offnonplan", "=", (Object)offnonplan), WTCHisServiceHelper.isCurrentVersion((boolean)true)});
        if (dys == null || dys.length == 0) {
            return new HashMap<Long, List<ShiftCardVo>>();
        }
        HashMap<Long, List<ShiftCardVo>> shiftMap = new HashMap<Long, List<ShiftCardVo>>(16);
        for (DynamicObject dy : dys) {
            ArrayList<ShiftCardVo> result = new ArrayList<ShiftCardVo>();
            DynamicObjectCollection shiftEntry = dy.getDynamicObjectCollection("entryentity");
            int num = 0;
            int LastDate = 0;
            for (DynamicObject dynamicObject : shiftEntry) {
                ShiftCardVo shiftCardVo = new ShiftCardVo();
                String outWorkType = dynamicObject.getString("outworktype");
                if (StringUtils.equals((CharSequence)outWorkType, (CharSequence)"B")) continue;
                shiftCardVo.setId(dynamicObject.getLong("id"));
                shiftCardVo.setWorkTimeStart(Boolean.valueOf(dynamicObject.getBoolean("isworktimestart")));
                shiftCardVo.setWorkTimeEnd(Boolean.valueOf(dynamicObject.getBoolean("isworktimeend")));
                shiftCardVo.setShiftEndDate(dynamicObject.getInt("shiftenddate"));
                if (num != 0) {
                    int startDate = dynamicObject.getInt("shiftstartdate");
                    ShiftCardVo upShiftCardVo = (ShiftCardVo)result.get(result.size() - 1);
                    if (startDate == LastDate) {
                        upShiftCardVo.setWorkTimeEnd(shiftCardVo.getWorkTimeEnd());
                        LastDate = shiftCardVo.getShiftEndDate();
                        continue;
                    }
                }
                LastDate = shiftCardVo.getShiftEndDate();
                result.add(shiftCardVo);
                ++num;
            }
            shiftMap.put(dy.getLong("id"), result);
        }
        return shiftMap;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        this.getModel().setDataChanged(false);
    }
}

