/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.takerule;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbd.common.vo.takecard.TimeSeqWrapper;
import kd.wtc.wtbs.common.constants.takecard.CardRuleConstants;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.enums.TakeCardRuleRefDayEnum;

public class TakeCardRuleEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TakeCardRuleEdit.class);

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        switch (operationStatus) {
            case VIEW: 
            case EDIT: {
                this.initTakecardShape();
                break;
            }
            case ADDNEW: {
                if ("fromHisAction".equals(this.getView().getFormShowParameter().getCustomParam("fromPage")) || this.getView().getFormShowParameter().getCustomParam("iscopy") != null && ((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).booleanValue()) {
                    WTCPageCache cache = new WTCPageCache(this.getView());
                    String copyNew = (String)cache.get("copynew", String.class);
                    if (HRStringUtils.isEmpty((String)copyNew)) {
                        this.initTakecardShape();
                        break;
                    }
                    this.deleteTimeSeq();
                    break;
                }
                this.deleteTimeSeq();
                break;
            }
        }
        Boolean isOff = (Boolean)this.getModel().getValue("isoff");
        this.setTakecardconfigMusetInput(isOff == false);
    }

    private void initTakecardShape() {
        IFormView view = this.getView();
        WTCPageCache cache = new WTCPageCache(view);
        int rowCount = this.getModel().getEntryRowCount("wtbd_tcardruleentry");
        cache.put("wtam_tcscopeEntryCollection", (Object)this.wrapEntryCollection(this.getModel().getEntryEntity("wtbd_tcardruleentry")));
        cache.put("cardConfigkeyIsChange", (Object)Boolean.FALSE);
        this.addTakeCardScopePage(rowCount);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"cardtrial"});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("takecardconfig");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"cardtrial")) {
            this.openCardtrial();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "isoff": {
                Boolean isOff = (Boolean)this.getModel().getValue("isoff");
                this.setTakecardconfigMusetInput(isOff == false);
                break;
            }
            case "takecardconfig": {
                String classTimeNum;
                IFormView formView = this.getView();
                WTCPageCache cache = new WTCPageCache(formView);
                cache.put("cardConfigkeyIsChange", (Object)Boolean.TRUE);
                this.deleteTimeSeq();
                DynamicObject takeCardConfig = (DynamicObject)this.getModel().getValue("takecardconfig");
                if (takeCardConfig == null || !StringUtils.isNotBlank((CharSequence)(classTimeNum = takeCardConfig.getString("classtimenum")))) break;
                this.addTakeCardScopePage(Integer.parseInt(classTimeNum));
                break;
            }
            case "bsed": {
                Date takeconfigDate;
                LocalDate takeconfigLocalDate;
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                LocalDate takeRuleLocalDate = WTCDateUtils.toLocalDate((Date)bsed);
                Object cardConfig = this.getModel().getValue("takecardconfig");
                if (cardConfig == null || !takeRuleLocalDate.isBefore(takeconfigLocalDate = WTCDateUtils.toLocalDate((Date)(takeconfigDate = this.getModel().getDataEntity().getDate("takecardconfig.bsed"))))) break;
                this.getModel().setValue("takecardconfig", null);
                break;
            }
        }
    }

    private void setTakeConfigDes() {
        DynamicObject takeCardConfig;
        IDataModel model = this.getModel();
        String name = ((ILocaleString)model.getValue("name")).getLocaleValue();
        if (name != null && null != (takeCardConfig = (DynamicObject)this.getModel().getValue("takecardconfig"))) {
            String classTimeNum = takeCardConfig.getString("classtimenum");
            model.setValue("classtimenum", (Object)classTimeNum);
            String classGetNum = takeCardConfig.getString("classgetnum");
            model.setValue("classgetnum", (Object)classGetNum);
            String takeCardShape = takeCardConfig.getString("takecardshape");
            model.setValue("takecardshape", (Object)takeCardShape);
        }
    }

    public void deleteTimeSeq() {
        IFormView formView = this.getView();
        WTCPageCache cache = new WTCPageCache(formView);
        Map pageIdMap = (Map)cache.get("pageId2TimeSeqNum", LinkedHashMap.class);
        if (!CollectionUtils.isEmpty((Map)pageIdMap)) {
            pageIdMap.forEach((key, val) -> {
                IFormView baseView = formView.getView(key);
                baseView.invokeOperation("close");
                formView.sendFormAction(baseView);
            });
            cache.remove("pageId2TimeSeqNum");
        }
    }

    private void addTakeCardScopePage(int num) {
        WTCPageCache cache = new WTCPageCache(this.getView());
        TimeSeqWrapper timeSeqWrapper = (TimeSeqWrapper)cache.get("wtam_tcscopeEntryCollection", TimeSeqWrapper.class);
        DynamicObject dynamicObject = null;
        Boolean cardConfigIsChange = (Boolean)cache.get("cardConfigkeyIsChange", Boolean.class);
        if (cardConfigIsChange.booleanValue()) {
            DynamicObject pk = (DynamicObject)this.getModel().getValue("takecardconfig");
            HRBaseServiceHelper takeCardConfigHelper = new HRBaseServiceHelper("wtbd_takecardconfig");
            dynamicObject = takeCardConfigHelper.queryOne(pk.getPkValue());
        }
        for (int i = 1; i <= num; ++i) {
            List<String> keyList = null;
            if (!cardConfigIsChange.booleanValue()) {
                if (timeSeqWrapper != null) {
                    List timeSeqList = timeSeqWrapper.getTimeSeqList();
                    keyList = this.setAttChangeByScope((TimeSeq)timeSeqList.get(i - 1));
                }
            } else {
                keyList = this.timeSeqAttChange(dynamicObject, i);
            }
            if (keyList == null) continue;
            this.addOneTakeCardScopePage(i, keyList);
        }
    }

    private void openCardtrial() {
        if (this.checkNull()) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("wtbd_tctestcomp");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setShowTitle(true);
        ArrayList<TimeSeq> timeSeqList = new ArrayList<TimeSeq>(this.getChildFormViewData(this.getView()).values());
        billShowParameter.setCustomParam("timeSeqList", timeSeqList);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public Map<Integer, TimeSeq> getChildFormViewData(IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        Map pageIdMap = (Map)pageCache.get("pageId2TimeSeqNum", LinkedHashMap.class);
        LinkedHashMap<Integer, TimeSeq> childViewMap = new LinkedHashMap<Integer, TimeSeq>();
        TimeSeq timeSeq = null;
        int num = 1;
        if (!CollectionUtils.isEmpty((Map)pageIdMap)) {
            for (Map.Entry entry : pageIdMap.entrySet()) {
                IFormView baseView = view.getView((String)entry.getKey());
                if (baseView == null || !baseView.getModel().isDataLoaded()) continue;
                DynamicObject timeSeqObject = baseView.getModel().getDataEntity(true);
                timeSeq = this.transToTimeSeqVo(timeSeqObject);
                timeSeq.setTimeSeq(Integer.valueOf(num));
                childViewMap.put(num, timeSeq);
                ++num;
            }
        }
        return childViewMap;
    }

    private TimeSeqWrapper wrapEntryCollection(DynamicObjectCollection entryEntity) {
        ArrayList<TimeSeq> timeSeqList = new ArrayList<TimeSeq>();
        for (DynamicObject dynamicObject : entryEntity) {
            timeSeqList.add(this.transToTimeSeqVo(dynamicObject));
        }
        return new TimeSeqWrapper(timeSeqList);
    }

    private TimeSeq transToTimeSeqVo(DynamicObject dynamicObject) {
        TimeSeq timeSeq = new TimeSeq();
        timeSeq.setStartBeforeScope((Integer)dynamicObject.get("sbeforescope"));
        timeSeq.setStartAfterScope((Integer)dynamicObject.get("safterscope"));
        timeSeq.setStartTakeCardRule((String)dynamicObject.get("stakecardrule"));
        timeSeq.setStartTakeCardSameLen((String)dynamicObject.get("stakecardsamelen"));
        timeSeq.setEndAfterScope((Integer)dynamicObject.get("eafterscope"));
        timeSeq.setEndBeforeScope((Integer)dynamicObject.get("ebeforescope"));
        timeSeq.setEndTakeCardRule((String)dynamicObject.get("etakecardrule"));
        timeSeq.setEndTakeCardSameLen((String)dynamicObject.get("etakecardsamelen"));
        return timeSeq;
    }

    public FormShowParameter createFormParameter(String pageId, int num, boolean startRule, boolean endRule) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("worktimeflex" + num);
        showParameter.setFormId("wtbd_timeseq");
        showParameter.setParentPageId(pageId);
        showParameter.setCustomParam("num", (Object)num);
        showParameter.getCustomParams().put("startRule", startRule);
        showParameter.getCustomParams().put("endRule", endRule);
        showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        showParameter.setSendToClient(true);
        logger.info("\u6253\u5f00\u52a8\u6001\u9875\u9762 {}", (Object)num);
        return showParameter;
    }

    private void addOneTakeCardScopePage(int num, List<String> keyList) {
        IFormView formView = this.getView();
        WTCPageCache cache = new WTCPageCache(formView);
        Map<String, String> pageIds = num == 1 ? new LinkedHashMap(16) : (Map)cache.get("pageId2TimeSeqNum", LinkedHashMap.class);
        boolean startRule = keyList.contains("stakecardrule");
        boolean endRule = keyList.contains("etakecardrule");
        FormShowParameter showParameter = this.createFormParameter(formView.getPageId(), num, startRule, endRule);
        formView.showForm(showParameter);
        if (startRule || endRule) {
            formView.setVisible(Boolean.TRUE, new String[]{"worktimeflex" + num});
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"worktimeflex" + num});
        }
        String pageId = showParameter.getPageId();
        pageIds.put(pageId, StringUtils.join(keyList, (String)","));
        cache.put("pageId2TimeSeqNum", pageIds);
    }

    private List<String> timeSeqAttChange(DynamicObject dynamicObject, int num) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        int workNum = (num - 1) * 2;
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection) && dynamicObjectCollection.size() > workNum) {
            return this.setAttChangeByConfig((DynamicObject)dynamicObjectCollection.get((num - 1) * 2));
        }
        return new ArrayList<String>();
    }

    private List<String> setAttChangeByScope(TimeSeq timeSeq) {
        boolean isWorkTimeEnd;
        boolean isWorkTimeStart;
        LinkedList<String> list = new LinkedList<String>();
        boolean bl = isWorkTimeStart = !StringUtils.isEmpty((CharSequence)timeSeq.getStartTakeCardRule());
        if (isWorkTimeStart) {
            list.add("sbeforescope");
            list.add("safterscope");
            list.add("stakecardrule");
        }
        boolean bl2 = isWorkTimeEnd = !StringUtils.isEmpty((CharSequence)timeSeq.getEndTakeCardRule());
        if (isWorkTimeEnd) {
            list.add("ebeforescope");
            list.add("eafterscope");
            list.add("etakecardrule");
        }
        return list;
    }

    private List<String> setAttChangeByConfig(DynamicObject dynamicObject) {
        LinkedList<String> list = new LinkedList<String>();
        String time = dynamicObject.getString("time");
        String type = dynamicObject.getString("classtimetype");
        if (HRStringUtils.equals((String)"1", (String)type)) {
            boolean isWorkTimeStart = dynamicObject.getBoolean("isworktimestart");
            boolean isWorkTimeEnd = dynamicObject.getBoolean("isworktimeend");
            return this.setAttChange(isWorkTimeStart, isWorkTimeEnd);
        }
        return list;
    }

    private List<String> setAttChange(boolean isWorkTimeStart, boolean isWorkTimeEnd) {
        LinkedList<String> list = new LinkedList<String>();
        if (isWorkTimeStart) {
            list.add("sbeforescope");
            list.add("safterscope");
            list.add("stakecardrule");
        }
        if (isWorkTimeEnd) {
            list.add("ebeforescope");
            list.add("eafterscope");
            list.add("etakecardrule");
        }
        return list;
    }

    private boolean checkNull() {
        IFormView view = this.getView();
        WTCPageCache pageCache = new WTCPageCache(view);
        Map pageIdMap = (Map)pageCache.get("pageId2TimeSeqNum", LinkedHashMap.class);
        int num = 1;
        String baseMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a", (String)"TakeCardRuleEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        StringBuilder bufAll = new StringBuilder(baseMsg);
        if (CollectionUtils.isEmpty((Map)pageIdMap)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d6\u5361\u914d\u7f6e\u201d\u3002", (String)"TakeCardRuleEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return true;
        }
        this.verificationTaskCardRanges(view, pageIdMap, num, bufAll);
        if (!StringUtils.equals((CharSequence)baseMsg, (CharSequence)bufAll)) {
            view.showTipNotification(bufAll.toString());
            return true;
        }
        return false;
    }

    private void verificationTaskCardRanges(IFormView view, Map<String, String> pageIdMap, int num, StringBuilder bufAll) {
        for (Map.Entry<String, String> entry : pageIdMap.entrySet()) {
            String eTakeCardSameLen;
            String sTakeCardSameLen;
            StringBuilder buf = new StringBuilder();
            IFormView baseView = view.getView(entry.getKey());
            String require = entry.getValue();
            if (baseView == null) continue;
            DynamicObject timeSeqObject = baseView.getModel().getDataEntity(true);
            this.validationTime(buf, require, timeSeqObject, "sbeforescope", ResManager.loadKDString((String)"\u201c\u65f6\u6bb5\u5f00\u59cb\u524d\u8303\u56f4\uff08\u5206\u949f\uff09\u201d\u3001", (String)"TakeCardRuleEdit_37", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.validationTime(buf, require, timeSeqObject, "safterscope", ResManager.loadKDString((String)"\u201c\u65f6\u6bb5\u5f00\u59cb\u540e\u8303\u56f4\uff08\u5206\u949f\uff09\u201d\u3001", (String)"TakeCardRuleEdit_38", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.validationTime(buf, require, timeSeqObject, "stakecardrule", ResManager.loadKDString((String)"\u201c(\u65f6\u6bb5\u5f00\u59cb)\u53d6\u5361\u65b9\u5f0f\u201d\u3001", (String)"TakeCardRuleEdit_39", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            String sTakeCardRule = timeSeqObject.getString("stakecardrule");
            if (StringUtils.equals((CharSequence)sTakeCardRule, (CharSequence)"5") && StringUtils.isEmpty((CharSequence)(sTakeCardSameLen = timeSeqObject.getString("stakecardsamelen")))) {
                String takeRuleMsg = ResManager.loadKDString((String)"\u201c(\u65f6\u6bb5\u5f00\u59cb)\u6700\u8fd1\u5361\u70b9\u8ddd\u79bb\u4e00\u81f4\u65f6\u201d\u3001", (String)"TakeCardRuleEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                buf.append(takeRuleMsg);
            }
            this.validationTime(buf, require, timeSeqObject, "ebeforescope", ResManager.loadKDString((String)"\u201c\u65f6\u6bb5\u7ed3\u675f\u524d\u8303\u56f4\uff08\u5206\u949f\uff09\u201d\u3001", (String)"TakeCardRuleEdit_40", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.validationTime(buf, require, timeSeqObject, "eafterscope", ResManager.loadKDString((String)"\u201c\u65f6\u6bb5\u7ed3\u675f\u540e\u8303\u56f4\uff08\u5206\u949f\uff09\u201d\u3001", (String)"TakeCardRuleEdit_41", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.validationTime(buf, require, timeSeqObject, "etakecardrule", ResManager.loadKDString((String)"\u201c(\u65f6\u6bb5\u7ed3\u675f)\u53d6\u5361\u65b9\u5f0f\u201d\u3001", (String)"TakeCardRuleEdit_42", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            String eTakeCardRule = timeSeqObject.getString("etakecardrule");
            if (StringUtils.equals((CharSequence)eTakeCardRule, (CharSequence)"5") && StringUtils.isEmpty((CharSequence)(eTakeCardSameLen = timeSeqObject.getString("etakecardsamelen")))) {
                String takeRuleMsg = ResManager.loadKDString((String)"\u201c(\u65f6\u6bb5\u7ed3\u675f)\u6700\u8fd1\u5361\u70b9\u8ddd\u79bb\u4e00\u81f4\u65f6\u201d\u3001", (String)"TakeCardRuleEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                buf.append(takeRuleMsg);
            }
            if (StringUtils.isNotBlank((CharSequence)buf)) {
                buf = buf.deleteCharAt(buf.length() - 1);
                String topMsg = String.format(ResManager.loadKDString((String)"\u201c\u4e0a\u73ed\u65f6\u6bb5%1$s\uff1a%2$s\u3002\u201d", (String)"TakeCardRuleEdit_43", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), num, buf);
                bufAll.append(topMsg);
            }
            ++num;
        }
    }

    private void validationTime(StringBuilder buf, String require, DynamicObject timeSeqObject, String sBeforeScope, String message) {
        if (this.isMustInputError(require, timeSeqObject, sBeforeScope)) {
            String msg = message;
            buf.append(msg);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        WTCPageCache cache = new WTCPageCache(this.getView());
        if ("true".equals(cache.get("hasChecked", String.class)) || "1".equals(cache.get("afterSaveClosePage"))) {
            cache.remove("hasChecked");
            this.refreshListPage();
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TakeCardRuleEdit_34", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TakeCardRuleEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u82e5\u4e0d\u4fdd\u5b58\uff0c\u8fd9\u4e9b\u66f4\u6539\u5c06\u4e22\u5931\u3002\r\n\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"TakeCardRuleEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        String changeDesc = this.getModel().getChangeDesc();
        String geneChangeDesc = this.checkChange();
        if (!StringUtils.isEmpty((CharSequence)geneChangeDesc)) {
            String string = changeDesc = StringUtils.isEmpty((CharSequence)changeDesc) ? geneChangeDesc : changeDesc + geneChangeDesc;
        }
        if (StringUtils.isEmpty((CharSequence)changeDesc)) {
            this.refreshListPage();
            return;
        }
        event.setCancel(true);
        this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Default, new ConfirmCallBackListener("callback_close"), btnNameMaps);
        this.refreshListPage();
    }

    private String checkChange() {
        Map<Integer, TimeSeq> childFormViewDataMap = this.getChildFormViewData(this.getView());
        DynamicObjectCollection wtamTcScopeEntry = this.getModel().getEntryEntity("wtbd_tcardruleentry");
        StringBuilder changeDesc = new StringBuilder();
        if (CollectionUtils.isEmpty(childFormViewDataMap)) {
            return changeDesc.toString();
        }
        for (Map.Entry<Integer, TimeSeq> entry : childFormViewDataMap.entrySet()) {
            TimeSeq value = entry.getValue();
            int rowIndex = entry.getKey() - 1;
            DynamicObject row = CollectionUtils.isEmpty((Collection)wtamTcScopeEntry) || entry.getKey() > wtamTcScopeEntry.size() ? null : (DynamicObject)wtamTcScopeEntry.get(rowIndex);
            StringBuilder changeDescRow = new StringBuilder(ResManager.loadKDString((String)"\u4e0a\u73ed\u65f6\u6bb5", (String)"TakeCardRuleEdit_17", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append(entry.getKey()).append(ResManager.loadKDString((String)"\u53d8\u52a8\u5b57\u6bb5\uff1a", (String)"TakeCardRuleEdit_35", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean sbScopeChanged = this.isChangedInt(row, changeDescRow, value.getStartBeforeScope(), "sbeforescope", ResManager.loadKDString((String)"\u65f6\u6bb5\u5f00\u59cb\u524d\u8303\u56f4\uff08\u5206\u949f\uff09", (String)"TakeCardRuleEdit_44", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean saScopeChanged = this.isChangedInt(row, changeDescRow, value.getStartAfterScope(), "safterscope", ResManager.loadKDString((String)"\u65f6\u6bb5\u5f00\u59cb\u540e\u8303\u56f4\uff08\u5206\u949f\uff09", (String)"TakeCardRuleEdit_45", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean sTakeChanged = this.isChangedStr(row, changeDescRow, value.getStartTakeCardRule(), "stakecardrule", ResManager.loadKDString((String)"\u53d6\u5361\u65b9\u5f0f\uff08\u5f00\u59cb)", (String)"TakeCardRuleEdit_46", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean sLenChanged = this.isChangedStr(row, changeDescRow, value.getStartTakeCardSameLen(), "stakecardsamelen", ResManager.loadKDString((String)"(\u65f6\u6bb5\u5f00\u59cb)\u6700\u8fd1\u5361\u70b9\u8ddd\u79bb\u4e00\u81f4\u65f6", (String)"TakeCardRuleEdit_47", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean ebScopeChanged = this.isChangedInt(row, changeDescRow, value.getEndBeforeScope(), "ebeforescope", ResManager.loadKDString((String)"\u65f6\u6bb5\u7ed3\u675f\u524d\u8303\u56f4\uff08\u5206\u949f\uff09", (String)"TakeCardRuleEdit_48", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean eaScopeChanged = this.isChangedInt(row, changeDescRow, value.getEndAfterScope(), "eafterscope", ResManager.loadKDString((String)"\u65f6\u6bb5\u7ed3\u675f\u540e\u8303\u56f4\uff08\u5206\u949f\uff09", (String)"TakeCardRuleEdit_49", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean eTakeChanged = this.isChangedStr(row, changeDescRow, value.getEndTakeCardRule(), "etakecardrule", ResManager.loadKDString((String)"\u53d6\u5361\u65b9\u5f0f\uff08\u7ed3\u675f)", (String)"TakeCardRuleEdit_50", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean eLenChanged = this.isChangedStr(row, changeDescRow, value.getEndTakeCardSameLen(), "etakecardsamelen", ResManager.loadKDString((String)"(\u65f6\u6bb5\u7ed3\u675f)\u6700\u8fd1\u5361\u70b9\u8ddd\u79bb\u4e00\u81f4\u65f6", (String)"TakeCardRuleEdit_51", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            boolean isChanged = sbScopeChanged || saScopeChanged || sTakeChanged || sLenChanged || ebScopeChanged || eaScopeChanged || eTakeChanged || eLenChanged;
            if (!isChanged) continue;
            String substring = changeDescRow.substring(0, changeDescRow.length() - 1);
            changeDesc.append(substring);
            changeDesc.append("\r\n");
        }
        return changeDesc.toString();
    }

    private String getResManager() {
        return ResManager.loadKDString((String)",", (String)"TakeCardRuleEdit_27", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
    }

    private boolean isChangedStr(DynamicObject row, StringBuilder changeDescRow, String startTakeCardRule, String sTakeCardRule, String message) {
        if (HRStringUtils.isEmpty((String)startTakeCardRule)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)startTakeCardRule, (CharSequence)((String)this.getIfNull(row, sTakeCardRule)))) {
            changeDescRow.append(message).append(this.getResManager());
            return true;
        }
        return false;
    }

    private boolean isChangedInt(DynamicObject row, StringBuilder changeDescRow, Integer startBeforeScope, String sBeforeScope, String message) {
        if (startBeforeScope == null) {
            return false;
        }
        if (this.compareAndCheckNull(startBeforeScope, (Integer)this.getIfNull(row, sBeforeScope))) {
            changeDescRow.append(message).append(this.getResManager());
            return true;
        }
        return false;
    }

    private boolean compareAndCheckNull(Integer aa, Integer bb) {
        return !Objects.equals(aa, bb);
    }

    private Object getIfNull(DynamicObject row, String sbeforescope) {
        return row == null ? null : row.get(sbeforescope);
    }

    protected void refreshListPage() {
        BillList billlistap;
        if (this.getView().getParentView() != null && (billlistap = (BillList)this.getView().getParentView().getControl("billlistap")) != null) {
            billlistap.refresh();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private boolean isMustInputError(String require, DynamicObject timeSeqObject, String key) {
        String keyValue = timeSeqObject.getString(key);
        return require.contains(key) && StringUtils.isEmpty((CharSequence)keyValue);
    }

    private void setDynamicDataToEntry(IDataModel model) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            dynamicObjects.addAll(this.getModel().getDataEntity(true).getDynamicObjectCollection("wtbd_tcardruleentry"));
        }
        Map<Integer, TimeSeq> childFormViewDataMap = this.getChildFormViewData(this.getView());
        AbstractFormDataModel model2 = (AbstractFormDataModel)model;
        model2.deleteEntryData("wtbd_tcardruleentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model2.beginInit();
        for (Map.Entry<Integer, TimeSeq> entry : childFormViewDataMap.entrySet()) {
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            TimeSeq timeSeq = entry.getValue();
            int rowIndx = entry.getKey() - 1;
            tableValueSetter.set("timeseq", (Object)entry.getKey(), rowIndx);
            tableValueSetter.set("sbeforescope", (Object)timeSeq.getStartBeforeScope(), rowIndx);
            tableValueSetter.set("safterscope", (Object)timeSeq.getStartAfterScope(), rowIndx);
            tableValueSetter.set("stakecardrule", (Object)timeSeq.getStartTakeCardRule(), rowIndx);
            tableValueSetter.set("stakecardsamelen", (Object)timeSeq.getStartTakeCardSameLen(), rowIndx);
            tableValueSetter.set("ebeforescope", (Object)timeSeq.getEndBeforeScope(), rowIndx);
            tableValueSetter.set("eafterscope", (Object)timeSeq.getEndAfterScope(), rowIndx);
            tableValueSetter.set("etakecardrule", (Object)timeSeq.getEndTakeCardRule(), rowIndx);
            tableValueSetter.set("etakecardsamelen", (Object)timeSeq.getEndTakeCardSameLen(), rowIndx);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects) || dynamicObjects.size() <= rowIndx) continue;
            tableValueSetter.set("entryboid", ((DynamicObject)dynamicObjects.get(rowIndx)).get("entryboid"), rowIndx);
        }
        model2.batchCreateNewEntryRow("wtbd_tcardruleentry", vs);
        this.getView().updateView("wtbd_tcardruleentry");
        model2.endInit();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        Boolean isOff = (Boolean)this.getModel().getValue("isoff");
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": 
            case "submitandaudit": {
                if (isOff.booleanValue()) {
                    int timeInterval;
                    this.getModel().setValue("takecardconfig", null);
                    this.getModel().setValue("classtimenum", null);
                    this.getModel().setValue("classgetnum", null);
                    this.getModel().setValue("takecardshape", null);
                    Integer takeCardStartTime = (Integer)this.getModel().getValue("takecardstarttime");
                    Integer takeCardEndtime = (Integer)this.getModel().getValue("takecardendtime");
                    String offRefDayStart = (String)this.getModel().getValue("offrefdaystart");
                    String offRefDayEnd = (String)this.getModel().getValue("offrefdayend");
                    if (HRStringUtils.equals((String)offRefDayStart, (String)offRefDayEnd) && takeCardStartTime >= takeCardEndtime) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u5361\u5f00\u59cb\u65f6\u95f4\u987b\u65e9\u4e8e\u53d6\u5361\u7ed3\u675f\u65f6\u95f4\u3002", (String)"TakeCardRuleEdit_14", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        beforeDoOperationEventArgs.setCancel(true);
                    }
                    if ((timeInterval = this.getTimeInterval(takeCardStartTime, takeCardEndtime, offRefDayStart, offRefDayEnd)) <= 172800) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u5361\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc748\u5c0f\u65f6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TakeCardRuleEdit_52", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    beforeDoOperationEventArgs.setCancel(true);
                    break;
                }
                if (!beforeDoOperationEventArgs.isCancel() && this.checkNull()) {
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                this.setDynamicDataToEntry(this.getModel());
                this.setTakeConfigDes();
                break;
            }
            case "new": {
                WTCPageCache cache = new WTCPageCache(this.getView());
                cache.put("copynew", (Object)"true");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"callback_close", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setDataChanged(false);
            WTCPageCache cache = new WTCPageCache(this.getView());
            if ("true".equals(cache.get("hasChecked", String.class))) {
                cache.remove("hasChecked");
                return;
            }
            cache.put("hasChecked", (Object)"true");
            this.getView().invokeOperation("close");
        }
    }

    private void setMustInput(String log, boolean isMustInput) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(log);
        fieldEdit.setMustInput(isMustInput);
    }

    private void setTakecardconfigMusetInput(Boolean isMustInput) {
        this.setMustInput("takecardconfig", isMustInput);
        this.setMustInput("classtimenum", isMustInput);
        this.setMustInput("classgetnum", isMustInput);
        this.setMustInput("takecardshape", isMustInput);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        if (Objects.isNull(bsed)) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6548\u65e5\u671f\u3002", (String)"TakeCardRuleEdit_30", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        } else {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<=", (Object)bsed));
        }
    }

    private int getTimeInterval(Integer takeCardStartTime, Integer takeCardEndTime, String offRefDayStart, String offRefDayEnd) {
        if (null == takeCardStartTime || null == takeCardEndTime || HRStringUtils.isEmpty((String)offRefDayStart) || HRStringUtils.isEmpty((String)offRefDayEnd)) {
            return 0;
        }
        if (HRStringUtils.equals((String)offRefDayStart, (String)TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay) && HRStringUtils.equals((String)offRefDayEnd, (String)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay)) {
            return CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT - takeCardStartTime + takeCardEndTime;
        }
        if (HRStringUtils.equals((String)offRefDayStart, (String)TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay) && HRStringUtils.equals((String)offRefDayEnd, (String)TakeCardRuleRefDayEnum.NEXT_DAY.refDay)) {
            return CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT - takeCardStartTime + CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT + takeCardEndTime;
        }
        if (HRStringUtils.equals((String)offRefDayStart, (String)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay) && HRStringUtils.equals((String)offRefDayEnd, (String)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay)) {
            return takeCardEndTime - takeCardStartTime;
        }
        if (HRStringUtils.equals((String)offRefDayStart, (String)TakeCardRuleRefDayEnum.CURRENT_DAY.refDay) && HRStringUtils.equals((String)offRefDayEnd, (String)TakeCardRuleRefDayEnum.NEXT_DAY.refDay)) {
            return CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT - takeCardStartTime + takeCardEndTime;
        }
        return 0;
    }
}

