/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.takerule;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbd.common.vo.takecard.TimeSeqWrapper;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class TimeSeqPlugin
extends HRDynamicFormBasePlugin {
    private static final String LABEL_NUM = "label_num";
    private static final String DELETE_TIME_SEQ = "deletetimeseq";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{DELETE_TIME_SEQ});
    }

    public void beforeBindData(EventObject eventObject) {
        Map keyList;
        IFormView view = this.getView();
        view.getFormShowParameter().setStatus(OperationStatus.VIEW);
        FormShowParameter formParam = view.getFormShowParameter();
        Map params = formParam.getCustomParams();
        boolean startRule = (Boolean)params.get("startRule");
        boolean endRule = (Boolean)params.get("endRule");
        String num = params.get("num").toString();
        Label labelStaff = (Label)view.getControl(LABEL_NUM);
        labelStaff.setText(num);
        view.setVisible(Boolean.valueOf(startRule), new String[]{"sbeforescope", "safterscope", "stakecardrule", "stakecardsamelen"});
        view.setVisible(Boolean.valueOf(endRule), new String[]{"ebeforescope", "eafterscope", "etakecardrule", "etakecardsamelen"});
        view.setVisible(Boolean.FALSE, new String[]{DELETE_TIME_SEQ});
        WTCPageCache cache = new WTCPageCache(view.getParentView());
        TimeSeqWrapper timeSeqWrapper = (TimeSeqWrapper)cache.get("wtam_tcscopeEntryCollection", TimeSeqWrapper.class);
        Boolean cardConfigIsChange = (Boolean)cache.get("cardConfigkeyIsChange", Boolean.class);
        if (!cardConfigIsChange.booleanValue()) {
            if (Objects.isNull(timeSeqWrapper)) {
                return;
            }
            if (Integer.parseInt(num) - 1 >= timeSeqWrapper.getTimeSeqList().size()) {
                return;
            }
            this.setDataFormEntryRow((TimeSeq)timeSeqWrapper.getTimeSeqList().get(Integer.parseInt(num) - 1));
        }
        if (!CollectionUtils.isEmpty((Map)(keyList = (Map)cache.get("pageId2TimeSeqNum", Map.class)))) {
            this.setCardPointAttrChange(keyList);
        }
        OperationStatus viewStatus = null;
        if (view.getParentView() != null) {
            viewStatus = view.getParentView().getFormShowParameter().getStatus();
        }
        if (OperationStatus.VIEW.equals(viewStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{"sbeforescope", "safterscope", "stakecardrule", "stakecardsamelen", "ebeforescope", "eafterscope", "etakecardrule", "etakecardsamelen"});
        }
    }

    private void setCardPointAttrChange(Map<String, String> keyList) {
        keyList.forEach((key, vaule) -> {
            if (StringUtils.equals((CharSequence)key, (CharSequence)this.getView().getPageId())) {
                this.setCardPointAttrChange((String)vaule);
            }
        });
    }

    private void setCardPointAttrChange(String require) {
        List<String> propertiedList = this.getKeyList();
        if (StringUtils.isNotBlank((CharSequence)require)) {
            String[] requires = StringUtils.split((String)require, (String)",");
            this.getView().setEnable(Boolean.TRUE, requires);
            this.setRequire(true, requires);
            propertiedList.removeAll(CollectionUtils.arrayToList((Object)requires));
        }
        if (!CollectionUtils.isEmpty(propertiedList)) {
            String[] surplusRequires = StringUtils.split((String)StringUtils.join(propertiedList, (String)","), (String)",");
            this.getView().setEnable(Boolean.FALSE, surplusRequires);
            this.setRequire(false, surplusRequires);
        }
    }

    private void setRequire(boolean isRequire, String ... keys) {
        for (String key : keys) {
            FieldEdit control = (FieldEdit)this.getControl(key);
            control.setMustInput(isRequire);
        }
    }

    private List<String> getKeyList() {
        LinkedList<String> propertiedList = new LinkedList<String>();
        propertiedList.add("sbeforescope");
        propertiedList.add("safterscope");
        propertiedList.add("stakecardrule");
        propertiedList.add("ebeforescope");
        propertiedList.add("eafterscope");
        propertiedList.add("etakecardrule");
        return propertiedList;
    }

    private void setDataFormEntryRow(TimeSeq timeSeq) {
        IDataModel model = this.getView().getModel();
        model.setValue("sbeforescope", (Object)timeSeq.getStartBeforeScope());
        model.setValue("safterscope", (Object)timeSeq.getStartAfterScope());
        model.setValue("stakecardrule", (Object)timeSeq.getStartTakeCardRule());
        model.setValue("stakecardsamelen", (Object)timeSeq.getStartTakeCardSameLen());
        model.setValue("ebeforescope", (Object)timeSeq.getEndBeforeScope());
        model.setValue("eafterscope", (Object)timeSeq.getEndAfterScope());
        model.setValue("etakecardrule", (Object)timeSeq.getEndTakeCardRule());
        model.setValue("etakecardsamelen", (Object)timeSeq.getEndTakeCardSameLen());
        this.setTakeCardSameLen(timeSeq.getStartTakeCardSameLen(), "stakecardsamelen");
        this.setTakeCardSameLen(timeSeq.getEndTakeCardSameLen(), "etakecardsamelen");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)DELETE_TIME_SEQ) && this.getView().getParentView() != null) {
            this.getView().getParentView().setReturnData((Object)this.getView().getPageId());
            this.getView().getParentView().invokeOperation("donothing");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        IDataModel model = this.getModel();
        switch (fieldKey) {
            case "stakecardrule": {
                String sTakeCardRule = (String)model.getValue("stakecardrule");
                this.setTakeCardSameLen(sTakeCardRule, "stakecardsamelen");
                break;
            }
            case "etakecardrule": {
                String eTakeCardRule = (String)model.getValue("etakecardrule");
                this.setTakeCardSameLen(eTakeCardRule, "etakecardsamelen");
                break;
            }
        }
    }

    private void setTakeCardSameLen(String takeCardRule, String changeKey) {
        this.setRequire(StringUtils.equals((CharSequence)takeCardRule, (CharSequence)"5"), changeKey);
    }
}

