/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.timesplit;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.timesplit.Section;
import kd.wtc.wtbd.business.timesplit.SectionUtils;
import kd.wtc.wtbd.common.constants.TimeTypeConstants;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class TimeTypeEdit
extends HRDataBaseEdit
implements TimeTypeConstants {
    private static final Set<String> opSet = new HashSet<String>(Arrays.asList("save", "submit", "submitandaudit", "confirmchange", "confirmchangenoaudit"));

    public void registerListener(EventObject object) {
        super.registerListener(object);
        for (int i = 0; i < WEEKDAYS.length; ++i) {
            this.addClickListeners(new String[]{WEEKDAYS[i] + "timeadd"});
        }
        for (String str : DEL_PREFIX_LIST) {
            for (int i = 2; i <= 5; ++i) {
                this.addClickListeners(new String[]{str + i});
            }
        }
    }

    public void initialize() {
        super.initialize();
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        for (int i = 0; i < WEEKDAYS.length; ++i) {
            String weekDay = WEEKDAYS[i];
            Integer weekdayIndex = (Integer)pageCache.get(weekDay + "index", Integer.class);
            if (null != weekdayIndex) continue;
            weekdayIndex = 0;
            pageCache.put(weekDay + "index", (Object)weekdayIndex);
        }
    }

    private void addDayTime(String day) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer mondayIndex = (Integer)pageCache.get(day + "index", Integer.class);
        if (mondayIndex == 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a05\u4e2a\u65f6\u6bb5", (String)"TimeTypeEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Integer n = mondayIndex;
        Integer n2 = mondayIndex = Integer.valueOf(mondayIndex + 1);
        pageCache.put(day + "index", (Object)mondayIndex);
        String timeAdd = day + "adddel" + mondayIndex;
        this.getView().setVisible(Boolean.TRUE, new String[]{timeAdd});
        String fieldAdd = day + "time" + mondayIndex;
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(fieldAdd);
        fieldEdit.setMustInput(true);
    }

    private void delDayTime(String day, String delIndex) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer mondayIndex = (Integer)pageCache.get(day + "index", Integer.class);
        String delKey = day + "adddel" + mondayIndex;
        this.getView().setVisible(Boolean.FALSE, new String[]{delKey});
        String fieldAdd = day + "time" + mondayIndex;
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(fieldAdd);
        fieldEdit.setMustInput(false);
        this.transferData(day, Integer.valueOf(delIndex), mondayIndex);
        String startTime = day + "range" + mondayIndex + "_starttime";
        String endTime = day + "range" + mondayIndex + "_endtime";
        this.getView().getModel().setValue(startTime, null);
        this.getView().getModel().setValue(endTime, null);
        Integer n = mondayIndex;
        Integer n2 = mondayIndex = Integer.valueOf(mondayIndex - 1);
        pageCache.put(day + "index", (Object)mondayIndex);
    }

    private void transferData(String day, Integer delIndex, Integer mondayIndex) {
        IDataModel model = this.getView().getModel();
        for (int i = delIndex + 1; i <= mondayIndex; ++i) {
            String srcStartTime = day + "range" + i + "_starttime";
            String srcEndTime = day + "range" + i + "_endtime";
            String destStartTime = day + "range" + (i - 1) + "_starttime";
            String destEndTime = day + "range" + (i - 1) + "_endtime";
            model.setValue(destStartTime, model.getValue(srcStartTime));
            model.setValue(destEndTime, model.getValue(srcEndTime));
        }
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        for (String str : ADDDEL_PREFIX_LIST) {
            for (int i = 2; i <= 5; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{str + i});
            }
        }
        if (!OperationStatus.ADDNEW.equals((Object)viewStatus) && OperationStatus.VIEW.equals((Object)viewStatus)) {
            this.hideAddAndDelBar();
        }
        this.setDateToView();
    }

    private void hideAddAndDelBar() {
        for (int i = 0; i < ADD_PREFIX_LIST.size(); ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{(String)ADD_PREFIX_LIST.get(i)});
            for (int j = 2; j <= 5; ++j) {
                this.getView().setVisible(Boolean.FALSE, new String[]{(String)DEL_PREFIX_LIST.get(i) + j});
            }
        }
    }

    private void setDateToView() {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection weekentry = model.getDataEntity(true).getDynamicObjectCollection("weekentry");
        for (int i = 0; i < weekentry.size(); ++i) {
            this.setDateToWeekDay(WEEKDAYS[i], model, (DynamicObject)weekentry.get(i));
        }
    }

    private void setDateToWeekDay(String weekDay, IDataModel model, DynamicObject object) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        model.setValue(weekDay + "switch", (Object)object.getString("dayenable"));
        String timetype = object.getString("timetype");
        model.setValue(weekDay + "dwonlist", (Object)(HRStringUtils.isEmpty((String)timetype) ? "1" : timetype));
        int timerangecount = object.getInt("timerangecount");
        pageCache.put(weekDay + "index", (Object)timerangecount);
        for (int j = 1; j <= timerangecount; ++j) {
            String startTime = weekDay + "range" + j + "_starttime";
            String endTime = weekDay + "range" + j + "_endtime";
            model.setValue(startTime, object.get("start" + j));
            model.setValue(endTime, object.get("end" + j));
            this.getView().setVisible(Boolean.TRUE, new String[]{weekDay + "adddel" + j});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String newValue;
        ChangeData changeData;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"begintime") || HRStringUtils.equals((String)name, (String)"endtime")) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("fixtimeentity");
            entryentity.stream().forEach(item -> {
                String etagdate;
                BigDecimal starttime = item.getBigDecimal("begintime");
                BigDecimal endtime = item.getBigDecimal("endtime");
                String stagdate = item.getString("stagdate");
                if (Objects.equals(stagdate, etagdate = item.getString("etagdate")) && stagdate != null && starttime.compareTo(endtime) >= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4", (String)"TimeTypeEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                }
            });
        }
        if (HRStringUtils.equals((String)name, (String)"begintime") || HRStringUtils.equals((String)name, (String)"endtime") || HRStringUtils.equals((String)name, (String)"stagdate") || HRStringUtils.equals((String)name, (String)"etagdate")) {
            ArrayList sectionList = new ArrayList();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("fixtimeentity");
            entryentity.stream().forEach(item -> {
                BigDecimal starttime = item.getBigDecimal("begintime");
                BigDecimal endtime = item.getBigDecimal("endtime");
                String stagdate = item.getString("stagdate");
                String etagdate = item.getString("etagdate");
                if (Objects.nonNull(starttime) && Objects.nonNull(endtime) && Objects.nonNull(stagdate) && Objects.nonNull(etagdate)) {
                    if (Objects.equals(stagdate, "C")) {
                        starttime = starttime.add(new BigDecimal("86400"));
                    }
                    if (Objects.equals(etagdate, "C")) {
                        endtime = endtime.add(new BigDecimal("86400"));
                    }
                    Section section = new Section(starttime, endtime);
                    sectionList.add(section);
                }
            });
            if (SectionUtils.complateCf(sectionList)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65f6\u6bb5\u5305\u542b\u5728\u5df2\u5b58\u5728\u7684\u65f6\u6bb5\u8303\u56f4\u5185\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"TimeTypeEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            }
        }
        if (HRStringUtils.equals((String)name, (String)"etagdate")) {
            changeData = args.getChangeSet()[0];
            newValue = (String)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (HRStringUtils.equals((String)newValue, (String)"D")) {
                this.getModel().setValue("stagdate", (Object)"D", rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"stagdate"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"stagdate"});
            }
        }
        if (HRStringUtils.equals((String)name, (String)"datatype")) {
            changeData = args.getChangeSet()[0];
            newValue = (String)changeData.getNewValue();
            if ("3".equals(newValue)) {
                for (String weekday : WEEKDAYS) {
                    this.getModel().setValue(weekday + "dwonlist", (Object)"1");
                }
                this.setMustInput(false);
            } else if ("2".equals(newValue)) {
                this.setMustInput(true);
            }
        }
        this.fillMustByName(name);
    }

    private void setMustInput(boolean flag) {
        FieldEdit begintimeFieldEdit = (FieldEdit)this.getView().getControl("begintime");
        begintimeFieldEdit.setMustInput(flag);
        FieldEdit stagdateFieldEdit = (FieldEdit)this.getView().getControl("stagdate");
        stagdateFieldEdit.setMustInput(flag);
        FieldEdit endtimeFieldEdit = (FieldEdit)this.getView().getControl("endtime");
        endtimeFieldEdit.setMustInput(flag);
        FieldEdit etagdateFieldEdit = (FieldEdit)this.getView().getControl("etagdate");
        etagdateFieldEdit.setMustInput(flag);
    }

    private void fillMustByName(String name) {
        if (name.endsWith("switch")) {
            String weekday = name.substring(0, name.indexOf("switch"));
            String firstTimeTag = weekday + "time1";
            String dwonlistTag = weekday + "dwonlist";
            String dwonlistSelect = (String)this.getView().getModel().getValue(dwonlistTag);
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(firstTimeTag);
            if (this.getView().getModel().getValue(name).equals(Boolean.FALSE) || HRStringUtils.equals((String)dwonlistSelect, (String)"1")) {
                fieldEdit.setMustInput(false);
                this.hideAllTimeRange(weekday);
            } else if (HRStringUtils.equals((String)dwonlistSelect, (String)"2")) {
                fieldEdit.setMustInput(true);
                this.showFirstTimeRange(weekday);
            }
        } else if (name.endsWith("dwonlist")) {
            String weekday = name.substring(0, name.indexOf("dwonlist"));
            String firstTimeTag = weekday + "time1";
            String dwonlistTag = weekday + "dwonlist";
            String dwonlistSelect = (String)this.getView().getModel().getValue(dwonlistTag);
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(firstTimeTag);
            if (HRStringUtils.equals((String)dwonlistSelect, (String)"1")) {
                fieldEdit.setMustInput(false);
                this.hideAllTimeRange(weekday);
            } else if (HRStringUtils.equals((String)dwonlistSelect, (String)"2")) {
                fieldEdit.setMustInput(true);
                this.showFirstTimeRange(weekday);
            }
        }
    }

    private void showFirstTimeRange(String weekDay) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        this.getView().setVisible(Boolean.TRUE, new String[]{weekDay + "adddel" + 1});
        pageCache.put(weekDay + "index", (Object)1);
    }

    private void hideAllTimeRange(String weekDay) {
        IDataModel model = this.getView().getModel();
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        int timerangecount = (Integer)pageCache.get(weekDay + "index", Integer.class);
        pageCache.put(weekDay + "index", (Object)timerangecount);
        for (int j = 1; j <= timerangecount; ++j) {
            String startTime = weekDay + "range" + j + "_starttime";
            String endTime = weekDay + "range" + j + "_endtime";
            model.setValue(startTime, null);
            model.setValue(endTime, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{weekDay + "adddel" + j});
        }
        pageCache.put(weekDay + "index", (Object)0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (opSet.contains(key)) {
            this.clearDisableEntry();
            this.updateWeekEntry();
            this.checkFixedTime(args);
            this.checkWeekDay(args);
        }
    }

    private void checkWeekDay(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getView().getModel();
        if (!"3".equals(model.getValue("datatype"))) {
            return;
        }
        boolean hasOne = false;
        for (int i = 0; i < WEEKDAYS.length; ++i) {
            String weekday = WEEKDAYS[i];
            if (!((Boolean)model.getValue(weekday + "switch")).booleanValue()) continue;
            hasOne = true;
            this.checkWeekDayCross(weekday, args, i);
        }
        if (!hasOne) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f00\u542f\u4e00\u5929\u3002", (String)"TimeTypeEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkWeekDayCross(String weekday, BeforeDoOperationEventArgs args, int index) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer weekdayIndex = (Integer)pageCache.get(weekday + "index", Integer.class);
        IDataModel model = this.getModel();
        for (int i = 1; i <= weekdayIndex; ++i) {
            String startTime = weekday + "range" + i + "_starttime";
            String endTime = weekday + "range" + i + "_endtime";
            int start = (Integer)model.getValue(startTime, index);
            int end = (Integer)model.getValue(endTime, index);
            if (start == -1 || start < end) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65f6\u95f4\u6bb5\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"TimeTypeEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            break;
        }
        DynamicObjectCollection weekentry = model.getEntryEntity("weekentry");
        ArrayList<Section> sectionList = new ArrayList<Section>(7);
        for (DynamicObject dynamicObject : weekentry) {
            if (!dynamicObject.getBoolean("dayenable")) continue;
            sectionList.clear();
            int timerangecount = dynamicObject.getInt("timerangecount");
            for (int i = 0; i < timerangecount; ++i) {
                BigDecimal starttime = dynamicObject.getBigDecimal("start" + (i + 1));
                BigDecimal endtime = dynamicObject.getBigDecimal("end" + (i + 1));
                Section section = new Section(starttime, endtime);
                sectionList.add(section);
            }
            if (!SectionUtils.complateCf(sectionList)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65f6\u6bb5\u5305\u542b\u5728\u5df2\u5b58\u5728\u7684\u65f6\u6bb5\u8303\u56f4\u5185\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"TimeTypeEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void checkFixedTime(BeforeDoOperationEventArgs args) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        if (!"2".equals(model.getValue("datatype"))) {
            return;
        }
        DynamicObjectCollection fixtimeentity = model.getEntryEntity("fixtimeentity");
        if (fixtimeentity.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u56fa\u5b9a\u65f6\u6bb5\u4fe1\u606f\u3002", (String)"TimeTypeEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        for (DynamicObject dynamicObject : fixtimeentity) {
            long endtime;
            long begintime = this.getAbsoluteTime(dynamicObject.getString("stagdate"), dynamicObject.getInt("begintime")).getTime().getTime();
            if (begintime < (endtime = this.getAbsoluteTime(dynamicObject.getString("etagdate"), dynamicObject.getInt("endtime")).getTime().getTime())) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"TimeTypeEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            break;
        }
        ArrayList<Section> sectionList = new ArrayList<Section>(7);
        for (DynamicObject dynamicObject : fixtimeentity) {
            BigDecimal starttime = dynamicObject.getBigDecimal("begintime");
            BigDecimal endtime = dynamicObject.getBigDecimal("endtime");
            if (Objects.equals(dynamicObject.getString("stagdate"), "C")) {
                starttime = starttime.add(new BigDecimal("86400"));
            }
            if (Objects.equals(dynamicObject.getString("etagdate"), "C")) {
                endtime = endtime.add(new BigDecimal("86400"));
            }
            Section section = new Section(starttime, endtime);
            sectionList.add(section);
        }
        if (SectionUtils.complateCf(sectionList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65f6\u6bb5\u5305\u542b\u5728\u5df2\u5b58\u5728\u7684\u65f6\u6bb5\u8303\u56f4\u5185\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"TimeTypeEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private Calendar getAbsoluteTime(String refstart, int startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateFormat = simpleDateFormat.format(new Date());
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(dateFormat));
            if (refstart.equals("C")) {
                calendar.add(5, 1);
            }
        }
        catch (ParseException e) {
            String msg = ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef\u3002", (String)"TimeTypeEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        calendar.add(13, startDate);
        return calendar;
    }

    private void clearDisableEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        String datatype = (String)model.getValue("datatype");
        for (int i = 0; i < DATE_TYPE_ARR.length; ++i) {
            if (datatype.equals(DATE_TYPE_ARR[i])) continue;
            model.deleteEntryData(DATE_TYPE_ENTRY[i]);
        }
    }

    private void updateWeekEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        if (!"3".equals(model.getValue("datatype"))) {
            return;
        }
        DynamicObjectCollection weekEntry = this.getModel().getEntryEntity("weekentry");
        if (!weekEntry.isEmpty()) {
            for (int i = 0; i < WEEKDAYS.length; ++i) {
                this.updateWeekdayOfEntryNew(WEEKDAYS[i], weekEntry, model, i);
            }
        } else {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            model.beginInit();
            for (int i = 0; i < WEEKDAYS.length; ++i) {
                this.updateWeekdayOfEntry(WEEKDAYS[i], vs, model, i);
            }
            model.batchCreateNewEntryRow("weekentry", vs);
            this.getView().updateView("weekentry");
            model.endInit();
        }
    }

    private void updateWeekdayOfEntry(String weekDay, TableValueSetter vs, AbstractFormDataModel model, int rowNum) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer mondayIndex = (Integer)pageCache.get(weekDay + "index", Integer.class);
        TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
        tableValueSetter.set("weekday", (Object)(rowNum + 1), rowNum);
        boolean dayenable = (Boolean)model.getValue(weekDay + "switch");
        String dwonlist = (String)model.getValue(weekDay + "dwonlist");
        tableValueSetter.set("dayenable", (Object)dayenable, rowNum);
        tableValueSetter.set("timetype", (Object)(HRStringUtils.isEmpty((String)dwonlist) ? "1" : dwonlist), rowNum);
        tableValueSetter.set("timerangecount", (Object)mondayIndex, rowNum);
        if (!dayenable || "1".equals(dwonlist)) {
            this.resetTimeRanges(tableValueSetter, rowNum);
            return;
        }
        this.updateTimeRanges(weekDay, tableValueSetter, model, rowNum);
    }

    private void resetTimeRanges(TableValueSetter tableValueSetter, int rowNum) {
        for (int i = 1; i <= 5; ++i) {
            tableValueSetter.set("start" + i, (Object)0, rowNum);
            tableValueSetter.set("end" + i, (Object)0, rowNum);
        }
    }

    private void updateTimeRanges(String weekDay, TableValueSetter tableValueSetter, AbstractFormDataModel model, int rowNum) {
        int i;
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer weekdayIndex = (Integer)pageCache.get(weekDay + "index", Integer.class);
        for (i = 1; i <= weekdayIndex; ++i) {
            String startTime = weekDay + "range" + i + "_starttime";
            String endTime = weekDay + "range" + i + "_endtime";
            tableValueSetter.set("start" + i, model.getValue(startTime), rowNum);
            tableValueSetter.set("end" + i, model.getValue(endTime), rowNum);
        }
        for (i = weekdayIndex + 1; i <= 5; ++i) {
            tableValueSetter.set("start" + i, (Object)-1, rowNum);
            tableValueSetter.set("end" + i, (Object)-1, rowNum);
        }
    }

    private void updateWeekdayOfEntryNew(String weekDay, DynamicObjectCollection weekEntry, AbstractFormDataModel model, int rowNum) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer mondayIndex = (Integer)pageCache.get(weekDay + "index", Integer.class);
        DynamicObject dynamicObject = (DynamicObject)weekEntry.get(rowNum);
        boolean dayenable = (Boolean)model.getValue(weekDay + "switch");
        String dwonlist = (String)model.getValue(weekDay + "dwonlist");
        dynamicObject.set("dayenable", (Object)dayenable);
        dynamicObject.set("timetype", (Object)(HRStringUtils.isEmpty((String)dwonlist) ? "1" : dwonlist));
        dynamicObject.set("timerangecount", (Object)mondayIndex);
        if (!dayenable || "1".equals(dwonlist)) {
            this.resetTimeRangesNew(dynamicObject);
            return;
        }
        this.updateTimeRangesNew(weekDay, dynamicObject, model);
    }

    private void resetTimeRangesNew(DynamicObject dynamicObject) {
        for (int i = 1; i <= 5; ++i) {
            dynamicObject.set("start" + i, (Object)0);
            dynamicObject.set("end" + i, (Object)0);
        }
    }

    private void updateTimeRangesNew(String weekDay, DynamicObject dynamicObject, AbstractFormDataModel model) {
        int i;
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Integer weekdayIndex = (Integer)pageCache.get(weekDay + "index", Integer.class);
        for (i = 1; i <= weekdayIndex; ++i) {
            String startTime = weekDay + "range" + i + "_starttime";
            String endTime = weekDay + "range" + i + "_endtime";
            dynamicObject.set("start" + i, model.getValue(startTime));
            dynamicObject.set("end" + i, model.getValue(endTime));
        }
        for (i = weekdayIndex + 1; i <= 5; ++i) {
            dynamicObject.set("start" + i, (Object)-1);
            dynamicObject.set("end" + i, (Object)-1);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        int length = key.length();
        if (ADD_PREFIX_SET.contains(key)) {
            this.addDayTime(key.substring(0, length - "timeadd".length()));
        }
        if (DEL_PREFIX_SET.contains(key.substring(0, length - 1))) {
            this.delDayTime(key.substring(0, length - "timedel".length() - 1), key.substring(length - 1));
        }
    }

    public void beforeBindData(EventObject e) {
        String dataType;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        BillOperationStatus bos = billShowParameter.getBillStatus();
        if (bos.equals((Object)BillOperationStatus.VIEW) || bos.equals((Object)BillOperationStatus.SUBMIT) || bos.equals((Object)BillOperationStatus.AUDIT)) {
            IDataEntityType dataEntityType = this.getModel().getDataEntity().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            int size = properties.size();
            ArrayList objects = Lists.newArrayListWithExpectedSize((int)size);
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                objects.add(name);
            }
            String[] objStr = new String[size];
            objects.toArray(objStr);
            this.getView().setEnable(Boolean.FALSE, objStr);
        }
        if ("2".equals(dataType = (String)this.getModel().getValue("datatype"))) {
            this.setMustInput(true);
        } else if ("3".equals(dataType)) {
            this.setMustInput(false);
        }
    }
}

