/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.business.workschedule.WorkScheduleService;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleEntryGenParam;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntryVo;
import kd.wtc.wtbd.fromplugin.util.WorkScheduleFormHelper;
import kd.wtc.wtbs.business.workschedule.datetypeadj.DateTypeAdjService;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class BatchWorkScheduleEdit
extends HRDataBaseEdit {
    private final HRBaseServiceHelper workScheduleHelper = new HRBaseServiceHelper("wtbd_workschedule");
    private Map<Long, DateTypeAdj> dateTypeAdjMap;

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String successMsg = (String)this.getView().getFormShowParameter().getCustomParam("successMsg");
        if (HRStringUtils.isNotEmpty((String)successMsg)) {
            this.getView().showSuccessNotification(successMsg);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "batch_save": 
            case "batch_submit": 
            case "batch_submitandaudit": 
            case "bar_saveandnew": {
                if (this.isLegalNameRepeat() && this.isLegalNumberAndOrgRepeat() && this.isLegal()) break;
                args.setCancel(true);
                break;
            }
            case "preview": {
                if (this.isLegalPreview()) break;
                args.setCancel(true);
                break;
            }
            case "new": {
                args.setCancel(true);
                this.openAddNew();
                break;
            }
        }
    }

    private void openAddNew() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("wtbd_batchworkschedule");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        showParameter.setCustomParam("useorgId", this.getView().getFormShowParameter().getCustomParam("useorgId"));
        showParameter.setCustomParam("successMsg", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BatchWorkScheduleEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u65b0\u589e\u5de5\u4f5c\u65e5\u7a0b\u8868", (String)"WorkScheduleList_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isLegalNumberAndOrgRepeat() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject createOrgDyn = dataEntity.getDynamicObject("createorg");
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5de5\u4f5c\u65e5\u7a0b\u8868\u4e2d\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u884c\u6570\u636e\u3002", (String)"BatchWorkScheduleEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> numberSet = new HashSet<String>(entryList.size());
        for (DynamicObject entryInfo : entryList) {
            if (numberSet.contains(entryInfo.getString("worknumber"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d\u3001\u201c\u521b\u5efa\u7ec4\u7ec7\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"BatchWorkScheduleEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{entryInfo.getString("worknumber")}));
                return false;
            }
            numberSet.add(entryInfo.getString("worknumber"));
        }
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        QFilter createOrgFilter = new QFilter("createorg", "=", (Object)createOrgDyn.getLong("id"));
        DynamicObject[] nameQuery = this.workScheduleHelper.query("id,name,number", new QFilter[]{numberFilter.and(createOrgFilter)});
        if (nameQuery != null && nameQuery.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d\u3001\u201c\u521b\u5efa\u7ec4\u7ec7\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"BatchWorkScheduleEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{nameQuery[0].getString("number")}));
            return false;
        }
        return true;
    }

    private boolean isLegalNameRepeat() {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        HashSet<String> nameSet = new HashSet<String>(entryList.size());
        for (DynamicObject entryInfo : entryList) {
            if (nameSet.contains(entryInfo.getString("workname"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s: \u201c\u540d\u79f0\u201d \u5df2\u5b58\u5728\u3002", (String)"BatchWorkScheduleEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{entryInfo.getString("workname")}));
                return false;
            }
            nameSet.add(entryInfo.getString("workname"));
        }
        DynamicObject[] nameQuery = this.workScheduleHelper.query("id,name,number", new QFilter[]{new QFilter("name", "in", nameSet)});
        if (nameQuery != null && nameQuery.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s: \u201c\u540d\u79f0\u201d \u5df2\u5b58\u5728\u3002", (String)"BatchWorkScheduleEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{nameQuery[0].getString("name")}));
            return false;
        }
        return true;
    }

    private boolean isLegal() {
        Date genStartTime = this.getModel().getDataEntity().getDate("genstarttime");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        DynamicObject baseDateDyn = entry.stream().filter(dy -> !this.isLegalBaseDate((DynamicObject)dy, genStartTime)).findFirst().orElse(null);
        if (null != baseDateDyn) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u57fa\u51c6\u65e5\u671f\u3002", (String)"BatchWorkScheduleEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return this.isLegalStartAndEndDate();
    }

    private boolean isLegalStartAndEndDate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date genStartTime = dataEntity.getDate("genstarttime");
        Date genEndTime = dataEntity.getDate("genendtime");
        if (genStartTime.getTime() > genEndTime.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3002", (String)"BatchWorkScheduleEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (WorkScheduleService.isExceed((Date)genStartTime, (Date)genEndTime, (int)WorkScheduleHelper.getWorkSchLengthLimit())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6700\u65e9\u751f\u6210\u65e5\u671f\u81f3\u6700\u665a\u7ed3\u675f\u65e5\u671f\u9ed8\u8ba4\u8bbe\u7f6e\u4e0d\u53ef\u8d85\u8fc7%1$s\u5e74\uff0c\u53ef\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u8be5\u8bbe\u7f6e\u3002", (String)"WorkScheduleEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), WorkScheduleHelper.getWorkSchLengthLimit()));
            return false;
        }
        return true;
    }

    private boolean isLegalBaseDate(DynamicObject curr, Date starDate) {
        if (curr.getDate("basedate") != null && starDate != null && curr.getDate("basedate").getTime() > starDate.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u57fa\u51c6\u65e5\u671f\u3002", (String)"BatchWorkScheduleEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isLegalPreview() {
        boolean nullCheck;
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        DynamicObject curr = (DynamicObject)entry.get(index);
        StringBuilder sbr = new StringBuilder();
        boolean legalTimeZone = this.isLegalTimeZone(sbr);
        boolean isLegalCalendarModel = this.isLegalCalendarModel(sbr);
        boolean isLegalGenStartDate = this.isLegalGenStartDate(sbr);
        boolean isLegalGenEndDate = this.isLegalGenEndDate(sbr);
        boolean isLegalName = this.isLegalName(curr, sbr);
        boolean isLegalNumber = this.isLegalNumber(curr, sbr);
        boolean isLegalShiftMode = this.isLegalShiftMode(curr, sbr);
        boolean isLegalBaseDate = this.isLegalBaseDate(curr, sbr);
        boolean bl = nullCheck = legalTimeZone && isLegalCalendarModel && isLegalBaseDate && isLegalGenStartDate && isLegalGenEndDate && isLegalName && isLegalNumber && isLegalShiftMode;
        if (!nullCheck) {
            if (sbr.toString().endsWith("\u3001")) {
                sbr.deleteCharAt(sbr.length() - 1);
            }
            sbr.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5fc5\u586b\u5b57\u6bb5\uff0c\u518d\u70b9\u51fb\u201c\u9884\u89c8\u201d\u6309\u94ae\u3002", (String)"BatchWorkScheduleEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(sbr.toString());
            return false;
        }
        Date genStartTime = this.getModel().getDataEntity().getDate("genstarttime");
        return this.isLegalStartAndEndDate() && this.isLegalBaseDate(curr, genStartTime);
    }

    private boolean isLegalTimeZone(StringBuilder sbr) {
        DynamicObject timeZoneDyn = this.getModel().getDataEntity().getDynamicObject("timezoneid");
        if (timeZoneDyn == null) {
            sbr.append(ResManager.loadKDString((String)"\u5730\u533a/\u65f6\u533a", (String)"BatchWorkScheduleEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalCalendarModel(StringBuilder sbr) {
        DynamicObject shiftModeDyn = this.getModel().getDataEntity().getDynamicObject("calendarmodel");
        if (shiftModeDyn == null) {
            sbr.append(ResManager.loadKDString((String)"\u65e5\u5386\u751f\u6210\u89c4\u5219", (String)"BatchWorkScheduleEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalGenStartDate(StringBuilder sbr) {
        Date startDate = this.getModel().getDataEntity().getDate("genstarttime");
        if (startDate == null) {
            sbr.append(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f", (String)"BatchWorkScheduleEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalGenEndDate(StringBuilder sbr) {
        Date endDate = this.getModel().getDataEntity().getDate("genendtime");
        if (endDate == null) {
            sbr.append(ResManager.loadKDString((String)"\u751f\u6210\u7ed3\u675f\u65e5\u671f", (String)"BatchWorkScheduleEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalName(DynamicObject currDyn, StringBuilder sbr) {
        String name = currDyn.getString("workname");
        if (HRStringUtils.isEmpty((String)name)) {
            sbr.append(ResManager.loadKDString((String)"\u540d\u79f0", (String)"BatchWorkScheduleEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalShiftMode(DynamicObject currDyn, StringBuilder sbr) {
        DynamicObject shiftModeDyn = currDyn.getDynamicObject("shiftmode");
        if (shiftModeDyn == null) {
            sbr.append(ResManager.loadKDString((String)"\u8f6e\u73ed\u89c4\u5219", (String)"BatchWorkScheduleEdit_12", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalNumber(DynamicObject currDyn, StringBuilder sbr) {
        String name = currDyn.getString("worknumber");
        if (HRStringUtils.isEmpty((String)name)) {
            sbr.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"BatchWorkScheduleEdit_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    private boolean isLegalBaseDate(DynamicObject currDyn, StringBuilder sbr) {
        Date startDate = currDyn.getDate("basedate");
        if (startDate == null) {
            sbr.append(ResManager.loadKDString((String)"\u57fa\u51c6\u65e5\u671f", (String)"BatchWorkScheduleEdit_14", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])).append('\u3001');
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "batch_save": 
            case "batch_submit": 
            case "batch_submitandaudit": 
            case "bar_saveandnew": {
                boolean isSaveNew = false;
                if (!args.getOperationResult().isSuccess() || !this.isLegal()) break;
                switch (operateKey) {
                    case "batch_save": {
                        operateKey = "save";
                        break;
                    }
                    case "batch_submit": {
                        operateKey = "submit";
                        break;
                    }
                    case "batch_submitandaudit": {
                        operateKey = "submitandaudit";
                        break;
                    }
                    case "bar_saveandnew": {
                        operateKey = "save";
                        isSaveNew = true;
                        break;
                    }
                }
                Map<String, Object> resultMap = this.toSave(operateKey);
                if (isSaveNew) {
                    operateKey = "saveandnew";
                }
                this.shoForm(resultMap, operateKey);
                break;
            }
            case "preview": {
                this.toPreview();
                break;
            }
        }
    }

    private void toPreview() {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        DynamicObject currDy = (DynamicObject)entry.get(index);
        long adjId = currDy.getLong("shiftmode.datetypeadj.id");
        this.dateTypeAdjMap = DateTypeAdjService.getInstance().getDateTypeAdjMap(Collections.singletonList(adjId));
        DynamicObject workSchedule = this.buildWorkScheduleInfoForPreview(currDy);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("wtbd_workschedule");
        showParameter.setShowTitle(true);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setCustomParam("wtbd_batchworkschedule", (Object)workSchedule);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8", (String)"BatchWorkScheduleEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        StyleCss style = new StyleCss();
        style.setHeight("90%");
        style.setWidth("90%");
        showParameter.getOpenStyle().setInlineStyleCss(style);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void shoForm(Map<String, Object> resultMap, String operateKey) {
        List successList = (List)resultMap.get("successList");
        List errorList = (List)resultMap.get("errorList");
        if (CollectionUtils.isEmpty((Collection)errorList)) {
            this.getModel().setDataChanged(false);
            if (operateKey.equals("saveandnew")) {
                this.getView().invokeOperation("new");
            } else {
                String showMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BatchWorkScheduleEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().showSuccessNotification(showMsg);
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                this.getView().close();
            }
            return;
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtc_operationresult");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setShowTitle(false);
        parameters.setCustomParam("operatename", (Object)this.getOperateName(operateKey));
        parameters.setCustomParam("allnum", (Object)String.valueOf(successList.size() + errorList.size()));
        parameters.setCustomParam("failnum", (Object)String.valueOf(errorList.size()));
        parameters.setCustomParam("oknum", (Object)String.valueOf(successList.size()));
        parameters.setCustomParam("failList", (Object)errorList);
        parameters.setCustomParam("successList", (Object)successList);
        parameters.setCustomParam("operatetype", (Object)operateKey);
        this.getView().showForm(parameters);
    }

    private String getOperateName(String operateKey) {
        String operateName;
        switch (operateKey) {
            case "save": {
                operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BatchWorkScheduleEdit_17", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                break;
            }
            case "submit": {
                operateName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"BatchWorkScheduleEdit_18", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                break;
            }
            case "submitandaudit": {
                operateName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)"BatchWorkScheduleEdit_19", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                operateName = operateKey;
            }
        }
        return operateName;
    }

    private DynamicObject buildWorkScheduleInfoForSave(DynamicObject entryDy, Map<String, List<String>> errorMap) {
        String number = entryDy.getString("worknumber");
        DynamicObject workSchedule = this.getBaseDyn();
        workSchedule.set("name", (Object)entryDy.getLocaleString("workname"));
        workSchedule.set("number", (Object)number);
        workSchedule.set("shiftmode", (Object)entryDy.getDynamicObject("shiftmode"));
        workSchedule.set("basedate", (Object)entryDy.getDate("basedate"));
        workSchedule.set("holidayportfolios", (Object)entryDy.getDynamicObjectCollection("holidayportfolios"));
        List<WorkScheduleNewEntry> entryList = this.genWorkScheduleEntry(workSchedule, entryDy);
        List<WorkScheduleNewEntryVo> voList = WorkScheduleFormHelper.batchConvert2VoList(entryList);
        List<String> messages = WorkScheduleFormHelper.validateShiftDates(voList);
        messages.addAll(WorkScheduleFormHelper.validateShiftOverlap(voList));
        if (CollectionUtils.isNotEmpty(messages)) {
            errorMap.put(number, messages);
        } else {
            DynamicObjectCollection dynamicObjects = workSchedule.getDynamicObjectCollection("wtbd_workscheduleentry");
            dynamicObjects.addAll(this.buildEntry(workSchedule, entryList));
        }
        return workSchedule;
    }

    private DynamicObject buildWorkScheduleInfoForPreview(DynamicObject entryDy) {
        DynamicObject workSchedule = this.getBaseDyn();
        workSchedule.set("name", (Object)entryDy.getLocaleString("workname"));
        workSchedule.set("number", (Object)entryDy.getString("worknumber"));
        workSchedule.set("shiftmode", (Object)entryDy.getDynamicObject("shiftmode"));
        workSchedule.set("basedate", (Object)entryDy.getDate("basedate"));
        workSchedule.set("holidayportfolios", (Object)entryDy.getDynamicObjectCollection("holidayportfolios"));
        DynamicObjectCollection dynamicObjects = workSchedule.getDynamicObjectCollection("wtbd_workscheduleentry");
        List<WorkScheduleNewEntry> entryList = this.genWorkScheduleEntry(workSchedule, entryDy);
        dynamicObjects.addAll(this.buildEntry(workSchedule, entryList));
        return workSchedule;
    }

    private Map<String, Object> toSave(String operateKey) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(entry.size());
        ArrayList successList = new ArrayList(entry.size());
        ArrayList<Map<String, String>> errorList = new ArrayList<Map<String, String>>(entry.size());
        resultMap.put("successList", successList);
        resultMap.put("errorList", errorList);
        ArrayList workScheduleList = new ArrayList(entry.size());
        Set adjIdList = entry.stream().map(dy -> dy.getLong("shiftmode.datetypeadj.id")).collect(Collectors.toSet());
        this.dateTypeAdjMap = DateTypeAdjService.getInstance().getDateTypeAdjMap(adjIdList);
        HashMap errorMap = Maps.newHashMap();
        entry.forEach(dy -> {
            DynamicObject workSchedule = this.buildWorkScheduleInfoForSave((DynamicObject)dy, errorMap);
            if ("submit".equals(operateKey) || "submitandaudit".equals(operateKey)) {
                workSchedule.set("status", (Object)"A");
                workSchedule.set("enable", (Object)"1");
            }
            workScheduleList.add(workSchedule);
        });
        for (DynamicObject obj : workScheduleList) {
            String number = obj.getString("number");
            if (CollectionUtils.isNotEmpty((Collection)((Collection)errorMap.get(number)))) {
                errorList.addAll(((List)errorMap.get(number)).stream().map(msg -> this.newErrorMap(obj, (String)msg)).collect(Collectors.toList()));
                continue;
            }
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                OperationResult result = OperationServiceHelper.executeOperate((String)operateKey, (String)"wtbd_workschedule", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)operateOption);
                if (result.isSuccess()) {
                    HashMap<String, String> map = new HashMap<String, String>(10);
                    map.put("number", obj.getString("number"));
                    map.put("name", obj.getString("name"));
                    successList.add(map);
                    continue;
                }
                String message = result.getValidateResult().getValidateErrors().stream().map(err -> err.getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.joining())).collect(Collectors.joining());
                errorList.add(this.newErrorMap(obj, message));
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>(10);
                map.put("number", obj.getString("number"));
                map.put("name", obj.getString("name"));
                map.put("message", ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\u3002", (String)"BatchWorkScheduleEdit_20", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                errorList.add(map);
            }
        }
        return resultMap;
    }

    private DynamicObject getBaseDyn() {
        Date now = new Date();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtbd_workschedule");
        DynamicObject workSchedule = new DynamicObject((DynamicObjectType)mainEntityType);
        workSchedule.set("createorg", (Object)dataEntity.getDynamicObject("createorg"));
        workSchedule.set("timezoneid", (Object)dataEntity.getDynamicObject("timezoneid"));
        workSchedule.set("calendarmodel", (Object)dataEntity.getDynamicObject("calendarmodel"));
        workSchedule.set("calendarmodelfid", (Object)dataEntity.getLong("calendarmodel.sourcevid"));
        workSchedule.set("genstarttime", (Object)dataEntity.getDate("genstarttime"));
        workSchedule.set("genendtime", (Object)dataEntity.getDate("genendtime"));
        workSchedule.set("floorgendate", (Object)dataEntity.getDate("genstarttime"));
        workSchedule.set("ceilinggendate", (Object)dataEntity.getDate("genendtime"));
        workSchedule.set("ctrlstrategy", (Object)dataEntity.getString("ctrlstrategy"));
        workSchedule.set("description", (Object)dataEntity.getString("description"));
        workSchedule.set("creator", (Object)dataEntity.getLong("creator.id"));
        workSchedule.set("createtime", (Object)now);
        return workSchedule;
    }

    private List<WorkScheduleNewEntry> genWorkScheduleEntry(DynamicObject workSchedule, DynamicObject entryDy) {
        long timezoneId = workSchedule.getLong("timezoneid.id");
        long calendarModelId = workSchedule.getLong("calendarmodel.id");
        long shiftModeId = workSchedule.getLong("shiftmode.id");
        Date genStartTime = workSchedule.getDate("genstarttime");
        Date baseDate = workSchedule.getDate("basedate");
        Date genEndTime = workSchedule.getDate("genendtime");
        List holidayPortfolioIdList = workSchedule.getDynamicObjectCollection("holidayportfolios").stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
        long dateTypeAdjId = workSchedule.getLong("shiftmode.datetypeadj.id");
        DateTypeAdj dateTypeAdj = this.dateTypeAdjMap.get(dateTypeAdjId);
        WorkScheduleEntryGenParam param = new WorkScheduleEntryGenParam(baseDate, genStartTime, genEndTime, timezoneId, calendarModelId, shiftModeId, holidayPortfolioIdList);
        String reviseDataStr = entryDy.getString("revisedata");
        if (HRStringUtils.isNotEmpty((String)reviseDataStr)) {
            Map dateListMap = (Map)SerializationUtils.deSerializeFromBase64((String)reviseDataStr);
            Map<Date, Long> dateTypeMap = dateListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Long)((List)entry.getValue()).get(1)));
            param.setConflictDateTypeMap(dateTypeMap);
        }
        List workScheduleNewEntries = WorkScheduleHelper.genWorkSchedule((WorkScheduleEntryGenParam)param);
        WorkScheduleHelper.adjWorkScheduleEntry((List)workScheduleNewEntries, (Date)genStartTime, (Date)genEndTime, (DateTypeAdj)dateTypeAdj);
        return workScheduleNewEntries;
    }

    private List<DynamicObject> buildEntry(DynamicObject workSchedule, List<WorkScheduleNewEntry> entryList) {
        ArrayList<DynamicObject> resEntryList = new ArrayList<DynamicObject>(entryList.size());
        DataEntityPropertyCollection propertyCollection = workSchedule.getDataEntityType().getProperties();
        EntryProp entryProp = (EntryProp)propertyCollection.get((Object)"wtbd_workscheduleentry");
        EntryType entryType = (EntryType)entryProp.getItemType();
        for (WorkScheduleNewEntry newEntry : entryList) {
            DynamicObject entryObject = new DynamicObject((DynamicObjectType)entryType);
            entryObject.set("workdate", (Object)newEntry.getWorkDate());
            entryObject.set("datetype", (Object)newEntry.getDateTypeId());
            entryObject.set("oridatetype", (Object)newEntry.getOriDateTypeId());
            entryObject.set("datepropertyid", (Object)newEntry.getDatePropertyId());
            entryObject.set("oridatepropertyid", (Object)newEntry.getOriDatePropertyId());
            entryObject.set("etimezoneid", (Object)newEntry.getEtimezoneid());
            entryObject.set("shiftid", (Object)newEntry.getShiftId());
            entryObject.set("holidayid", (Object)newEntry.getHolidayId());
            entryObject.set("weekday", (Object)newEntry.getWeekDay());
            entryObject.set("selfset", (Object)0);
            entryObject.set("ecreatorid", (Object)workSchedule.getLong("creator"));
            entryObject.set("ecreatetime", (Object)workSchedule.getDate("createtime"));
            resEntryList.add(entryObject);
        }
        return resEntryList;
    }

    private Map<String, String> newErrorMap(DynamicObject dynamicObject, String message) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("number", dynamicObject.getString("number"));
        map.put("name", dynamicObject.getString("name"));
        map.put("message", message);
        return map;
    }
}

