/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.hp.HpHolidayCalculateService;
import kd.wtc.wtbd.business.workschedule.WorkScheduleViewService;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BatchWorkScheduleHpConflictEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final HpHolidayCalculateService HP_HOLIDAY_CALCULATE_SERVICE = new HpHolidayCalculateService();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        if (evt.getChangeSet() == null || evt.getChangeSet().length <= 0) {
            return;
        }
        switch (name) {
            case "shiftmode": 
            case "basedate": 
            case "holidayportfolios": {
                this.judgeSingleRowConflict(evt.getChangeSet()[0].getRowIndex());
                break;
            }
            case "genstarttime": 
            case "genendtime": 
            case "calendarmodel": {
                this.judgeAllRowConflict();
                break;
            }
        }
    }

    private void judgeAllRowConflict() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList workSchHpParams = Lists.newArrayListWithCapacity((int)entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            workSchHpParams.add(WorkScheduleViewService.getInstance().genWorkSchHolidayParam(dataEntity, dynamicObject));
        }
        Map conflictHolidayAllMap = HP_HOLIDAY_CALCULATE_SERVICE.getConflictedSortedHoliday(workSchHpParams.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        for (int i = 0; i < workSchHpParams.size(); ++i) {
            Map conflictHolidayMap = null;
            WorkSchHolidayParam workSchHolidayParam = (WorkSchHolidayParam)workSchHpParams.get(i);
            if (workSchHolidayParam != null) {
                conflictHolidayMap = (Map)conflictHolidayAllMap.get(workSchHolidayParam);
            }
            this.judgeConflict(i, conflictHolidayMap);
        }
    }

    private void judgeSingleRowConflict(int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Map conflictHolidayMap = null;
        WorkSchHolidayParam workSchHolidayParam = WorkScheduleViewService.getInstance().genWorkSchHolidayParam(dataEntity, (DynamicObject)entryEntity.get(rowIndex));
        if (workSchHolidayParam != null) {
            Map conflictHolidayAllMap = HP_HOLIDAY_CALCULATE_SERVICE.getConflictedSortedHoliday(Collections.singletonList(workSchHolidayParam));
            conflictHolidayMap = (Map)conflictHolidayAllMap.get(workSchHolidayParam);
        }
        this.judgeConflict(rowIndex, conflictHolidayMap);
    }

    private void judgeConflict(int rowIndex, Map<Date, List<Long>> conflictHolidayMap) {
        boolean isConflict;
        boolean bl = isConflict = conflictHolidayMap != null && !conflictHolidayMap.isEmpty();
        if (isConflict) {
            this.getModel().setValue("revisesource", (Object)SerializationUtils.serializeToBase64(conflictHolidayMap), rowIndex);
            this.getModel().setValue("revisedata", null, rowIndex);
        }
        String opText = isConflict ? WorkSchKDString.getReviseOpText() : "";
        this.getModel().setValue("reviseop", (Object)opText, rowIndex);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("reviseop".equals(fieldName)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "wtbd_workschhprevise" + rowIndex);
            String conflictDateMapStr = ((DynamicObject)entryEntity.get(rowIndex)).getString("revisesource");
            String reviseDataStr = ((DynamicObject)entryEntity.get(rowIndex)).getString("revisedata");
            String shiftModeId = ((DynamicObject)entryEntity.get(rowIndex)).getString("shiftmode.id");
            Date baseDate = ((DynamicObject)entryEntity.get(rowIndex)).getDate("basedate");
            Date startDate = dataEntity.getDate("genstarttime");
            Date endDate = dataEntity.getDate("genendtime");
            WorkScheduleViewService.getInstance().showReviseView(baseDate, startDate, endDate, shiftModeId, conflictDateMapStr, this.getView(), closeCallBack, reviseDataStr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("wtbd_workschhprevise") && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            int rowIndex = Integer.parseInt(actionId.replace("wtbd_workschhprevise", ""));
            this.getModel().setValue("revisedata", (Object)SerializationUtils.serializeToBase64((Object)returnData), rowIndex);
        }
    }
}

