/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class CalendarModelEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final int MAX_WEEK_OF_YEAR = 52;
    private static final int MAX_DAY_OF_YEAR = 366;
    private static final int DAYS_OF_WEEK = 7;
    private static final int DEFAULT_WEEK_COUNT = 1;
    private static final int DEFAULT_DAY_COUNT = 7;
    private static final int MINIMUM_LOOP_FACTOR = 1;

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("holidaycombine".equals(name)) {
            QFilter isCurrentVersion = WTCHisServiceHelper.isCurrentVersion((boolean)true);
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(isCurrentVersion));
        } else if ("dateprop".equals(name)) {
            QFilter datePropQFilter = new QFilter("id", "in", Arrays.asList(DateAttribute.WORKDAY.getId(), DateAttribute.OFFDAY.getId()));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(datePropQFilter));
        }
    }

    public void registerListener(EventObject object) {
        super.registerListener(object);
        BasedataEdit control = (BasedataEdit)this.getView().getControl("holidaycombine");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataProp = (BasedataEdit)this.getControl("dateprop");
        dataProp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private boolean isEditMode() {
        return !WTCHisService.isLock((IFormView)this.getView());
    }

    private void initCustomControlIfNecessary(boolean resetCusCtrl) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String workDaySetMode = dataEntity.getString("wrokdaysetmode");
        if (!"B".equals(workDaySetMode)) {
            return;
        }
        int loopFactor = dataEntity.getInt("loopfactor");
        String loopMode = dataEntity.getString("loopmode");
        int cellCount = loopMode.equals("A") ? 7 * loopFactor : loopFactor;
        int argsType = 0;
        int argsRows = cellCount / 7 + (cellCount % 7 > 0 ? 1 : 0);
        int argsCols = 7;
        int argsStartIndex = 0;
        int argsEndIndex = cellCount - 1;
        String argsMode = loopMode.equals("A") ? "w" : "d";
        boolean argsLock = !this.isEditMode();
        int[] argsCells = this.getCells(cellCount, resetCusCtrl);
        int[] argsSelectedCells = new int[1];
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        args.put("type", argsType);
        args.put("rows", argsRows);
        args.put("cols", argsCols);
        args.put("startindex", argsStartIndex);
        args.put("endindex", argsEndIndex);
        args.put("mode", argsMode);
        args.put("lock", argsLock);
        args.put("cells", argsCells);
        args.put("selectedCells", argsSelectedCells);
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "init");
        returnData.put("args", args);
        this.setCustomCtrlReturnData(returnData);
    }

    private int[] getCells(int cellCount, boolean resetCusCtrl) {
        int[] cells = null;
        if (cellCount <= 0) {
            return new int[0];
        }
        cells = new int[cellCount];
        cells[0] = 1;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isWeek = "A".equals(dataEntity.getString("loopmode"));
        if (isWeek) {
            int offset;
            int count = cellCount / 7;
            for (int times = 0; times < count; ++times) {
                offset = times * 7;
                cells[offset] = 1;
                cells[offset + 1] = 1;
                cells[offset + 2] = 1;
                cells[offset + 3] = 1;
                cells[offset + 4] = 1;
            }
            int end = Math.min(offset + 5, cellCount);
            for (offset = times * 7; offset < end; ++offset) {
                cells[offset] = 1;
            }
        }
        if (resetCusCtrl) {
            this.getModel().setValue("cycperiodtxt", null);
            return cells;
        }
        String cusCtrlValue = dataEntity.getString("cycperiodtxt");
        if (HRStringUtils.isEmpty((String)cusCtrlValue)) {
            return cells;
        }
        String[] split = cusCtrlValue.split(",");
        if (split.length == cellCount) {
            for (int i = 0; i < cellCount; ++i) {
                cells[i] = Integer.parseInt(split[i]);
            }
        }
        return cells;
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.triggerWorkDaySetModeChange(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "wrokdaysetmode": {
                this.triggerWorkDaySetModeChange(true);
                break;
            }
            case "loopmode": {
                this.triggerLoopModeChange();
            }
            case "loopfactor": {
                this.triggerLoopFactorChange();
                break;
            }
        }
    }

    private void triggerLoopModeChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String loopMode = dataEntity.getString("loopmode");
        String workDaySetMode = dataEntity.getString("wrokdaysetmode");
        if (HRStringUtils.isEmpty((String)loopMode)) {
            return;
        }
        if ("B".equals(workDaySetMode) && this.isEditMode()) {
            if (loopMode.equals("A")) {
                this.getModel().setValue("loopfactor", (Object)1);
            } else {
                this.getModel().setValue("loopfactor", (Object)7);
            }
        }
        this.initCustomControlIfNecessary(true);
    }

    private void triggerLoopFactorChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String loopMode = dataEntity.getString("loopmode");
        int loopFactor = dataEntity.getInt("loopfactor");
        if (HRStringUtils.isEmpty((String)loopMode)) {
            return;
        }
        if (loopMode.equals("A") && this.isEditMode()) {
            if (loopFactor > 52) {
                this.getModel().setValue("loopfactor", (Object)52);
                return;
            }
            if (loopFactor < 1) {
                this.getModel().setValue("loopfactor", (Object)1);
                return;
            }
        }
        if (loopMode.equals("B") && this.isEditMode()) {
            if (loopFactor > 366) {
                this.getModel().setValue("loopfactor", (Object)366);
                return;
            }
            if (loopFactor < 1) {
                this.getModel().setValue("loopfactor", (Object)1);
                return;
            }
        }
        this.initCustomControlIfNecessary(true);
    }

    private void triggerWorkDaySetModeChange(boolean resetCusCtrl) {
        String workDaySetMode;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (workDaySetMode = dataEntity.getString("wrokdaysetmode")) {
            case "A": {
                this.setLoopModeAndFactorEnable(false);
                this.setFieldsVisible(false, "cuscycleflex", "fieldgrouppanelap");
                this.setFieldsVisible(true, "flexpanelap");
                break;
            }
            case "B": {
                this.setWeekLabelDefaultValue();
                this.setFieldsVisible(false, "flexpanelap");
                this.setFieldsVisible(true, "cuscycleflex", "fieldgrouppanelap");
                this.setLoopModeAndFactorEnable(true);
                this.initCustomControlIfNecessary(resetCusCtrl);
                break;
            }
        }
    }

    private void setWeekLabelDefaultValue() {
        if (this.isEditMode()) {
            this.getModel().setValue("mon", (Object)Boolean.TRUE);
            this.getModel().setValue("tue", (Object)Boolean.TRUE);
            this.getModel().setValue("wed", (Object)Boolean.TRUE);
            this.getModel().setValue("thurs", (Object)Boolean.TRUE);
            this.getModel().setValue("fri", (Object)Boolean.TRUE);
            this.getModel().setValue("sat", (Object)Boolean.FALSE);
            this.getModel().setValue("sun", (Object)Boolean.FALSE);
        }
    }

    private void setLoopModeAndFactorEnable(boolean flag) {
        if (!flag && this.isEditMode()) {
            this.getModel().setValue("loopmode", (Object)"A");
            this.getModel().setValue("loopfactor", (Object)1);
            this.getModel().setValue("cycperiodtxt", null);
        }
        this.setFieldsMustInput(flag, "loopmode", "loopfactor");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operateKey;
        super.beforeItemClick(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey = evt.getOperationKey()) {
            case "pullupwindows": {
                this.pullUpNewSpecRuleWindows();
                return;
            }
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                String isSyn = this.getPageCache().get("IS_SYN");
                if (isSyn == null && "B".equals(dataEntity.getString("wrokdaysetmode"))) {
                    this.sendSynDataEvent(operateKey);
                    evt.setCancel(true);
                    return;
                }
                boolean validate = this.validate();
                if (!validate) break;
                evt.setCancel(validate);
                break;
            }
        }
    }

    private boolean validate() {
        if (!this.isLegalWorkDaySetMode4Week()) {
            this.getPageCache().remove("IS_SYN");
            return true;
        }
        if (!this.isLegalWorkDaySetMode4Cus()) {
            this.getPageCache().remove("IS_SYN");
            return true;
        }
        if (!this.isLegalSpecialDayEntry()) {
            this.getPageCache().remove("IS_SYN");
            return true;
        }
        return false;
    }

    private boolean isLegalSpecialDayEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection exEntry = dataEntity.getDynamicObjectCollection("exentryentity");
        if (!exEntry.isEmpty()) {
            Date floorDate = WorkScheduleHelper.getFloorDate((long)WTCOrgUnitServiceHelper.getHRDefaultRootOrgId());
            TreeMap treeMap = Maps.newTreeMap();
            int size = 0;
            for (DynamicObject entry : exEntry) {
                Date startDate = entry.getDate("startdate");
                Date endDate = entry.getDate("enddate");
                if (startDate == null || endDate == null) continue;
                if (floorDate != null && startDate.before(floorDate)) {
                    String msg = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6700\u65e9\u5141\u8bb8\u53d8\u66f4\u7684\u65e5\u671f%s\u3002", (String)"WorkSyncEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)floorDate)});
                    this.getView().showErrorNotification(msg);
                    return false;
                }
                if (startDate.compareTo(endDate) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalendarModelEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    return false;
                }
                treeMap.put(startDate.getTime(), endDate.getTime());
                ++size;
            }
            if (!this.validateTimeCross(treeMap, size)) {
                this.getView().showErrorNotification(WorkSchKDString.getTimePeriodCrossErrTip());
                return false;
            }
        }
        return true;
    }

    private boolean validateTimeCross(TreeMap<Long, Long> timePairs, int size) {
        if (size != timePairs.size()) {
            return false;
        }
        long lastEndTime = 0L;
        for (Map.Entry<Long, Long> pair : timePairs.entrySet()) {
            if (pair.getKey() <= lastEndTime) {
                return false;
            }
            lastEndTime = pair.getValue();
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.triggerWorkDaySetModeChange(false);
    }

    private boolean isLegalWorkDaySetMode4Cus() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!"B".equals(dataEntity.getString("wrokdaysetmode"))) {
            return true;
        }
        String cusCtrlVal = dataEntity.getString("cycperiodtxt");
        boolean isLegal = cusCtrlVal.contains("1");
        if (!isLegal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8bbe\u7f6e\uff1a\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u5929\u4f5c\u4e3a\u5de5\u4f5c\u65e5\u3002", (String)"CalendarModelEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        return isLegal;
    }

    private boolean isLegalWorkDaySetMode4Week() {
        boolean isLegal;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!"A".equals(dataEntity.getString("wrokdaysetmode"))) {
            return true;
        }
        boolean weekMon = dataEntity.getBoolean("mon");
        boolean weekTue = dataEntity.getBoolean("tue");
        boolean weekWed = dataEntity.getBoolean("wed");
        boolean weekThu = dataEntity.getBoolean("thurs");
        boolean weekFri = dataEntity.getBoolean("fri");
        boolean weekSat = dataEntity.getBoolean("sat");
        boolean weekSun = dataEntity.getBoolean("sun");
        boolean bl = isLegal = weekMon || weekTue || weekWed || weekThu || weekFri || weekSat || weekSun;
        if (!isLegal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8bbe\u7f6e\uff1a\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u5929\u4f5c\u4e3a\u5de5\u4f5c\u65e5\u3002", (String)"CalendarModelEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        return isLegal;
    }

    public void customEvent(CustomEventArgs eventArgs) {
        super.customEvent(eventArgs);
        String args = eventArgs.getEventArgs();
        String eventName = eventArgs.getEventName();
        if ("getData".equals(eventName)) {
            JSONObject jsonObj = (JSONObject)JSONObject.parse((String)args);
            String data = jsonObj.getString("data").replaceAll("\\[", "").replaceAll("]", "");
            this.getModel().setValue("cycperiodtxt", (Object)data);
            String operateKey = jsonObj.get((Object)"opType").toString();
            if (HRStringUtils.isEmpty((String)operateKey)) {
                return;
            }
            this.getPageCache().put("IS_SYN", "IS_SYN");
            if (!this.validate()) {
                this.getView().invokeOperation(operateKey);
            }
            return;
        }
        if ("delete".equals(eventName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CalendarModelEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        if ("unselected".equals(eventName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u5355\u5143\u683c\u3002", (String)"CalendarModelEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        if ("workdaySeted".equals(eventName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u5143\u683c\u5df2\u662f\u5de5\u4f5c\u65e5\u3002", (String)"CalendarModelEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void sendSynDataEvent(String opType) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "getData");
        returnData.put("args", opType);
        returnData.put("nanoTime", System.nanoTime());
        this.setCustomCtrlReturnData(returnData);
    }

    private void setCustomCtrlReturnData(Map<String, Object> returnData) {
        CustomControl control = (CustomControl)this.getView().getControl("cusctrl");
        control.setData(returnData);
    }

    private void pullUpNewSpecRuleWindows() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtbd_newspecrule");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("700px");
        cssValue.setHeight("400px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(style);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection exEntry = this.getModel().getEntryEntity("exentryentity");
        formShowParameter.setCustomParam("exentryentity", (Object)exEntry);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "newentry".equals(actionId)) {
            Map map = (Map)returnData;
            DynamicObject nsrDateProperty = (DynamicObject)map.get("dateproperty");
            DynamicObject nsrDateType = (DynamicObject)map.get("datetype");
            DynamicObjectCollection nsrEntry = (DynamicObjectCollection)map.get("entryentity");
            for (DynamicObject row : nsrEntry) {
                int rowIdx = this.getModel().createNewEntryRow("exentryentity");
                this.getModel().setValue("startdate", (Object)row.getDate("startdate"), rowIdx);
                this.getModel().setValue("enddate", (Object)row.getDate("enddate"), rowIdx);
                this.getModel().setValue("dateprop", (Object)nsrDateProperty, rowIdx);
                this.getModel().setValue("datetype", (Object)nsrDateType, rowIdx);
            }
        }
    }

    private void setFieldsVisible(boolean flag, String ... fieldNames) {
        this.getView().setVisible(Boolean.valueOf(flag), fieldNames);
    }

    private void setFieldsMustInput(boolean flag, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            ((FieldEdit)this.getControl(fieldName)).setMustInput(flag);
        }
    }
}

