/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbd.fromplugin.web.workschedule.WorkCalComEdit;
import kd.wtc.wtbd.fromplugin.web.workschedule.WorkSyncEdit;
import kd.wtc.wtbs.business.workschedule.datetypeadj.DateTypeAdjService;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class ChangeModelEdit
extends WorkCalComEdit
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(WorkSyncEdit.class);
    private static final HRBaseServiceHelper CHANGE_RECORD_HELPER = new HRBaseServiceHelper("wtbd_calchangerecord");
    private static final HRBaseServiceHelper CALENDAR_MODEL_HELPER = new HRBaseServiceHelper("wtbd_calendarmodel");
    private static final String WORK_SCH_FIELDS = "id,name,number,createorg.name,createorg.id,description,floorgendate,ceilinggendate,calendarmodel.name,calendarmodel.id";

    public void registerListener(EventObject even) {
        super.registerListener(even);
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl("workschedule");
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject even) {
        super.beforeBindData(even);
        this.fillData();
    }

    private void fillData() {
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)cusMap.get("ids");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        DynamicObject[] dys = this.workScheduleHelper.query(WORK_SCH_FIELDS, new QFilter[]{new QFilter("id", "in", (Object)ids)});
        int size = dys.length;
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (size != 1 || rowCount != 1) {
            this.getModel().batchCreateNewEntryRow("entryentity", Math.max(size - 1, 1));
        }
        for (int i = size - 1; i >= 0; --i) {
            this.getModel().setValue("workschedule", (Object)dys[i], i);
        }
        String orgStr = (String)cusMap.get("org");
        if (HRStringUtils.isNotEmpty((String)orgStr)) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgStr));
        }
    }

    public void afterBindData(EventObject even) {
        super.afterBindData(even);
        this.operateTips(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("closetips".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
        } else if ("againtips".equals(operateKey)) {
            this.operateTips(false);
        } else if ("save".equals(operateKey)) {
            if (!this.afterCheck()) {
                return;
            }
            HashMap cusMap = Maps.newHashMap();
            cusMap.put("confirmsync", "PAGE_CALL_BACK_FROM_CHANGEMODAL");
            this.toConfirmForm((Map)cusMap);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("save".equals(source.getOperateKey()) && !this.saveCheck()) {
            args.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection dynamicObjects;
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (HRStringUtils.equals((String)beforeF7SelectEvent.getProperty().getName(), (String)"workschedule") && !CollectionUtils.isEmpty((Collection)(dynamicObjects = this.getModel().getEntryEntity("entryentity")))) {
            List ids = dynamicObjects.stream().map(dy -> dy.getLong("workschedule.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "not in", ids);
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && this.saveCheck()) {
            try {
                this.toConfirmOperate();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"ChangeModelEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\u3002", (String)"ChangeModelEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        }
    }

    private void toConfirmOperate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject newCalModel = dataEntity.getDynamicObject("calendarmodel");
        List<Long> workScheduleIds = this.getModel().getEntryEntity("entryentity").stream().filter(dy -> null != dy.getDynamicObject("workschedule")).map(dy -> dy.getDynamicObject("workschedule").getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> changeRecordList = new ArrayList<DynamicObject>(workScheduleIds.size());
        ArrayList<DynamicObject> updateEntry = new ArrayList<DynamicObject>(100);
        ArrayList<DynamicObject> updateWorkSchedule = new ArrayList<DynamicObject>(workScheduleIds.size());
        Map<Long, List<DynamicObject>> oldEntryMap = this.queryEntryOldList(workScheduleIds);
        Map<Long, DynamicObject> workScheduleMap = this.getWorkSchedule(workScheduleIds);
        Set adjIdSet = workScheduleMap.values().stream().map(dy -> dy.getLong("shiftmode.datetypeadj.id")).collect(Collectors.toSet());
        Map dateTypeAdjMap = DateTypeAdjService.getInstance().getDateTypeAdjMap(adjIdSet);
        for (Long workScheduleId : workScheduleIds) {
            DynamicObject workSchedule = workScheduleMap.get(workScheduleId);
            DynamicObject oldCalModel = workSchedule.getDynamicObject("calendarmodel");
            workSchedule.set("calendarmodel", (Object)newCalModel);
            workSchedule.set("calendarmodelfid", (Object)newCalModel.getLong("sourcevid"));
            List<WorkScheduleNewEntry> newEntryList = this.getNewEntry(workSchedule, this.getDateInfo(workSchedule, true));
            List<DynamicObject> oldEntryList = oldEntryMap.get(workScheduleId);
            oldEntryList.sort(Comparator.comparing(dy -> dy.getDate("workdate")));
            long dateTypeAdjId = workSchedule.getLong("shiftmode.datetypeadj.id");
            DateTypeAdj dateTypeAdj = (DateTypeAdj)dateTypeAdjMap.get(dateTypeAdjId);
            for (int i = 0; i < newEntryList.size(); ++i) {
                WorkScheduleNewEntry newEntry = newEntryList.get(i);
                DynamicObject oldEntry = oldEntryList.get(i);
                newEntry.setShiftId(oldEntry.getLong("shiftid"));
            }
            Date genStartTime = workSchedule.getDate("floorgendate");
            Date genEndTime = workSchedule.getDate("ceilinggendate");
            WorkScheduleHelper.adjWorkScheduleEntry(newEntryList, (Date)genStartTime, (Date)genEndTime, (DateTypeAdj)dateTypeAdj);
            long userId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            for (int i = 0; i < newEntryList.size(); ++i) {
                WorkScheduleNewEntry newEntry = newEntryList.get(i);
                DynamicObject oldEntry = oldEntryList.get(i);
                if (newEntry.getWorkDate().getTime() != oldEntry.getDate("workdate").getTime()) {
                    log.error("\u53d8\u66f4\u65e5\u5386\u751f\u6210\u89c4\u5219\uff0c\u65e5\u671f\u4e0d\u5339\u914d newDat = {} ; oldDate = {}", (Object)newEntry.getWorkDate(), (Object)oldEntry.getDate("workdate"));
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u5339\u914d\u3002", (String)"ChangeModelEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                }
                boolean holidayEqual = this.holidayEqual(newEntry, oldEntry);
                long datePropertyId = oldEntry.getLong("datepropertyid.id");
                boolean datePropertyEq = this.longEqual(newEntry.getDatePropertyId(), datePropertyId);
                long dateTypeId = oldEntry.getLong("datetype.id");
                boolean dateTypeEq = this.longEqual(newEntry.getDateTypeId(), dateTypeId);
                long oriDatePropertyId = oldEntry.getLong("oridatepropertyid.id");
                boolean oriDatePropertyEq = this.longEqual(newEntry.getOriDatePropertyId(), oriDatePropertyId);
                long oriDateTypeId = oldEntry.getLong("oridatetype.id");
                boolean oriDateTypeEq = this.longEqual(newEntry.getOriDateTypeId(), oriDateTypeId);
                if (!datePropertyEq && !oriDatePropertyEq && !dateTypeEq && !oriDateTypeEq && !holidayEqual) continue;
                oldEntry.set("datepropertyid", (Object)newEntry.getDatePropertyId());
                oldEntry.set("oridatepropertyid", (Object)newEntry.getOriDatePropertyId());
                oldEntry.set("datetype", (Object)newEntry.getDateTypeId());
                oldEntry.set("oridatetype", (Object)newEntry.getOriDateTypeId());
                oldEntry.set("holidayid", (Object)(newEntry.getHolidayId() == null ? " " : newEntry.getHolidayId()));
                updateEntry.add(oldEntry);
            }
            changeRecordList.add(this.getChangeRecord(newCalModel, now, userId, workSchedule, oldCalModel));
            updateWorkSchedule.add(workSchedule);
        }
        this.toSave(changeRecordList, updateEntry, updateWorkSchedule);
    }

    private void toSave(List<DynamicObject> changeRecordList, List<DynamicObject> updateEntryList, List<DynamicObject> updateWorkSchedule) {
        try (TXHandle txHandle = TX.required();){
            this.workScheduleHelper.update(updateWorkSchedule.toArray(new DynamicObject[0]));
            this.workScheduleEntryHelper.update(updateEntryList.toArray(new DynamicObject[0]));
            CHANGE_RECORD_HELPER.save(changeRecordList.toArray(new DynamicObject[0]));
        }
    }

    private boolean afterCheck() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        DynamicObject nullWorkSchedule = entry.stream().filter(dy -> null == dy.getDynamicObject("workschedule")).findFirst().orElse(null);
        return nullWorkSchedule == null;
    }

    private boolean saveCheck() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long calModelId = dataEntity.getLong("calendarmodel.id");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u5de5\u4f5c\u65e5\u7a0b\u8868\u4e2d\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u884c\u6570\u636e", (String)"ChangeModelEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (entry.size() == 1 && null == ((DynamicObject)entry.get(0)).getDynamicObject("workschedule")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u5de5\u4f5c\u65e5\u7a0b\u8868\u4e2d\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u884c\u6570\u636e", (String)"ChangeModelEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject find = entry.stream().filter(dy -> null != dy.getDynamicObject("workschedule") && calModelId == dy.getDynamicObject("workschedule").getLong("calendarmodel.id")).findFirst().orElse(null);
        if (null != find) {
            String msg = ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7684\u65e5\u5386\u751f\u6210\u89c4\u5219\u4e0e\u201c%s\u201d\u65e5\u5386\u751f\u6210\u89c4\u5219\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ChangeModelEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{find.getDynamicObject("workschedule").getString("name")});
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    @Override
    public void initTipOperate() {
    }

    private Map<Long, List<DynamicObject>> queryEntryOldList(List<Long> workScheduleIds) {
        QFilter qFilter = new QFilter("fid", "in", workScheduleIds);
        DynamicObject[] entryList = this.workScheduleEntryHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Arrays.stream(entryList).collect(Collectors.groupingBy(dy -> dy.getLong("fid")));
    }

    private DynamicObject getChangeRecord(DynamicObject newCalModel, Date now, long userId, DynamicObject workSchedule, DynamicObject oldCalModel) {
        DynamicObject changeRecord = CHANGE_RECORD_HELPER.generateEmptyDynamicObject();
        changeRecord.set("workschedule", (Object)workSchedule.getLong("id"));
        changeRecord.set("name", (Object)workSchedule.getString("name"));
        changeRecord.set("number", (Object)workSchedule.getString("number"));
        changeRecord.set("createorg", (Object)workSchedule.getDynamicObject("createorg"));
        changeRecord.set("precalrmodel", (Object)oldCalModel.getLong("id"));
        DynamicObject preCalModel = CALENDAR_MODEL_HELPER.generateEmptyDynamicObject();
        preCalModel.set("id", (Object)oldCalModel.getLong("sourcevid"));
        changeRecord.set("precalmodelfid", (Object)preCalModel);
        changeRecord.set("precalname", (Object)oldCalModel.getString("name"));
        changeRecord.set("aftercalrmodel", (Object)newCalModel.getLong("id"));
        DynamicObject afterCalModel = CALENDAR_MODEL_HELPER.generateEmptyDynamicObject();
        afterCalModel.set("id", (Object)newCalModel.getLong("sourcevid"));
        changeRecord.set("aftercalrmodelfid", (Object)afterCalModel);
        changeRecord.set("aftercalname", (Object)newCalModel.getString("name"));
        changeRecord.set("createtime", (Object)now);
        changeRecord.set("modifytime", (Object)now);
        changeRecord.set("creator", (Object)userId);
        changeRecord.set("modifier", (Object)userId);
        return changeRecord;
    }
}

