/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.business.workschedule.WorkScheduleViewService;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;

public class EditGenConditionEdit
extends HRDataBaseEdit {
    private static final String OP_KEY = "opkey";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        for (IDataEntityProperty prop : dataEntityType.getAllFields().values()) {
            BasedataEdit basedataEdit;
            if (!(prop instanceof IBasedataField) || (basedataEdit = (BasedataEdit)this.getControl(prop.getName())) == null || this.getView().getParentView() == null) continue;
            basedataEdit.addBeforeF7SelectListener(f7Evt -> ((ListShowParameter)f7Evt.getFormShowParameter()).setUseOrgId(this.getView().getParentView().getModel().getDataEntity().getLong("createorg.id")));
        }
    }

    public void beforeBindData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("shiftmode", customParams.get("shiftmode"));
        this.getModel().setValue("calendarmodel", customParams.get("calendarmodel"));
        JSONArray idJsonArr = (JSONArray)customParams.get("holidayportfolios");
        Object[] pkArr = new Object[idJsonArr.size()];
        for (int i = 0; i < idJsonArr.size(); ++i) {
            pkArr[i] = idJsonArr.get(i);
        }
        this.getModel().setValue("holidayportfolios", (Object)pkArr);
        this.getModel().setValue("basedate", customParams.get("basedate"));
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String key;
        switch (key = propertyChangedArgs.getProperty().getName()) {
            case "basedate": 
            case "genstarttime": 
            case "genendtime": {
                if (!this.isLegalBaseDateAndGenStartTime(true)) {
                    return;
                }
                this.isLegalGenScope(true);
                break;
            }
        }
    }

    protected boolean isContinuousGenDate() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String floorDateStr = (String)customParams.get("floorgendate");
        String ceilingDateStr = (String)customParams.get("ceilinggendate");
        Date floorGenDate = WTCDateUtils.str2Date((String)floorDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        Date ceilingGenDate = WTCDateUtils.str2Date((String)ceilingDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        if (floorGenDate == null && ceilingGenDate == null) {
            return true;
        }
        Date oldFloorGenDate = floorGenDate;
        Date oldCeilingGenDate = ceilingGenDate;
        floorGenDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getZeroDate((Date)floorGenDate), (long)-1L);
        ceilingGenDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getZeroDate((Date)ceilingGenDate), (long)1L);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date genStartTime = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("genstarttime"));
        Date genEndTime = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("genendtime"));
        if (genEndTime.getTime() < floorGenDate.getTime() || genStartTime.getTime() > ceilingGenDate.getTime()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb/\u7ed3\u675f\u65e5\u671f\u533a\u95f4\u4e0e\u5f53\u524d\u65e5\u7a0b\uff08%1$s~%2$s\uff09\u9700\u8981\u8fde\u7eed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"EditGenConditionEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)oldFloorGenDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)oldCeilingGenDate)));
            return false;
        }
        return true;
    }

    protected boolean isLegalBaseDateAndGenStartTime(boolean isValidIfLackDate) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date baseDate = dataEntity.getDate("basedate");
        Date genStartTime = dataEntity.getDate("genstarttime");
        if (baseDate == null || genStartTime == null) {
            return isValidIfLackDate;
        }
        if (baseDate.getTime() > genStartTime.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u57fa\u51c6\u65e5\u671f\u3002", (String)"EditGenConditionEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean isLegalGenScope(boolean isValidIfLackDate) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date genStartTime = dataEntity.getDate("genstarttime");
        Date genEndTime = dataEntity.getDate("genendtime");
        if (genStartTime == null || genEndTime == null) {
            return isValidIfLackDate;
        }
        if (genStartTime.getTime() > genEndTime.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3002", (String)"EditGenConditionEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject mainDataEntity = parentView.getModel().getDataEntity();
        Date floorGenDate = parentView.getModel().getDataEntity().getDate("floorgendate");
        Date ceilGenDate = parentView.getModel().getDataEntity().getDate("ceilinggendate");
        floorGenDate = floorGenDate == null ? genStartTime : WTCDateUtils.getMinDate((Date)floorGenDate, (Date)genStartTime);
        ceilGenDate = ceilGenDate == null ? genEndTime : WTCDateUtils.getMaxDate((Date)ceilGenDate, (Date)genEndTime);
        int workSchLengthLimit = WorkScheduleHelper.getWorkSchLengthLimit();
        return !WorkScheduleViewService.getInstance().validateMaxRange(mainDataEntity, workSchLengthLimit, floorGenDate, ceilGenDate, this.getView());
    }

    protected boolean isExistShiftMode() {
        return this.getModel().getDataEntity().getDynamicObject("shiftmode") != null;
    }

    protected boolean isExistCalendarModel() {
        return this.getModel().getDataEntity().getDynamicObject("calendarmodel") != null;
    }

    private boolean isExistBaseDate() {
        return this.getModel().getDataEntity().getDate("basedate") != null;
    }

    private boolean isExistGenStartDate() {
        return this.getModel().getDataEntity().getDate("genstarttime") != null;
    }

    private boolean isExistGenEndDate() {
        return this.getModel().getDataEntity().getDate("genstarttime") != null;
    }

    protected boolean isLegalGenCondition() {
        boolean isLegal = true;
        ArrayList<String> list = new ArrayList<String>(6);
        if (!this.isExistShiftMode()) {
            list.add(ResManager.loadKDString((String)"\u8f6e\u73ed\u89c4\u5219", (String)"EditGenConditionEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            isLegal = false;
        }
        if (!this.isExistCalendarModel()) {
            list.add(ResManager.loadKDString((String)"\u65e5\u5386\u751f\u6210\u89c4\u5219", (String)"EditGenConditionEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            isLegal = false;
        }
        if (!this.isExistBaseDate()) {
            list.add(ResManager.loadKDString((String)"\u57fa\u51c6\u65e5\u671f", (String)"EditGenConditionEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            isLegal = false;
        }
        if (!this.isExistGenStartDate()) {
            list.add(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f", (String)"EditGenConditionEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            isLegal = false;
        }
        if (!this.isExistGenEndDate()) {
            list.add(ResManager.loadKDString((String)"\u751f\u6210\u7ed3\u675f\u65e5\u671f", (String)"EditGenConditionEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            isLegal = false;
        }
        if (!isLegal) {
            String join = String.join((CharSequence)"\u3001", list);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u540e\uff0c\u518d\u6b21\u70b9\u51fb\u9884\u89c8\u6309\u94ae\u3002", (String)"EditGenConditionEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{join}));
            return false;
        }
        return this.isLegalBaseDateAndGenStartTime(false) && this.isLegalGenScope(false) && this.isContinuousGenDate();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey = ((FormOperate)event.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            event.setCancel(true);
            this.getPageCache().put(OP_KEY, "returnData");
            this.getView().invokeOperation("close");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String opkey = pageCache.get(OP_KEY);
        if (!"returnData".equals(opkey)) {
            return;
        }
        pageCache.remove(OP_KEY);
        if (!this.isLegalGenCondition()) {
            evt.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("shiftmode", dataEntity.getLong("shiftmode.id"));
        returnData.put("calendarmodel", dataEntity.getLong("calendarmodel.id"));
        List holidayProIds = dataEntity.getDynamicObjectCollection("holidayportfolios").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
        returnData.put("holidayportfolios", holidayProIds);
        returnData.put("basedate", dataEntity.getDate("basedate"));
        returnData.put("genstarttime", dataEntity.getDate("genstarttime"));
        returnData.put("genendtime", dataEntity.getDate("genendtime"));
        returnData.put("coverexist", dataEntity.getBoolean("coverexist"));
        view.returnDataToParent(returnData);
        view.sendFormAction(parentView);
    }
}

