/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.fromplugin.web.workschedule.WorkScheduleEdit;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class EditableCalendarEdit
extends HRDataBaseEdit {
    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        this.getModel().setValue("showmonth", parentView.getModel().getValue("showmonth"));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key = evt.getProperty().getName();
        if (key.equals("showmonth")) {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            if (parentView == null) {
                return;
            }
            parentView.getModel().setValue("showmonth", this.getModel().getValue("showmonth"));
            view.sendFormAction(parentView);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "premonth": {
                this.setShowMonth2PreMonthIfExist();
                args.setCancel(true);
                break;
            }
            case "nextmonth": {
                this.setShowMonth2NextMonthIfExist();
                args.setCancel(true);
                break;
            }
        }
    }

    private void setShowMonth2PreMonthIfExist() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date showMonth = dataEntity.getDate("showmonth");
        if (showMonth == null) {
            return;
        }
        Date curMonthFirstDate = WorkScheduleEdit.getMonthStartDayZeroTime(showMonth);
        Date preMonthFirstDate = WTCDateUtils.add((Date)curMonthFirstDate, (int)2, (int)-1);
        this.setShowMonth(preMonthFirstDate);
    }

    private void setShowMonth2NextMonthIfExist() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date showMonth = dataEntity.getDate("showmonth");
        if (showMonth == null) {
            return;
        }
        Date curMonthFirstDate = WorkScheduleEdit.getMonthStartDayZeroTime(showMonth);
        Date preMonthFirstDate = WTCDateUtils.add((Date)curMonthFirstDate, (int)2, (int)1);
        this.setShowMonth(preMonthFirstDate);
    }

    private void setShowMonth(Date showMonth) {
        this.getModel().setValue("showmonth", (Object)showMonth);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getProperty("showmonth").getOrdinal(), false);
    }
}

