/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.fromplugin.web.workschedule.WorkCalComList;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RelWorkScheduleList
extends WorkCalComList {
    public void setFilter(SetFilterEvent filter) {
        filter.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("syncplanroster".equals(source.getOperateKey())) {
            if (this.getSelectedRows() != null && this.getSelectedRows().size() != 1) {
                args.setCancel(true);
                this.getView().showTipNotification(MessageFormat.format(WTCBaseKDString.getOnlySelectOneTip(), source.getOperateName().getLocaleValue()));
                return;
            }
            List workSchIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            List attFileIdsOfWsIds = WorkScheduleHelper.getAttFileIdsOfWsIds(workSchIds, null, null);
            if (WTCCollections.isEmpty((Collection)attFileIdsOfWsIds)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5de5\u4f5c\u65e5\u7a0b\u8868\u672a\u88ab\u8003\u52e4\u6863\u6848\u5173\u8054\uff0c\u65e0\u6cd5\u6267\u884c\u540c\u6b65\u8ba1\u5212\u6392\u73ed\u3002", (String)"RelWorkScheduleList_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (("sync".equals(operateKey) || "change".equals(operateKey) || "records".equals(operateKey) || "syncplanroster".equals(operateKey)) && args.getOperationResult().isSuccess()) {
            this.toCusForm(operateKey);
        }
    }

    private void toCusForm(String operateKey) {
        List ids = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        HashMap cusMap = Maps.newHashMap();
        cusMap.put("ids", ids);
        cusMap.put("org", this.getPageCache().get("createOrg"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams((Map)cusMap);
        if ("sync".equals(operateKey)) {
            formShowParameter.setFormId("wtbd_relworkschedulesync");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "PAGE_CALL_BACK_FROM_SYNCMODAL"));
        } else if ("change".equals(operateKey)) {
            formShowParameter.setFormId("wtbd_changemodel");
            StyleCss style = new StyleCss();
            style.setHeight("90%");
            style.setWidth("90%");
            formShowParameter.getOpenStyle().setInlineStyleCss(style);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "PAGE_CALL_BACK_FROM_CHANGEMODAL"));
        } else if ("records".equals(operateKey)) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("wtbd_calmodrecord");
        } else if ("syncplanroster".equals(operateKey)) {
            cusMap.put("ids", SerializationUtils.serializeToBase64(ids));
            formShowParameter.setFormId("wts_schsyncroster");
        }
        this.getView().showForm(formShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"calendarmodel_name", (CharSequence)args.getFieldName())) {
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Long id = (Long)billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
            args.setCancel(true);
            HRBaseServiceHelper workScheduleHelper = new HRBaseServiceHelper("wtbd_workschedule");
            String fields = "id,name,number,calendarmodel.name,calendarmodel.id,calendarmodelfid";
            DynamicObject workSchedule = workScheduleHelper.queryOne(fields, new QFilter[]{new QFilter("id", "in", (Object)id)});
            this.toCalModel(workSchedule.getLong("calendarmodel.id"), ShowType.MainNewTabPage, workSchedule.getLong("calendarmodelfid"));
        } else if (StringUtils.equals((CharSequence)"number", (CharSequence)args.getFieldName())) {
            args.setCancel(true);
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Long id = (Long)billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
            this.toWorkSchedule(id, ShowType.MainNewTabPage);
        }
    }
}

