/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.fromplugin.web.workschedule.CalModelParamEdit;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class SpecRuleWindowsEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_KEY = "opkey";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit control = (BasedataEdit)this.getView().getControl("datetype");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit controlDP = (BasedataEdit)this.getView().getControl("dateproperty");
        controlDP.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("datetype".equals(name)) {
            QFilter enable = new QFilter("enable", "!=", (Object)"0");
            QFilter workOrRelaxDate = new QFilter("dateproperty.number", "in", Arrays.asList("DS-0001", "DS-0002"));
            beforeF7SelectEvent.setCustomQFilters(Arrays.asList(workOrRelaxDate, enable));
        } else if ("dateproperty".equals(name)) {
            QFilter enable = new QFilter("enable", "!=", (Object)"0");
            QFilter workOrRelaxDate = new QFilter("number", "in", Arrays.asList("DS-0001", "DS-0002"));
            beforeF7SelectEvent.setCustomQFilters(Arrays.asList(workOrRelaxDate, enable));
        }
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.triggerSetModeChange();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangeArgs) {
        String propName;
        switch (propName = propertyChangeArgs.getProperty().getName()) {
            case "setmode": {
                this.triggerSetModeChange();
                break;
            }
            case "startdate": 
            case "enddate": {
                if (this.hasOutOfRange()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u4fee\u6539%s\u4e4b\u540e\u7684\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{CalModelParamEdit.getFloorDateStr()}));
                    return;
                }
                if (this.hasOutOfOrder()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.hasIntersection()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u65f6\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SpecRuleWindowsEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void triggerSetModeChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String setMode = dataEntity.getString("setmode");
        if ("A".equals(setMode)) {
            this.setFieldsEnabled(false, "datetype");
            this.setFieldsEnabled(true, "dateproperty");
        } else {
            this.setFieldsEnabled(true, "datetype");
            this.setFieldsEnabled(false, "dateproperty");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        String operateKey = ((FormOperate)event.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            event.setCancel(true);
            this.getPageCache().put(OP_KEY, "returnData");
            this.getView().invokeOperation("close");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String opkey = pageCache.get(OP_KEY);
        if (!"returnData".equals(opkey)) {
            return;
        }
        pageCache.remove(OP_KEY);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String setMode = dataEntity.getString("setmode");
        DynamicObject dateProperty = dataEntity.getDynamicObject("dateproperty");
        DynamicObject dateType = dataEntity.getDynamicObject("datetype");
        if (dateProperty == null && "A".equals(setMode)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u5c5e\u6027\u3002", (String)"SpecRuleWindowsEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (dateType == null && "B".equals(setMode)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u7c7b\u578b\u3002", (String)"SpecRuleWindowsEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        dateProperty = dateType != null && "B".equals(setMode) ? dateType.getDynamicObject("dateproperty") : dateProperty;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u3002", (String)"SpecRuleWindowsEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        for (DynamicObject row : entryEntity) {
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            if (startDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (endDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            startDate = WTCDateUtils.getZeroDate((Date)startDate);
            endDate = WTCDateUtils.getDayLastDate((Date)endDate);
            if (startDate.getTime() < endDate.getTime()) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.hasIntersection()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u65f6\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SpecRuleWindowsEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.hasOutOfRange()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u4fee\u6539%s\u4e4b\u540e\u7684\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\u3002", (String)"SpecRuleWindowsEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{CalModelParamEdit.getFloorDateStr()}));
            evt.setCancel(true);
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("dateproperty", dateProperty);
        returnData.put("datetype", dateType);
        returnData.put("entryentity", entryEntity);
        view.returnDataToParent(returnData);
        view.sendFormAction(parentView);
    }

    private boolean hasOutOfRange() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        long floor = CalModelParamEdit.getFloorDate().getTime();
        for (DynamicObject row : entryEntity) {
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            if (startDate != null && WTCDateUtils.getZeroDate((Date)startDate).getTime() < floor) {
                return true;
            }
            if (endDate == null || WTCDateUtils.getDayLastDate((Date)endDate).getTime() >= floor) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutOfOrder() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entryEntity) {
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            if (startDate == null || endDate == null) continue;
            startDate = WTCDateUtils.getZeroDate((Date)startDate);
            endDate = WTCDateUtils.getDayLastDate((Date)endDate);
            if (startDate.getTime() < endDate.getTime()) continue;
            return true;
        }
        return false;
    }

    private boolean hasIntersection() {
        JSONArray exEntry = (JSONArray)this.getView().getFormShowParameter().getCustomParam("exentryentity");
        ArrayList<Section> exSection = new ArrayList<Section>(exEntry.size());
        for (int i = 0; i < exEntry.size(); ++i) {
            JSONObject jsonObject = exEntry.getJSONObject(i);
            long start = WTCDateUtils.getZeroDate((Date)jsonObject.getDate("startdate")).getTime();
            long end = WTCDateUtils.getDayLastDate((Date)jsonObject.getDate("enddate")).getTime();
            exSection.add(new Section(start, end));
        }
        List sectionList = this.getModel().getEntryEntity("entryentity").stream().map(row -> {
            Date startDate = row.getDate("startdate");
            Date endDate = row.getDate("enddate");
            if (startDate == null || endDate == null) {
                return null;
            }
            startDate = WTCDateUtils.getZeroDate((Date)startDate);
            endDate = WTCDateUtils.getDayLastDate((Date)endDate);
            return new Section(startDate.getTime(), endDate.getTime());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        sectionList.addAll(exSection);
        int validRow = sectionList.size();
        sectionList.sort(Comparator.comparingLong(Section::getBegin));
        for (int idx = 0; idx < sectionList.size(); ++idx) {
            Section firstSection = (Section)sectionList.get(idx);
            long start = firstSection.getBegin();
            long end = firstSection.getEnd();
            int canReachIdx = idx;
            int wantReachIdx = canReachIdx + 1;
            while (wantReachIdx < sectionList.size()) {
                Section tempSection = (Section)sectionList.get(wantReachIdx);
                long tempStart = tempSection.getBegin();
                long tempEnd = tempSection.getEnd();
                if (end <= tempStart) break;
                end = Math.max(end, tempEnd);
                canReachIdx = wantReachIdx++;
            }
            Section newSection = new Section(start, end);
            for (int tempIdx = canReachIdx; tempIdx >= idx; --tempIdx) {
                sectionList.remove(tempIdx);
            }
            sectionList.add(idx, newSection);
        }
        return validRow != sectionList.size();
    }

    private void setFieldsEnabled(boolean flag, String ... fieldNames) {
        if (!flag) {
            this.cleanFieldValueIfExist(fieldNames);
        }
        this.setFieldsMustInput(flag, fieldNames);
        this.setFieldsVisible(flag, fieldNames);
    }

    private void setFieldsVisible(boolean flag, String ... fieldNames) {
        this.getView().setVisible(Boolean.valueOf(flag), fieldNames);
    }

    private void setFieldsMustInput(boolean flag, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            ((FieldEdit)this.getControl(fieldName)).setMustInput(flag);
        }
    }

    private void cleanFieldValueIfExist(String ... fieldNames) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String fieldName : fieldNames) {
            if (HRStringUtils.isEmpty((String)dataEntity.getString(fieldName))) continue;
            this.getModel().setValue(fieldName, null);
        }
    }

    private static class Section {
        long begin;
        long end;

        Section(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

