/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleEntryGenParam;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;

abstract class WorkCalComEdit
extends HRDataBaseEdit {
    public HRBaseServiceHelper workScheduleHelper = new HRBaseServiceHelper("wtbd_workschedule");
    public HRBaseServiceHelper workScheduleEntryHelper = new HRBaseServiceHelper("wtbd_workscheduleentryq");
    public static List<String> WORK_SCHEDULE_FILE = Arrays.asList("id", "name", "floorgendate", "createorg", "ceilinggendate", "shiftmode", "calendarmodel", "holidayportfolios", "basedate", "timezoneid", "calendarmodelfid");

    WorkCalComEdit() {
    }

    protected void operateTips(boolean operate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_useroperate");
        long userId = RequestContext.get().getCurrUserId();
        if (operate) {
            QFilter page = new QFilter("pagenum", "=", (Object)this.getModel().getDataEntityType().getName());
            QFilter operateType = new QFilter("operatetype", "=", (Object)"1");
            QFilter user = new QFilter("creator", "=", (Object)userId);
            DynamicObject dy = serviceHelper.queryOne(new QFilter[]{page, operateType, user});
            if (null != dy) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
                this.initTipOperate();
            }
        } else {
            DynamicObject save = serviceHelper.generateEmptyDynamicObject();
            save.set("pagenum", (Object)this.getModel().getDataEntityType().getName());
            save.set("operatetype", (Object)"1");
            save.set("creator", (Object)userId);
            serviceHelper.save(new DynamicObject[]{save});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
            this.initTipOperate();
        }
    }

    public void toConfirmForm(Map<String, Object> cusMap) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u5df2\u9009\u7684\u65e5\u5386\u751f\u6210\u89c4\u5219\u5c06\u66ff\u6362\u5f53\u524d\u5de5\u4f5c\u65e5\u7a0b\u8868\u4e2d\u7684\u65e5\u5386\u751f\u6210\u89c4\u5219\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"WorkCalComEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMTIPS", (IFormPlugin)this));
    }

    public abstract void initTipOperate();

    protected Map<Long, DynamicObject> getWorkSchedule(List<Long> ids) {
        HRBaseServiceHelper workScheduleServiceHelper = new HRBaseServiceHelper("wtbd_workschedule");
        String properties = String.join((CharSequence)",", WORK_SCHEDULE_FILE);
        DynamicObject[] workSchedule = workScheduleServiceHelper.query(properties, new QFilter[]{new QFilter("id", "in", ids)});
        return Arrays.stream(workSchedule).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }

    protected Map<String, Date> getDateInfo(DynamicObject workSchedule, boolean syncAll) {
        HashMap<String, Date> map = new HashMap<String, Date>(10);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date baseDate = workSchedule.getDate("basedate");
        map.put("basedate", baseDate);
        if (syncAll) {
            map.put("floorgendate", workSchedule.getDate("floorgendate"));
            map.put("ceilinggendate", workSchedule.getDate("ceilinggendate"));
        } else {
            map.put("floorgendate", dataEntity.getDate("startdate"));
            map.put("ceilinggendate", dataEntity.getDate("enddate"));
        }
        return map;
    }

    protected List<WorkScheduleNewEntry> getNewEntry(DynamicObject workSchedule, Map<String, Date> dateInfo) {
        Date baseDate = dateInfo.get("basedate");
        Date genStartTime = dateInfo.get("floorgendate");
        Date genEndTime = dateInfo.get("ceilinggendate");
        long timezoneId = workSchedule.getLong("timezoneid.id");
        long calendarModelId = workSchedule.getLong("calendarmodel.id");
        long shiftModeId = workSchedule.getLong("shiftmode.id");
        List holidayPortfolioIdList = workSchedule.getDynamicObjectCollection("holidayportfolios").stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
        WorkScheduleEntryGenParam param = new WorkScheduleEntryGenParam(baseDate, genStartTime, genEndTime, timezoneId, calendarModelId, shiftModeId, holidayPortfolioIdList);
        return WorkScheduleHelper.genWorkSchedule((WorkScheduleEntryGenParam)param);
    }

    protected boolean holidayEqual(WorkScheduleNewEntry newEntry, DynamicObject oldEntry) {
        String oldHoliday;
        String newHoliday = newEntry.getHolidayId();
        if (HRStringUtils.equals((String)newHoliday, (String)(oldHoliday = oldEntry.getString("holidayid")))) {
            return false;
        }
        if (HRStringUtils.isEmpty((String)newHoliday) && HRStringUtils.isNotEmpty((String)oldHoliday)) {
            return true;
        }
        if (HRStringUtils.isNotEmpty((String)newHoliday) && HRStringUtils.isEmpty((String)oldHoliday)) {
            return true;
        }
        List<String> newHolidayList = Arrays.asList(newHoliday.split(","));
        List<String> oldHolidayList = Arrays.asList(oldEntry.getString("holidayid").split(","));
        for (String holiday : newHolidayList) {
            if (oldHolidayList.contains(holiday)) continue;
            return true;
        }
        return false;
    }

    protected boolean longEqual(long one, long two) {
        return one != two;
    }
}

