/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ai.util.JsonUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.business.workschedule.WorkScheduleViewService;
import kd.wtc.wtbd.common.entity.workschedule.TableSelectedIndexes;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleEntryGenParam;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntryVo;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleVo;
import kd.wtc.wtbd.fromplugin.util.WorkScheduleFormHelper;
import kd.wtc.wtbs.business.workschedule.datetypeadj.DateTypeAdjService;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WorkScheduleEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(WorkScheduleEdit.class);
    private static final String CACHE_SHIFT_EDIT_INFO = "CACHE_SHIFT_EDIT_INFO";
    private static final String DATE_PATTERN_YYYYMM = "yyyy-MM";
    private static final Set<String> NOCHECKCHANGEDFIELDS = Sets.newHashSetWithExpectedSize((int)3);

    private boolean isNewMode() {
        return OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus();
    }

    private boolean isEditMode() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        evt.getFormShowParameter().setCustomParam("checkRightAppId", (Object)"wtp");
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String key;
        switch (key = propertyChangedArgs.getProperty().getName()) {
            case "timezoneid": {
                if (!this.isExistTimeZone()) break;
                this.closeFieldNullErrorTip("timezoneid");
                break;
            }
            case "shiftmode": {
                if (!this.isExistShiftMode()) break;
                this.closeFieldNullErrorTip("shiftmode");
                break;
            }
            case "calendarmodel": {
                if (!this.isExistCalendarModel()) break;
                this.closeFieldNullErrorTip("calendarmodel");
                break;
            }
            case "basedate": 
            case "genstarttime": 
            case "genendtime": {
                if (this.isExistBaseDate()) {
                    this.closeFieldNullErrorTip("basedate");
                }
                if (this.isExistGenStartDate()) {
                    this.closeFieldNullErrorTip("genstarttime");
                }
                if (this.isExistGenEndDate()) {
                    this.closeFieldNullErrorTip("genendtime");
                }
                if (!this.isLegalBaseDateAndGenStartTime(true)) {
                    return;
                }
                this.isLegalGenScope(true);
                break;
            }
            case "showmonth": {
                this.cusCtrlShowPage("set");
                break;
            }
        }
        this.validateShiftDatesOnPropertyChanged(key);
    }

    private boolean isContinuousGenDate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date floorGenDate = dataEntity.getDate("floorgendate");
        Date ceilingGenDate = dataEntity.getDate("ceilinggendate");
        if (floorGenDate == null && ceilingGenDate == null) {
            return true;
        }
        floorGenDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getZeroDate((Date)floorGenDate), (long)-1L);
        ceilingGenDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getZeroDate((Date)ceilingGenDate), (long)1L);
        Date genStartTime = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("genstarttime"));
        Date genEndTime = WTCDateUtils.getZeroDate((Date)dataEntity.getDate("genendtime"));
        if (genEndTime.getTime() < floorGenDate.getTime() || genStartTime.getTime() > ceilingGenDate.getTime()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb/\u7ed3\u675f\u65e5\u671f\u533a\u95f4\u4e0e\u5f53\u524d\u65e5\u7a0b\uff08%1$s~%2$s\uff09\u9700\u8981\u8fde\u7eed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"WorkScheduleEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)floorGenDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)ceilingGenDate)));
            return false;
        }
        return true;
    }

    private boolean isLegalBaseDateAndGenStartTime(boolean isValidIfLackDate) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date baseDate = dataEntity.getDate("basedate");
        Date genStartTime = dataEntity.getDate("genstarttime");
        if (baseDate == null || genStartTime == null) {
            return isValidIfLackDate;
        }
        if (baseDate.getTime() > genStartTime.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u57fa\u51c6\u65e5\u671f\u3002", (String)"WorkScheduleEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isLegalGenScope(boolean isValidIfLackDate) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date genStartTime = dataEntity.getDate("genstarttime");
        Date genEndTime = dataEntity.getDate("genendtime");
        if (genStartTime == null || genEndTime == null) {
            return isValidIfLackDate;
        }
        if (genStartTime.getTime() > genEndTime.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkScheduleEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        int workSchLengthLimit = WorkScheduleHelper.getWorkSchLengthLimit();
        Date floorGenDate = dataEntity.getDate("floorgendate");
        Date ceilGenDate = dataEntity.getDate("ceilinggendate");
        floorGenDate = floorGenDate == null ? genStartTime : WTCDateUtils.getMinDate((Date)floorGenDate, (Date)genStartTime);
        Date date = ceilGenDate = ceilGenDate == null ? genEndTime : WTCDateUtils.getMaxDate((Date)ceilGenDate, (Date)genEndTime);
        return !WorkScheduleViewService.getInstance().validateMaxRange(dataEntity, workSchLengthLimit, floorGenDate, ceilGenDate, this.getView());
    }

    private boolean isExistTimeZone() {
        return this.getModel().getDataEntity().getDynamicObject("timezoneid") != null;
    }

    private boolean isExistShiftMode() {
        return this.getModel().getDataEntity().getDynamicObject("shiftmode") != null;
    }

    private boolean isExistCalendarModel() {
        return this.getModel().getDataEntity().getDynamicObject("calendarmodel") != null;
    }

    private boolean isExistBaseDate() {
        return this.getModel().getDataEntity().getDate("basedate") != null;
    }

    private boolean isExistGenStartDate() {
        return this.getModel().getDataEntity().getDate("genstarttime") != null;
    }

    private boolean isExistGenEndDate() {
        return this.getModel().getDataEntity().getDate("genendtime") != null;
    }

    private boolean isLegalGenCondition(boolean printTips) {
        boolean isLegal = true;
        ArrayList<String> list = new ArrayList<String>(6);
        ArrayList<String> keyList = new ArrayList<String>(6);
        if (!this.isExistTimeZone()) {
            list.add(ResManager.loadKDString((String)"\u201c\u5730\u533a/\u65f6\u533a\u201d", (String)"WorkScheduleEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("timezoneid");
            isLegal = false;
        }
        if (!this.isExistShiftMode()) {
            list.add(ResManager.loadKDString((String)"\u201c\u8f6e\u73ed\u89c4\u5219\u201d", (String)"WorkScheduleEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("shiftmode");
            isLegal = false;
        }
        if (!this.isExistCalendarModel()) {
            list.add(ResManager.loadKDString((String)"\u201c\u65e5\u5386\u751f\u6210\u89c4\u5219\u201d", (String)"WorkScheduleEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("calendarmodel");
            isLegal = false;
        }
        if (!this.isExistBaseDate()) {
            list.add(ResManager.loadKDString((String)"\u201c\u57fa\u51c6\u65e5\u671f\u201d", (String)"WorkScheduleEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("basedate");
            isLegal = false;
        }
        if (!this.isExistGenStartDate()) {
            list.add(ResManager.loadKDString((String)"\u201c\u751f\u6210\u5f00\u59cb\u65e5\u671f\u201d", (String)"WorkScheduleEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("genstarttime");
            isLegal = false;
        }
        if (!this.isExistGenEndDate()) {
            list.add(ResManager.loadKDString((String)"\u201c\u751f\u6210\u7ed3\u675f\u65e5\u671f\u201d", (String)"WorkScheduleEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            keyList.add("genstarttime");
            isLegal = false;
        }
        if (!isLegal) {
            String join = String.join((CharSequence)"\u3001", list);
            if (printTips) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u540e\uff0c\u518d\u6b21\u70b9\u51fb\u9884\u89c8\u6309\u94ae\u3002", (String)"WorkScheduleEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{join}));
            } else {
                this.openFieldNullErrorTip(keyList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"WorkScheduleEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{join}));
            }
            return false;
        }
        return this.isLegalBaseDateAndGenStartTime(false) && this.isLegalGenScope(false) && this.isContinuousGenDate();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "addduty": {
                String workSchEntry = this.getPageCache().get("cache_wtbd_workscheduleentry");
                if (HRStringUtils.isEmpty((String)workSchEntry)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9884\u89c8\u518d\u751f\u6210\u65e5\u7a0b\u8868\u3002", (String)"WorkScheduleEdit_12", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String haveSelect = this.getPageCache().get("ws_selected_cells_data");
                if (!StringUtils.isBlank((CharSequence)haveSelect)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"WorkScheduleEdit_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "save": 
            case "submit": 
            case "submitandaudit": {
                this.beforeSaveOp(args);
                break;
            }
            case "gen": {
                if (!this.isLegalGenCondition(true)) break;
                this.doGen();
                this.updatePreviewFloorGenDateAndCeilingGenDate();
                this.initShowMonthAfterGen();
                break;
            }
        }
    }

    private void beforeSaveOp(BeforeDoOperationEventArgs args) {
        if (!this.isLegalGenCondition(false)) {
            args.setCancel(true);
            return;
        }
        this.doGen();
        this.updateFloorGenDateAndCeilingGenDate();
        List<WorkScheduleNewEntryVo> voList = WorkScheduleFormHelper.batchConvert2VoList(this.getNewestEffectStaticObjectEntry());
        if (!this.validateShiftDates(voList)) {
            args.setCancel(true);
            return;
        }
        if (!this.validateShiftOverlap(voList)) {
            args.setCancel(true);
            return;
        }
        this.synchronizeNestEntryToPage();
        this.getPageCache().remove("cache_wtbd_workscheduleentry");
        if (this.getPageEntryStaticObjectEntry().isEmpty()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u751f\u6210\u6570\u636e\u3002", (String)"WorkScheduleEdit_14", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void doGen() {
        List<WorkScheduleNewEntry> newEntries = this.genWorkSchedule();
        if (this.isNewMode()) {
            this.clearAndResetEntryEntity(newEntries, true);
        } else {
            List<WorkScheduleNewEntry> lastStoreStaticObjectEntry = this.getLastStoreStaticObjectEntry();
            this.clearAndResetEntryEntity(lastStoreStaticObjectEntry, false);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String appendMode = dataEntity.getString("appendmode");
            if ("B".equals(appendMode)) {
                this.appendNotExistEntryEntity(newEntries);
            } else if ("C".equals(appendMode)) {
                this.appendAndReplaceEntryEntity(newEntries);
            } else {
                this.appendAndReplaceEntryEntity(newEntries);
            }
        }
        this.attachShiftEditInfo2EntryEntity();
    }

    private void attachShiftEditInfo2EntryEntity() {
        Set<ShiftEditInfo> newestShiftEditInfo = this.getNewestShiftEditInfo();
        if (newestShiftEditInfo.isEmpty()) {
            return;
        }
        HashMap<String, ShiftEditInfo> changeMap = new HashMap<String, ShiftEditInfo>(newestShiftEditInfo.size());
        for (ShiftEditInfo shiftEditInfo : newestShiftEditInfo) {
            changeMap.put(shiftEditInfo.getDateStr(), shiftEditInfo);
        }
        LinkedList needAdjDateTypeEntries = Lists.newLinkedList();
        List<WorkScheduleNewEntry> newestEffectStaticObjectEntry = this.getNewestEffectStaticObjectEntry();
        for (WorkScheduleNewEntry entry : newestEffectStaticObjectEntry) {
            String workDateStr = entry.getWorkDateStr();
            ShiftEditInfo shiftEditInfo = (ShiftEditInfo)changeMap.get(workDateStr);
            if (shiftEditInfo == null) continue;
            entry.setShiftId(shiftEditInfo.getShiftId());
            entry.setEmodifierid(shiftEditInfo.getEmodifierid());
            entry.setEmodifiername(shiftEditInfo.getEmodifiername());
            entry.setEmodifytime(shiftEditInfo.getEmodifytime());
            needAdjDateTypeEntries.add(entry);
        }
        this.adjustDateType(needAdjDateTypeEntries, false);
        this.setNewestEffectStaticObjectEntry(newestEffectStaticObjectEntry);
    }

    private void initShowMonthAfterGen() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date floorGenDate = this.getExactFloorGenDate();
        Date ceilingGenDate = this.getExactCeilingGenDate();
        Date showMonth = dataEntity.getDate("showmonth");
        if (floorGenDate == null || ceilingGenDate == null) {
            this.setShowMonth(null);
            return;
        }
        if (showMonth == null) {
            this.setShowMonth(floorGenDate);
            return;
        }
        Date monthStartDayZeroTime = WorkScheduleEdit.getMonthStartDayZeroTime(showMonth);
        Date monthEndDayLastTime = WorkScheduleEdit.getMonthEndDayLastTime(showMonth);
        if (WTCDateUtils.getZeroDate((Date)floorGenDate).getTime() > monthEndDayLastTime.getTime() || WTCDateUtils.getDayLastDate((Date)ceilingGenDate).getTime() < monthStartDayZeroTime.getTime()) {
            this.setShowMonth(floorGenDate);
            return;
        }
        this.cusCtrlShowPage("set");
    }

    private void updateFloorGenDateAndCeilingGenDate() {
        List<WorkScheduleNewEntry> list = this.getNewestEffectStaticObjectEntry();
        if (list.isEmpty()) {
            return;
        }
        Date floorGenDate = list.get(0).getWorkDate();
        Date ceilingGenDate = list.get(list.size() - 1).getWorkDate();
        this.getModel().setValue("floorgendate", (Object)floorGenDate);
        this.getModel().setValue("ceilinggendate", (Object)ceilingGenDate);
        this.getModel().setValue("calendarmodelfid", (Object)this.getModel().getDataEntity().getLong("calendarmodel.sourcevid"));
        this.showYearMonthDayRangeLabelIfNecessary();
    }

    private void updatePreviewFloorGenDateAndCeilingGenDate() {
        List<WorkScheduleNewEntry> list = this.getNewestEffectStaticObjectEntry();
        if (list.isEmpty()) {
            return;
        }
        this.getModel().setValue("previewfloorgendate", (Object)list.get(0).getWorkDate());
        this.getModel().setValue("previewceilinggendate", (Object)list.get(list.size() - 1).getWorkDate());
        this.showYearMonthDayRangeLabelIfNecessary();
    }

    private void clearAndResetEntryEntity(List<WorkScheduleNewEntry> newEntries, boolean isAdjDateType) {
        List<WorkScheduleNewEntry> newestEffectRows = this.getNewestEffectStaticObjectEntry();
        newestEffectRows.clear();
        newestEffectRows.addAll(newEntries);
        newestEffectRows.sort(Comparator.comparing(WorkScheduleNewEntry::getWorkDateStr));
        if (isAdjDateType) {
            this.adjustDateType(newestEffectRows, true);
        }
        this.setNewestEffectStaticObjectEntry(newestEffectRows);
    }

    private void appendAndReplaceEntryEntity(List<WorkScheduleNewEntry> newEntries) {
        this.doAppendEntryEntity(newEntries, true);
    }

    private void appendNotExistEntryEntity(List<WorkScheduleNewEntry> newEntries) {
        this.doAppendEntryEntity(newEntries, false);
    }

    private void doAppendEntryEntity(List<WorkScheduleNewEntry> newEntries, boolean replaceExistEntry) {
        List<WorkScheduleNewEntry> newestEffectRows = this.getNewestEffectStaticObjectEntry();
        if (newestEffectRows.isEmpty()) {
            newestEffectRows.addAll(newEntries);
            this.setNewestEffectStaticObjectEntry(newestEffectRows);
            return;
        }
        LinkedList needAdjWorkScheduleEntries = Lists.newLinkedList();
        if (replaceExistEntry) {
            Map<String, WorkScheduleNewEntry> helpMap = newEntries.stream().collect(Collectors.toMap(WorkScheduleNewEntry::getWorkDateStr, entry -> entry));
            newestEffectRows.removeIf(next -> {
                String workDateStr = next.getWorkDateStr();
                WorkScheduleNewEntry workScheduleNewEntry = (WorkScheduleNewEntry)helpMap.get(workDateStr);
                if (workScheduleNewEntry != null) {
                    if (next.getEmodifierid() != 0L) {
                        next.setHolidayId(workScheduleNewEntry.getHolidayId());
                        next.setDatePropertyId(workScheduleNewEntry.getDatePropertyId());
                        next.setDateTypeId(workScheduleNewEntry.getDateTypeId());
                        next.setOriDatePropertyId(workScheduleNewEntry.getOriDatePropertyId());
                        next.setOriDateTypeId(workScheduleNewEntry.getOriDateTypeId());
                        needAdjWorkScheduleEntries.add(next);
                        helpMap.remove(workDateStr);
                        return false;
                    }
                    return true;
                }
                return false;
            });
            newEntries = new ArrayList<WorkScheduleNewEntry>(helpMap.values());
            needAdjWorkScheduleEntries.addAll(newEntries);
        } else {
            Set workDateStrSet = newestEffectRows.stream().map(WorkScheduleNewEntry::getWorkDateStr).collect(Collectors.toSet());
            newEntries.removeIf(next -> workDateStrSet.contains(next.getWorkDateStr()));
            needAdjWorkScheduleEntries.addAll(newEntries);
        }
        this.adjustDateType(needAdjWorkScheduleEntries, true);
        newestEffectRows.addAll(newEntries);
        newestEffectRows.sort(Comparator.comparing(WorkScheduleNewEntry::getWorkDateStr));
        this.setNewestEffectStaticObjectEntry(newestEffectRows);
    }

    private void synchronizeNestEntryToPage() {
        String totalEntryJsonStr = this.getPageCache().get("cache_wtbd_workscheduleentry");
        if (HRStringUtils.isEmpty((String)totalEntryJsonStr)) {
            return;
        }
        try {
            List totalEntry = (List)HRJSONUtils.cast((String)totalEntryJsonStr, List.class, (Class[])new Class[]{WorkScheduleNewEntry.class});
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("wtbd_workscheduleentry");
            model.beginInit();
            model.batchCreateNewEntryRow("wtbd_workscheduleentry", WorkScheduleEdit.batchCreateNewEntryRow(totalEntry));
            model.endInit();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "IO error"), new Object[0]);
        }
    }

    private void setNewestEffectStaticObjectEntry(List<WorkScheduleNewEntry> newestEntries) {
        try {
            HashSet dateSets = Sets.newHashSetWithExpectedSize((int)newestEntries.size());
            Iterator<WorkScheduleNewEntry> iterator = newestEntries.iterator();
            while (iterator.hasNext()) {
                WorkScheduleNewEntry next = iterator.next();
                if (dateSets.contains(next.getWorkDateStr())) {
                    iterator.remove();
                    continue;
                }
                dateSets.add(next.getWorkDateStr());
            }
            String totalEntryJsonStr = HRJSONUtils.toString(newestEntries);
            this.getPageCache().put("cache_wtbd_workscheduleentry", totalEntryJsonStr);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            String msg = ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\u3002", (String)"WorkScheduleEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
    }

    private List<WorkScheduleNewEntry> getNewestEffectStaticObjectEntry() {
        String totalEntryJsonStr = this.getPageCache().get("cache_wtbd_workscheduleentry");
        if (totalEntryJsonStr != null) {
            try {
                return (List)HRJSONUtils.cast((String)totalEntryJsonStr, List.class, (Class[])new Class[]{WorkScheduleNewEntry.class});
            }
            catch (IOException e) {
                this.getPageCache().remove("cache_wtbd_workscheduleentry");
                logger.error((Throwable)e);
                String msg = ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\u3002", (String)"WorkScheduleEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        List<WorkScheduleNewEntry> result = this.getLastStoreStaticObjectEntry();
        try {
            totalEntryJsonStr = HRJSONUtils.toString(result);
            this.getPageCache().put("cache_wtbd_workscheduleentry", totalEntryJsonStr);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            String msg = ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\u3002", (String)"WorkScheduleEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        return result;
    }

    private List<WorkScheduleNewEntry> getPageEntryStaticObjectEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("wtbd_workscheduleentry");
        return entryEntity.stream().filter(row -> row.getDate("workdate") != null).map(row -> {
            WorkScheduleNewEntry entry = new WorkScheduleNewEntry();
            entry.setWorkDate(row.getDate("workdate"));
            entry.setDateTypeId(row.getLong("datetype"));
            entry.setDatePropertyId(row.getLong("datepropertyid"));
            entry.setOriDateTypeId(row.getLong("oridatetype"));
            entry.setOriDatePropertyId(row.getLong("oridatepropertyid"));
            entry.setEtimezoneid(row.getLong("etimezoneid"));
            entry.setShiftId(row.getLong("shiftid"));
            entry.setHolidayId(row.getString("holidayid"));
            entry.setWeekDay(row.getInt("weekday"));
            entry.setSelfSet(row.getString("selfset"));
            entry.setEcreatetime(row.getDate("ecreatetime"));
            entry.setEcreatorid(row.getLong("ecreatorid"));
            entry.setEmodifytime(row.getDate("emodifytime"));
            entry.setEmodifierid(row.getLong("emodifierid"));
            entry.setEmodifiername(row.getString("emodifiername"));
            return entry;
        }).collect(Collectors.toList());
    }

    private List<WorkScheduleNewEntry> getLastStoreStaticObjectEntry() {
        return this.getPageEntryStaticObjectEntry();
    }

    public static TableValueSetter batchCreateNewEntryRow(List<WorkScheduleNewEntry> workScheduleEntryList) {
        TableValueSetter tableValueSetter = WorkScheduleEdit.getTableValueSetter("oridatetype", "datepropertyid");
        tableValueSetter.addField("emodifytime", new Object[0]);
        tableValueSetter.addField("emodifierid", new Object[0]);
        tableValueSetter.addField("emodifiername", new Object[0]);
        for (WorkScheduleNewEntry workScheduleEntry : workScheduleEntryList) {
            tableValueSetter.addRow(new Object[]{workScheduleEntry.getWorkDate(), workScheduleEntry.getDateTypeId(), workScheduleEntry.getOriDateTypeId(), workScheduleEntry.getDatePropertyId(), workScheduleEntry.getOriDatePropertyId(), workScheduleEntry.getEtimezoneid(), workScheduleEntry.getShiftId(), workScheduleEntry.getHolidayId(), workScheduleEntry.getWeekDay(), workScheduleEntry.getSelfSetStr(), workScheduleEntry.getEcreatetime(), workScheduleEntry.getEcreatorid(), workScheduleEntry.getEmodifytime(), workScheduleEntry.getEmodifierid(), workScheduleEntry.getEmodifiername()});
        }
        return tableValueSetter;
    }

    private static TableValueSetter getTableValueSetter(String fieldOriDateType, String fieldDatePropertyId) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("workdate", new Object[0]);
        tableValueSetter.addField("datetype", new Object[0]);
        tableValueSetter.addField(fieldOriDateType, new Object[0]);
        tableValueSetter.addField(fieldDatePropertyId, new Object[0]);
        tableValueSetter.addField("oridatepropertyid", new Object[0]);
        tableValueSetter.addField("etimezoneid", new Object[0]);
        tableValueSetter.addField("shiftid", new Object[0]);
        tableValueSetter.addField("holidayid", new Object[0]);
        tableValueSetter.addField("weekday", new Object[0]);
        tableValueSetter.addField("selfset", new Object[0]);
        tableValueSetter.addField("ecreatetime", new Object[0]);
        tableValueSetter.addField("ecreatorid", new Object[0]);
        return tableValueSetter;
    }

    private List<WorkScheduleNewEntry> genWorkSchedule() {
        if (!this.isLegalGenCondition(true)) {
            return Collections.EMPTY_LIST;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date baseDate = dataEntity.getDate("basedate");
        Date genStartTime = dataEntity.getDate("genstarttime");
        Date genEndTime = dataEntity.getDate("genendtime");
        long timezoneId = dataEntity.getLong("timezoneid.id");
        long calendarModelId = dataEntity.getLong("calendarmodel.id");
        long shiftModeId = dataEntity.getLong("shiftmode.id");
        List holidayPortfolioIdList = dataEntity.getDynamicObjectCollection("holidayportfolios").stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
        WorkScheduleEntryGenParam param = new WorkScheduleEntryGenParam(baseDate, genStartTime, genEndTime, timezoneId, calendarModelId, shiftModeId, holidayPortfolioIdList);
        String reviseDataStr = this.getPageCache().get("revisedata");
        if (HRStringUtils.isNotEmpty((String)reviseDataStr)) {
            Map dateListMap = (Map)SerializationUtils.deSerializeFromBase64((String)reviseDataStr);
            Map<Date, Long> dateTypeMap = dateListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Long)((List)entry.getValue()).get(1)));
            param.setConflictDateTypeMap(dateTypeMap);
        }
        return WorkScheduleHelper.genWorkSchedule((WorkScheduleEntryGenParam)param);
    }

    public void afterBindData(EventObject env) {
        this.cleanInvalidEntryRow();
        this.cusCtrlInit();
        this.initShowMonthFlex();
        this.showYearMonthDayRangeLabelIfNecessary();
        this.showEditGenConditionButtonIfNecessary();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Boolean parentBatch = null != parentView && "wtbd_batchworkschedule".equals(parentView.getFormShowParameter().getFormId());
        if (parentBatch.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"basesummary", "fs_baseinfo", "advconap", "bar_save", "bar_submit", "bar_modify", "bar_unsubmit", "bar_submitandaudit", "bar_disable", "bar_audit", "bar_unaudit"});
        }
        if (!(parentView instanceof ListView) || !this.getView().getEntityId().equals(((ListView)parentView).getListModel().getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        this.initBtnVisible(parentBatch);
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.getModel().setValue("previewfloorgendate", (Object)this.getModel().getDataEntity().getDate("floorgendate"));
        this.getModel().setValue("previewceilinggendate", (Object)this.getModel().getDataEntity().getDate("ceilinggendate"));
    }

    private void initBtnVisible(Boolean parentBatch) {
        Boolean isShowMod = "A".equals(this.getModel().getDataEntity().getString("status"));
        if (!parentBatch.booleanValue()) {
            this.getView().setVisible(isShowMod, new String[]{"bar_modify"});
        }
    }

    private void initShowMonthFlex() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wtbd_editableclandar");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap4");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showmonth"));
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getPageCache().put("showmonth", parameter.getPageId());
        this.getView().showForm(parameter);
    }

    private void setShowMonth(Date showMonth) {
        this.getModel().setValue("showmonth", (Object)showMonth);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getProperty("showmonth").getOrdinal(), false);
        String pageId = this.getPageCache().get("showmonth");
        if (pageId != null) {
            IFormView subView = this.getView().getView(pageId);
            subView.getModel().setValue("showmonth", (Object)showMonth);
            this.getView().sendFormAction(subView);
        }
    }

    private void cleanInvalidEntryRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("wtbd_workscheduleentry");
        if (entryEntity.size() > 0) {
            ArrayList<Integer> delRows = new ArrayList<Integer>();
            for (int i = entryEntity.size() - 1; i >= 0; --i) {
                Date date = ((DynamicObject)entryEntity.get(i)).getDate("workdate");
                if (date != null) continue;
                delRows.add(i);
            }
            if (delRows.isEmpty()) {
                return;
            }
            int[] delRow = new int[delRows.size()];
            this.getModel().deleteEntryRows("wtbd_workscheduleentry", delRow);
        }
    }

    private void showEditGenConditionButtonIfNecessary() {
        this.getView().setVisible(Boolean.valueOf(this.isEditMode()), new String[]{"editgencondition"});
    }

    private void showYearMonthDayRangeLabelIfNecessary() {
        Date floorGenDate = this.getModel().getDataEntity().getDate("previewfloorgendate");
        Date ceilingGenDate = this.getModel().getDataEntity().getDate("previewceilinggendate");
        if (floorGenDate != null && ceilingGenDate != null) {
            Label label = (Label)this.getView().getControl("createdrange");
            String startStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)floorGenDate);
            String endStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)ceilingGenDate);
            label.setText(startStr + " ~ " + endStr);
            this.getView().setVisible(Boolean.TRUE, new String[]{"yearmonth"});
        }
    }

    private void cusCtrlInit() {
        Date floorGenDate = this.getExactFloorGenDate();
        Date ceilingGenDate = this.getExactCeilingGenDate();
        if (floorGenDate == null || ceilingGenDate == null) {
            this.setCustomData("init", new WorkScheduleVo());
            return;
        }
        Date showMonth = new Date();
        Date monthStartDayZeroTime = WorkScheduleEdit.getMonthStartDayZeroTime(showMonth);
        Date monthEndDayLastTime = WorkScheduleEdit.getMonthEndDayLastTime(showMonth);
        if (WTCDateUtils.getZeroDate((Date)floorGenDate).getTime() > monthEndDayLastTime.getTime() || WTCDateUtils.getDayLastDate((Date)ceilingGenDate).getTime() < monthStartDayZeroTime.getTime()) {
            showMonth = floorGenDate;
        }
        this.setShowMonth(showMonth);
        this.cusCtrlShowPage("init");
    }

    private void cusCtrlShowPage(String eventStr) {
        List<WorkScheduleNewEntryVo> voList;
        Date floorGenDate = this.getExactFloorGenDate();
        Date ceilingGenDate = this.getExactCeilingGenDate();
        Date showMonth = this.getModel().getDataEntity().getDate("showmonth");
        if (showMonth == null || floorGenDate == null || ceilingGenDate == null) {
            return;
        }
        String yearMonthStr = WTCDateUtils.date2Str((Date)showMonth, (String)DATE_PATTERN_YYYYMM);
        Date monthStartDayZeroTime = WorkScheduleEdit.getMonthStartDayZeroTime(showMonth);
        Date monthEndDayLastTime = WorkScheduleEdit.getMonthEndDayLastTime(showMonth);
        if (WTCDateUtils.getZeroDate((Date)floorGenDate).getTime() > monthEndDayLastTime.getTime() || WTCDateUtils.getDayLastDate((Date)ceilingGenDate).getTime() < monthStartDayZeroTime.getTime()) {
            voList = this.getEmptyYearMonthDataVoList(showMonth);
        } else {
            List<WorkScheduleNewEntry> specYearMonthData = this.getSpecYearMonthData(showMonth, this.getNewestEffectStaticObjectEntry());
            voList = WorkScheduleFormHelper.batchConvert2VoList(specYearMonthData);
            voList.sort(Comparator.comparing(WorkScheduleNewEntryVo::getWorkDate));
        }
        this.setCustomData(eventStr, new WorkScheduleVo(yearMonthStr, voList));
    }

    private List<WorkScheduleNewEntryVo> getEmptyYearMonthDataVoList(Date yearMonth) {
        Date monthStartDayZeroTime = WorkScheduleEdit.getMonthStartDayZeroTime(yearMonth);
        Calendar cal = Calendar.getInstance();
        cal.setTime(yearMonth);
        int actualDay = cal.getActualMaximum(5);
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(actualDay);
        Date curDate = monthStartDayZeroTime;
        for (int i = 1; i <= actualDay; ++i) {
            WorkScheduleNewEntryVo vo = new WorkScheduleNewEntryVo(0, curDate);
            curDate = WTCDateUtils.addDays((Date)curDate, (int)1);
            result.add(vo);
        }
        return result;
    }

    private Date getExactFloorGenDate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date floorGenDate = dataEntity.getDate("previewfloorgendate");
        return floorGenDate == null ? dataEntity.getDate("floorgendate") : floorGenDate;
    }

    private Date getExactCeilingGenDate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date ceilingGenDate = dataEntity.getDate("previewceilinggendate");
        return ceilingGenDate == null ? dataEntity.getDate("ceilinggendate") : ceilingGenDate;
    }

    public static Date getMonthStartDayZeroTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return WTCDateUtils.getZeroDate((Date)cal.getTime());
    }

    private static Date getMonthEndDayLastTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return WTCDateUtils.getDayLastDate((Date)cal.getTime());
    }

    private void setCustomData(String eventName, WorkScheduleVo workScheduleVo) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        data.put("event", eventName);
        data.put("args", workScheduleVo);
        data.put("timestamp", System.currentTimeMillis());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("wscalendar");
        customcontrol.setData(data);
    }

    private List<WorkScheduleNewEntry> getSpecYearMonthData(Date yearMonth, List<WorkScheduleNewEntry> entries) {
        String yearMonthStr = WTCDateUtils.date2Str((Date)yearMonth, (String)DATE_PATTERN_YYYYMM);
        return entries.stream().filter(entry -> yearMonthStr.equals(WTCDateUtils.date2Str((Date)entry.getWorkDate(), (String)DATE_PATTERN_YYYYMM))).collect(Collectors.toList());
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String eventName;
        if ("wscalendar".equals(customEventArgs.getKey()) && "select".equalsIgnoreCase(eventName = customEventArgs.getEventName())) {
            TableSelectedIndexes tableSelectedIndexes = (TableSelectedIndexes)JsonUtil.decodeFromString((String)customEventArgs.getEventArgs(), TableSelectedIndexes.class);
            this.getPageCache().put("ws_selected_cells_data", StringUtils.join((Iterable)tableSelectedIndexes.getSelected(), (String)","));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("addduty".equals(operateKey)) {
            this.openShiftF7();
        } else if ("editgencondition".equals(operateKey)) {
            this.pullUpEditGenConditionWindows();
        } else if ("new".equals(operateKey)) {
            this.setCustomData("set", new WorkScheduleVo());
        } else if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.showEditGenConditionButtonIfNecessary();
            this.updatePreviewFloorGenDateAndCeilingGenDate();
            this.initShowMonthAfterGen();
            this.getModel().setDataChanged(false);
        }
    }

    private void pullUpEditGenConditionWindows() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtbd_editgencond");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(style);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap<String, Object> cusParams = new HashMap<String, Object>(6);
        cusParams.put("shiftmode", dataEntity.getLong("shiftmode.id"));
        cusParams.put("calendarmodel", dataEntity.getLong("calendarmodel.id"));
        List holidayProIds = dataEntity.getDynamicObjectCollection("holidayportfolios").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
        cusParams.put("holidayportfolios", holidayProIds);
        cusParams.put("basedate", dataEntity.getDate("basedate"));
        cusParams.put("floorgendate", dataEntity.getDate("floorgendate"));
        cusParams.put("ceilinggendate", dataEntity.getDate("ceilinggendate"));
        formShowParameter.setCustomParams(cusParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editgencondition"));
        this.getView().showForm(formShowParameter);
    }

    private void openShiftF7() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"wtbd_shift", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "F7_SHIFT"));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter filter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
        String[] dateStrArr = this.getSelectedDates();
        if (dateStrArr != null && dateStrArr.length == 1) {
            String dateStr = dateStrArr[0];
            Date date = WTCDateUtils.str2Date((String)dateStr, (String)"yyyy-MM-dd");
            Long shiftId = this.getNewestEffectStaticObjectEntry().stream().filter(entry -> dateStr.equals(entry.getWorkDateStr())).findFirst().map(WorkScheduleNewEntry::getShiftId).orElse(null);
            filter.and(new QFilter("firstbsed", "<=", (Object)date)).and(new QFilter("id", "!=", (Object)shiftId));
        }
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setUseOrgId(this.getModel().getDataEntity().getLong("createorg.id"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("F7_SHIFT".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection row = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            long shiftId = Long.parseLong(row.get(0).getPrimaryKeyValue().toString());
            String userName = RequestContext.get().getUserName();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            Date now = new Date();
            String[] dateStrArr = this.getSelectedDates();
            Set<ShiftEditInfo> newestShiftEditInfoSet = this.getNewestShiftEditInfo();
            for (String dateStr : dateStrArr) {
                ShiftEditInfo shiftEditInfo = new ShiftEditInfo(dateStr, shiftId, userId, userName, now);
                newestShiftEditInfoSet.remove(shiftEditInfo);
                newestShiftEditInfoSet.add(shiftEditInfo);
            }
            this.setNewestShiftEditInfo(newestShiftEditInfoSet);
            this.doGen();
            this.cusCtrlShowPage("set");
            this.validateShiftOverlap(WorkScheduleFormHelper.batchConvert2VoList(this.getNewestEffectStaticObjectEntry()));
        } else if ("editgencondition".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.clearGenCondition();
            this.getModel().setValue("shiftmode", returnData.get("shiftmode"));
            this.getModel().setValue("calendarmodel", returnData.get("calendarmodel"));
            List idJsonArr = (List)returnData.get("holidayportfolios");
            Object[] pkArr = new Object[idJsonArr.size()];
            for (int i = 0; i < idJsonArr.size(); ++i) {
                pkArr[i] = idJsonArr.get(i);
            }
            this.getModel().setValue("holidayportfolios", (Object)pkArr);
            this.getModel().setValue("basedate", returnData.get("basedate"));
            this.getModel().setValue("genstarttime", returnData.get("genstarttime"));
            this.getModel().setValue("genendtime", returnData.get("genendtime"));
            Boolean coverExist = (Boolean)returnData.get("coverexist");
            this.getModel().setValue("appendmode", (Object)(coverExist != false ? "C" : "B"));
            this.getView().invokeOperation("gen");
        }
    }

    private String[] getSelectedDates() {
        String selectCells = this.getPageCache().get("ws_selected_cells_data");
        return StringUtils.split((String)selectCells, (String)",");
    }

    private void clearGenCondition() {
        this.getModel().setValue("shiftmode", null);
        this.getModel().setValue("calendarmodel", null);
        this.getModel().setValue("holidayportfolios", null);
        this.getModel().setValue("genendtime", null);
        this.getModel().setValue("genstarttime", null);
        this.getModel().setValue("basedate", null);
    }

    private Set<ShiftEditInfo> getNewestShiftEditInfo() {
        String shiftEditInfoSetJsonStr = this.getPageCache().get(CACHE_SHIFT_EDIT_INFO);
        if (shiftEditInfoSetJsonStr != null) {
            try {
                return (Set)HRJSONUtils.cast((String)shiftEditInfoSetJsonStr, Set.class, (Class[])new Class[]{ShiftEditInfo.class});
            }
            catch (IOException e) {
                this.getPageCache().remove(CACHE_SHIFT_EDIT_INFO);
                logger.error((Throwable)e);
            }
        }
        return new HashSet<ShiftEditInfo>(16);
    }

    private void setNewestShiftEditInfo(Set<ShiftEditInfo> newestShiftEditInfoSet) {
        if (newestShiftEditInfoSet == null || newestShiftEditInfoSet.isEmpty()) {
            return;
        }
        try {
            String shiftEditInfoSetJsonStr = HRJSONUtils.toString(newestShiftEditInfoSet);
            this.getPageCache().put(CACHE_SHIFT_EDIT_INFO, shiftEditInfoSetJsonStr);
        }
        catch (IOException e) {
            String msg = ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\u3002", (String)"WorkScheduleEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
    }

    public void beforeBindData(EventObject env) {
        super.beforeBindData(env);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (null != parentView && "wtbd_batchworkschedule".equals(parentView.getFormShowParameter().getFormId())) {
            Object customParam = this.getView().getFormShowParameter().getCustomParam("wtbd_batchworkschedule");
            this.setDataFromParent((Map)JsonUtil.decodeFromString((String)customParam.toString(), Map.class));
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String noCheckChangedField : NOCHECKCHANGEDFIELDS) {
            IDataEntityProperty noCheckChangedFieldProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)noCheckChangedField);
            dataEntity.getDataEntityState().setBizChanged(noCheckChangedFieldProp.getOrdinal(), false);
        }
    }

    private void setDataFromParent(Map<String, Object> workSchedule) {
        if (workSchedule == null) {
            return;
        }
        List<String> showProperty = Arrays.asList("name", "number", "basedate", "genstarttime", "genendtime", "floorgendate", "ceilinggendate", "wtbd_workscheduleentry");
        DataEntityPropertyCollection currentCollection = this.getModel().getDataEntityType().getProperties();
        for (Map.Entry<String, Object> entry : workSchedule.entrySet()) {
            String property = entry.getKey();
            boolean flag = currentCollection.stream().anyMatch(arg -> HRStringUtils.equals((String)arg.getName(), (String)property));
            if (!flag || !showProperty.contains(property)) continue;
            if ("wtbd_workscheduleentry".equals(property)) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("wtbd_workscheduleentry", this.buildEntry((List)JsonUtil.decodeFromString((String)workSchedule.get("wtbd_workscheduleentry").toString(), List.class)));
                model.endInit();
                continue;
            }
            this.getModel().setValue(property, workSchedule.get(property));
        }
    }

    private TableValueSetter buildEntry(List<Map<String, Object>> totalEntry) {
        TableValueSetter tableValueSetter = WorkScheduleEdit.getTableValueSetter("datepropertyid", "oridatetype");
        for (Map<String, Object> map : totalEntry) {
            tableValueSetter.addRow(new Object[]{WTCDateUtils.str2Date((String)(map.get("workdate") + ""), (String)"yyyy-MM-dd HH:mm:ss"), map.get("datetype"), map.get("datepropertyid"), map.get("oridatetype"), map.get("oridatepropertyid"), map.get("etimezoneid"), map.get("shiftid"), map.get("holidayid"), map.get("weekday"), map.get("selfset"), WTCDateUtils.str2Date((String)(map.get("ecreatetime") + ""), (String)"yyyy-MM-dd HH:mm:ss"), map.get("ecreatorid")});
        }
        return tableValueSetter;
    }

    private void closeFieldNullErrorTip(String key) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(key);
        fieldTip.setSuccess(true);
        this.getView().showFieldTip(fieldTip);
    }

    private void openFieldNullErrorTip(List<String> keyList) {
        List tipsList = keyList.stream().map(key -> {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkScheduleEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            fieldTip.setFieldKey(key);
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            return fieldTip;
        }).collect(Collectors.toList());
        this.getView().showFieldTips(tipsList);
    }

    private void validateShiftDatesOnPropertyChanged(String key) {
        if (!Arrays.asList("shiftmode", "calendarmodel", "basedate", "genstarttime", "genendtime").contains(key)) {
            return;
        }
        if (this.isExistShiftMode() && this.isExistCalendarModel() && this.isExistBaseDate() && this.isExistGenStartDate() && this.isExistGenEndDate()) {
            this.doGen();
            List<WorkScheduleNewEntryVo> voList = WorkScheduleFormHelper.batchConvert2VoList(this.getNewestEffectStaticObjectEntry());
            if (this.validateShiftDates(voList)) {
                this.validateShiftOverlap(voList);
            }
        }
    }

    private boolean validateShiftDates(List<WorkScheduleNewEntryVo> voList) {
        List<String> messages = WorkScheduleFormHelper.validateShiftDates(voList);
        WorkScheduleFormHelper.showConfirm(this.getView(), ResManager.loadKDString((String)"\u5b58\u5728\u672a\u751f\u6548\u7684\u73ed\u6b21", (String)"WorkScheduleEdit_17", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), messages);
        return CollectionUtils.isEmpty(messages);
    }

    private boolean validateShiftOverlap(List<WorkScheduleNewEntryVo> voList) {
        List<String> messages = WorkScheduleFormHelper.validateShiftOverlap(voList);
        WorkScheduleFormHelper.showConfirm(this.getView(), ResManager.loadKDString((String)"\u5b58\u5728\u65f6\u6bb5\u91cd\u53e0\u7684\u73ed\u6b21", (String)"WorkScheduleEdit_20", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), messages);
        return CollectionUtils.isEmpty(messages);
    }

    private void adjustDateType(List<WorkScheduleNewEntry> workScheduleNewEntries, boolean isSkipEditShiftEntry) {
        ArrayList needAdjWorkScheduleEntries = Lists.newArrayList(workScheduleNewEntries);
        if (isSkipEditShiftEntry) {
            Set<ShiftEditInfo> newestShiftEditInfo = this.getNewestShiftEditInfo();
            Set dateStrSet = newestShiftEditInfo.stream().map(ShiftEditInfo::getDateStr).collect(Collectors.toSet());
            needAdjWorkScheduleEntries.removeIf(entry -> dateStrSet.contains(entry.getWorkDateStr()));
        }
        if (WTCCollections.isEmpty((Collection)needAdjWorkScheduleEntries)) {
            return;
        }
        DynamicObject workScheduleDy = this.getModel().getDataEntity();
        Date genStartTime = workScheduleDy.getDate("floorgendate");
        Date genEndTime = workScheduleDy.getDate("ceilinggendate");
        long dateTypeAdjId = workScheduleDy.getLong("shiftmode.datetypeadj.id");
        DateTypeAdj dateTypeAdj = DateTypeAdjService.getInstance().getDateTypeAdj(dateTypeAdjId);
        WorkScheduleHelper.adjWorkScheduleEntry((List)needAdjWorkScheduleEntries, (Date)genStartTime, (Date)genEndTime, (DateTypeAdj)dateTypeAdj);
    }

    static {
        NOCHECKCHANGEDFIELDS.add("showmonth");
        NOCHECKCHANGEDFIELDS.add("previewfloorgendate");
        NOCHECKCHANGEDFIELDS.add("previewceilinggendate");
    }

    private static class ShiftEditInfo {
        private String dateStr;
        private long shiftId;
        private long emodifierid;
        private String emodifiername;
        private Date emodifytime;

        public ShiftEditInfo() {
        }

        public ShiftEditInfo(String dateStr, long shiftId, long emodifierid, String emodifiername, Date emodifytime) {
            this.dateStr = dateStr;
            this.shiftId = shiftId;
            this.emodifierid = emodifierid;
            this.emodifiername = emodifiername;
            this.emodifytime = emodifytime;
        }

        public String getDateStr() {
            return this.dateStr;
        }

        public void setDateStr(String dateStr) {
            this.dateStr = dateStr;
        }

        public long getShiftId() {
            return this.shiftId;
        }

        public void setShiftId(long shiftId) {
            this.shiftId = shiftId;
        }

        public long getEmodifierid() {
            return this.emodifierid;
        }

        public void setEmodifierid(long emodifierid) {
            this.emodifierid = emodifierid;
        }

        public String getEmodifiername() {
            return this.emodifiername;
        }

        public void setEmodifiername(String emodifiername) {
            this.emodifiername = emodifiername;
        }

        public Date getEmodifytime() {
            return this.emodifytime;
        }

        public void setEmodifytime(Date emodifytime) {
            this.emodifytime = emodifytime;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ShiftEditInfo that = (ShiftEditInfo)obj;
            return Objects.equals(this.dateStr, that.dateStr);
        }

        public int hashCode() {
            return Objects.hash(this.dateStr);
        }
    }
}

