/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.hp.HpHolidayCalculateService;
import kd.wtc.wtbd.business.workschedule.WorkScheduleViewService;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;

public class WorkScheduleHpConflictEdit
extends HRDataBaseEdit {
    private static final String KEY_REVISETIP = "revisetip";
    private static final String OP_REVISE = "reviseconflicthd";
    private static final String BTN_REVISE = "revisebtn";
    private static final HpHolidayCalculateService HP_HOLIDAY_CALCULATE_SERVICE = new HpHolidayCalculateService();

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (OP_REVISE.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.showRevisePage();
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter instanceof BillShowParameter) {
            this.judgeConflict();
        }
    }

    private void showRevisePage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String conflictDateMapStr = this.getPageCache().get("revisesource");
        String reviseDataStr = this.getPageCache().get("revisedata");
        String shiftModeId = dataEntity.getString("shiftmode.id");
        Date baseDate = dataEntity.getDate("basedate");
        Date startDate = dataEntity.getDate("genstarttime");
        Date endDate = dataEntity.getDate("genendtime");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "wtbd_workschhprevise");
        WorkScheduleViewService.getInstance().showReviseView(baseDate, startDate, endDate, shiftModeId, conflictDateMapStr, this.getView(), closeCallBack, reviseDataStr);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name;
        super.propertyChanged(evt);
        switch (name = evt.getProperty().getName()) {
            case "basedate": 
            case "shiftmode": 
            case "calendarmodel": 
            case "holidayportfolios": 
            case "genstarttime": 
            case "genendtime": {
                this.judgeConflict();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object object;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("wtbd_workschhprevise".equals(actionId) && (object = closedCallBackEvent.getReturnData()) instanceof Map) {
            this.getPageCache().put("revisedata", SerializationUtils.serializeToBase64((Object)object));
        }
    }

    private void judgeConflict() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startDate = dataEntity.getDate("genstarttime");
        Date endDate = dataEntity.getDate("genendtime");
        Date baseDate = dataEntity.getDate("basedate");
        DynamicObject calendarModelDy = dataEntity.getDynamicObject("calendarmodel");
        DynamicObject shiftModeDy = dataEntity.getDynamicObject("shiftmode");
        Boolean isVisible = Boolean.FALSE;
        if (WorkScheduleViewService.getInstance().isCheckConflict(baseDate, startDate, endDate, calendarModelDy, shiftModeDy)) {
            DynamicObjectCollection holidayHpDyColl = dataEntity.getDynamicObjectCollection("holidayportfolios");
            List holidayPortFolioIdsOfCalendarRule = calendarModelDy.getDynamicObjectCollection("holidaycombine").stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            List holidayPortFolioIdsOfWorkSch = holidayHpDyColl.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            ArrayList holidayPortFolioIds = new ArrayList(holidayPortFolioIdsOfCalendarRule.size() + holidayPortFolioIdsOfWorkSch.size());
            holidayPortFolioIds.addAll(holidayPortFolioIdsOfCalendarRule);
            holidayPortFolioIds.addAll(holidayPortFolioIdsOfWorkSch);
            WorkSchHolidayParam workSchHolidayParam = new WorkSchHolidayParam(startDate, endDate, holidayPortFolioIds);
            Map conflictHolidayAllMap = HP_HOLIDAY_CALCULATE_SERVICE.getConflictedSortedHoliday(Collections.singletonList(workSchHolidayParam));
            Map conflictHolidayMap = (Map)conflictHolidayAllMap.get(workSchHolidayParam);
            if (conflictHolidayMap != null && !conflictHolidayMap.isEmpty()) {
                isVisible = Boolean.TRUE;
                this.getPageCache().put("revisesource", SerializationUtils.serializeToBase64((Object)conflictHolidayMap));
                this.getPageCache().put("revisedata", null);
            }
        }
        if (this.getView().getFormShowParameter() instanceof BillShowParameter && ((BillShowParameter)this.getView().getFormShowParameter()).getPkId() != null) {
            this.getView().setVisible(isVisible, new String[]{BTN_REVISE});
        } else {
            this.getView().setVisible(isVisible, new String[]{KEY_REVISETIP});
        }
    }
}

