/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.workschedule.shiftmode.ShiftModeService;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WorkScheduleRevisePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(WorkScheduleRevisePlugin.class);
    private static final String CACHE_CONFLICTHOLIDAYIDLIST = "cache_conflictholidayidlist";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("holiday");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String conflictMapStr = (String)showParameter.getCustomParam("revisesource");
        if (HRStringUtils.isNotEmpty((String)conflictMapStr)) {
            LinkedHashMap map = (LinkedHashMap)SerializationUtils.deSerializeFromBase64((String)conflictMapStr);
            String reviseDataStr = (String)showParameter.getCustomParam("revisedata");
            Map<Date, Long> holidayMap = null;
            if (HRStringUtils.isNotEmpty((String)reviseDataStr)) {
                Map dateListMap = (Map)SerializationUtils.deSerializeFromBase64((String)reviseDataStr);
                holidayMap = dateListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Long)((List)entry.getValue()).get(0)));
            }
            Date baseDate = WTCDateUtils.str2Date((String)((String)showParameter.getCustomParam("basedate")), (String)"yyyy-MM-dd");
            Date startDate = WTCDateUtils.str2Date((String)((String)showParameter.getCustomParam("genstarttime")), (String)"yyyy-MM-dd");
            Date endDate = WTCDateUtils.str2Date((String)((String)showParameter.getCustomParam("genendtime")), (String)"yyyy-MM-dd");
            Long shiftModeId = Long.parseLong((String)showParameter.getCustomParam("shiftmode"));
            Map shiftDataMap = ShiftModeService.getInstance().genRosterShiftBoInfos(baseDate, startDate, endDate, shiftModeId);
            Map shiftMap = ShiftService.getInstance().getShiftEvalVoMapByVids(new HashSet(shiftDataMap.values()));
            this.setEntryData(map, holidayMap, shiftDataMap, shiftMap);
        }
    }

    private void setEntryData(LinkedHashMap<Date, List<Long>> map, Map<Date, Long> holidayMap, Map<LocalDate, Long> shiftDataMap, Map<Long, Shift> shiftMap) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("conflictdate", new Object[0]);
        tableValueSetter.addField("holiday", new Object[0]);
        tableValueSetter.addField("shift", new Object[0]);
        tableValueSetter.addField("shifttime", new Object[0]);
        tableValueSetter.addField("weekday", new Object[0]);
        ArrayList conflictHolidayIdList = Lists.newArrayListWithCapacity((int)map.size());
        int index = 0;
        for (Map.Entry<Date, List<Long>> dateMapEntry : map.entrySet()) {
            Long holidayId;
            Date currDate = dateMapEntry.getKey();
            tableValueSetter.set("conflictdate", (Object)currDate, index);
            Long l = holidayId = holidayMap != null ? holidayMap.get(dateMapEntry.getKey()) : null;
            if (holidayId == null) {
                holidayId = dateMapEntry.getValue().get(0);
            }
            conflictHolidayIdList.add(dateMapEntry.getValue());
            tableValueSetter.set("holiday", (Object)holidayId, index);
            tableValueSetter.set("weekday", (Object)WTCDateUtils.getDayOfWeek((Date)currDate), index);
            if (shiftDataMap != null) {
                LocalDate currLocalDate = WTCDateUtils.toLocalDate((Date)currDate);
                Long shiftId = shiftDataMap.get(currLocalDate);
                tableValueSetter.set("shift", (Object)shiftId, index);
                Shift shift = shiftMap.get(shiftId);
                String shiftTime = MessageFormat.format("{0}-{1}", WorkScheduleRevisePlugin.seconds2Time(shift.getLastShiftStartDate()), WorkScheduleRevisePlugin.seconds2Time(shift.getLastShiftEndDate()));
                tableValueSetter.set("shifttime", (Object)shiftTime, index);
            }
            ++index;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        this.getPageCache().put(CACHE_CONFLICTHOLIDAYIDLIST, SerializationUtils.serializeToBase64((Object)conflictHolidayIdList));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("ok".equals(args.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashMap defaultHolidayMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
            for (DynamicObject entryDy : entryEntity) {
                long dateTypeId = entryDy.getLong("holiday.datetype.id");
                long holidayId = entryDy.getLong("holiday.id");
                ArrayList holidayTypeIds = Lists.newArrayList((Object[])new Long[]{holidayId, dateTypeId});
                defaultHolidayMap.put(entryDy.getDate("conflictdate"), holidayTypeIds);
            }
            this.getView().returnDataToParent((Object)defaultHolidayMap);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("holiday".equals(beforeF7SelectEvent.getProperty().getName())) {
            List conflictHolidayIdList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_CONFLICTHOLIDAYIDLIST));
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", conflictHolidayIdList.get(beforeF7SelectEvent.getRow())));
        }
    }

    private static String seconds2Time(int seconds) {
        int minute = seconds / 60;
        int hour = 0;
        if (minute >= 60) {
            hour = minute / 60;
            minute %= 60;
        }
        return String.format("%02d:%02d", hour, minute);
    }
}

