/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.datetype.DateTypeServices;
import kd.wtc.wtbd.business.holiday.HolidayServices;
import kd.wtc.wtbd.business.workschedule.WorkScheduleHelper;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbd.fromplugin.web.workschedule.CalModelParamEdit;
import kd.wtc.wtbd.fromplugin.web.workschedule.WorkCalComEdit;
import kd.wtc.wtbs.business.workschedule.datetypeadj.DateTypeAdjService;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WorkSyncEdit
extends WorkCalComEdit {
    private static final Log log = LogFactory.getLog(WorkSyncEdit.class);
    private HRBaseServiceHelper syncRecordHelper = new HRBaseServiceHelper("wtbd_calsyncrecord");
    private static final HRBaseServiceHelper CALENDAR_MODEL_HELPER = new HRBaseServiceHelper("wtbd_calendarmodel");

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject dataEntity;
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        if ("syncalldate".equals(propertyName)) {
            dataEntity = this.getModel().getDataEntity();
            boolean syncAll = dataEntity.getBoolean("syncalldate");
            DateEdit startDate = (DateEdit)this.getView().getControl("startdate");
            startDate.setEnable(null, !syncAll, -1);
            startDate.setMustInput(!syncAll);
            DateEdit endDate = (DateEdit)this.getView().getControl("enddate");
            endDate.setEnable(null, !syncAll, -1);
            endDate.setMustInput(!syncAll);
            if (syncAll) {
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        }
        if ("startdate".equals(propertyName) || "enddate".equals(propertyName)) {
            dataEntity = this.getModel().getDataEntity();
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            if (null != startDate && null != endDate) {
                if (startDate.after(endDate)) {
                    this.showErrorTip(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkSyncEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), "enddate");
                } else {
                    this.delErrorTip("startdate", "enddate");
                }
            }
        }
    }

    public void afterBindData(EventObject even) {
        super.afterBindData(even);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflexon"});
        this.operateTips(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (this.checkSave()) {
                HashMap cusMap = Maps.newHashMap();
                this.toConfirmForm(cusMap);
            }
        } else if ("closetips".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipsflex"});
            this.initTipOperate();
        } else if ("againtips".equals(operateKey)) {
            this.operateTips(false);
        }
    }

    private boolean checkSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean syncAll = dataEntity.getBoolean("syncalldate");
        if (!syncAll) {
            Map cusMap = this.getView().getFormShowParameter().getCustomParams();
            List ids = (List)cusMap.get("ids");
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            if (null == startDate || null == endDate) {
                if (null == startDate) {
                    this.showErrorTip(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkSyncEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), "startdate");
                }
                if (null == endDate) {
                    this.showErrorTip(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkSyncEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), "enddate");
                }
                return false;
            }
            Date sysDate = CalModelParamEdit.getFloorDate();
            if (startDate.before(sysDate)) {
                String msg = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6700\u65e9\u5141\u8bb8\u53d8\u66f4\u7684\u65e5\u671f%s\u3002", (String)"WorkSyncEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)sysDate)});
                this.getView().showErrorNotification(msg);
                return false;
            }
            if (startDate.getTime() > endDate.getTime()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkSyncEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject[] dys = this.workScheduleHelper.query("id,name,floorgendate,ceilinggendate", new QFilter[]{new QFilter("id", "in", (Object)ids)});
            List filterDys = Arrays.asList(dys).stream().filter(dy -> dy.getDate("floorgendate").after(startDate) || dy.getDate("ceilinggendate").before(endDate)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterDys)) {
                StringBuilder sbr = new StringBuilder();
                String msg = ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u8303\u56f4\u5df2\u8d85\u51fa\u201c%s\u201d\u7684\u751f\u6210\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"WorkSyncEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]) + "\n";
                for (DynamicObject filterDy : filterDys) {
                    sbr.append(ResManager.loadKDString((String)msg, (String)"WorkSyncEdit_01", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{filterDy.get("name")}));
                }
                this.getView().showErrorNotification(sbr.toString());
                return false;
            }
            this.delErrorTip("startdate", "enddate");
        }
        return true;
    }

    @Override
    public void toConfirmForm(Map<String, Object> cusMap) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u5df2\u9009\u65e5\u671f\u8303\u56f4\u5185\u7684\u65e5\u5386\u751f\u6210\u89c4\u5219\u5c06\u66ff\u6362\u5f53\u524d\u5de5\u4f5c\u65e5\u7a0b\u8868\u4e2d\u7684\u65e5\u5386\uff0c\u662f\u5426\u66f4\u65b0\uff1f", (String)"WorkSyncEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMTIPS", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && this.checkSave()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", this.getView().getFormShowParameter().getCheckRightAppId());
            OperationResult rightResult = OperationServiceHelper.executeOperate((String)"save", (String)"wtbd_relworkschedulesync", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)option);
            if (rightResult != null && !rightResult.isSuccess()) {
                this.getView().showOperationResult(rightResult);
                return;
            }
            try {
                this.toSyncOperate();
            }
            catch (Exception ex) {
                log.error("workSch.sync.error", (Throwable)ex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"WorkSyncEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"WorkSyncEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        }
    }

    @Override
    public void initTipOperate() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"tipsflexon"});
    }

    private void showErrorTip(String tip, String key) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setTip(tip);
        fieldTip.setSuccess(false);
        fieldTip.setFieldKey(key);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
        this.getView().showFieldTip(fieldTip);
    }

    private void delErrorTip(String ... keys) {
        ArrayList<FieldTip> fieldTipList = new ArrayList<FieldTip>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(true);
            fieldTip.setFieldKey(keys[i]);
            fieldTipList.add(fieldTip);
        }
        this.getView().showFieldTips(fieldTipList);
    }

    private void toSyncOperate() {
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)cusMap.get("ids");
        Map<Long, List<DynamicObject>> oldEntryMap = this.queryEntryOldList();
        Map<Long, DynamicObject> workScheduleMap = this.getWorkSchedule(ids);
        ArrayList<DynamicObject> updateEntryList = new ArrayList<DynamicObject>(100);
        ArrayList<DynamicObject> syncRecordList = new ArrayList<DynamicObject>(100);
        ArrayList<DynamicObject> workScheduleList = new ArrayList<DynamicObject>(100);
        for (Long id : ids) {
            DynamicObject workSchedule = workScheduleMap.get(id);
            Map<String, List<DynamicObject>> resultMap = this.compareChange(workSchedule, oldEntryMap.get(id));
            List<DynamicObject> updateEntry = resultMap.get("wtbd_workscheduleentry");
            updateEntryList.addAll(updateEntry);
            List<DynamicObject> syncRecord = resultMap.get("wtbd_calsyncrecord");
            syncRecordList.addAll(syncRecord);
            workSchedule.set("calendarmodelfid", (Object)workSchedule.getLong("calendarmodel.sourcevid"));
            workScheduleList.add(workSchedule);
        }
        this.toSave(updateEntryList, syncRecordList, workScheduleList);
    }

    private void toSave(List<DynamicObject> entryList, List<DynamicObject> syncRecordList, List<DynamicObject> workScheduleList) {
        try (TXHandle txHandle = TX.required();){
            this.workScheduleEntryHelper.update(entryList.toArray(new DynamicObject[0]));
            this.syncRecordHelper.save(syncRecordList.toArray(new DynamicObject[0]));
            this.workScheduleHelper.update(workScheduleList.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, List<DynamicObject>> compareChange(DynamicObject workSchedule, List<DynamicObject> oldEntryList) {
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(10);
        boolean syncAll = this.getModel().getDataEntity().getBoolean("syncalldate");
        Map<String, Date> dateInfo = this.getDateInfo(workSchedule, syncAll);
        List<WorkScheduleNewEntry> newEntryList = this.getNewEntry(workSchedule, dateInfo);
        Map dateAttrNameMap = WorkScheduleHelper.getAllDateAttrName();
        Map dateTypeNameMap = DateTypeServices.queryAllDateTypeName();
        Map holidayNameMap = HolidayServices.queryAllHolidayNameMap();
        oldEntryList.sort(Comparator.comparing(dy -> dy.getDate("workdate")));
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        ArrayList<DynamicObject> saveEntry = new ArrayList<DynamicObject>(newEntryList.size());
        resultMap.put("wtbd_workscheduleentry", saveEntry);
        ArrayList<DynamicObject> saveSyncRecord = new ArrayList<DynamicObject>(newEntryList.size());
        resultMap.put("wtbd_calsyncrecord", saveSyncRecord);
        long dateTypeAdjId = workSchedule.getLong("shiftmode.datetypeadj.id");
        DateTypeAdj dateTypeAdj = DateTypeAdjService.getInstance().getDateTypeAdj(dateTypeAdjId);
        for (int i = 0; i < newEntryList.size(); ++i) {
            WorkScheduleNewEntry newEntry = newEntryList.get(i);
            DynamicObject oldEntry = oldEntryList.get(i);
            newEntry.setShiftId(oldEntry.getLong("shiftid"));
        }
        Date genStartTime = workSchedule.getDate("floorgendate");
        Date genEndTime = workSchedule.getDate("ceilinggendate");
        WorkScheduleHelper.adjWorkScheduleEntry(newEntryList, (Date)genStartTime, (Date)genEndTime, (DateTypeAdj)dateTypeAdj);
        for (int i = 0; i < newEntryList.size(); ++i) {
            WorkScheduleNewEntry newEntry = newEntryList.get(i);
            DynamicObject oldEntry = oldEntryList.get(i);
            if (newEntry.getWorkDate().getTime() != oldEntry.getDate("workdate").getTime()) {
                log.error("\u65e5\u671f\u4e0d\u5339\u914d newDat = {} ; oldDate = {}", (Object)newEntry.getWorkDate(), (Object)oldEntry.getDate("workdate"));
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u5339\u914d\u3002", (String)"WorkSyncEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            }
            long datePropertyId = oldEntry.getLong("datepropertyid.id");
            boolean datePropertyEq = this.longEqual(newEntry.getDatePropertyId(), datePropertyId);
            long oriDatePropertyId = oldEntry.getLong("oridatepropertyid.id");
            boolean oriDatePropertyEq = this.longEqual(newEntry.getOriDatePropertyId(), oriDatePropertyId);
            long dateTypeId = oldEntry.getLong("datetype.id");
            boolean dateTypeEq = this.longEqual(newEntry.getDateTypeId(), dateTypeId);
            long oriDateTypeId = oldEntry.getLong("oridatetype.id");
            boolean oriDateTypeEq = this.longEqual(newEntry.getOriDateTypeId(), oriDateTypeId);
            boolean holidayEqual = this.holidayEqual(newEntry, oldEntry);
            if (!datePropertyEq && !oriDatePropertyEq && !dateTypeEq && !oriDateTypeEq && !holidayEqual) continue;
            this.handleNotEqualData(workSchedule, dateAttrNameMap, dateTypeNameMap, holidayNameMap, userId, now, saveSyncRecord, newEntry, oldEntry, datePropertyId, datePropertyEq, oriDatePropertyId, oriDatePropertyEq, dateTypeId, dateTypeEq, oriDateTypeId, oriDateTypeEq, holidayEqual);
            saveEntry.add(oldEntry);
        }
        return resultMap;
    }

    private void handleNotEqualData(DynamicObject workSchedule, Map<Long, String> dateAttrNameMap, Map<Long, String> dateTypeNameMap, Map<Long, String> holidayNameMap, long userId, Date now, List<DynamicObject> saveSyncRecord, WorkScheduleNewEntry newEntry, DynamicObject oldEntry, long datePropertyId, boolean datePropertyEq, long oriDatePropertyId, boolean oriDatePropertyEq, long dateTypeId, boolean dateTypeEq, long oriDateTypeId, boolean oriDateTypeEq, boolean holidayEqual) {
        DynamicObject record;
        oldEntry.set("datepropertyid", (Object)newEntry.getDatePropertyId());
        oldEntry.set("datetype", (Object)newEntry.getDateTypeId());
        oldEntry.set("oridatepropertyid", (Object)newEntry.getOriDatePropertyId());
        oldEntry.set("oridatetype", (Object)newEntry.getOriDateTypeId());
        if (datePropertyEq) {
            record = this.getBaseSyncRecordDy(oldEntry, now, userId, workSchedule);
            record.set("synctype", (Object)"A");
            record.set("syncbefore", (Object)this.nullToWu(dateAttrNameMap.get(datePropertyId)));
            record.set("syncafter", (Object)this.nullToWu(dateAttrNameMap.get(newEntry.getDatePropertyId())));
            saveSyncRecord.add(record);
        }
        if (oriDatePropertyEq) {
            record = this.getBaseSyncRecordDy(oldEntry, now, userId, workSchedule);
            record.set("synctype", (Object)"D");
            record.set("syncbefore", (Object)this.nullToWu(dateAttrNameMap.get(oriDatePropertyId)));
            record.set("syncafter", (Object)this.nullToWu(dateAttrNameMap.get(newEntry.getOriDatePropertyId())));
            saveSyncRecord.add(record);
        }
        if (dateTypeEq) {
            record = this.getBaseSyncRecordDy(oldEntry, now, userId, workSchedule);
            record.set("synctype", (Object)"B");
            record.set("syncbefore", (Object)this.nullToWu(dateTypeNameMap.get(dateTypeId)));
            record.set("syncafter", (Object)this.nullToWu(dateTypeNameMap.get(newEntry.getDateTypeId())));
            saveSyncRecord.add(record);
        }
        if (oriDateTypeEq) {
            record = this.getBaseSyncRecordDy(oldEntry, now, userId, workSchedule);
            record.set("synctype", (Object)"B");
            record.set("syncbefore", (Object)this.nullToWu(dateTypeNameMap.get(oriDateTypeId)));
            record.set("syncafter", (Object)this.nullToWu(dateTypeNameMap.get(newEntry.getOriDateTypeId())));
            saveSyncRecord.add(record);
        }
        if (holidayEqual) {
            record = this.getBaseSyncRecordDy(oldEntry, now, userId, workSchedule);
            record.set("synctype", (Object)"C");
            record.set("syncbefore", (Object)this.getHolidayName(holidayNameMap, oldEntry.getString("holidayid")));
            record.set("syncafter", (Object)this.getHolidayName(holidayNameMap, newEntry.getHolidayId()));
            saveSyncRecord.add(record);
            oldEntry.set("holidayid", (Object)(newEntry.getHolidayId() == null ? " " : newEntry.getHolidayId()));
        }
    }

    private DynamicObject getBaseSyncRecordDy(DynamicObject oldEntry, Date now, long userId, DynamicObject workSchedule) {
        DynamicObject record = this.syncRecordHelper.generateEmptyDynamicObject();
        record.set("workschedule", (Object)oldEntry.getLong("fid"));
        record.set("number", (Object)workSchedule.getString("number"));
        record.set("name", (Object)workSchedule.getString("name"));
        record.set("calendarmodel", (Object)workSchedule.getLong("calendarmodel.id"));
        DynamicObject calendarModel = CALENDAR_MODEL_HELPER.generateEmptyDynamicObject();
        calendarModel.set("id", (Object)workSchedule.getLong("calendarmodel.sourcevid"));
        record.set("calendarmodelfid", (Object)calendarModel);
        record.set("calname", (Object)workSchedule.getString("calendarmodel.name"));
        record.set("createorg", (Object)workSchedule.getDynamicObject("createorg"));
        record.set("syncdate", (Object)oldEntry.getDate("workdate"));
        record.set("createtime", (Object)now);
        record.set("modifytime", (Object)now);
        record.set("creator", (Object)userId);
        record.set("modifier", (Object)userId);
        return record;
    }

    private Map<Long, List<DynamicObject>> queryEntryOldList() {
        QFilter[] qFilters;
        Map cusMap = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)cusMap.get("ids");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean syncAll = dataEntity.getBoolean("syncalldate");
        QFilter qFilter = new QFilter("fid", "in", (Object)ids);
        if (syncAll) {
            qFilters = new QFilter[]{qFilter};
        } else {
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            QFilter startDateFilter = new QFilter("workdate", ">=", (Object)startDate);
            QFilter endDateFilter = new QFilter("workdate", "<=", (Object)endDate);
            qFilters = new QFilter[]{qFilter, startDateFilter, endDateFilter};
        }
        DynamicObject[] entryList = this.workScheduleEntryHelper.loadDynamicObjectArray(qFilters);
        return Arrays.stream(entryList).collect(Collectors.groupingBy(dy -> dy.getLong("fid")));
    }

    private String getHolidayName(Map<Long, String> holidayNameMap, String holidayStr) {
        if (HRStringUtils.isEmpty((String)holidayStr)) {
            return ResManager.loadKDString((String)"\u65e0", (String)"WorkSyncEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        Set holidayName = Arrays.stream(holidayStr.split(",")).map(str -> (String)holidayNameMap.get(Long.valueOf(str))).collect(Collectors.toSet());
        return String.join((CharSequence)",", holidayName);
    }

    private String nullToWu(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return ResManager.loadKDString((String)"\u65e0", (String)"WorkSyncEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        return str;
    }
}

