/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule.datetypeadj;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class DateTypeAdjEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(DateTypeAdjEdit.class);

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        evt.getFormShowParameter().setCustomParam("checkRightAppId", (Object)"wtp");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit toDateType = (BasedataEdit)this.getControl("todatetype");
        if (toDateType != null) {
            toDateType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("todatetype".equals(beforeF7SelectEvent.getProperty().getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObject currSelectedEntry = (DynamicObject)entryEntity.get(beforeF7SelectEvent.getRow());
            QFilter qFilter = new QFilter("dateproperty.number", "in", (Object)Lists.newArrayList((Object[])new String[]{DateAttribute.OFFDAY.getCode(), DateAttribute.WORKDAY.getCode()}));
            qFilter.and("id", "!=", (Object)currSelectedEntry.getLong("fromdatetype.id"));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        switch (name) {
            case "dayofweeks": 
            case "datetypes": 
            case "shiftofftypes": {
                this.initEntry();
                break;
            }
            case "todatetype": {
                this.setBusinessMeaning(args.getChangeSet()[0].getRowIndex());
                this.validateInputSpecialDate(args);
                break;
            }
        }
    }

    private void validateInputSpecialDate(PropertyChangedArgs args) {
        if (args.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
            if (DateTypeEnum.REST_SPECIAL.getId().longValue() == newValue.getLong("id") && this.getModel().getDataEntity().getLong("specialdate.id") == 0L) {
                this.getView().showErrorNotification(WorkSchKDString.getSpecialDateInputTip());
            }
        }
    }

    public void beforeBindData(EventObject evt) {
        this.setCombination();
    }

    private void setBusinessMeaning(int index) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.setBusinessMeaning(entryEntity, index);
    }

    private void setBusinessMeaning() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setBusinessMeaning(entryEntity, i);
        }
    }

    private void setBusinessMeaning(DynamicObjectCollection entryEntity, int index) {
        DynamicObject entry = (DynamicObject)entryEntity.get(index);
        ComboProp comboProp = (ComboProp)entry.getDataEntityType().getProperties().get((Object)"dayofweek");
        ComboProp shiftOffTypeComboProp = (ComboProp)entry.getDataEntityType().getProperties().get((Object)"shiftofftype");
        String dayOfWeek = (String)comboProp.getValueFast((Object)entry);
        String shiftOffType = (String)shiftOffTypeComboProp.getValueFast((Object)entry);
        String formDateTypeName = entry.getString("fromdatetype.name");
        String toDateTypeName = entry.getString("todatetype.name");
        if (HRStringUtils.isNotEmpty((String)dayOfWeek) && HRStringUtils.isNotEmpty((String)formDateTypeName)) {
            String busMeaning;
            String dayOfWeekItem = comboProp.getItemByName(dayOfWeek);
            if (HRStringUtils.isNotEmpty((String)shiftOffType)) {
                String shiftOffTypeItem = shiftOffTypeComboProp.getItemByName(shiftOffType);
                if (HRStringUtils.isNotEmpty((String)toDateTypeName)) {
                    String toDatePropName = entry.getString("todatetype.dateproperty.name");
                    busMeaning = MessageFormat.format(WorkSchKDString.getDateTypeCombinationShiftOffTrimDesc(), dayOfWeekItem, shiftOffTypeItem, formDateTypeName, toDateTypeName, toDatePropName);
                } else {
                    busMeaning = MessageFormat.format(WorkSchKDString.getDateTypeCombinationShiftOffNoTrimDesc(), dayOfWeekItem, shiftOffTypeItem, formDateTypeName);
                }
            } else if (HRStringUtils.isNotEmpty((String)toDateTypeName)) {
                String toDatePropName = entry.getString("todatetype.dateproperty.name");
                busMeaning = MessageFormat.format(WorkSchKDString.getDateTypeCombinationTrimDesc(), dayOfWeekItem, formDateTypeName, toDateTypeName, toDatePropName);
            } else {
                busMeaning = MessageFormat.format(WorkSchKDString.getDateTypeCombinationNoTrimDesc(), dayOfWeekItem, formDateTypeName);
            }
            this.getModel().setValue("busmeaning", (Object)busMeaning, index);
        }
    }

    private void setCombination() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        ComboProp dayOfWeekComboProp = null;
        ComboProp shiftOffTypeComboProp = null;
        if (entryEntity.size() > 0) {
            dayOfWeekComboProp = (ComboProp)((DynamicObject)entryEntity.get(0)).getDataEntityType().getProperties().get((Object)"dayofweek");
            shiftOffTypeComboProp = (ComboProp)((DynamicObject)entryEntity.get(0)).getDataEntityType().getProperties().get((Object)"shiftofftype");
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String dayOfWeekItem;
            String shiftOffType;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String dayOfWeek = dayOfWeekComboProp == null ? "" : (String)dayOfWeekComboProp.getValueFast((Object)entry);
            String formDateTypeName = entry.getString("fromdatetype.name");
            String string = shiftOffType = shiftOffTypeComboProp == null ? "" : (String)shiftOffTypeComboProp.getValueFast((Object)entry);
            if (!HRStringUtils.isNotEmpty((String)dayOfWeek) || !HRStringUtils.isNotEmpty((String)formDateTypeName)) continue;
            String string2 = dayOfWeekItem = dayOfWeekComboProp == null ? "" : dayOfWeekComboProp.getItemByName(dayOfWeek);
            if (HRStringUtils.isEmpty((String)shiftOffType)) {
                this.getModel().setValue("combination", (Object)MessageFormat.format("{0} + {1}", dayOfWeekItem, formDateTypeName), i);
                continue;
            }
            String shiftOffTypeName = shiftOffTypeComboProp == null ? "" : shiftOffTypeComboProp.getItemByName(shiftOffType);
            this.getModel().setValue("combination", (Object)MessageFormat.format("{0} + {1} + {2}", dayOfWeekItem, shiftOffTypeName, formDateTypeName), i);
        }
        this.setBusinessMeaning();
    }

    private void initEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String dayOfWeeksVal = dataEntity.getString("dayofweeks");
        DynamicObjectCollection dateTypes = dataEntity.getDynamicObjectCollection("datetypes");
        String shiftOffTypesVal = dataEntity.getString("shiftofftypes");
        if (HRStringUtils.isNotEmpty((String)dayOfWeeksVal) && !dateTypes.isEmpty()) {
            LOG.info("initEntry:{}", (Object)dayOfWeeksVal);
            String[] dayOfWeeks = (String[])Arrays.stream(dayOfWeeksVal.split(",")).filter(HRStringUtils::isNotEmpty).toArray(String[]::new);
            String[] shiftOffTypes = shiftOffTypesVal != null ? (String[])Arrays.stream(shiftOffTypesVal.split(",")).filter(HRStringUtils::isNotEmpty).toArray(String[]::new) : new String[]{};
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("dayofweek", new Object[0]);
            tableValueSetter.addField("fromdatetype", new Object[0]);
            int index = 0;
            if (shiftOffTypes.length == 0) {
                for (String dayOfWeek : dayOfWeeks) {
                    for (DynamicObject dateType : dateTypes) {
                        tableValueSetter.set("dayofweek", (Object)dayOfWeek, index);
                        tableValueSetter.set("fromdatetype", (Object)dateType.getDynamicObject("fbasedataid").getLong("id"), index++);
                    }
                }
            } else {
                tableValueSetter.addField("shiftofftype", new Object[0]);
                for (String dayOfWeek : dayOfWeeks) {
                    for (String shiftOffType : shiftOffTypes) {
                        for (DynamicObject dateType : dateTypes) {
                            tableValueSetter.set("dayofweek", (Object)dayOfWeek, index);
                            tableValueSetter.set("shiftofftype", (Object)shiftOffType, index);
                            tableValueSetter.set("fromdatetype", (Object)dateType.getDynamicObject("fbasedataid").getLong("id"), index++);
                        }
                    }
                }
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        }
        this.setCombination();
    }
}

