/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.workschedule.specialdate;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbs.business.workschedule.specialdate.SpecialDateService;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class SpecialDateEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(SpecialDateEdit.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit toDateType = (BasedataEdit)this.getControl("todatetype");
        if (toDateType != null) {
            toDateType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
        if (!(parentView instanceof ListView) || !((ListView)parentView).getEntityTypeId().equals(this.getView().getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("todatetype".equals(beforeF7SelectEvent.getProperty().getName())) {
            QFilter qFilter = new QFilter("dateproperty.number", "in", (Object)Lists.newArrayList((Object[])new String[]{DateAttribute.OFFDAY.getCode(), DateAttribute.WORKDAY.getCode()}));
            qFilter.and("id", "!=", (Object)DateTypeEnum.REST_SPECIAL.getId());
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        DynamicObject entry;
        String name = evt.getProperty().getName();
        if (evt.getChangeSet() == null || evt.getChangeSet().length <= 0) {
            return;
        }
        if (("startdate".equals(name) || "enddate".equals(name)) && (entry = evt.getChangeSet()[0].getDataEntity()).get("startdate") != null && entry.get("enddate") != null) {
            boolean isCross = SpecialDateService.getInstance().validateTimeCross(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
            LOG.info("validateTimeCross.isCross:{}", (Object)isCross);
            if (isCross) {
                this.getView().showErrorNotification(WorkSchKDString.getTimePeriodCrossErrTip());
            }
        }
    }
}

