/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.basedata.shiftperiod;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.cache.IWTCAppCache;

public class ShiftPeriodService {
    private static final Log LOG = LogFactory.getLog(ShiftPeriodService.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtbd_shiftperiod");
    private static final ShiftPeriodService INS = new ShiftPeriodService();

    public static ShiftPeriodService getInstance() {
        return INS;
    }

    public Map<Long, List<Integer>> getIndexesOfPeriodByParentId(Collection<Long> parentIds) {
        LOG.info("getIndexesOfPeriodByParentId.params:{}", parentIds);
        DynamicObjectCollection periods = HELPER.queryOriginalCollection("index,parent.id", new QFilter("parent", "in", parentIds).toArray(), "index");
        return periods.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parent.id"), Collectors.mapping(dy -> dy.getInt("index"), Collectors.toList())));
    }

    public String getNumber(long parentId, int index) {
        return MessageFormat.format("{0,number,#}_{1,number,00}_{2,number,00}_S", parentId / 100L, parentId % 100L, index);
    }

    public ILocaleString getName(ILocaleString parentName, int index) {
        LocaleString localeString = new LocaleString();
        for (Map.Entry entry : parentName.entrySet()) {
            localeString.put((String)entry.getKey(), (Object)MessageFormat.format("{0}_{1}", entry.getValue(), index));
        }
        return localeString;
    }

    public boolean requireShiftPeriodOpMutex(IWTCAppCache appCache) {
        Date date = (Date)appCache.get("wtbd_shiftperiodmutexdeletesave", Date.class);
        Calendar instance = Calendar.getInstance();
        Date now = instance.getTime();
        instance.add(13, -30);
        if (date == null || instance.getTime().after(date)) {
            appCache.put("wtbd_shiftperiodmutexdeletesave", (Object)now);
            return true;
        }
        return false;
    }

    public void removeMutex(IWTCAppCache appCache) {
        appCache.remove("wtbd_shiftperiodmutexdeletesave");
    }
}

