/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.datasourceconf;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.bizupgrade.WtcBizUpgradeService;
import kd.wtc.wtbd.common.enums.bizupgrade.BizUpgradeEventStatusEnum;
import kd.wtc.wtbd.common.enums.datasourceconf.DataSourceUpgradeResultEnum;
import kd.wtc.wtbs.business.history.service.WTCCommonHisService;
import kd.wtc.wtbs.common.predata.wtbd.PreDasoConf;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class OtDatasourceConfDataUpgradeService {
    private static final Log LOG = LogFactory.getLog(OtDatasourceConfDataUpgradeService.class);
    private final String DATA_SOURCE_JSON = "{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":1,\"name\":\"T02\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e)\",\"value\":\"1010_01_S,1040_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":2,\"name\":\"T03\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":3,\"name\":\"T04\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":4,\"name\":\"T05\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":5,\"name\":\"T06\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":6,\"name\":\"T07\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":7,\"name\":\"T08\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":8,\"name\":\"T09\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e),\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1010_01_S,1040_01_S,1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":9,\"name\":\"T10\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":10,\"name\":\"T11\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u662f\",\"value\":\"true\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":11,\"name\":\"T12\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":12,\"name\":\"T13\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":13,\"name\":\"T14\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":14,\"name\":\"T15\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":15,\"name\":\"T16\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5426\",\"value\":\"false\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":16,\"name\":\"T17\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":17,\"name\":\"T18\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":18,\"name\":\"T19\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":19,\"name\":\"T20\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"2\",\"conditionExpressList\":[{\"name\":\"T01\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T02\",\"logical\":\" and \",\"leftBracket\":\"( ( \",\"rightBracket\":\"\"},{\"name\":\"T03\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T04\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T05\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T06\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T07\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T08\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T09\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) ) )\"},{\"name\":\"T10\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T11\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T12\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T13\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T14\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) )\"},{\"name\":\"T15\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T16\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T17\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T18\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T19\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T20\",\"leftBracket\":\"( \",\"rightBracket\":\" ) ) )\",\"logical\":\"\"}],\"conditionExpressStr\":\"( T01 and ( ( T02 and T03 ) or ( T04 and T05 ) or T06 or T07 or ( T08 and T09 ) ) ) or ( T10 and T11 and ( T12 or T13 or T14 ) ) or ( T15 and T16 and ( T17 or T18 or T19 or  T20  ) )\"}";
    private static final Long DATA_SOURCE_BO_ID = PreDasoConf.PD_1090_S;
    private final String RECORD_EVENT = "otDataSource_v1";

    public Tuples.Tuple2<Boolean, DataSourceUpgradeResultEnum> markUnNeedUpgrade() {
        Tuples.Tuple2<DynamicObject, List<DynamicObject>> versionInfo = this.getVersionInfo(DATA_SOURCE_BO_ID);
        if (versionInfo.item1 == null || CollectionUtils.isEmpty((Collection)((Collection)versionInfo.item2))) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.NOT_EXIST_DATA);
        }
        List notCurrentVersion = (List)versionInfo.item2;
        Tuples.Tuple2<Boolean, DataSourceUpgradeResultEnum> needUpgrade = this.verifyDefaultUpgradeStatus(notCurrentVersion);
        if (LOG.isInfoEnabled()) {
            LOG.info("OtDatasourceConfDataUpgradeService_markUnNeedUpgrade needUpgrade = {}", (Object)JSON.toJSONString(needUpgrade));
        }
        if (!((Boolean)needUpgrade.item1).booleanValue()) {
            return needUpgrade;
        }
        WtcBizUpgradeService service = new WtcBizUpgradeService();
        DynamicObject upgradeEvent = this.getUpgradeEvent(RequestContext.get().getCurrUserId(), BizUpgradeEventStatusEnum.UN_NEED_UPGRADE, " ");
        boolean saveLog = service.saveNewEvent(upgradeEvent);
        if (!saveLog) {
            LOG.warn("error in update updateOTDataSource case by save operate log");
            throw new KDBizException("error in update updateOTDataSource case by save operate log");
        }
        return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)DataSourceUpgradeResultEnum.NOT_EXIST_DATA);
    }

    public DataSourceUpgradeResultEnum updateOTDataSourceForCustom(Date effectDate) {
        if (effectDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u751f\u6548\u65e5\u671f\u3002", (String)"OtDatasourceConfDataUpgradeService_0", (String)"wtc-wtbd-business", (Object[])new Object[0]));
        }
        Date minEndDate = WTCDateUtils.getMinEndDate();
        Date maxEndDate = WTCDateUtils.getMaxEndDate();
        if (effectDate.compareTo(minEndDate) < 0 || effectDate.compareTo(maxEndDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u51651900-01-01\u52302099-12-31\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"OtDatasourceConfDataUpgradeService_2", (String)"wtc-wtbd-business", (Object[])new Object[0]));
        }
        Tuples.Tuple2<DynamicObject, List<DynamicObject>> versionInfo = this.getVersionInfo(DATA_SOURCE_BO_ID);
        if (versionInfo.item1 == null || CollectionUtils.isEmpty((Collection)((Collection)versionInfo.item2))) {
            return DataSourceUpgradeResultEnum.NOT_EXIST_DATA;
        }
        List notCurrentVersion = (List)versionInfo.item2;
        DynamicObject currentVersion = (DynamicObject)versionInfo.item1;
        Tuples.Tuple2<Boolean, DataSourceUpgradeResultEnum> needUpgrade = this.verifyDefaultUpgradeStatus(notCurrentVersion);
        if (!((Boolean)needUpgrade.item1).booleanValue()) {
            return (DataSourceUpgradeResultEnum)needUpgrade.item2;
        }
        DynamicObject newDy = (DynamicObject)currentVersion.getDataEntityType().createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)currentVersion, (DynamicObject)newDy, (Set)Sets.newHashSet((Object[])new String[]{"id"}));
        newDy.set("id", (Object)ID.genLongId());
        newDy.set("bsed", (Object)effectDate);
        newDy.set("bsled", null);
        newDy.set("conditions", (Object)"{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":1,\"name\":\"T02\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e)\",\"value\":\"1010_01_S,1040_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":2,\"name\":\"T03\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":3,\"name\":\"T04\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":4,\"name\":\"T05\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":5,\"name\":\"T06\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":6,\"name\":\"T07\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":7,\"name\":\"T08\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":8,\"name\":\"T09\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e),\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1010_01_S,1040_01_S,1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":9,\"name\":\"T10\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":10,\"name\":\"T11\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u662f\",\"value\":\"true\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":11,\"name\":\"T12\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":12,\"name\":\"T13\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":13,\"name\":\"T14\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":14,\"name\":\"T15\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":15,\"name\":\"T16\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5426\",\"value\":\"false\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":16,\"name\":\"T17\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":17,\"name\":\"T18\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":18,\"name\":\"T19\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":19,\"name\":\"T20\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"2\",\"conditionExpressList\":[{\"name\":\"T01\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T02\",\"logical\":\" and \",\"leftBracket\":\"( ( \",\"rightBracket\":\"\"},{\"name\":\"T03\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T04\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T05\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T06\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T07\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T08\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T09\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) ) )\"},{\"name\":\"T10\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T11\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T12\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T13\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T14\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) )\"},{\"name\":\"T15\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T16\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T17\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T18\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T19\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T20\",\"leftBracket\":\"( \",\"rightBracket\":\" ) ) )\",\"logical\":\"\"}],\"conditionExpressStr\":\"( T01 and ( ( T02 and T03 ) or ( T04 and T05 ) or T06 or T07 or ( T08 and T09 ) ) ) or ( T10 and T11 and ( T12 or T13 or T14 ) ) or ( T15 and T16 and ( T17 or T18 or T19 or  T20  ) )\"}");
        try (TXHandle tx = TX.required();){
            try {
                HisResponse response = WTCCommonHisService.saveTimeHisModelData((DynamicObject[])new DynamicObject[]{newDy}, (String)"wtbd_dasoconf", (Long)ID.genLongId(), (Boolean)true);
                if (!HRStringUtils.equals((String)response.getCode(), (String)"200")) {
                    LOG.warn("error in update updateOTDataSource case by saveTimeHisModelData");
                    throw new KDBizException("error in update updateOTDataSource case by saveTimeHisModelData");
                }
                WtcBizUpgradeService service = new WtcBizUpgradeService();
                HashMap mark = Maps.newHashMapWithExpectedSize((int)2);
                mark.put("new", "{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":1,\"name\":\"T02\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e)\",\"value\":\"1010_01_S,1040_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":2,\"name\":\"T03\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":3,\"name\":\"T04\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":4,\"name\":\"T05\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":5,\"name\":\"T06\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":6,\"name\":\"T07\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":7,\"name\":\"T08\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":8,\"name\":\"T09\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e),\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1010_01_S,1040_01_S,1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":9,\"name\":\"T10\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":10,\"name\":\"T11\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u662f\",\"value\":\"true\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":11,\"name\":\"T12\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":12,\"name\":\"T13\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":13,\"name\":\"T14\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":14,\"name\":\"T15\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":15,\"name\":\"T16\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5426\",\"value\":\"false\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":16,\"name\":\"T17\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":17,\"name\":\"T18\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":18,\"name\":\"T19\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":19,\"name\":\"T20\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"2\",\"conditionExpressList\":[{\"name\":\"T01\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T02\",\"logical\":\" and \",\"leftBracket\":\"( ( \",\"rightBracket\":\"\"},{\"name\":\"T03\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T04\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T05\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T06\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T07\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T08\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T09\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) ) )\"},{\"name\":\"T10\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T11\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T12\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T13\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T14\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) )\"},{\"name\":\"T15\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T16\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T17\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T18\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T19\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T20\",\"leftBracket\":\"( \",\"rightBracket\":\" ) ) )\",\"logical\":\"\"}],\"conditionExpressStr\":\"( T01 and ( ( T02 and T03 ) or ( T04 and T05 ) or T06 or T07 or ( T08 and T09 ) ) ) or ( T10 and T11 and ( T12 or T13 or T14 ) ) or ( T15 and T16 and ( T17 or T18 or T19 or  T20  ) )\"}");
                mark.put("newHisVersionId", newDy.get("id"));
                mark.put("param", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd HH:mm:ss"));
                boolean saveLog = service.saveNewEvent(this.getUpgradeEvent(RequestContext.get().getCurrUserId(), BizUpgradeEventStatusEnum.HAS_UPGRADE, JSON.toJSONString((Object)mark)));
                if (!saveLog) {
                    LOG.warn("error in update updateOTDataSource case by save operate log");
                    throw new KDBizException("error in update updateOTDataSource case by save operate log");
                }
            }
            catch (KDBizException kdBizException) {
                tx.markRollback();
                throw kdBizException;
            }
            catch (Exception throwable) {
                tx.markRollback();
                String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e\u6e90\u5931\u8d25\u3002", (String)"OtDatasourceConfDataUpgradeService_1", (String)"wtc-wtbd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)throwable, new ErrorCode("", msg), new Object[0]);
            }
        }
        return DataSourceUpgradeResultEnum.SUCCESS;
    }

    public boolean judeNeedUpgrade() {
        Tuples.Tuple2<DynamicObject, List<DynamicObject>> versionInfo = this.getVersionInfo(DATA_SOURCE_BO_ID);
        if (versionInfo.item1 == null || CollectionUtils.isEmpty((Collection)((Collection)versionInfo.item2))) {
            return false;
        }
        List notCurrentVersion = (List)versionInfo.item2;
        Tuples.Tuple2<Boolean, DataSourceUpgradeResultEnum> needUpgrade = this.verifyDefaultUpgradeStatus(notCurrentVersion);
        return (Boolean)needUpgrade.item1;
    }

    private DynamicObject getUpgradeEvent(Long creatorId, BizUpgradeEventStatusEnum statusEnum, String reMark) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_bizupgrade");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("creator_id", (Object)creatorId);
        dynamicObject.set("eventstauts", (Object)statusEnum.getCode());
        dynamicObject.set("remark_tag", (Object)reMark);
        dynamicObject.set("remark", (Object)" ");
        dynamicObject.set("number", (Object)"otDataSource_v1");
        dynamicObject.set("createtime", (Object)new Date());
        return dynamicObject;
    }

    private Tuples.Tuple2<Boolean, DataSourceUpgradeResultEnum> verifyDefaultUpgradeStatus(List<DynamicObject> notCurrentVersion) {
        DynamicObject dynamicObject;
        String lastJson;
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean havePerm = permissionService.checkPermission(RequestContext.get().getCurrUserId(), "wtp", "wtp_otplan", "47156aff000000ac");
        if (!havePerm) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.PERMISSION_ERROR);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_bizupgrade");
        DynamicObject record = serviceHelper.queryOne("eventstauts,creator", new QFilter[]{new QFilter("number", "=", (Object)"otDataSource_v1")});
        if (record != null) {
            String eventStatus = record.getString("eventstauts");
            if (BizUpgradeEventStatusEnum.HAS_UPGRADE.getCode().equals(eventStatus)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.SYS_HAS_UPGRADE);
            }
            if (BizUpgradeEventStatusEnum.UN_NEED_UPGRADE.getCode().equals(eventStatus)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.UN_NEED_UPGRADE);
            }
        }
        if (notCurrentVersion.size() > 2) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.USER_HAS_MODIFY);
        }
        if (notCurrentVersion.size() == 2) {
            DynamicObject lastVersion = notCurrentVersion.get(1);
            String lastJson2 = lastVersion.getString("conditions");
            if ("{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":1,\"name\":\"T02\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e)\",\"value\":\"1010_01_S,1040_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":2,\"name\":\"T03\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":3,\"name\":\"T04\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":4,\"name\":\"T05\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":5,\"name\":\"T06\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":6,\"name\":\"T07\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":7,\"name\":\"T08\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":8,\"name\":\"T09\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e),\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1010_01_S,1040_01_S,1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":9,\"name\":\"T10\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":10,\"name\":\"T11\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u662f\",\"value\":\"true\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":11,\"name\":\"T12\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":12,\"name\":\"T13\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":13,\"name\":\"T14\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":14,\"name\":\"T15\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":15,\"name\":\"T16\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5426\",\"value\":\"false\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":16,\"name\":\"T17\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":17,\"name\":\"T18\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":18,\"name\":\"T19\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":19,\"name\":\"T20\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"2\",\"conditionExpressList\":[{\"name\":\"T01\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T02\",\"logical\":\" and \",\"leftBracket\":\"( ( \",\"rightBracket\":\"\"},{\"name\":\"T03\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T04\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T05\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T06\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T07\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T08\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T09\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) ) )\"},{\"name\":\"T10\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T11\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T12\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T13\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T14\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) )\"},{\"name\":\"T15\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T16\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T17\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T18\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T19\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T20\",\"leftBracket\":\"( \",\"rightBracket\":\" ) ) )\",\"logical\":\"\"}],\"conditionExpressStr\":\"( T01 and ( ( T02 and T03 ) or ( T04 and T05 ) or T06 or T07 or ( T08 and T09 ) ) ) or ( T10 and T11 and ( T12 or T13 or T14 ) ) or ( T15 and T16 and ( T17 or T18 or T19 or  T20  ) )\"}".equals(lastJson2)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.SYS_HAS_UPGRADE);
            }
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.USER_HAS_MODIFY);
        }
        if (notCurrentVersion.size() == 1 && "{\"conditionList\":[{\"index\":0,\"name\":\"T01\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5de5\u4f5c\u65e5\",\"value\":\"DS-0001\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":1,\"name\":\"T02\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e)\",\"value\":\"1010_01_S,1040_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":2,\"name\":\"T03\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":3,\"name\":\"T04\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":4,\"name\":\"T05\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":5,\"name\":\"T06\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":6,\"name\":\"T07\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":7,\"name\":\"T08\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":8,\"name\":\"T09\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u524d),\u73ed\u6b21\u5916\u65f6\u6bb5(\u73ed\u6b21\u540e),\u4f11\u606f\u65f6\u6bb5\",\"value\":\"1010_01_S,1040_01_S,1030_01_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":9,\"name\":\"T10\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":10,\"name\":\"T11\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u662f\",\"value\":\"true\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":11,\"name\":\"T12\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":12,\"name\":\"T13\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":13,\"name\":\"T14\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":14,\"name\":\"T15\",\"displayParam\":\"\u65e5\u671f\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.dateattribute\",\"paramType\":\"string\",\"target\":false,\"operators\":\"in\",\"valueType\":\"2\",\"displayValue\":\"\u4f11\u606f\u65e5,\u8282\u5047\u65e5\",\"value\":\"DS-0002,DS-0003\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":15,\"name\":\"T16\",\"displayParam\":\"\u662f\u5426OFF\u73ed\",\"param\":\"bucket.wtte_buckettime.off\",\"paramType\":\"boolean\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u5426\",\"value\":\"false\",\"valueDataType\":\"boolean\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":16,\"name\":\"T17\",\"displayParam\":\"\u65f6\u95f4\u5bf9\u5b9e\u4f53.\u5f02\u5e38\u72b6\u6001\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.punchcardtag.id\",\"paramType\":\"dynamicObject\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u6b63\u5e38\u6253\u5361\",\"value\":\"1295500392737583104\",\"valueDataType\":\"number\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":17,\"name\":\"T18\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u52a0\u73ed\u5355\",\"value\":\"1010_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":18,\"name\":\"T19\",\"displayParam\":\"\u65f6\u6bb5\u5c5e\u6027\",\"param\":\"bucket.wtte_buckettime.shifttimebucketproperty\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u73ed\u6b21\u5185\u52a0\u73ed\u65f6\u6bb5\",\"value\":\"1020_03_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"},{\"index\":19,\"name\":\"T20\",\"displayParam\":\"\u5355\u636e\u6807\u8bc6\",\"param\":\"bucket.wtte_buckettime.attendancebilltag\",\"paramType\":\"string\",\"target\":false,\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\"\u51fa\u5dee\u5355\",\"value\":\"1030_S\",\"valueDataType\":\"enum\",\"objectId\":\"\",\"objectNumber\":\"\"}],\"conditionExpressType\":\"2\",\"conditionExpressList\":[{\"name\":\"T01\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T02\",\"logical\":\" and \",\"leftBracket\":\"( ( \",\"rightBracket\":\"\"},{\"name\":\"T03\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T04\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T05\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" )\"},{\"name\":\"T06\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T07\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T08\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T09\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) ) )\"},{\"name\":\"T10\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T11\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T12\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T13\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T14\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\" ) )\"},{\"name\":\"T15\",\"logical\":\" and \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T16\",\"logical\":\" and \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T17\",\"logical\":\" or \",\"leftBracket\":\"( \",\"rightBracket\":\"\"},{\"name\":\"T18\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T19\",\"logical\":\" or \",\"leftBracket\":\"\",\"rightBracket\":\"\"},{\"name\":\"T20\",\"leftBracket\":\"( \",\"rightBracket\":\" ) ) )\",\"logical\":\"\"}],\"conditionExpressStr\":\"( T01 and ( ( T02 and T03 ) or ( T04 and T05 ) or T06 or T07 or ( T08 and T09 ) ) ) or ( T10 and T11 and ( T12 or T13 or T14 ) ) or ( T15 and T16 and ( T17 or T18 or T19 or  T20  ) )\"}".equals(lastJson = (dynamicObject = notCurrentVersion.get(0)).getString("conditions"))) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)DataSourceUpgradeResultEnum.SYS_HAS_UPGRADE);
        }
        return new Tuples.Tuple2((Object)Boolean.TRUE, null);
    }

    private Tuples.Tuple2<DynamicObject, List<DynamicObject>> getVersionInfo(Long boId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_dasoconf");
        QFilter boIdFilter = new QFilter("boid", "=", (Object)boId);
        DynamicObject[] otDataSourceCurrentVersion = serviceHelper.loadDynamicObjectArray(new QFilter[]{boIdFilter});
        if (otDataSourceCurrentVersion.length == 0) {
            return new Tuples.Tuple2(null, null);
        }
        ArrayList<DynamicObject> notCurrentVersion = new ArrayList<DynamicObject>(10);
        DynamicObject currentVersion = null;
        for (DynamicObject dynamicObject : otDataSourceCurrentVersion) {
            boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            if (isCurrentVersion) {
                currentVersion = dynamicObject;
                continue;
            }
            notCurrentVersion.add(dynamicObject);
        }
        notCurrentVersion.sort((o1, o2) -> {
            Date dateO1 = o1.getDate("bsed");
            Date dateO2 = o2.getDate("bsed");
            String versionO1 = o1.getString("hisversion");
            String versionO2 = o2.getString("hisversion");
            dateO1 = dateO1 == null ? WTCDateUtils.str2Date((String)"1900-01-01", (String)"yyyy-MM-dd") : dateO1;
            Date date = dateO2 = dateO2 == null ? WTCDateUtils.str2Date((String)"1900-01-01", (String)"yyyy-MM-dd") : dateO2;
            if (dateO1.compareTo(dateO2) == 0 && HRStringUtils.isNotEmpty((String)versionO1) && HRStringUtils.isNotEmpty((String)versionO2) && versionO1.startsWith("V") && versionO2.startsWith("V")) {
                return Integer.valueOf(versionO1.substring(1)).compareTo(Integer.valueOf(versionO2.substring(1)));
            }
            return dateO1.compareTo(dateO2);
        });
        return new Tuples.Tuple2(currentVersion, notCurrentVersion);
    }
}

