/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.datetype;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.BaseDataUtils;

public class DateTypeService {
    private static final Log LOG = LogFactory.getLog(DateTypeService.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtbd_datetype");
    private static final DateTypeService INS = new DateTypeService();

    private DateTypeService() {
    }

    public static DateTypeService getInstance() {
        return INS;
    }

    public Map<String, Set<Long>> getCountByDateProp(List<String> dateProps) {
        LOG.info("getCountByDateProp:{}", dateProps);
        DynamicObjectCollection dateTypes = HELPER.queryOriginalCollection("id,dateproperty.number", new QFilter[]{new QFilter("dateproperty.number", "in", dateProps)});
        return dateTypes.stream().collect(Collectors.groupingBy(dt -> dt.getString("dateproperty.number"), Collectors.mapping(dy -> dy.getLong("id"), Collectors.toSet())));
    }

    public static Map<Object, BaseDataCheckRefrenceResult> existReferences(String pageNumber, Object[] ids) {
        return BaseDataUtils.existReferences((String)pageNumber, (Object[])ids);
    }
}

