/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.hp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.hp.HpHolidayInfoService;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbd.common.hp.HpInfoCalculateJson;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class HpHolidayCalculateService {
    private static final Log logger = LogFactory.getLog(HpHolidayCalculateService.class);

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> getAllHolidayIdType(List<WorkSchHolidayParam> workSchHolidayParamList) {
        Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> workSchHolidayParamMapMap = this.getAllHolidayInfo(workSchHolidayParamList);
        return this.convertDyToLongAndDateType(this.convertHolidayIdToDy(workSchHolidayParamMapMap));
    }

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> getAllHolidayInfo(List<WorkSchHolidayParam> workSchHolidayParamList) {
        if (CollectionUtils.isEmpty(workSchHolidayParamList)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] hpInfoDys = this.getHpInfoDyByParam(workSchHolidayParamList);
        for (WorkSchHolidayParam workSchHolidayParam : workSchHolidayParamList) {
            LinkedHashMap<Date, List<Long>> dateSetMap = this.groupHoliday(workSchHolidayParam, hpInfoDys);
            result.put(workSchHolidayParam, dateSetMap);
        }
        return result;
    }

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> getConflictedSortedHoliday(List<WorkSchHolidayParam> workSchHolidayParamList) {
        Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> conflictedHolidayIdType = this.getConflictedHolidayIdType(workSchHolidayParamList);
        conflictedHolidayIdType.values().stream().flatMap(dateMap -> dateMap.values().stream()).forEach(this::sortHolidayTuple);
        HashMap workSchHolidayParamMap = Maps.newHashMapWithExpectedSize((int)conflictedHolidayIdType.size());
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> entry : conflictedHolidayIdType.entrySet()) {
            LinkedHashMap<Date, List<Tuple<Long, Long>>> dateMap2 = entry.getValue();
            LinkedHashMap newDateMap = Maps.newLinkedHashMapWithExpectedSize((int)dateMap2.size());
            for (Map.Entry<Date, List<Tuple<Long, Long>>> dateListEntry : dateMap2.entrySet()) {
                newDateMap.put(dateListEntry.getKey(), dateListEntry.getValue().stream().map(tp -> (Long)tp.item1).collect(Collectors.toList()));
            }
            workSchHolidayParamMap.put(entry.getKey(), newDateMap);
        }
        return workSchHolidayParamMap;
    }

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> getConflictedHoliday(List<WorkSchHolidayParam> workSchHolidayParamList) {
        Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> workSchHolidayParamMapMap = this.getConflictedDyInDB(workSchHolidayParamList);
        HashMap result = Maps.newHashMapWithExpectedSize((int)workSchHolidayParamMapMap.size());
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> entry : workSchHolidayParamMapMap.entrySet()) {
            LinkedHashMap resultForEach = Maps.newLinkedHashMapWithExpectedSize((int)entry.getValue().size());
            for (Map.Entry<Date, List<DynamicObject>> holidayIdIt : entry.getValue().entrySet()) {
                resultForEach.put(holidayIdIt.getKey(), this.convertDyToPkId(holidayIdIt.getValue()));
            }
            result.put(entry.getKey(), resultForEach);
        }
        return result;
    }

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> getConflictedHolidayIdType(List<WorkSchHolidayParam> workSchHolidayParamList) {
        Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> workSchHolidayParamMapMap = this.getConflictedDyInDB(workSchHolidayParamList);
        return this.convertDyToLongAndDateType(workSchHolidayParamMapMap);
    }

    private Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Tuple<Long, Long>>>> convertDyToLongAndDateType(Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> dateAndDy) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)dateAndDy.size());
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> entry : dateAndDy.entrySet()) {
            LinkedHashMap resultForEach = Maps.newLinkedHashMapWithExpectedSize((int)entry.getValue().size());
            for (Map.Entry<Date, List<DynamicObject>> holidayIdIt : entry.getValue().entrySet()) {
                resultForEach.put(holidayIdIt.getKey(), this.convertDyToPkIdAndDateTypeList(holidayIdIt.getValue()));
            }
            result.put(entry.getKey(), resultForEach);
        }
        return result;
    }

    private List<Tuple<Long, Long>> convertDyToPkIdAndDateTypeList(List<DynamicObject> holidayDys) {
        if (CollectionUtils.isEmpty(holidayDys)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)holidayDys.size());
        for (DynamicObject holidayDy : holidayDys) {
            result.add(new Tuple((Object)((Long)holidayDy.getPkValue()), (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)holidayDy, (String)"datetype")));
        }
        return result;
    }

    private List<Long> convertDyToPkId(List<DynamicObject> holidayDys) {
        if (CollectionUtils.isEmpty(holidayDys)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)holidayDys.size());
        for (DynamicObject holidayDy : holidayDys) {
            result.add((Long)holidayDy.getPkValue());
        }
        return result;
    }

    private Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> getConflictedDyInDB(List<WorkSchHolidayParam> workSchHolidayParamList) {
        if (CollectionUtils.isEmpty(workSchHolidayParamList)) {
            return Collections.emptyMap();
        }
        DynamicObject[] hpInfoDys = this.getHpInfoDyByParam(workSchHolidayParamList);
        return this.getConflictedDy(workSchHolidayParamList, hpInfoDys);
    }

    public Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> getConflictedDy(List<WorkSchHolidayParam> workSchHolidayParamList, DynamicObject[] hpInfoDys) {
        HashMap workSchHolidayAndId = Maps.newHashMapWithExpectedSize((int)16);
        for (WorkSchHolidayParam workSchHolidayParam : workSchHolidayParamList) {
            LinkedHashMap<Date, List<Long>> dateSetMap = this.groupConflictedHoliday(workSchHolidayParam, hpInfoDys);
            workSchHolidayAndId.put(workSchHolidayParam, dateSetMap);
        }
        Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> beforeFilter = this.convertHolidayIdToDy(workSchHolidayAndId);
        HashMap afterFilterResult = Maps.newHashMapWithExpectedSize((int)beforeFilter.size());
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> entry : beforeFilter.entrySet()) {
            LinkedHashMap<Date, List<DynamicObject>> dateAndHoliday = entry.getValue();
            LinkedHashMap<Date, List<DynamicObject>> newDateAndHoliday = new LinkedHashMap<Date, List<DynamicObject>>(16);
            for (Map.Entry<Date, List<DynamicObject>> holidayIdIt : dateAndHoliday.entrySet()) {
                HashSet dateType = Sets.newHashSetWithExpectedSize((int)16);
                holidayIdIt.getValue().forEach(hpDy -> dateType.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"datetype")));
                if (dateType.size() <= 1) continue;
                newDateAndHoliday.put(holidayIdIt.getKey(), holidayIdIt.getValue());
            }
            afterFilterResult.put(entry.getKey(), newDateAndHoliday);
        }
        return afterFilterResult;
    }

    private Map<WorkSchHolidayParam, LinkedHashMap<Date, List<DynamicObject>>> convertHolidayIdToDy(Map<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> workSchHolidayParamMapMap) {
        if (CollectionUtils.isEmpty(workSchHolidayParamMapMap)) {
            return Collections.emptyMap();
        }
        HashSet holidayIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> entry : workSchHolidayParamMapMap.entrySet()) {
            for (Map.Entry<Date, List<Long>> entry2 : entry.getValue().entrySet()) {
                holidayIdSet.addAll((Collection)entry2.getValue());
            }
        }
        HRBaseServiceHelper holidayService = new HRBaseServiceHelper("wtbd_holiday");
        DynamicObject[] holidayDyArr = holidayService.query(WTCStringUtils.joinOnComma((String[])new String[]{"id", "datetype"}), new QFilter("id", "in", (Object)holidayIdSet).toArray());
        HashMap idAndDy = Maps.newHashMapWithExpectedSize((int)holidayDyArr.length);
        for (DynamicObject holiday : holidayDyArr) {
            idAndDy.put(holiday.getLong("id"), holiday);
        }
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)holidayDyArr.length);
        for (Map.Entry<WorkSchHolidayParam, LinkedHashMap<Date, List<Long>>> entry : workSchHolidayParamMapMap.entrySet()) {
            LinkedHashMap dateInfo = Maps.newLinkedHashMapWithExpectedSize((int)entry.getValue().size());
            for (Map.Entry<Date, List<Long>> holidayIdIt : entry.getValue().entrySet()) {
                dateInfo.put(holidayIdIt.getKey(), this.convertToDy(holidayIdIt.getValue(), idAndDy));
            }
            hashMap.put(entry.getKey(), dateInfo);
        }
        return hashMap;
    }

    private List<DynamicObject> convertToDy(List<Long> holidayIds, Map<Long, DynamicObject> idAndDyAll) {
        if (CollectionUtils.isEmpty(holidayIds)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)idAndDyAll.size());
        for (Long holidayId : holidayIds) {
            result.add(idAndDyAll.get(holidayId));
        }
        return result;
    }

    private DynamicObject[] getHpInfoDyByParam(List<WorkSchHolidayParam> workSchHolidayParamList) {
        HashSet hpBoIds = Sets.newHashSetWithExpectedSize((int)16);
        workSchHolidayParamList.forEach(workSchHolidayParam -> hpBoIds.addAll(workSchHolidayParam.getHolidayPortFolioIds()));
        HRBaseServiceHelper hpInfoService = new HRBaseServiceHelper("wtbd_holidayportfolioinfo");
        DynamicObject[] hpInfoDys = hpInfoService.loadDynamicObjectArray(new QFilter("hp", "in", (Object)hpBoIds).toArray());
        Set<Long> needFreshData = this.passRefreshData(hpBoIds, hpInfoDys);
        if (!CollectionUtils.isEmpty(needFreshData)) {
            this.refreshData(needFreshData);
            return hpInfoService.loadDynamicObjectArray(new QFilter("hp", "in", (Object)hpBoIds).toArray());
        }
        return hpInfoDys;
    }

    private Set<Long> passRefreshData(Set<Long> needQueryHpBoIds, DynamicObject[] existHpInfoDys) {
        HashSet needRefreshData = Sets.newHashSetWithExpectedSize((int)16);
        for (Long needQueryHpBoId : needQueryHpBoIds) {
            boolean exist = false;
            for (DynamicObject existHpInfoDy : existHpInfoDys) {
                long boId = existHpInfoDy.getLong("hp");
                if (boId != needQueryHpBoId) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            needRefreshData.add(needQueryHpBoId);
        }
        return needRefreshData;
    }

    private void refreshData(Set<Long> needRefreshData) {
        HRBaseServiceHelper hpService = new HRBaseServiceHelper("wtbd_holidayportfolio");
        DynamicObject[] hpDys = hpService.loadDynamicObjectArray(new QFilter("boid", "in", needRefreshData).toArray());
        HpHolidayInfoService hpHolidayInfoService = new HpHolidayInfoService();
        DynamicObject[] hpHolidayInfoByHp = hpHolidayInfoService.getHpHolidayInfoByHp(hpDys);
        HRBaseServiceHelper hpInfoService = new HRBaseServiceHelper("wtbd_holidayportfolioinfo");
        hpInfoService.deleteByFilter(new QFilter("hp", "in", needRefreshData).toArray());
        hpInfoService.save(hpHolidayInfoByHp);
    }

    private LinkedHashMap<Date, List<Long>> groupConflictedHoliday(WorkSchHolidayParam workSchHolidayParam, DynamicObject[] hpInfoDys) {
        LinkedHashMap<Date, List<Long>> dateAndHoliday = this.groupHoliday(workSchHolidayParam, hpInfoDys);
        LinkedHashMap dateAndHolidayConflicted = Maps.newLinkedHashMapWithExpectedSize((int)dateAndHoliday.size());
        for (Map.Entry entry : dateAndHoliday.entrySet()) {
            List holidayIds = (List)entry.getValue();
            if (holidayIds.size() <= 1) continue;
            LinkedHashSet idSet = Sets.newLinkedHashSetWithExpectedSize((int)holidayIds.size());
            idSet.addAll(holidayIds);
            dateAndHolidayConflicted.put(entry.getKey(), Lists.newArrayList((Iterable)idSet));
        }
        return dateAndHolidayConflicted;
    }

    public LinkedHashMap<Date, List<Long>> groupHoliday(WorkSchHolidayParam workSchHolidayParam, DynamicObject[] hpInfoDys) {
        if (CollectionUtils.isEmpty((Collection)workSchHolidayParam.getHolidayPortFolioIds())) {
            return new LinkedHashMap<Date, List<Long>>(0);
        }
        Date startDate = workSchHolidayParam.getStartDate();
        Date endDate = workSchHolidayParam.getEndDate();
        if (startDate == null || endDate == null) {
            logger.warn("HpHolidayCalculateService.groupConflictedHoliday workSchHolidayParam.getStartDate() and workSchHolidayParam.getEndDate() can not be null");
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HpHolidayCalculateService_0", (String)"wtc-wtbd-business", (Object[])new Object[0]));
        }
        LinkedHashMap dateAndHoliday = Maps.newLinkedHashMapWithExpectedSize((int)16);
        List holidayPortFolioIds = workSchHolidayParam.getHolidayPortFolioIds();
        if (CollectionUtils.isEmpty((Collection)holidayPortFolioIds)) {
            return new LinkedHashMap<Date, List<Long>>(0);
        }
        for (Long holidayPortFolioId : holidayPortFolioIds) {
            for (DynamicObject hpInfoDy : hpInfoDys) {
                String jsonInfo;
                long hpBoId = hpInfoDy.getLong("hp");
                if (!holidayPortFolioId.equals(hpBoId) || HRStringUtils.isEmpty((String)(jsonInfo = hpInfoDy.getString("calculatejson")))) continue;
                List hpInfoCalculateJsonList = SerializationUtils.fromJsonStringToList((String)jsonInfo, HpInfoCalculateJson.class);
                for (HpInfoCalculateJson hpInfoCalculateJson : hpInfoCalculateJsonList) {
                    Date holidayAbsoluteDate = hpInfoCalculateJson.getHolidayAbsoluteDate();
                    if (holidayAbsoluteDate == null || !WTCDateUtils.betweenDay((Date)holidayAbsoluteDate, (Date)startDate, (Date)endDate)) continue;
                    HpHolidayCalculateService.addToMap(dateAndHoliday, hpInfoCalculateJson.getHolidayId(), holidayAbsoluteDate);
                }
            }
        }
        LinkedHashMap dateAndHolidayList = Maps.newLinkedHashMapWithExpectedSize((int)16);
        dateAndHoliday.forEach((date, id) -> dateAndHolidayList.put(date, Lists.newArrayList((Iterable)id)));
        return dateAndHolidayList;
    }

    private static void addToMap(Map<Date, LinkedHashSet<Long>> resultMap, long holidayId, Date fullDay) {
        LinkedHashSet holidayIds = resultMap.computeIfAbsent(fullDay, val -> new LinkedHashSet(16));
        holidayIds.add(holidayId);
    }

    public void sortHolidayTuple(List<Tuple<Long, Long>> holidayTuples) {
        Tuple<Long, Long> tmp;
        Tuple<Long, Long> holidayTuple;
        int pos;
        int i;
        for (i = pos = 0; i < holidayTuples.size(); ++i) {
            holidayTuple = holidayTuples.get(i);
            if (!DateTypeEnum.HOLIDAY_PAID.getId().equals(holidayTuple.item2)) continue;
            tmp = holidayTuples.get(pos);
            holidayTuples.set(pos++, holidayTuple);
            holidayTuples.set(i, tmp);
        }
        for (i = pos; i < holidayTuples.size(); ++i) {
            holidayTuple = holidayTuples.get(i);
            if (!DateTypeEnum.HOLIDAY_HALF_PAID.getId().equals(holidayTuple.item2)) continue;
            tmp = holidayTuples.get(pos);
            holidayTuples.set(pos++, holidayTuple);
            holidayTuples.set(i, tmp);
        }
    }
}

