/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.hp;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.hp.HpInfoCalculateJson;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class HpHolidayInfoService {
    private static final Log logger = LogFactory.getLog(HpHolidayInfoService.class);

    public DynamicObject[] getHpHolidayInfoByHp(DynamicObject[] hpDys) {
        if (hpDys == null || hpDys.length == 0) {
            return new DynamicObject[0];
        }
        DynamicObject[] hpAllHisDys = this.getHpAllHisDysByBoId(hpDys);
        Map<Long, List<DynamicObject>> groupHisHpByBoIdMap = this.groupByBoId(hpAllHisDys);
        Map<Long, Date> boIdAndUpdateTime = this.getBoIdAndUpdateTime(hpDys);
        ArrayList hpInfoDyList = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<Long, List<DynamicObject>> hisHpBoEntry : groupHisHpByBoIdMap.entrySet()) {
            List<DynamicObject> hisHpDy = hisHpBoEntry.getValue();
            Long hpBoId = hisHpBoEntry.getKey();
            hpInfoDyList.add(this.getHpInfoDy(hpBoId, hisHpDy, boIdAndUpdateTime));
        }
        return hpInfoDyList.toArray(new DynamicObject[0]);
    }

    private Map<Long, Date> getBoIdAndUpdateTime(DynamicObject[] hpDys) {
        HashSet boIds = Sets.newHashSetWithExpectedSize((int)hpDys.length);
        for (DynamicObject hpDy : hpDys) {
            boIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_holidayportfolio");
        QFilter dateQFilter = new QFilter("boid", "in", (Object)boIds);
        dateQFilter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] hpCurrentDys = serviceHelper.query(WTCStringUtils.joinOnComma((String[])new String[]{"boid", "modifytime"}), dateQFilter.toArray());
        HashMap boIdAndUpdateTime = Maps.newHashMapWithExpectedSize((int)hpCurrentDys.length);
        for (DynamicObject hpCurrentDy : hpCurrentDys) {
            boIdAndUpdateTime.put(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpCurrentDy, (String)"boid"), hpCurrentDy.getDate("modifytime"));
        }
        return boIdAndUpdateTime;
    }

    public DynamicObject getHpInfoDy(long hpDyBoId, List<DynamicObject> hisHpDy, Map<Long, Date> boIdAndUpdateTimeInfo) {
        List<HolidayCompare> allHolidayCompare = this.getAllHolidayCompare(hisHpDy);
        List<Object> hpInfoCalculateJson = this.getHpInfoCalculateJson(allHolidayCompare);
        if (CollectionUtils.isEmpty(hpInfoCalculateJson)) {
            hpInfoCalculateJson = Collections.emptyList();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_holidayportfolioinfo");
        DynamicObject hpInfo = serviceHelper.generateEmptyDynamicObject();
        hpInfo.set("hp", (Object)hpDyBoId);
        hpInfo.set("hpupdatetime", (Object)boIdAndUpdateTimeInfo.get(hpDyBoId));
        hpInfo.set("calculatejson", (Object)SerializationUtils.toJsonString(hpInfoCalculateJson));
        return hpInfo;
    }

    private List<HpInfoCalculateJson> getHpInfoCalculateJson(List<HolidayCompare> holidayCompareList) {
        if (CollectionUtils.isEmpty(holidayCompareList)) {
            return Collections.emptyList();
        }
        holidayCompareList.sort((o1, o2) -> {
            long o1Time = o1.getHolidayAbsoluteDate().getTime();
            long o2Time = o2.getHolidayAbsoluteDate().getTime();
            return Long.compare(o1Time, o2Time);
        });
        ArrayList result = Lists.newArrayListWithExpectedSize((int)holidayCompareList.size());
        for (HolidayCompare holidayCompare : holidayCompareList) {
            HpInfoCalculateJson hpInfoCalculateJson = new HpInfoCalculateJson();
            hpInfoCalculateJson.setHolidayId(((Long)holidayCompare.getHolidayDy().getPkValue()).longValue());
            hpInfoCalculateJson.setHolidayAbsoluteDate(holidayCompare.getHolidayAbsoluteDate());
            result.add(hpInfoCalculateJson);
        }
        return result;
    }

    private DynamicObject[] getHpAllHisDysByBoId(DynamicObject[] hpDys) {
        if (hpDys == null) {
            return new DynamicObject[0];
        }
        HashSet boIds = Sets.newHashSetWithExpectedSize((int)hpDys.length);
        for (DynamicObject hpDy : hpDys) {
            boIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid"));
        }
        QFilter dateQFilter = new QFilter("boid", "in", (Object)boIds);
        dateQFilter.and("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2", "0"}));
        dateQFilter.and("iscurrentversion", "!=", (Object)"1");
        dateQFilter.and("status", "=", (Object)"C");
        dateQFilter.and("enable", "=", (Object)"1");
        HRBaseServiceHelper hpService = new HRBaseServiceHelper("wtbd_holidayportfolio");
        String field = WTCStringUtils.joinOnComma((String[])new String[]{WTCStringUtils.joinOnDot((String[])new String[]{"holidayentity", "holiday"}), WTCStringUtils.joinOnDot((String[])new String[]{"holidayentity", "holidaytype"}), WTCStringUtils.joinOnDot((String[])new String[]{"holidayentity", "startyear"}), WTCStringUtils.joinOnDot((String[])new String[]{"holidayentity", "endyear"}), "bsed", "bsled", "boid"});
        return hpService.query(field, dateQFilter.toArray());
    }

    private Map<Long, List<DynamicObject>> groupByBoId(DynamicObject[] allHisHpDys) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)allHisHpDys.length);
        for (DynamicObject hpDy : allHisHpDys) {
            Long hpBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid");
            HpHolidayInfoService.addToMap(resultMap, hpDy, hpBoId);
        }
        return resultMap;
    }

    private List<HolidayCompare> getAllHolidayCompare(List<DynamicObject> hpDys) {
        ArrayList allHolidayCompare = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject hpDy : hpDys) {
            ArrayList holidayCompareInOneHpList = Lists.newArrayListWithExpectedSize((int)10);
            Date hpBsed = hpDy.getDate("bsed");
            Date hpBsled = hpDy.getDate("bsled");
            DynamicObjectCollection entry = hpDy.getDynamicObjectCollection("holidayentity");
            for (DynamicObject entryDy : entry) {
                holidayCompareInOneHpList.addAll(this.getHolidayCompare(entryDy, hpBsed, hpBsled));
            }
            holidayCompareInOneHpList.forEach(holidayCompare -> {
                holidayCompare.setHpDy(hpDy);
                holidayCompare.setHpBsed(hpBsed);
                holidayCompare.setHpBsled(hpBsled);
            });
            allHolidayCompare.addAll(holidayCompareInOneHpList);
        }
        return allHolidayCompare;
    }

    private List<HolidayCompare> getHolidayCompare(DynamicObject entryDy, Date hpBsed, Date hpBsled) {
        Date holidayStartDate = entryDy.getDate("startyear");
        Date holidayEndDate = entryDy.getDate("endyear");
        if (holidayStartDate == null || holidayEndDate == null) {
            return Collections.emptyList();
        }
        holidayStartDate = WTCDateUtils.getBeginDayOfYear((Date)holidayStartDate);
        holidayEndDate = WTCDateUtils.getEndDayOfYear((Date)holidayEndDate);
        Date calculateStart = hpBsed;
        Date calculateEnd = hpBsled == null ? WTCDateUtils.getMaxEndDate() : hpBsled;
        calculateStart = holidayStartDate.getTime() > calculateStart.getTime() ? holidayStartDate : calculateStart;
        calculateEnd = holidayEndDate.getTime() < calculateEnd.getTime() ? holidayEndDate : calculateEnd;
        Set<String> holidayAbsoluteDates = this.getHoliday(entryDy.getDynamicObject("holiday"), calculateStart, calculateEnd);
        ArrayList holidayCompareList = Lists.newArrayListWithExpectedSize((int)10);
        for (String holidayAbsoluteDate : holidayAbsoluteDates) {
            Date holidayDate = null;
            try {
                holidayDate = HRDateTimeUtils.parseDate((String)holidayAbsoluteDate, (String)"yyyy-MM-dd");
            }
            catch (ParseException parseException) {
                logger.warn("getHolidayCompare convert date error", (Throwable)parseException);
                throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u8f6c\u6362\u9519\u8bef", (String)"HpHolidayInfoService_0", (String)"wtc-wtbd-business", (Object[])new Object[0]));
            }
            HolidayCompare holidayCompare = new HolidayCompare();
            holidayCompare.setHolidayDy(entryDy.getDynamicObject("holiday"));
            holidayCompare.setHolidayAbsoluteDate(holidayDate);
            holidayCompareList.add(holidayCompare);
        }
        return holidayCompareList;
    }

    private Set<String> getHoliday(DynamicObject holiday, Date startYear, Date endYear) {
        if (holiday == null) {
            logger.info("HpHolidayInfoService.getHoliday  holiday is null");
            return Collections.emptySet();
        }
        int startYearInt = Integer.parseInt(HRDateTimeUtils.format((Date)startYear, (String)"yyyy"));
        int endYearInt = Integer.parseInt(HRDateTimeUtils.format((Date)endYear, (String)"yyyy"));
        String holidayType = holiday.getString("holidaytype");
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        if ("A".equals(holidayType)) {
            resultSet.addAll(this.getHolidayFix(holiday, startYearInt, endYearInt));
        } else if ("B".equals(holidayType)) {
            resultSet.addAll(this.getHolidayUnFix(holiday, startYearInt, endYearInt));
        }
        logger.info("HpHolidayInfoService.getHoliday \u8fc7\u6ee4\u524d\u7684\u65e5\u671f resultSet={}", (Object)JSON.toJSONString((Object)resultSet));
        Iterator timeResultIterator = resultSet.iterator();
        while (timeResultIterator.hasNext()) {
            String timeStr = (String)timeResultIterator.next();
            Date time = null;
            try {
                time = HRDateTimeUtils.parseDate((String)timeStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException ex) {
                logger.info("HpHolidayInfoService.getHoliday \u65f6\u95f4\u8f6c\u6362\u9519\u8bef,\u4e0d\u52a0\u5165\u7ed3\u679c\u96c6,timeStr = {}", (Object)timeStr);
                timeResultIterator.remove();
                continue;
            }
            if (WTCDateUtils.betweenDay((Date)time, (Date)startYear, (Date)endYear)) continue;
            timeResultIterator.remove();
        }
        return resultSet;
    }

    private Set<String> getHolidayUnFix(DynamicObject holiday, int startYearInt, int endYearInt) {
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet<String> yearMonthSet = new HashSet<String>(16);
        for (int i = startYearInt; i <= endYearInt; ++i) {
            yearMonthSet.add(String.valueOf(i));
        }
        DynamicObjectCollection unfixEntryCollection = holiday.getDynamicObjectCollection("unfixentry");
        for (DynamicObject dy : unfixEntryCollection) {
            Date ufstartdate = dy.getDate("ufstartdate");
            Date ufenddate = dy.getDate("ufenddate");
            int days = this.daysBetween(ufstartdate, ufenddate) + 1;
            for (int i = 0; i < days; ++i) {
                Date currDate = HRDateTimeUtils.addDay((Date)ufstartdate, (long)i);
                String currDateStr = HRDateTimeUtils.format((Date)currDate, (String)"yyyy-MM-dd");
                String currYearMonth = HRDateTimeUtils.format((Date)currDate, (String)"yyyy");
                if (!yearMonthSet.contains(currYearMonth)) continue;
                resultSet.add(currDateStr);
            }
        }
        return resultSet;
    }

    private Set<String> getHolidayFix(DynamicObject holiday, int startYearInt, int endYearInt) {
        HashSet resultSet;
        block3: {
            String fixedType;
            block2: {
                resultSet = Sets.newHashSetWithExpectedSize((int)16);
                fixedType = holiday.getString("fixedtype");
                if (!"A".equals(fixedType)) break block2;
                int month = holiday.getInt("month");
                int day = holiday.getInt("day");
                String monthStr = month < 10 ? "0" + month : month + "";
                String dayStr = day < 10 ? "0" + day : day + "";
                for (int i = startYearInt; i <= endYearInt; ++i) {
                    String fullDay = i + "-" + monthStr + "-" + dayStr;
                    resultSet.add(fullDay);
                }
                break block3;
            }
            if (!"B".equals(fixedType)) break block3;
            int dymonth = holiday.getInt("dymonth");
            int week = holiday.getInt("week");
            int dyday = holiday.getInt("dyday");
            for (int i = startYearInt; i < endYearInt + 1; ++i) {
                String fullDay = this.getLocalDateStr(i, dymonth, week, dyday);
                if (!HRStringUtils.isNotEmpty((String)fullDay)) continue;
                resultSet.add(fullDay);
            }
        }
        return resultSet;
    }

    private int daysBetween(Date startDate, Date endDate) {
        long intervalMs = endDate.getTime() - startDate.getTime();
        return HpHolidayInfoService.millisecondsToDays(intervalMs);
    }

    private static int millisecondsToDays(long intervalMs) {
        return (int)(intervalMs / 86400000L);
    }

    private String getLocalDateStr(int year, int month, int weekOfMonth, int dayOfWeek) {
        Map<Integer, List<Date>> dateInWeek = this.getDateInWeek(year, month);
        List<Date> date = dateInWeek.get(dayOfWeek = ++dayOfWeek == 8 ? 1 : dayOfWeek);
        if (CollectionUtils.isEmpty(date)) {
            return "";
        }
        Date result = null;
        if (weekOfMonth == -1 && date.size() > 0) {
            result = date.get(date.size() - 1);
        } else if (date.size() >= weekOfMonth) {
            result = date.get(weekOfMonth - 1);
        }
        if (result == null) {
            return "";
        }
        return HRDateTimeUtils.format(result, (String)"yyyy-MM-dd");
    }

    private Map<Integer, List<Date>> getDateInWeek(int year, int month) {
        int currMonth = month - 1;
        Calendar instance = Calendar.getInstance();
        instance.setFirstDayOfWeek(1);
        instance.set(10, 0);
        instance.set(12, 0);
        instance.set(14, 0);
        instance.set(1, year);
        instance.set(2, currMonth);
        instance.set(5, 1);
        HashMap weekMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 1; i <= 7; ++i) {
            weekMap.put(i, new ArrayList(16));
        }
        while (instance.get(2) == currMonth) {
            int day = instance.get(7);
            List dates = (List)weekMap.get(day);
            dates.add(instance.getTime());
            instance.add(5, 1);
        }
        return weekMap;
    }

    private static void addToMap(Map<Long, List<DynamicObject>> resultMap, DynamicObject hpDy, Long hpBoId) {
        List hpDys = resultMap.computeIfAbsent(hpBoId, val -> new ArrayList(10));
        hpDys.add(hpDy);
    }

    private static class HolidayCompare {
        private DynamicObject hpDy;
        private DynamicObject holidayDy;
        private Date hpBsed;
        private Date hpBsled;
        private Date holidayAbsoluteDate;

        private HolidayCompare() {
        }

        public DynamicObject getHpDy() {
            return this.hpDy;
        }

        public void setHpDy(DynamicObject hpDy) {
            this.hpDy = hpDy;
        }

        public DynamicObject getHolidayDy() {
            return this.holidayDy;
        }

        public void setHolidayDy(DynamicObject holidayDy) {
            this.holidayDy = holidayDy;
        }

        public Date getHpBsed() {
            return this.hpBsed;
        }

        public void setHpBsed(Date hpBsed) {
            this.hpBsed = hpBsed;
        }

        public Date getHpBsled() {
            return this.hpBsled;
        }

        public void setHpBsled(Date hpBsled) {
            this.hpBsled = hpBsled;
        }

        public Date getHolidayAbsoluteDate() {
            return this.holidayAbsoluteDate;
        }

        public void setHolidayAbsoluteDate(Date holidayAbsoluteDate) {
            this.holidayAbsoluteDate = holidayAbsoluteDate;
        }
    }
}

