/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class DataReaderHelper {
    public static final String CODE_MAP = "codeMap";
    public static final String SOURCE_MAP = "sourceMap";

    public static Map<String, Map<String, String>> getPropertyClassMap(Map<String, EntityType> propertieCollection) {
        HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>(2);
        Map propertyClassMap = dataMap.computeIfAbsent(CODE_MAP, codeMap -> new HashMap(16));
        Map propertyNameMap = dataMap.computeIfAbsent("nameMap", nameMap -> new HashMap(16));
        Map sourceMap = dataMap.computeIfAbsent(SOURCE_MAP, nameMap -> new HashMap(16));
        for (Map.Entry<String, EntityType> entry : propertieCollection.entrySet()) {
            String key = entry.getKey();
            EntityType entityType = entry.getValue();
            Map fields = entityType.getFields();
            String prix = entityType instanceof EntryType ? key + "." : "";
            String namePrix = entityType instanceof EntryType ? entityType.getDisplayName() + "." : "";
            propertyClassMap.put("id", ConditionFieldTypeEnum.TYPE_ID.getCode());
            propertyNameMap.put("id", "FId");
            List<IDataEntityProperty> propertyList = fields.values().stream().collect(Collectors.toList());
            DataReaderHelper.doGetPropertyClassMap(propertyClassMap, propertyNameMap, prix, propertyList, namePrix, sourceMap);
        }
        return dataMap;
    }

    public static void doGetPropertyClassMap(Map<String, String> propertyClassMap, Map<String, String> propertyNameMap, String prix, List<IDataEntityProperty> properties, String namePrix, Map<String, String> sourceMap) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof MulComboProp) continue;
            if (property instanceof TimeProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_NUM.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof BooleanProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_BOOLEAN.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof TextProp || property instanceof AdminDivisionProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_TEXT.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof ComboProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ENUM.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof DateTimeProp) {
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_DATE.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (property instanceof DecimalProp) {
                if (WTCStringUtils.equals((String)"boid", (String)property.getName())) {
                    propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ID.getCode());
                    propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                    continue;
                }
                propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_NUM.getCode());
                propertyNameMap.put(prix + property.getName(), namePrix + property.getDisplayName());
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            DataEntityPropertyCollection childProperties = ((BasedataProp)property).getDynamicComplexPropertyType().getProperties();
            List<IDataEntityProperty> childPropertieList = childProperties.stream().collect(Collectors.toList());
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            propertyClassMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ID.getCode());
            propertyNameMap.put(prix + property.getName(), ConditionFieldTypeEnum.TYPE_ID.getCode());
            if (WTCCollections.isNotEmpty(childPropertieList)) {
                propertyNameMap.put(prix + property.getName() + ".id", namePrix + property.getDisplayName() + "." + ((IDataEntityProperty)childPropertieList.get(0)).getAlias());
            }
            sourceMap.put(prix + property.getName() + ".id", baseEntityId);
            propertyClassMap.put(prix + property.getName() + ".id", baseEntityId);
            DataReaderHelper.doGetPropertyClassMap(propertyClassMap, propertyNameMap, prix + property.getName() + ".", childPropertieList, namePrix + property.getDisplayName() + ".", sourceMap);
        }
    }
}

