/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalItemCheckResultVo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class RetrievalConfigHelper {
    public static RetrievalItemCheckResultVo checkBatchFetchItemEnableByIds(List<Long> fetchItemIds, long fetchConfigId) {
        DynamicObjectCollection fetchConfigItems = RetrievalConfigHelper.selectRetrievalItemUsedByIds(fetchItemIds);
        if (WTCCollections.isEmpty((Collection)fetchConfigItems)) {
            return new RetrievalItemCheckResultVo("0");
        }
        ArrayList<String> relatedItemList = new ArrayList<String>(10);
        for (DynamicObject obj : fetchConfigItems) {
            long configId = obj.getLong("config.id");
            if (configId <= 0L || configId == fetchConfigId) continue;
            relatedItemList.add(obj.getString("name"));
        }
        if (WTCCollections.isEmpty(relatedItemList)) {
            return new RetrievalItemCheckResultVo("0");
        }
        return new RetrievalItemCheckResultVo("3", relatedItemList);
    }

    public static String getSwitchDataType(String dataType, String entryType) {
        if (WTCStringUtils.equals((String)entryType, (String)"fetchfieldentry")) {
            if (WTCStringUtils.equals((String)dataType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
                dataType = ConditionFieldTypeEnum.TYPE_TEXT.getCode();
            }
        } else if (WTCStringUtils.equals((String)entryType, (String)"relationentry") && WTCStringUtils.equals((String)dataType, (String)ConditionFieldTypeEnum.TYPE_BOOLEAN.getCode())) {
            dataType = ConditionFieldTypeEnum.TYPE_ENUM.getCode();
        }
        return dataType;
    }

    public static RetrievalItemCheckResultVo checkFetchConfigItemCycle(long configId, String configName, List<String> relationItemIdList, List<Long> fetchItemIds) {
        DynamicObjectCollection fetchConfigItems = RetrievalConfigHelper.selectAllRetrievalItemUsed(configId);
        if (configId == 0L) {
            configId = 123456789123456789L;
        }
        HashSet<Long> configIdSet = new HashSet<Long>(16);
        HashSet<Long> enableConfigList = new HashSet<Long>(10);
        HashMap<Long, String> configNameMap = new HashMap<Long, String>(16);
        configIdSet.add(configId);
        enableConfigList.add(configId);
        configNameMap.put(configId, configName);
        Map<Long, List<String>> allConfigFilterItemMap = RetrievalConfigHelper.assembleAllConfigFilterItemMap(configIdSet, enableConfigList, configNameMap);
        allConfigFilterItemMap.put(configId, relationItemIdList);
        Map<String, Long> itemConfigMap = RetrievalConfigHelper.assembleItemConfigMap(fetchConfigItems, configIdSet);
        long finalConfigId = configId;
        fetchItemIds.forEach(item -> itemConfigMap.put(String.valueOf(item), finalConfigId));
        Set<Long> curFilterConfigSet = RetrievalConfigHelper.assembleConfigItemMap(relationItemIdList, itemConfigMap);
        ArrayList<String> configPathList = new ArrayList<String>(10);
        ArrayList<Long> errConfigList = new ArrayList<Long>(10);
        boolean checkFlag = RetrievalConfigHelper.execCheckCycle(true, configId, configPathList, null, curFilterConfigSet, allConfigFilterItemMap, itemConfigMap, errConfigList, enableConfigList);
        if (!checkFlag) {
            return new RetrievalItemCheckResultVo("1", RetrievalConfigHelper.getConfigNameById(errConfigList, configNameMap));
        }
        return new RetrievalItemCheckResultVo("0");
    }

    private static boolean execCheckCycle(boolean isFirst, long configId, List<String> configPathList, StringBuilder configPathSb, Set<Long> curFilterConfigSet, Map<Long, List<String>> allConfigFilterItemMap, Map<String, Long> itemConfigMap, List<Long> errConfigList, Set<Long> enableConfigList) {
        for (Long filterConfigId : curFilterConfigSet) {
            if (isFirst) {
                configPathSb = new StringBuilder(String.valueOf(configId));
            }
            if (filterConfigId - configId == 0L) {
                RetrievalConfigHelper.addErrConfig(configPathSb, errConfigList);
                return false;
            }
            if (!enableConfigList.contains(filterConfigId)) continue;
            if (configPathSb.toString().contains(filterConfigId + "")) {
                RetrievalConfigHelper.addErrConfig(configPathSb, errConfigList);
                return false;
            }
            configPathSb.append('#').append(filterConfigId);
            List<String> filterItemList = allConfigFilterItemMap.get(filterConfigId);
            if (WTCCollections.isEmpty(filterItemList)) {
                configPathList.add(configPathSb.toString());
                continue;
            }
            Set<Long> filterConfigSet = RetrievalConfigHelper.assembleConfigItemMap(filterItemList, itemConfigMap);
            boolean flag = RetrievalConfigHelper.execCheckCycle(false, configId, configPathList, configPathSb, filterConfigSet, allConfigFilterItemMap, itemConfigMap, errConfigList, enableConfigList);
            if (flag) continue;
            return flag;
        }
        return true;
    }

    private static void addErrConfig(StringBuilder configPathSb, List<Long> errConfigList) {
        String[] errConfigArr = configPathSb.toString().split("#");
        List errConfigs = Arrays.stream(errConfigArr).map(Long::parseLong).collect(Collectors.toList());
        errConfigList.addAll(errConfigs);
    }

    private static Map<Long, List<String>> assembleAllConfigFilterItemMap(Set<Long> configIdSet, Set<Long> enableConfigList, Map<Long, String> configMap) {
        HashMap<Long, List<String>> allConfigFilterItemMap = new HashMap<Long, List<String>>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_retrievalconfig");
        QFilter filter = new QFilter("relationentry.valuetype", "=", (Object)ConditionValueTypeEnum.TYPE_FTITEM.getCode());
        DynamicObjectCollection configItemObjs = helper.queryOriginalCollection("id,name,relationentry.comparevalue,enable", new QFilter[]{filter});
        for (DynamicObject obj : configItemObjs) {
            long configId = obj.getLong("id");
            String itemId = obj.getString("relationentry.comparevalue");
            String configName = obj.getString("name");
            List itemList = allConfigFilterItemMap.computeIfAbsent(configId, list -> new ArrayList(10));
            if (WTCStringUtils.isEmpty((String)itemId)) continue;
            if (itemId.contains(";")) {
                String[] itemArr = itemId.split(";");
                Collections.addAll(itemList, itemArr);
            } else {
                itemList.add(itemId);
            }
            configIdSet.add(configId);
            configMap.put(configId, configName);
            enableConfigList.add(configId);
        }
        return allConfigFilterItemMap;
    }

    private static Set<Long> assembleConfigItemMap(List<String> relationItemList, Map<String, Long> itemConfigMap) {
        HashSet<Long> configSet = new HashSet<Long>(16);
        for (String itemId : relationItemList) {
            Long configId = itemConfigMap.get(itemId);
            if (configId == null) continue;
            configSet.add(configId);
        }
        return configSet;
    }

    private static Map<String, Long> assembleItemConfigMap(DynamicObjectCollection fetchConfigItems, Set<Long> configIdSet) {
        HashMap<String, Long> itemConfigMap = new HashMap<String, Long>(16);
        for (DynamicObject obj : fetchConfigItems) {
            String itemId = obj.getString("id");
            long config = obj.getLong("config.id");
            itemConfigMap.put(itemId, config);
            configIdSet.add(config);
        }
        return itemConfigMap;
    }

    public static List<Long> getRelatedFetchItemIdByFetchConfigId(Long fetchConfigId) {
        ArrayList<Long> codeList = new ArrayList<Long>(10);
        DynamicObjectCollection dynamicObjects = RetrievalConfigHelper.selectAllRetrievalItemUsed(fetchConfigId);
        if (WTCCollections.isEmpty((Collection)dynamicObjects)) {
            return codeList;
        }
        for (DynamicObject obj : dynamicObjects) {
            long fetchItemId = obj.getLong("id");
            if (fetchItemId == 0L) continue;
            codeList.add(fetchItemId);
        }
        return codeList;
    }

    public static List<String> getConfigNameById(List<Long> idList, Map<Long, String> configNameMap) {
        ArrayList<String> nameList = new ArrayList<String>(10);
        idList.stream().forEach(single -> nameList.add((String)configNameMap.get(single)));
        return nameList;
    }

    public static DynamicObject[] selectRetrievalItemList(List<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
        QFilter filter = new QFilter("id", "in", ids);
        return helper.query("id,numberx,name,uniquecode,config.id,config.name,type,way,parent.grouptype,grouptype,isleaf,level", new QFilter[]{filter});
    }

    public static DynamicObjectCollection selectRetrievalItemUsedByIds(List<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("config.id", "!=", (Object)0);
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection("id,numberx,name,uniquecode,config.id,config.name,type,way,parent.grouptype,grouptype,isleaf,level", new QFilter[]{filter});
        return fetchConfigItems;
    }

    public static DynamicObjectCollection selectAllRetrievalItemUsed(Long configId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
        QFilter filter = new QFilter("config.id", "!=", (Object)0);
        if (configId != null && configId != 0L) {
            filter.and("config.id", "!=", (Object)configId);
        }
        DynamicObjectCollection fetchConfigItems = helper.queryOriginalCollection("id,numberx,name,uniquecode,config.id,config.name,type,way,parent.grouptype,grouptype,isleaf,level", new QFilter[]{filter});
        return fetchConfigItems;
    }

    public static Map<String, String> queryUsedItemConfigMap(Set<String> fetchItemIdSet) {
        HashMap<String, String> configItemMap = new HashMap<String, String>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_retrievalconfig");
        QFilter filter = new QFilter("relationentry.comparevalue", "in", fetchItemIdSet);
        filter.and(new QFilter("relationentry.valuetype", "=", (Object)ConditionValueTypeEnum.TYPE_FTITEM.getCode()));
        DynamicObjectCollection configItemObjs = helper.queryOriginalCollection("name,relationentry.comparevalue", new QFilter[]{filter});
        if (WTCCollections.isEmpty((Collection)configItemObjs)) {
            return configItemMap;
        }
        for (DynamicObject configItemObj : configItemObjs) {
            String fetchItemId = configItemObj.getString("relationentry.comparevalue");
            configItemMap.put(fetchItemId, configItemObj.getString("name"));
        }
        return configItemMap;
    }
}

