/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.retrieval.PreDataRetrievalRule;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class RetrievalItemConfigUpgradeService {
    private static final Log LOG = LogFactory.getLog(RetrievalItemConfigUpgradeService.class);

    public void upgrade() {
        DynamicObject[] allRules;
        LOG.info("\u5347\u7ea7retrievalWay\uff0cuniqueCode-\u9488\u5bf9\u6807\u51c6\u53d6\u6570\uff0c\u9700\u8981\u505a\u5230\u901a\u7528\u5316\u5904\u7406\u5f00\u59cb\u3002");
        ImmutableSet itemIds = ImmutableSet.of((Object)1807888947171322880L, (Object)1800051594683764736L, (Object)1807891020407400448L, (Object)1800058978193921024L, (Object)1800058909449278464L, (Object)1800049773844124672L, (Object[])new Long[]{1800069503699144704L, 1800069282843873280L, 1800068793762861056L, 1800068269944623104L, 1800068166949294080L, 1800068071713427456L, 1827472773874839552L, 1797196983593637888L, 1792788237807379456L});
        QFilter qFilter = new QFilter("entryentity.subentryentity.fieldid", "in", (Object)itemIds);
        HRBaseServiceHelper ruleHelper = HRBaseServiceHelper.create((String)"wtbd_scenerulecfg");
        for (DynamicObject rule : allRules = ruleHelper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            DynamicObject[] timeCutConfigDys;
            DynamicObjectCollection entryCollection;
            DynamicObjectCollection entryEntity;
            Map<String, String> paramKeyMap = this.getParamKeyMap(rule, (Set<Long>)itemIds);
            if (paramKeyMap.isEmpty()) continue;
            DynamicObjectCollection updateCollection = new DynamicObjectCollection();
            long ruleId = rule.getLong("id");
            if (ruleId == PreDataRetrievalRule.PD_1010_S) {
                HRBaseServiceHelper otBaseSetServiceHelper = HRBaseServiceHelper.create((String)"wtp_otbaseset");
                DynamicObject[] otBaseSettDys = otBaseSetServiceHelper.loadDynamicObjectArray(new QFilter[0]);
                this.setUpdateCollection(updateCollection, otBaseSettDys, paramKeyMap, "daterangecondition");
                if (WTCCollections.isNotEmpty((Collection)updateCollection)) {
                    otBaseSetServiceHelper.save(updateCollection);
                }
            }
            if (ruleId == PreDataRetrievalRule.PD_1020_S || ruleId == PreDataRetrievalRule.PD_1030_S) {
                DynamicObject[] overWorkRuleDys;
                HRBaseServiceHelper overWorkRuleServiceHelper = HRBaseServiceHelper.create((String)"wtp_overworkrule");
                for (DynamicObject dy : overWorkRuleDys = overWorkRuleServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                    entryEntity = dy.getDynamicObjectCollection("overworkcalentry");
                    if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                    entryCollection = new DynamicObjectCollection();
                    this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "daterangecondition");
                    this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "limitscope");
                    if (!WTCCollections.isNotEmpty((Collection)entryCollection)) continue;
                    updateCollection.add((Object)dy);
                }
                if (WTCCollections.isNotEmpty((Collection)updateCollection)) {
                    overWorkRuleServiceHelper.save(updateCollection);
                }
            }
            if (ruleId == PreDataRetrievalRule.PD_1050_S) {
                DynamicObject[] swShiftRuleDys;
                HRBaseServiceHelper swShiftRuleServiceHelper = HRBaseServiceHelper.create((String)"wtp_swshiftrule");
                for (DynamicObject dy : swShiftRuleDys = swShiftRuleServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                    entryEntity = dy.getDynamicObjectCollection("entryentity");
                    if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                    entryCollection = new DynamicObjectCollection();
                    this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "limitscope");
                    if (!WTCCollections.isNotEmpty((Collection)entryCollection)) continue;
                    updateCollection.add((Object)dy);
                }
                if (WTCCollections.isNotEmpty((Collection)updateCollection)) {
                    swShiftRuleServiceHelper.save(updateCollection);
                }
            }
            if (ruleId != PreDataRetrievalRule.PD_1060_S) continue;
            HRBaseServiceHelper timeCutConfigServiceHelper = HRBaseServiceHelper.create((String)"wtp_timecut");
            for (DynamicObject dy : timeCutConfigDys = timeCutConfigServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                entryEntity = dy.getDynamicObjectCollection("timecutentry");
                if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                entryCollection = new DynamicObjectCollection();
                this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "beforedaycond");
                this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "beforedaycond");
                this.setUpdateCollection(entryCollection, new ArrayList(entryEntity).toArray(new DynamicObject[0]), paramKeyMap, "afterdaycond");
                if (!WTCCollections.isNotEmpty((Collection)entryCollection)) continue;
                updateCollection.add((Object)dy);
            }
            if (!WTCCollections.isNotEmpty((Collection)updateCollection)) continue;
            timeCutConfigServiceHelper.save(updateCollection);
        }
        LOG.info("\u5347\u7ea7retrievalWay\uff0cuniqueCode-\u9488\u5bf9\u6807\u51c6\u53d6\u6570\uff0c\u9700\u8981\u505a\u5230\u901a\u7528\u5316\u5904\u7406\u7ed3\u675f\u3002");
    }

    private void setUpdateCollection(DynamicObjectCollection updateCollection, DynamicObject[] dynamicObjects, Map<String, String> paramKeyMap, String conditionTag) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            JSONObject jsObj;
            String conditionStr = dynamicObject.getString(conditionTag);
            if (!HRStringUtils.isNotEmpty((String)conditionStr)) continue;
            try {
                jsObj = JSON.parseObject((String)conditionStr);
            }
            catch (Exception e) {
                continue;
            }
            boolean flag = false;
            if (jsObj.containsKey((Object)"conditionList")) {
                JSONArray conditionList = jsObj.getJSONArray("conditionList");
                for (int i = 0; i < conditionList.size(); ++i) {
                    JSONObject jsonObject = conditionList.getJSONObject(i);
                    String conditionParam = jsonObject.getString("param");
                    String retrievalWay = jsonObject.getString("retrievalWay");
                    if (!HRStringUtils.isNotEmpty((String)conditionParam) || !paramKeyMap.containsKey(conditionParam) || WTCStringUtils.equals((String)retrievalWay, (String)RetrievalTypeEnum.CONFIG.getValue())) continue;
                    flag = true;
                    jsonObject.put("retrievalWay", (Object)RetrievalTypeEnum.CONFIG.getValue());
                    jsonObject.put("uniqueCode", (Object)paramKeyMap.get(conditionParam));
                }
            }
            if (!flag) continue;
            dynamicObject.set(conditionTag, (Object)jsObj.toJSONString());
            if (updateCollection.contains((Object)dynamicObject)) continue;
            updateCollection.add((Object)dynamicObject);
        }
    }

    private Map<String, String> getParamKeyMap(DynamicObject rule, Set<Long> itemIds) {
        HashMap paramKeyMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection entryEntity = rule.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isEmpty((Collection)entryEntity)) {
            return paramKeyMap;
        }
        for (DynamicObject entryDynamicObject : entryEntity) {
            DynamicObjectCollection subEntryEntity = entryDynamicObject.getDynamicObjectCollection("subentryentity");
            if (WTCCollections.isEmpty((Collection)subEntryEntity)) continue;
            String inputNumber = entryDynamicObject.getString("inputnumber");
            for (DynamicObject subDynamicObject : subEntryEntity) {
                long fieldId = subDynamicObject.getLong("fieldid.id");
                if (!itemIds.contains(fieldId)) continue;
                String belongObjNumber = subDynamicObject.getString("fieldid.belongobj.number");
                String fieldNumber = subDynamicObject.getString("fieldid.number");
                String fieldType = subDynamicObject.getString("fieldid.type");
                String uniqueCode = subDynamicObject.getString("fieldid.uniquecode");
                StringBuilder paramKeyBuffer = new StringBuilder();
                paramKeyBuffer.append(inputNumber).append(".").append(belongObjNumber).append(".").append(fieldNumber);
                if (HRStringUtils.equals((String)"dynamicObject", (String)fieldType)) {
                    paramKeyBuffer.append(".id");
                }
                paramKeyMap.put(paramKeyBuffer.toString(), uniqueCode);
            }
        }
        return paramKeyMap;
    }
}

