/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalItemHelper {
    private static final HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final HRBaseServiceHelper formulaSetServiceHelper = HRBaseServiceHelper.create((String)"wtp_formulaset");

    private RetrievalItemHelper() {
    }

    public static List<Long> getGroupIdsHasItems() {
        DynamicObject[] retrievalItems = itemHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("category", "=", (Object)"1")});
        Set hasItemGroups = Arrays.stream(retrievalItems).map(item -> item.getLong("parent.id")).collect(Collectors.toSet());
        return new ArrayList<Long>(hasItemGroups);
    }

    public static long getConfigIdById(Long id) {
        String fields = "id,config";
        DynamicObject dy = itemHelper.queryOne(fields, new QFilter[]{new QFilter("id", "in", (Object)id)});
        return dy.getLong("config.id");
    }

    public static void updateItemConfigIdField(Long configId, List<Long> newestItemIds) {
        QFilter qFilter = new QFilter("config.id", "=", (Object)configId);
        DynamicObject[] itemDys = itemHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (itemDys.length > 0) {
            Arrays.stream(itemDys).forEach(item -> item.set("config", null));
            itemHelper.save(itemDys);
        }
        if (WTCCollections.isNotEmpty(newestItemIds)) {
            QFilter uqFilter = new QFilter("id", "in", newestItemIds);
            DynamicObject[] upItemDys = itemHelper.loadDynamicObjectArray(new QFilter[]{uqFilter});
            Arrays.stream(upItemDys).forEach(item -> item.set("config", (Object)configId));
            itemHelper.save(upItemDys);
        }
    }

    public static Map<Long, String> checkUsedByFormula(Map<Long, String> idToUnicodeMap) {
        HashMap<Long, String> idToFormulaSetNameMap = new HashMap<Long, String>(idToUnicodeMap.size());
        DynamicObject[] formulaSetDys = formulaSetServiceHelper.queryOriginalArray("name,dependentcalitem,dependentcalitemforfunc", new QFilter[0]);
        for (Map.Entry<Long, String> entry : idToUnicodeMap.entrySet()) {
            DynamicObject matchedDy = RetrievalItemHelper.checkUsedByFormula(entry.getValue(), formulaSetDys);
            if (matchedDy == null) continue;
            idToFormulaSetNameMap.put(entry.getKey(), matchedDy.getString("name"));
        }
        return idToFormulaSetNameMap;
    }

    private static DynamicObject checkUsedByFormula(String unicode, DynamicObject[] formulaSetDys) {
        for (DynamicObject formulaSetDy : formulaSetDys) {
            String dependentCalItemStr = formulaSetDy.getString("dependentcalitem");
            if (HRStringUtils.isNotEmpty((String)dependentCalItemStr) && dependentCalItemStr.contains(unicode)) {
                return formulaSetDy;
            }
            String dependentCalItemForFuncStr = formulaSetDy.getString("dependentcalitemforfunc");
            if (!HRStringUtils.isNotEmpty((String)dependentCalItemForFuncStr) || !dependentCalItemForFuncStr.contains(unicode)) continue;
            return formulaSetDy;
        }
        return null;
    }

    public static Map<String, DynamicObject> checkNameUnique(List<String> names, List<String> categories) {
        if (WTCCollections.isNotEmpty(names) && WTCCollections.isNotEmpty(categories)) {
            QFilter qFilter = new QFilter("name", "in", names);
            qFilter.and("category", "in", categories);
            DynamicObject[] itemDys = itemHelper.queryOriginalArray("id,name", new QFilter[]{qFilter});
            if (itemDys.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, DynamicObject> nameToDyMap = new HashMap<String, DynamicObject>(itemDys.length);
            for (DynamicObject dy : itemDys) {
                nameToDyMap.put(dy.getString("name"), dy);
            }
            return nameToDyMap;
        }
        return Collections.emptyMap();
    }

    public static Map<String, DynamicObject> checkCodeUnique(Set<String> codes) {
        if (WTCCollections.isNotEmpty(codes)) {
            QFilter qFilter = new QFilter("numberx", "in", codes);
            DynamicObject[] itemDys = itemHelper.queryOriginalArray("id,numberx,name", new QFilter[]{qFilter});
            if (itemDys.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, DynamicObject> codeToDyMap = new HashMap<String, DynamicObject>(itemDys.length);
            for (DynamicObject dy : itemDys) {
                codeToDyMap.put(dy.getString("numberx"), dy);
            }
            return codeToDyMap;
        }
        return Collections.emptyMap();
    }
}

