/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalItemConstants;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalItemTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalItemUpgradeService {
    private static final Log LOG = LogFactory.getLog(RetrievalItemUpgradeService.class);
    private static final HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final HRBaseServiceHelper calElementHelper = new HRBaseServiceHelper("wtp_calelement");
    private static final HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("wtbd_scenerulecfg");

    public void upgrade() {
        LOG.info("\u5347\u7ea7\u53d6\u6570\u9879\u76ee\u5f00\u59cb\u3002");
        DynamicObject[] oldItemDys = this.upgradeOldData();
        this.upgradeCalElement(oldItemDys);
        this.upgradeRetrievalRule();
        LOG.info("\u5347\u7ea7\u53d6\u6570\u9879\u76ee\u7ed3\u675f\u3002");
    }

    private DynamicObject[] upgradeOldData() {
        DynamicObject[] allItemDyArr = itemHelper.loadDynamicObjectArray(new QFilter[0]);
        HashMap parentMap = new HashMap(allItemDyArr.length);
        for (DynamicObject dy : allItemDyArr) {
            long parentId = dy.getLong("parent.id");
            Optional<DynamicObject> parentOpl = Arrays.stream(allItemDyArr).filter(item -> parentId == item.getLong("id")).findFirst();
            parentOpl.ifPresent(dynamicObject -> parentMap.put(dy.getLong("id"), dynamicObject));
        }
        List<DynamicObject> itemDys = Arrays.stream(allItemDyArr).filter(item -> HRStringUtils.isEmpty((String)item.getString("numberx"))).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(itemDys)) {
            for (DynamicObject dy : itemDys) {
                String uuid;
                Long id = dy.getLong("id");
                if (HRStringUtils.equals((String)dy.getString("category"), (String)"1")) {
                    if (HRStringUtils.isEmpty((String)dy.getString("grouptype"))) {
                        dy.set("grouptype", (Object)"1");
                    }
                    if (HRStringUtils.isEmpty((String)dy.getString("way"))) {
                        dy.set("way", (Object)(dy.getBoolean("issyspreset") ? "3" : "2"));
                    }
                    if (HRStringUtils.isEmpty((String)dy.getString("uniquecode"))) {
                        uuid = parentMap.containsKey(id) ? String.join((CharSequence)"$", "CT$A$A", ((DynamicObject)parentMap.get(id)).getString("number"), dy.getString("number")) : String.join((CharSequence)"$", "CT$A$A", dy.getString("number"));
                        dy.set("uniquecode", (Object)uuid);
                    }
                    if (HRStringUtils.equals((String)"number", (String)dy.getString("type"))) {
                        dy.set("scale", (Object)"6");
                        dy.set("tailprocessing", (Object)"1");
                    }
                    if (!HRStringUtils.isEmpty((String)dy.getString("numberx"))) continue;
                    dy.set("numberx", (Object)dy.getString("number"));
                    continue;
                }
                if (HRStringUtils.isEmpty((String)dy.getString("uniquecode"))) {
                    uuid = parentMap.containsKey(id) ? String.join((CharSequence)"$", "CT$A$A", ((DynamicObject)parentMap.get(id)).getString("number"), dy.getString("number")) : String.join((CharSequence)"$", "CT$A$A", dy.getString("number"));
                    dy.set("uniquecode", (Object)uuid);
                }
                if (!HRStringUtils.isEmpty((String)dy.getString("numberx"))) continue;
                dy.set("numberx", (Object)dy.getString("number"));
            }
            itemHelper.update(itemDys.toArray(new DynamicObject[0]));
        }
        return allItemDyArr;
    }

    private void upgradeCalElement(DynamicObject[] oldItemDys) {
        DynamicObject dy;
        HashMap oldItemMap = new HashMap(oldItemDys.length);
        Arrays.stream(oldItemDys).forEach(item -> oldItemMap.put(item.getLong("id"), item));
        MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_scenefieldcfg");
        DynamicObject[] allElements = calElementHelper.loadDynamicObjectArray(new QFilter[0]);
        List<DynamicObject> categoryDys = Arrays.stream(allElements).filter(element -> element.getString("eletype").equals("1")).collect(Collectors.toList());
        ArrayList<DynamicObject> sortedCategoryDys = new ArrayList<DynamicObject>(categoryDys.size());
        this.getSortedCategoryQueue(sortedCategoryDys, 0L, categoryDys);
        Set<Object> aeCategoryIds = new HashSet(categoryDys.size());
        Optional<DynamicObject> aeOpl = categoryDys.stream().filter(element -> HRStringUtils.equals((String)"AE", (String)element.getString("number"))).findFirst();
        if (aeOpl.isPresent()) {
            ArrayList<DynamicObject> aeCategoryDys = new ArrayList<DynamicObject>(categoryDys.size());
            aeCategoryDys.add(aeOpl.get());
            this.getSortedCategoryQueue(aeCategoryDys, aeOpl.get().getLong("id"), categoryDys);
            aeCategoryIds = aeCategoryDys.stream().map(element -> element.getLong("id")).collect(Collectors.toSet());
        }
        LOG.info("upgradeCalElement: sortedCategoryDys: " + sortedCategoryDys.stream().map(element -> element.getLong("id")).collect(Collectors.toList()));
        for (DynamicObject categoryDy : sortedCategoryDys) {
            if (oldItemMap.containsKey(categoryDy.getLong("id"))) continue;
            long id = categoryDy.getLong("id");
            dy = new DynamicObject((DynamicObjectType)metaType);
            dy.set("category", (Object)"3");
            dy.set("grouptype", (Object)(RetrievalItemConstants.CALELEMENT_OF_ATTRESULT == id ? "3" : "2"));
            dy.set("uniquecode", (Object)categoryDy.getString("uniquecode"));
            dy.set("calctype", (Object)"2");
            dy.set("id", (Object)categoryDy.getLong("id"));
            dy.set("number", (Object)categoryDy.getString("number"));
            dy.set("numberx", (Object)categoryDy.getString("number"));
            dy.set("longnumber", (Object)categoryDy.getString("longnumber"));
            dy.set("fullname", (Object)categoryDy.getString("fullname"));
            dy.set("name", categoryDy.get("name"));
            dy.set("level", categoryDy.get("level"));
            dy.set("isleaf", categoryDy.get("isleaf"));
            dy.set("parent", (Object)categoryDy.getLong("parent.id"));
            dy.set("description", categoryDy.get("description"));
            dy.set("issyspreset", categoryDy.get("issyspreset"));
            dy.set("enable", categoryDy.get("enable"));
            dy.set("status", categoryDy.get("status"));
            dy.set("creator", categoryDy.get("creator"));
            if (HRStringUtils.equals((String)"BI", (String)categoryDy.getString("number"))) {
                dy.set("index", (Object)1);
            } else if (HRStringUtils.equals((String)"AE", (String)categoryDy.getString("number"))) {
                dy.set("index", (Object)2);
            } else {
                dy.set("index", categoryDy.get("index"));
            }
            LOG.info("upgradeCalElement: category: " + dy.getLong("id"));
            itemHelper.saveOne(dy);
        }
        List itemDys = Arrays.stream(allElements).filter(element -> element.getString("eletype").equals("2")).collect(Collectors.toList());
        ArrayList<DynamicObject> savedDys = new ArrayList<DynamicObject>(itemDys.size());
        for (DynamicObject itemDy : itemDys) {
            if (oldItemMap.containsKey(itemDy.getLong("id"))) continue;
            dy = new DynamicObject((DynamicObjectType)metaType);
            dy.set("category", (Object)"1");
            dy.set("grouptype", (Object)"2");
            if (itemDy.getBoolean("issyspreset")) {
                dy.set("way", (Object)(aeCategoryIds.contains(itemDy.getLong("parent.id")) ? "3" : "1"));
            } else {
                dy.set("way", (Object)"2");
            }
            dy.set("uniquecode", (Object)itemDy.getString("uniquecode"));
            RetrievalItemTypeEnum typeEnum = RetrievalItemTypeEnum.formCalElementType((String)itemDy.getString("datatype"));
            dy.set("type", (Object)typeEnum.getDbValue());
            if (HRStringUtils.equals((String)"number", (String)dy.getString("type"))) {
                dy.set("scale", (Object)"6");
                dy.set("tailprocessing", (Object)"1");
            }
            dy.set("id", (Object)itemDy.getLong("id"));
            dy.set("number", (Object)itemDy.getString("number"));
            dy.set("longnumber", (Object)itemDy.getString("longnumber"));
            dy.set("fullname", (Object)itemDy.getString("fullname"));
            dy.set("numberx", (Object)itemDy.getString("number"));
            dy.set("name", itemDy.get("name"));
            dy.set("level", itemDy.get("level"));
            dy.set("isleaf", itemDy.get("isleaf"));
            dy.set("index", itemDy.get("index"));
            dy.set("parent", (Object)itemDy.getLong("parent.id"));
            dy.set("description", itemDy.get("description"));
            dy.set("issyspreset", itemDy.get("issyspreset"));
            dy.set("enable", itemDy.get("enable"));
            dy.set("status", itemDy.get("status"));
            dy.set("creator", itemDy.get("creator"));
            savedDys.add(dy);
        }
        LOG.info("upgradeCalElement: element: " + savedDys.stream().map(element -> element.getLong("id")).collect(Collectors.toList()));
        itemHelper.save(savedDys.toArray(new DynamicObject[0]));
    }

    private void getSortedCategoryQueue(List<DynamicObject> sortedCategoryDys, Long parentId, List<DynamicObject> categoryDys) {
        List childDys = categoryDys.stream().filter(category -> category.getLong("parent.id") == parentId.longValue()).collect(Collectors.toList());
        if (WTCCollections.isEmpty(childDys)) {
            return;
        }
        sortedCategoryDys.addAll(childDys);
        for (DynamicObject childDy : childDys) {
            this.getSortedCategoryQueue(sortedCategoryDys, childDy.getLong("id"), categoryDys);
        }
    }

    private void upgradeRetrievalRule() {
        DynamicObject[] allRules = ruleHelper.loadDynamicObjectArray(new QFilter[0]);
        List<DynamicObject> oldRules = Arrays.stream(allRules).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(oldRules)) {
            for (DynamicObject rule : oldRules) {
                if (HRStringUtils.isEmpty((String)rule.getString("grouptype"))) {
                    rule.set("grouptype", (Object)"1");
                }
                boolean isSysPreset = rule.getBoolean("issyspreset");
                DynamicObjectCollection entries = rule.getDynamicObjectCollection("entryentity");
                Map<String, Long> fieldIdMap = this.getFieldIdMap(entries);
                boolean entryPresetProcessed = entries.stream().anyMatch(entry -> entry.getBoolean("entryispreset"));
                for (DynamicObject entry2 : entries) {
                    if (isSysPreset && !entryPresetProcessed) {
                        entry2.set("entryispreset", (Object)Boolean.TRUE);
                    }
                    entry2.getDynamicObjectCollection("subentryentity").forEach(subEntry -> {
                        String key;
                        if (isSysPreset && !entryPresetProcessed) {
                            subEntry.set("fieldissyspreset", (Object)Boolean.TRUE);
                        }
                        if (subEntry.getLong("fieldid.id") == 0L && fieldIdMap.containsKey(key = entry2.getLong("inputobject.id") + subEntry.getString("fieldnumber"))) {
                            subEntry.set("fieldid", fieldIdMap.get(key));
                        }
                    });
                }
            }
            LOG.info("upgradeRetrievalRule: " + oldRules.stream().map(element -> element.getLong("id")));
            ruleHelper.update(oldRules.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, Long> getFieldIdMap(DynamicObjectCollection entryEntityColl) {
        HashSet inputObjIds = new HashSet(16);
        entryEntityColl.forEach(entryEntity -> inputObjIds.add(entryEntity.getLong("inputobject.id")));
        QFilter qFilter = new QFilter("parent", "in", inputObjIds);
        DynamicObject[] inputObjDyArr = itemHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<String, Long> groupMap = new HashMap<String, Long>(16);
        Arrays.stream(inputObjDyArr).forEach(inputObjDy -> groupMap.put(inputObjDy.getLong("parent.id") + inputObjDy.getString("number"), inputObjDy.getLong("id")));
        return groupMap;
    }
}

