/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.retrieval.PreDataRetrievalRule;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalRuleHelper {
    private static final HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final HRBaseServiceHelper useCfgHelper = new HRBaseServiceHelper("wtbd_sceneusecfg");
    private static final Log LOG = LogFactory.getLog(RetrievalRuleHelper.class);

    private RetrievalRuleHelper() {
    }

    public static List<TreeNode> getRetrievalRulePreviewTreeNodes(DynamicObject rule) {
        if (null == rule) {
            return Collections.emptyList();
        }
        long id = rule.getLong("id");
        if (id == PreDataRetrievalRule.PD_1070_S || id == PreDataRetrievalRule.PD_1080_S) {
            return RetrievalRuleHelper.getRetrievalRulePreviewTreeNodes4Formula(rule);
        }
        return RetrievalRuleHelper.getRetrievalRulePreviewTreeNodes4Ct(rule);
    }

    private static List<TreeNode> getRetrievalRulePreviewTreeNodes4Formula(DynamicObject rule) {
        DynamicObject[] allItems = itemHelper.loadDynamicObjectArray(new QFilter[0]);
        HashMap<String, DynamicObject> idToDyMap = new HashMap<String, DynamicObject>();
        Arrays.stream(allItems).forEach(item -> idToDyMap.put(String.valueOf(item.getLong("id")), (DynamicObject)item));
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("entryentity");
        Set<String> categoryIds = entries.stream().map(entry -> entry.getString("inputobject.id")).collect(Collectors.toSet());
        HashSet itemIds = new HashSet(16);
        ArrayList<String> sortedItemIds = new ArrayList<String>(16);
        HashMap idToDisplayNameMap = new HashMap(16);
        for (DynamicObject entry2 : entries) {
            DynamicObjectCollection subEntries = entry2.getDynamicObjectCollection("subentryentity");
            subEntries.forEach(subEntry -> {
                long fieldId = subEntry.getLong("fieldid.id");
                if (fieldId != 0L) {
                    itemIds.add(fieldId);
                    sortedItemIds.add(String.valueOf(fieldId));
                    if (HRStringUtils.isNotEmpty((String)subEntry.getString("fielddisplayname"))) {
                        idToDisplayNameMap.put(fieldId, subEntry.getString("fielddisplayname"));
                    }
                }
            });
        }
        LinkedList<String> categoryIdQueue = new LinkedList<String>();
        categoryIds.forEach(categoryIdQueue::push);
        ArrayList parentCategoryIds = new ArrayList(categoryIds);
        while (!categoryIdQueue.isEmpty()) {
            long parentId;
            String categoryId = (String)categoryIdQueue.pop();
            if (!idToDyMap.containsKey(categoryId) || (parentId = ((DynamicObject)idToDyMap.get(categoryId)).getLong("parent.id")) == 0L) continue;
            parentCategoryIds.add(String.valueOf(parentId));
            categoryIdQueue.push(String.valueOf(parentId));
        }
        categoryIds.addAll(parentCategoryIds);
        HashSet allIds = new HashSet(categoryIds);
        allIds.addAll(itemIds.stream().map(String::valueOf).collect(Collectors.toList()));
        Map<String, TreeNode> nodeMap = allIds.stream().map(idToDyMap::get).collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> new TreeNode("", String.valueOf(dy.getLong("id")), idToDisplayNameMap.containsKey(dy.getLong("id")) ? (String)idToDisplayNameMap.get(dy.getLong("id")) : dy.getString("name"))));
        for (String allId : allIds) {
            DynamicObject dy2 = (DynamicObject)idToDyMap.get(allId);
            long parentId = dy2.getLong("parent.id");
            TreeNode treeNodeItem = nodeMap.get(allId);
            if (parentId == 0L) continue;
            String parentIdStr = String.valueOf(parentId);
            treeNodeItem.setParentid(parentIdStr);
            List childrenNodes = nodeMap.get(parentIdStr).getChildren();
            if (WTCCollections.isNotEmpty((Collection)childrenNodes)) {
                childrenNodes.add(treeNodeItem);
                continue;
            }
            nodeMap.get(parentIdStr).addChild(treeNodeItem);
        }
        List<TreeNode> rootNodes = nodeMap.values().stream().filter(item -> HRStringUtils.isEmpty((String)item.getParentid())).collect(Collectors.toList());
        RetrievalRuleHelper.sortRetrievalRulePreviewTreeNodes4Formula(idToDyMap, categoryIds, sortedItemIds, rootNodes);
        return rootNodes;
    }

    private static void sortRetrievalRulePreviewTreeNodes4Formula(Map<String, DynamicObject> idToDyMap, Set<String> categoryIds, List<String> sortedItemIds, List<TreeNode> rootNodes) {
        ArrayList<Object> allSortIds = new ArrayList<Object>(10);
        List sortedCategoryIds = categoryIds.stream().sorted(Comparator.comparingInt(categoryId -> idToDyMap.containsKey(categoryId) ? ((DynamicObject)idToDyMap.get(categoryId)).getInt("index") : 0)).collect(Collectors.toList());
        allSortIds.addAll(sortedCategoryIds);
        allSortIds.addAll(sortedItemIds);
        HashMap<String, Integer> idToIndexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < allSortIds.size(); ++i) {
            idToIndexMap.put(String.valueOf(allSortIds.get(i)), i);
        }
        LinkedList sortQueue = new LinkedList();
        rootNodes.forEach(sortQueue::push);
        while (!sortQueue.isEmpty()) {
            TreeNode node = (TreeNode)sortQueue.pop();
            List childrenNodes = node.getChildren();
            if (WTCCollections.isEmpty((Collection)childrenNodes)) continue;
            childrenNodes.sort(Comparator.comparingInt(childrenNode -> idToIndexMap.getOrDefault(childrenNode.getId(), 0)));
            node.setChildren(childrenNodes);
            childrenNodes.forEach(childrenNode -> {
                String category;
                if (idToDyMap.containsKey(childrenNode.getId()) && (HRStringUtils.equals((String)"2", (String)(category = ((DynamicObject)idToDyMap.get(childrenNode.getId())).getString("category"))) || HRStringUtils.equals((String)"3", (String)category))) {
                    sortQueue.push(childrenNode);
                }
            });
        }
        rootNodes.sort(Comparator.comparingInt(childrenNode -> idToIndexMap.getOrDefault(childrenNode.getId(), 0)));
    }

    private static List<TreeNode> getRetrievalRulePreviewTreeNodes4Ct(DynamicObject rule) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        DynamicObjectCollection entryEntity = rule.getDynamicObjectCollection("entryentity");
        if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject entry : entryEntity) {
                TreeNode node = new TreeNode("", entry.getString("inputobject.id"), entry.getString("inputname"));
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
                if (WTCCollections.isNotEmpty((Collection)subEntries)) {
                    subEntries.forEach(subEntry -> node.addChild(new TreeNode("", subEntry.getString("fieldid.id"), HRStringUtils.isNotEmpty((String)subEntry.getString("fielddisplayname")) ? subEntry.getString("fielddisplayname") : subEntry.getString("fieldid.name"))));
                }
                nodes.add(node);
            }
        }
        return nodes;
    }

    public static boolean checkRetrievalItemUsedByCt(Map<String, String> paramKeyMap, long ruleId) {
        if (ruleId == 0L) {
            return false;
        }
        if (ruleId == PreDataRetrievalRule.PD_1010_S) {
            DynamicObject[] otbasesetDys;
            HRBaseServiceHelper otbasesetServiceHelper = HRBaseServiceHelper.create((String)"wtp_otbaseset");
            for (DynamicObject dy : otbasesetDys = otbasesetServiceHelper.queryOriginalArray("id,daterangecondition", new QFilter[0])) {
                if (!RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, dy.getString("daterangecondition"))) continue;
                LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), 0, "wtp_otbaseset", "daterangecondition"});
                return true;
            }
            return false;
        }
        if (ruleId == PreDataRetrievalRule.PD_1020_S || ruleId == PreDataRetrievalRule.PD_1030_S) {
            DynamicObject[] overworkruleDys;
            HRBaseServiceHelper overworkruleServiceHelper = HRBaseServiceHelper.create((String)"wtp_overworkrule");
            for (DynamicObject dy : overworkruleDys = overworkruleServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("overworkcalentry");
                if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                for (DynamicObject entry : entryEntity) {
                    if (RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("daterangecondition"))) {
                        LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_overworkrule", "daterangecondition"});
                        return true;
                    }
                    if (!RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("limitscope"))) continue;
                    LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_overworkrule", "limitscope"});
                    return true;
                }
            }
            return false;
        }
        if (ruleId == PreDataRetrievalRule.PD_1050_S) {
            DynamicObject[] swshiftruleDys;
            HRBaseServiceHelper swshiftruleServiceHelper = HRBaseServiceHelper.create((String)"wtp_swshiftrule");
            for (DynamicObject dy : swshiftruleDys = swshiftruleServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
                if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                for (DynamicObject entry : entryEntity) {
                    if (!RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("limitscope"))) continue;
                    LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_swshiftrule", "limitscope"});
                    return true;
                }
            }
            return false;
        }
        if (ruleId == PreDataRetrievalRule.PD_1060_S) {
            DynamicObject[] timecutconfigDys;
            HRBaseServiceHelper timecutconfigServiceHelper = HRBaseServiceHelper.create((String)"wtp_timecut");
            for (DynamicObject dy : timecutconfigDys = timecutconfigServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("timecutentry");
                if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                for (DynamicObject entry : entryEntity) {
                    if (RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("beforedaycond"))) {
                        LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_timecut", "beforedaycond"});
                        return true;
                    }
                    if (RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("daycond"))) {
                        LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_timecut", "daycond"});
                        return true;
                    }
                    if (!RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("afterdaycond"))) continue;
                    LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_timecut", "afterdaycond"});
                    return true;
                }
            }
            return false;
        }
        if (ruleId == PreDataRetrievalRule.PD_1090_S) {
            DynamicObject[] configDys;
            HRBaseServiceHelper hrBaseServiceHelper = HRBaseServiceHelper.create((String)"wtp_qtgenconfig");
            for (DynamicObject dy : configDys = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
                DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
                if (WTCCollections.isEmpty((Collection)entryEntity)) continue;
                for (DynamicObject entry : entryEntity) {
                    if (!RetrievalRuleHelper.doCheckRetrievalItemUsedByCt(paramKeyMap, entry.getString("conditionfilter"))) continue;
                    LOG.info("retrievalItem used by: id={}, entryId={}, table={}, field={}", new Object[]{dy.getLong("id"), entry.get("id"), "wtp_qtgenconfig", "conditionfilter"});
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean doCheckRetrievalItemUsedByCt(Map<String, String> paramKeyMap, String conditionStr) {
        JSONObject jsObj;
        if (HRStringUtils.isNotEmpty((String)conditionStr) && (jsObj = JSON.parseObject((String)conditionStr)).containsKey((Object)"conditionList")) {
            JSONArray conditionList = jsObj.getJSONArray("conditionList");
            for (int i = 0; i < conditionList.size(); ++i) {
                String conditionParam = conditionList.getJSONObject(i).getString("param");
                if (!HRStringUtils.isNotEmpty((String)conditionParam) || !paramKeyMap.containsKey(conditionParam)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<DynamicObject> getRelatedUseCfgDyList(long ruleId) {
        if (ruleId == 0L) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("scenerule.id", "=", (Object)ruleId);
        DynamicObject[] dyArr = useCfgHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Arrays.stream(dyArr).collect(Collectors.toList());
    }

    public static Map<Long, List<DynamicObject>> getAllRelatedUseCfgMap() {
        DynamicObject[] dyArr = useCfgHelper.loadDynamicObjectArray(new QFilter[0]);
        List lists = Arrays.stream(dyArr).collect(Collectors.toList());
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(lists.size());
        if (WTCCollections.isNotEmpty(lists)) {
            for (DynamicObject dy : lists) {
                long sceneRuleId = dy.getLong("scenerule.id");
                if (!map.containsKey(sceneRuleId)) {
                    map.put(sceneRuleId, new ArrayList(10));
                }
                ((List)map.get(sceneRuleId)).add(dy);
            }
        }
        return map;
    }
}

