/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalRuleUpgradeService {
    private static final Log LOG = LogFactory.getLog(RetrievalRuleUpgradeService.class);
    private static final HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("wtbd_scenerulecfg");
    private static final String DELETE_SQL = "DELETE FROM T_PERM_ROLEPERMDETIAL WHERE fentitytypeid = 'wtbd_scenerulecfg' and fpermitemid in ('47156aff000000ac', '4715e1f1000000ac', '47J1XOE1MT/M', '47J2/9PR5GVM');";

    public void upgrade() {
        LOG.info("\u5347\u7ea7\u53d6\u6570\u5e94\u7528\u573a\u666f\u5f00\u59cb\u3002");
        this.upgradeRetrievalRule();
        this.deleteRolePermDetail();
        LOG.info("\u5347\u7ea7\u53d6\u6570\u5e94\u7528\u573a\u666f\u7ed3\u675f\u3002");
    }

    private void upgradeRetrievalRule() {
        QFilter qFilter = new QFilter("issyspreset", "=", (Object)false);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] allRules = ruleHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        List<DynamicObject> oldRules = Arrays.stream(allRules).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(oldRules)) {
            for (DynamicObject rule : oldRules) {
                rule.set("enable", (Object)"0");
            }
            LOG.info("upgradeRetrievalRule: " + oldRules.stream().map(element -> element.getLong("id")).collect(Collectors.toList()));
            ruleHelper.update(oldRules.toArray(new DynamicObject[0]));
        }
    }

    private void deleteRolePermDetail() {
        DBRoute sysDbRoute = new DBRoute("sys");
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)sysDbRoute, (String)DELETE_SQL);
            }
            catch (Exception ex) {
                tx.markRollback();
                LOG.error("RetrievalRuleUpgrade error", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "wtbd_scenerulecfg upgrade exception, " + ex.getMessage()), new Object[0]);
            }
        }
    }
}

