/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.server.ScheduleService;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableList;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class RetrievalUtil {
    private static final Log LOGGER = LogFactory.getLog(RetrievalUtil.class);

    public static MainEntityType getDataEntityType(String number) {
        try {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)number);
            if (mainEntity == null) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalUtil_0", (String)"wtc-wtbd-business", (Object[])new Object[0]), number));
            }
            return mainEntity;
        }
        catch (Exception e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalUtil_0", (String)"wtc-wtbd-business", (Object[])new Object[0]), number));
        }
    }

    public static DynamicProperty getProperty(MainEntityType mainEntity, String key) {
        try {
            DynamicProperty property = mainEntity.getProperty(key);
            if (property == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u5b57\u6bb5[{1}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalUtil_1", (String)"wtc-wtbd-business", (Object[])new Object[]{mainEntity.getDisplayName(), key}));
            }
            return property;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u5b57\u6bb5[{1}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalUtil_1", (String)"wtc-wtbd-business", (Object[])new Object[]{mainEntity.getDisplayName(), key}));
        }
    }

    public static WTCDataTypeEnum getTypePropertyDataTypeByPath(String entityName, String keyPath) {
        MainEntityType entityType = RetrievalUtil.getDataEntityType(entityName, keyPath);
        if (entityType == null) {
            return WTCDataTypeEnum.NUM;
        }
        String className = entityType.getPrimaryKey().getPropertyType().getName();
        if (StringUtils.equalsAny((CharSequence)className, (CharSequence[])new CharSequence[]{Long.class.getName(), "long"})) {
            return WTCDataTypeEnum.NUM;
        }
        return WTCDataTypeEnum.TEXT;
    }

    @Deprecated
    public static WTCDataTypeEnum getPkType(long itemId, DynamicObject config) {
        DynamicObjectCollection fetchfieldEntry = config.getDynamicObjectCollection("fetchfieldentry");
        String key = null;
        for (DynamicObject entry : fetchfieldEntry) {
            long id = entry.getLong("fetchitem.id");
            if (itemId != id) continue;
            key = entry.getString("field");
            break;
        }
        if (key == null) {
            return null;
        }
        String sourceMetaname = config.getString("fetchsource.id");
        return RetrievalUtil.getTypePropertyDataTypeByPath(sourceMetaname, key);
    }

    public static List<String> getItemTypeList(String fieldType) {
        List typeList = WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_DATE.getCode()) ? ImmutableList.of((Object)"date") : (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_NUM.getCode()) ? ImmutableList.of((Object)"number") : (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_ID.getCode()) ? ImmutableList.of((Object)"dynamicObject") : (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_BOOLEAN.getCode()) ? ImmutableList.of((Object)"boolean") : ImmutableList.of((Object)"string", (Object)"enum"))));
        return typeList;
    }

    public static MainEntityType getDataEntityType(String fetchSource, String fieldCode) {
        String[] split = fieldCode.split("\\.");
        if (split.length == 0) {
            return null;
        }
        if (split.length == 1) {
            return RetrievalUtil.getDataEntityType(fetchSource);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fetchSource);
        Map allFields = dataEntityType.getAllFields();
        fieldCode = fieldCode.substring(fieldCode.indexOf(46) + 1);
        DynamicProperty property = dataEntityType.getProperty(split[0]);
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(split[0]);
        if (property instanceof BasedataProp) {
            return RetrievalUtil.getDataEntityType(((BasedataProp)property).getBaseEntityId(), fieldCode);
        }
        if (property instanceof EntryProp) {
            return RetrievalUtil.getDataEntityType(fetchSource, fieldCode);
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            return RetrievalUtil.getDataEntityType(((BasedataProp)iDataEntityProperty).getBaseEntityId(), fieldCode);
        }
        return null;
    }

    public static Map<String, LocaleString> getComboItemLocaleMap(String fetchSource, String fieldCode) {
        HashMap<String, LocaleString> comboItemMap = new HashMap<String, LocaleString>(16);
        MainEntityType entityType = RetrievalUtil.getDataEntityType(fetchSource, fieldCode);
        if (entityType == null) {
            return comboItemMap;
        }
        DynamicProperty property = entityType.getProperty(fieldCode.substring(fieldCode.lastIndexOf(46) + 1));
        ComboProp fieldValueCombo = (ComboProp)property;
        List comboItems = fieldValueCombo.getComboItems();
        if (WTCCollections.isEmpty((Collection)comboItems)) {
            return comboItemMap;
        }
        for (ValueMapItem item : comboItems) {
            String value = item.getValue();
            LocaleString name = item.getName();
            comboItemMap.put(value, name);
        }
        return comboItemMap;
    }

    public static Map<String, String> getComboItemMap(String fetchSource, String fieldCode, String langTag) {
        HashMap<String, String> comboItemMap = new HashMap<String, String>(16);
        MainEntityType entityType = RetrievalUtil.getDataEntityType(fetchSource, fieldCode);
        if (entityType == null) {
            return comboItemMap;
        }
        Map propertyMap = entityType.getAllFields();
        if (WTCCollections.isEmpty((Map)propertyMap)) {
            return comboItemMap;
        }
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)propertyMap.get(fieldCode.substring(fieldCode.lastIndexOf(46) + 1));
        if (!(iDataEntityProperty instanceof ComboProp)) {
            return comboItemMap;
        }
        ComboProp fieldValueCombo = (ComboProp)iDataEntityProperty;
        if (fieldValueCombo == null) {
            return comboItemMap;
        }
        List comboItems = fieldValueCombo.getComboItems();
        if (WTCCollections.isEmpty((Collection)comboItems)) {
            return comboItemMap;
        }
        for (ValueMapItem item : comboItems) {
            String value = item.getValue();
            LocaleString name = item.getName();
            comboItemMap.put(value, (String)name.get((Object)langTag));
        }
        return comboItemMap;
    }

    public static Map<String, String> getComboItemMapByField(String fetchSource, String fieldCode, String langTag) {
        HashMap<String, String> comboItemMap = new HashMap<String, String>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)fetchSource);
        if (entityType == null) {
            return comboItemMap;
        }
        Map propertyMap = entityType.getAllFields();
        if (WTCCollections.isEmpty((Map)propertyMap)) {
            return comboItemMap;
        }
        ComboProp fieldValueCombo = (ComboProp)propertyMap.get(fieldCode);
        if (fieldValueCombo == null) {
            return comboItemMap;
        }
        List comboItems = fieldValueCombo.getComboItems();
        if (WTCCollections.isEmpty((Collection)comboItems)) {
            return comboItemMap;
        }
        for (ValueMapItem item : comboItems) {
            String value = item.getValue();
            LocaleString name = item.getName();
            comboItemMap.put(value, (String)name.get((Object)langTag));
        }
        return comboItemMap;
    }

    public static boolean isUpgradeFinished(String scheduleId, String jobId) {
        boolean existSchedulePlan = ScheduleService.getInstance().getObjectFactory().getScheduleDao().existed(scheduleId);
        boolean existScheduleJob = ScheduleService.getInstance().getObjectFactory().getJobDao().isExist(jobId);
        return !existSchedulePlan && existScheduleJob;
    }
}

