/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.QueryTimeout;
import kd.wtc.wtbd.business.retrieval.DataReaderHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalKDStringHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.retrieval.service.ContextRetrievalExpUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMatchUtil;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.OutputModeEnum;
import kd.wtc.wtbd.common.enums.retrieval.RuleOperatorEnum;
import kd.wtc.wtbd.common.utils.WTCObjectUtils;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalConfigInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalFieldInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalFilterInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalSortedInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalDataFromDatabaseCallable
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(RetrievalDataFromDatabaseCallable.class);
    private static final Map<String, String> CONDITION_MATCH_MAP = new HashMap<String, String>(12);
    private List<RetrievalDimension> dims;
    private Map<Long, String> retrievalItemIdUnicodeMap;
    private Set<Long> retrievalItems;
    private RetrievalConfigInfo config;
    private RetrievalMCConfig mcConfig;

    public RetrievalDataFromDatabaseCallable(List<RetrievalDimension> dims, Map<Long, String> retrievalItemIdUnicodeMap, Set<Long> retrievalItems, RetrievalMCConfig mcConfig, RetrievalConfigInfo config) {
        this.dims = dims;
        this.retrievalItemIdUnicodeMap = retrievalItemIdUnicodeMap;
        this.retrievalItems = retrievalItems;
        this.mcConfig = mcConfig;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        Map<String, String> propertyClassMap = this.getPropertyClassMap(this.config);
        this.validateFieldAndFieldType(this.config, propertyClassMap);
        for (RetrievalFilterInfo filterInfo : this.config.getFilterInfoList()) {
            String unicode;
            if (!WTCStringUtils.equals((String)filterInfo.getValueType(), (String)ConditionValueTypeEnum.TYPE_FTITEM.getCode()) || !RetrievalDataFromDatabaseCallable.isLong(filterInfo.getValue()) || !WTCStringUtils.isNotEmpty((String)(unicode = this.retrievalItemIdUnicodeMap.get(Long.valueOf(filterInfo.getValue()))))) continue;
            filterInfo.setValue(unicode);
        }
        List<RetrievalDimension> queryDims = this.getQueryDims(this.dims, this.config.getFilterInfoList());
        if (WTCCollections.isEmpty(queryDims)) {
            return Boolean.FALSE;
        }
        ArrayList<String> selectFieldList = new ArrayList<String>(10);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        StringBuilder sortType = new StringBuilder();
        for (RetrievalFieldInfo fieldInfo : this.config.getFieldInfoList()) {
            if (selectFieldList.contains(fieldInfo.getFieldId())) continue;
            selectFieldList.add(fieldInfo.getFieldId());
        }
        for (RetrievalFilterInfo filterInfo : this.config.getFilterInfoList()) {
            if (!selectFieldList.contains(filterInfo.getFieldId())) {
                selectFieldList.add(filterInfo.getFieldId());
            }
            QFilter qFilter = this.assembleFilter(filterInfo.getCondition(), filterInfo.getFieldId(), filterInfo.getValue(), filterInfo.getValueType(), filterInfo.getDataType(), queryDims, this.config.getFetchSourceId());
            filterList.add(qFilter);
        }
        this.assembleFetchSortInfo(selectFieldList, sortType, this.config.getSortedInfoList());
        StringBuilder selectFieldsBuilder = this.getSelectFieldBuilder(selectFieldList);
        QFilter[] qFilters = new QFilter[filterList.size()];
        filterList.toArray(qFilters);
        StringBuilder filterStr = this.getFilterBuilder(qFilters);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MessageFormat.format("RetrievalDataReaderService.retrievalDataFromDatabase \u67e5\u8be2\u5b57\u6bb5\uff1a{0}\uff0c\u8fc7\u6ee4\u6761\u4ef6\uff1a{1}\uff0c\u6392\u5e8f\u65b9\u5f0f\uff1a{2}", selectFieldsBuilder.toString(), filterStr, sortType.toString()));
        }
        DataSet dataSets = null;
        ORM orm = ORM.create();
        orm.hint().setLang(Lang.from((String)this.mcConfig.getRetrievalLang()));
        try {
            boolean onlyFixedValue = this.isOnlyFixedValue(this.config);
            QueryTimeout timeout = null;
            if (this.mcConfig.isRetrievalMaxTimeOpen()) {
                timeout = DB.timeout((int)this.mcConfig.getRetrievalMaxTime());
            }
            try {
                dataSets = onlyFixedValue && WTCStringUtils.equals((String)this.config.getOutputMode(), (String)OutputModeEnum.ONE.getCode()) ? orm.queryDataSet(this.getClass().getName(), this.config.getFetchSourceId(), selectFieldsBuilder.toString(), qFilters, sortType.toString(), 1) : orm.queryDataSet(this.getClass().getName(), this.config.getFetchSourceId(), selectFieldsBuilder.toString(), qFilters, sortType.toString(), this.mcConfig.getRetrievalMaxSize() + 1);
            }
            catch (Exception ex) {
                LOGGER.warn("RetrievalDataReaderService.retrievalDataFromDatabase orm.queryDataSet error", (Throwable)ex);
                if (ex instanceof KDException && ((KDException)ex).getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                    String message = ResManager.loadKDString((String)"\u53d6\u6570\u64cd\u4f5c\u8d85\u65f6\uff0c\u4efb\u52a1\u4e2d\u6b62\u3002\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff1a{0}\uff0c{1}\u3002", (String)"RetrievalDataFromDatabaseService_6", (String)"wtc-wtbd-business", (Object[])new Object[]{this.config.getNumber(), this.config.getName()});
                    throw new KDBizException(message);
                }
                String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u6570\u636e\u5e93\u53d6\u6570\u5f02\u5e38\u3010{2}\u3011", (String)"RetrievalDataFromDatabaseService_4", (String)"wtc-wtbd-business", (Object[])new Object[]{this.config.getName(), this.config.getNumber(), ex.getMessage()});
                throw new KDBizException(message);
            }
            finally {
                if (timeout != null) {
                    timeout.close();
                }
            }
            Iterator rowIterator = dataSets.iterator();
            if (!rowIterator.hasNext()) {
                LOGGER.info("RetrievalDataReaderService\u53d6\u6570\u914d\u7f6e\u67e5\u8be2\u6570\u636e\u5e93\u7ed3\u679c\u4e3a\u7a7a");
                Boolean message = Boolean.FALSE;
                return message;
            }
            RowMeta rowMeta = dataSets.getRowMeta();
            DynamicObjectType dynamicObjectType = new DynamicObjectType("PlainObject");
            DynamicSimpleProperty[] properties = this.getDynamicSimpleProperty(rowMeta, dynamicObjectType);
            Map<String, String> groupMap = this.getGroupMap(this.config);
            String groupFieldId = groupMap.get("groupFieldId");
            if (WTCStringUtils.isNotEmpty((String)groupFieldId)) {
                Map<Object, List<RetrievalDimension>> retrievalDimensionGroupMap = queryDims.stream().collect(Collectors.groupingBy(item -> item.getUnicodeValues().get(groupMap.get("groupValue"))));
                this.matchResultByGroup(queryDims, this.config, groupFieldId, retrievalDimensionGroupMap, rowIterator, properties, dynamicObjectType, propertyClassMap);
            } else {
                this.matchResult(queryDims, this.config, rowIterator, properties, dynamicObjectType, propertyClassMap);
            }
            this.unicodeListSwitchArray(this.config, queryDims);
        }
        finally {
            if (dataSets != null) {
                dataSets.close();
            }
        }
        return Boolean.TRUE;
    }

    protected void unicodeListSwitchArray(RetrievalConfigInfo config, List<RetrievalDimension> queryDims) {
        if (WTCStringUtils.equals((String)config.getOutputMode(), (String)OutputModeEnum.MORE.getCode()) && WTCCollections.isNotEmpty(queryDims)) {
            String uniqueCode = ((RetrievalFieldInfo)config.getFieldInfoList().get(0)).getUniqueCode();
            queryDims.forEach(retrievalDimension -> {
                Map<String, Object> unicodeValues = retrievalDimension.getUnicodeValues();
                if (unicodeValues.containsKey(uniqueCode)) {
                    List list = (List)unicodeValues.get(uniqueCode);
                    unicodeValues.put(uniqueCode, list.toArray());
                }
            });
        }
    }

    protected boolean isOnlyFixedValue(RetrievalConfigInfo config) {
        boolean flag = true;
        for (RetrievalFilterInfo filterInfo : config.getFilterInfoList()) {
            String valueType = filterInfo.getValueType();
            if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) && !WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType) && !WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected Map<String, String> getGroupMap(RetrievalConfigInfo config) {
        HashMap<String, String> groupMap = new HashMap<String, String>(2);
        String groupFieldId = "";
        String groupValue = "";
        for (RetrievalFilterInfo filterInfo : config.getFilterInfoList()) {
            String valueType = filterInfo.getValueType();
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) && WTCStringUtils.equals((String)filterInfo.getCondition(), (String)RuleOperatorEnum.EQUAL.getValue())) {
                groupFieldId = filterInfo.getFieldId();
                groupValue = filterInfo.getValue();
                break;
            }
            if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType) || !WTCStringUtils.equals((String)filterInfo.getCondition(), (String)RuleOperatorEnum.EQUAL.getValue())) continue;
            groupFieldId = filterInfo.getFieldId();
            groupValue = filterInfo.getValue();
            break;
        }
        groupMap.put("groupValue", groupValue);
        groupMap.put("groupFieldId", groupFieldId);
        return groupMap;
    }

    protected void validateExceedRetrievalMaxSize(int num, RetrievalConfigInfo config) {
        if (num > this.mcConfig.getRetrievalMaxSize()) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u6570\u91cf\u8fc7\u5927\uff0c\u4efb\u52a1\u4e2d\u6b62\u3002\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff1a{0}\uff0c{1}\u3002", (String)"RetrievalDataFromDatabaseService_5", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getNumber(), config.getName()});
            throw new KDBizException(message);
        }
    }

    protected void matchResultByGroup(List<RetrievalDimension> queryDims, RetrievalConfigInfo config, String groupFieldId, Map<Object, List<RetrievalDimension>> retrievalDimensionGroupMap, Iterator<Row> rowIterator, DynamicSimpleProperty[] properties, DynamicObjectType dt, Map<String, String> propertyClassMap) {
        int num = 0;
        while (rowIterator.hasNext()) {
            this.validateExceedRetrievalMaxSize(++num, config);
            if (WTCCollections.isEmpty(queryDims)) {
                return;
            }
            DynamicObject row = this.getDynamicObject(rowIterator, properties, dt);
            List<RetrievalDimension> retrievalDimensions = retrievalDimensionGroupMap.get(row.get(groupFieldId));
            if (!WTCCollections.isNotEmpty(retrievalDimensions)) continue;
            Iterator<RetrievalDimension> iterator = retrievalDimensions.iterator();
            while (iterator.hasNext()) {
                RetrievalDimension retrievalDimension = iterator.next();
                Map<String, Object> unicodeValues = retrievalDimension.getUnicodeValues();
                boolean matchFlag = this.matchOne(config, row, unicodeValues);
                if (!matchFlag) continue;
                this.writeBackOne(config, row, unicodeValues, propertyClassMap);
                if (!WTCStringUtils.equals((String)config.getOutputMode(), (String)OutputModeEnum.ONE.getCode())) continue;
                iterator.remove();
                queryDims.remove(retrievalDimension);
            }
        }
    }

    protected void matchResult(List<RetrievalDimension> queryDims, RetrievalConfigInfo config, Iterator<Row> rowIterator, DynamicSimpleProperty[] properties, DynamicObjectType dt, Map<String, String> propertyClassMap) {
        int num = 0;
        while (rowIterator.hasNext()) {
            this.validateExceedRetrievalMaxSize(++num, config);
            if (WTCCollections.isEmpty(queryDims)) {
                return;
            }
            DynamicObject row = this.getDynamicObject(rowIterator, properties, dt);
            Iterator<RetrievalDimension> iterator = queryDims.iterator();
            while (iterator.hasNext()) {
                RetrievalDimension retrievalDimension = iterator.next();
                Map<String, Object> unicodeValues = retrievalDimension.getUnicodeValues();
                boolean matchFlag = this.matchOne(config, row, unicodeValues);
                if (!matchFlag) continue;
                this.writeBackOne(config, row, unicodeValues, propertyClassMap);
                if (!WTCStringUtils.equals((String)config.getOutputMode(), (String)OutputModeEnum.ONE.getCode())) continue;
                iterator.remove();
            }
        }
    }

    protected DynamicSimpleProperty[] getDynamicSimpleProperty(RowMeta rowMeta, DynamicObjectType dt) {
        int fieldCount = rowMeta.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Field field = rowMeta.getField(i);
            String fieldName = field.getAlias();
            if (fieldName.isEmpty() || dt.getProperties().containsKey((Object)fieldName)) {
                fieldName = "Property" + i;
            }
            Class propertyType = ORMUtil.getPropertyType((DataType)field.getDataType());
            DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, propertyType, null);
            property.setEnableNull(field.isNullable());
            dt.registerSimpleProperty(property);
        }
        DynamicSimpleProperty[] properties = (DynamicSimpleProperty[])dt.getProperties().toArray((Object[])new DynamicSimpleProperty[0]);
        return properties;
    }

    protected DynamicObject getDynamicObject(Iterator<Row> rowIterator, DynamicSimpleProperty[] properties, DynamicObjectType dt) {
        DynamicObject obj = new DynamicObject(dt, true);
        obj.beginInit();
        Row row = rowIterator.next();
        for (int i = 0; i < properties.length; ++i) {
            properties[i].setValueFast((Object)obj, row.get(i));
        }
        obj.endInit();
        return obj;
    }

    protected boolean matchOne(RetrievalConfigInfo config, DynamicObject row, Map<String, Object> unicodeValues) {
        boolean matchFlag = true;
        for (RetrievalFilterInfo filterInfo : config.getFilterInfoList()) {
            Object filterFieldValue = row.get(filterInfo.getFieldId());
            String compareTypeValue = filterInfo.getCondition();
            String valueType = filterInfo.getValueType();
            Object compareValueResult = filterInfo.getValue();
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) || WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType) || WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                compareValueResult = unicodeValues.get(filterInfo.getValue());
            }
            ConditionValueTypeEnum valueTypeEnum = ConditionValueTypeEnum.getEnumByCode((String)filterInfo.getValueType());
            boolean matchedOneSuccess = RetrievalMatchUtil.doMatchOneRelationEntry(filterInfo.getDataType(), filterFieldValue, compareTypeValue, valueTypeEnum, compareValueResult);
            if (matchedOneSuccess) continue;
            matchFlag = false;
            break;
        }
        return matchFlag;
    }

    protected void writeBackOne(RetrievalConfigInfo config, DynamicObject row, Map<String, Object> unicodeValues, Map<String, String> propertyClassMap) {
        Long fetchItemId;
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (RetrievalFieldInfo fieldInfo : config.getFieldInfoList()) {
            if (!this.retrievalItems.contains(fieldInfo.getFetchItemId())) continue;
            Object fieldValue = row.get(fieldInfo.getFieldId());
            Map<Object, Object> comboItemMap = Maps.newHashMapWithExpectedSize((int)16);
            if (WTCStringUtils.equals((String)propertyClassMap.get(fieldInfo.getFieldId()), (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
                comboItemMap = RetrievalUtil.getComboItemMap(config.getFetchSourceId(), fieldInfo.getFieldId(), this.mcConfig.getRetrievalLang());
            }
            if (WTCStringUtils.equals((String)config.getOutputMode(), (String)OutputModeEnum.ONE.getCode())) {
                unicodeValues.put(fieldInfo.getUniqueCode(), fieldValue);
                if (!WTCStringUtils.equals((String)propertyClassMap.get(fieldInfo.getFieldId()), (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) continue;
                unicodeValues.put(fieldInfo.getUniqueCode() + "combo_tag", comboItemMap.get(fieldValue));
                continue;
            }
            map.put(fieldInfo.getFieldId(), fieldValue);
            if (!WTCStringUtils.equals((String)propertyClassMap.get(fieldInfo.getFieldId()), (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) continue;
            map.put(fieldInfo.getFieldId() + "combo_tag", comboItemMap.get(fieldValue));
        }
        if (WTCStringUtils.equals((String)config.getOutputMode(), (String)OutputModeEnum.MORE.getCode()) && this.retrievalItems.contains(fetchItemId = ((RetrievalFieldInfo)config.getFieldInfoList().get(0)).getFetchItemId())) {
            List<HashMap> list;
            String uniqueCode = ((RetrievalFieldInfo)config.getFieldInfoList().get(0)).getUniqueCode();
            if (unicodeValues.containsKey(uniqueCode)) {
                list = (List)unicodeValues.get(uniqueCode);
                list.add(map);
            } else {
                list = Lists.newArrayListWithExpectedSize((int)16);
                list.add(map);
                unicodeValues.put(uniqueCode, list);
            }
        }
    }

    protected void validateFieldAndFieldType(RetrievalConfigInfo config, Map<String, String> propertyClassMap) {
        if (WTCStringUtils.isEmpty((String)config.getFetchSourceId())) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u53d6\u6570\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"RetrievalDataFromDatabaseService_0", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getName(), config.getNumber()});
            throw new KDBizException(message);
        }
        config.getFieldInfoList().forEach(item -> this.validateFieldAndFieldTypeOne(propertyClassMap, config, item.getFieldId(), item.getDataType(), "fetchfieldentry"));
        config.getFilterInfoList().forEach(item -> this.validateFieldAndFieldTypeOne(propertyClassMap, config, item.getFieldId(), item.getDataType(), "relationentry"));
        config.getSortedInfoList().forEach(item -> this.validateFieldAndFieldTypeOne(propertyClassMap, config, item.getFieldId(), "", "fetchsortentry"));
    }

    protected Map<String, String> getPropertyClassMap(RetrievalConfigInfo config) {
        Map<String, Map<String, String>> propertyMap;
        Map<String, String> propertyClassMap;
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType(config.getFetchSourceId());
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = RetrievalUtil.getDataEntityType(((QueryEntityType)mainEntity).getEntityName());
        }
        if ((propertyClassMap = (propertyMap = DataReaderHelper.getPropertyClassMap(mainEntity.getAllEntities())).get("codeMap")) == null) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u53d6\u6570\u5b9e\u4f53\u6ca1\u6709\u53ef\u9009\u5b57\u6bb5\u3002", (String)"RetrievalDataFromDatabaseService_1", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getName(), config.getNumber()});
            throw new KDBizException(message);
        }
        return propertyClassMap;
    }

    protected void validateFieldAndFieldTypeOne(Map<String, String> propertyClassMap, RetrievalConfigInfo config, String fieldId, String dataType, String entryType) {
        if (!propertyClassMap.containsKey(fieldId)) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u5b57\u6bb5\u3010{2}\u3011\u4e0d\u5b58\u5728\u3002", (String)"RetrievalDataFromDatabaseService_2", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getName(), config.getNumber(), fieldId});
            throw new KDBizException(message);
        }
        if (fieldId.endsWith(".id")) {
            fieldId = fieldId.substring(0, fieldId.length() - 3);
        }
        String fieldType = propertyClassMap.get(fieldId);
        fieldType = RetrievalConfigHelper.getSwitchDataType(fieldType, entryType);
        if (WTCStringUtils.isNotEmpty((String)dataType) && !WTCStringUtils.equals((String)fieldType, (String)dataType)) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u5b57\u6bb5\u3010{2}\u3011\u6570\u636e\u7c7b\u578b\u5df2\u8c03\u6574\u3002", (String)"RetrievalDataFromDatabaseService_3", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getName(), config.getNumber(), fieldId});
            throw new KDBizException(message);
        }
    }

    protected List<RetrievalDimension> getQueryDims(List<RetrievalDimension> dims, List<RetrievalFilterInfo> retrievalFilterInfoList) {
        ArrayList<RetrievalDimension> queryDims = new ArrayList<RetrievalDimension>(dims.size());
        dims.forEach(dim -> {
            boolean keyFlag = true;
            for (RetrievalFilterInfo filterInfo : retrievalFilterInfoList) {
                String valueType = filterInfo.getValueType();
                if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) && !WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType) && !WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType) || dim.unicodeValues.containsKey(filterInfo.getValue())) continue;
                keyFlag = false;
                break;
            }
            if (keyFlag) {
                queryDims.add((RetrievalDimension)dim);
            }
        });
        return queryDims;
    }

    protected StringBuilder getSelectFieldBuilder(List<String> selectFieldList) {
        StringBuilder selectFieldsBuilder = new StringBuilder();
        for (String selectField : selectFieldList) {
            if (selectFieldsBuilder.length() > 0) {
                selectFieldsBuilder.append(',');
            }
            selectFieldsBuilder.append(selectField);
        }
        return selectFieldsBuilder;
    }

    protected StringBuilder getFilterBuilder(QFilter[] qFilters) {
        StringBuilder filterStr = new StringBuilder();
        for (QFilter filter : qFilters) {
            if (filterStr.length() > 0) {
                filterStr.append(',');
            }
            filterStr.append(filter);
        }
        return filterStr;
    }

    protected QFilter assembleFilter(String condition, String fieldId, String value, String valueType, String dataType, List<RetrievalDimension> dims, String fetchSourceId) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        List<String> unionList = Arrays.asList(RuleOperatorEnum.EQUAL.getValue(), RuleOperatorEnum.IN.getValue());
        List<String> intersectionList = Arrays.asList(RuleOperatorEnum.NOT_EQUAL.getValue(), RuleOperatorEnum.NOT_IN.getValue());
        List<String> minList = Arrays.asList(RuleOperatorEnum.LESS_THAN.getValue(), RuleOperatorEnum.LESS_OR_EQUAL.getValue());
        List<String> maxList = Arrays.asList(RuleOperatorEnum.GREATER_THAN.getValue(), RuleOperatorEnum.GREATER_OR_EQUAL.getValue());
        List<String> containsList = Arrays.asList(RuleOperatorEnum.CONTAINS.getValue(), RuleOperatorEnum.NOT_CONTAINS.getValue());
        if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) || WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType) || WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
            Set<Object> objects = this.unionSet(value, dims);
            if (unionList.contains(condition)) {
                filter = this.assembleSingleFilter(RuleOperatorEnum.IN.getValue(), fieldId, objects, dataType);
            } else if (intersectionList.contains(condition)) {
                if (this.validateEquals(value, dims)) {
                    Object object = dims.get(0).getUnicodeValues().get(value);
                    filter = this.assembleSingleFilter(RuleOperatorEnum.NOT_IN.getValue(), fieldId, object, dataType);
                } else {
                    filter = new QFilter("1", "=", (Object)1);
                }
            } else if (minList.contains(condition)) {
                if (ConditionFieldTypeEnum.TYPE_DATE.getCode().equals(dataType)) {
                    Set setOfDates = objects.stream().map(obj -> (Date)obj).collect(Collectors.toSet());
                    Date max = (Date)Collections.max(setOfDates);
                    filter = this.assembleSingleFilter(condition, fieldId, max, dataType);
                } else if (ConditionFieldTypeEnum.TYPE_NUM.getCode().equals(dataType)) {
                    Set setOfDates = objects.stream().map(ContextRetrievalExpUtil::parseToBigDecimal).collect(Collectors.toSet());
                    BigDecimal max = (BigDecimal)Collections.max(setOfDates);
                    filter = this.assembleSingleFilter(condition, fieldId, max, dataType);
                }
            } else if (maxList.contains(condition)) {
                if (ConditionFieldTypeEnum.TYPE_DATE.getCode().equals(dataType)) {
                    Set setOfDates = objects.stream().map(obj -> (Date)obj).collect(Collectors.toSet());
                    Date min = (Date)Collections.min(setOfDates);
                    filter = this.assembleSingleFilter(condition, fieldId, min, dataType);
                } else if (ConditionFieldTypeEnum.TYPE_NUM.getCode().equals(dataType)) {
                    Set setOfDates = objects.stream().map(ContextRetrievalExpUtil::parseToBigDecimal).collect(Collectors.toSet());
                    BigDecimal min = (BigDecimal)Collections.min(setOfDates);
                    filter = this.assembleSingleFilter(condition, fieldId, min, dataType);
                }
            } else if (containsList.contains(condition)) {
                filter = this.containsFilter(condition, fieldId, value, dataType, dims);
            }
        } else if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)valueType)) {
            Object fixedValue = this.assembleFixedValue(condition, fieldId, value, dataType, fetchSourceId);
            filter = this.assembleSingleFilter(condition, fieldId, fixedValue, dataType);
        } else if (WTCStringUtils.isEmpty((String)valueType)) {
            filter = this.assembleSingleFilter(condition, fieldId, value, dataType);
        }
        return filter;
    }

    protected QFilter containsFilter(String condition, String fieldId, String value, String dataType, List<RetrievalDimension> dims) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        HashMap<Object, String> map = new HashMap<Object, String>(16);
        for (int i = 0; i < dims.size(); ++i) {
            Object param = dims.get(i).getUnicodeValues().get(value);
            if (i == 0) {
                map.put(param, "1");
                filter = this.assembleSingleFilter(condition, fieldId, param, dataType);
                continue;
            }
            if (map.containsKey(param)) continue;
            map.put(param, "1");
            QFilter singleFilter = this.assembleSingleFilter(condition, fieldId, param, dataType);
            filter.or(singleFilter);
        }
        return filter;
    }

    protected Set<Object> unionSet(String value, List<RetrievalDimension> dims) {
        HashSet<Object> unionSets = new HashSet<Object>();
        dims.forEach(item -> unionSets.add(item.getUnicodeValues().get(value)));
        return unionSets;
    }

    protected boolean validateEquals(String value, List<RetrievalDimension> dims) {
        if (dims.size() == 1) {
            return true;
        }
        boolean flag = true;
        Object object = null;
        for (int i = 0; i < dims.size(); ++i) {
            Object item = dims.get(i).getUnicodeValues().get(value);
            if (i == 0) {
                object = item;
                continue;
            }
            if (WTCObjectUtils.equals((Object)object, (Object)item)) {
                object = item;
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected QFilter assembleSingleFilter(String condition, String fieldId, Object value, String dataType) {
        List<String> normalOpList = Arrays.asList(RuleOperatorEnum.EQUAL.getValue(), RuleOperatorEnum.NOT_EQUAL.getValue(), RuleOperatorEnum.GREATER_THAN.getValue(), RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), RuleOperatorEnum.LESS_THAN.getValue(), RuleOperatorEnum.LESS_OR_EQUAL.getValue(), RuleOperatorEnum.IN.getValue(), RuleOperatorEnum.NOT_IN.getValue(), RuleOperatorEnum.IS_NULL.getValue(), RuleOperatorEnum.IS_NOT_NULL.getValue());
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (normalOpList.contains(condition)) {
            filter = new QFilter(fieldId, CONDITION_MATCH_MAP.get(condition), value);
            if (WTCStringUtils.equals((String)condition, (String)RuleOperatorEnum.IS_NULL.getValue())) {
                if (WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)dataType) || WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType)) {
                    filter.or(fieldId, "=", (Object)0);
                } else if (WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)dataType) || WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ENUM.getCode(), (String)dataType)) {
                    filter.or(fieldId, "=", (Object)" ");
                }
            }
        } else if (WTCStringUtils.equals((String)RuleOperatorEnum.CONTAINS.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)("%" + value + "%"));
        } else if (WTCStringUtils.equals((String)RuleOperatorEnum.NOT_CONTAINS.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "not like", (Object)("%" + value + "%"));
        } else if (WTCStringUtils.equals((String)RuleOperatorEnum.STARTS_WITH.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)(value + "%"));
        } else if (WTCStringUtils.equals((String)RuleOperatorEnum.ENDS_WITH.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)("%" + value));
        }
        return filter;
    }

    protected Object assembleFixedValue(String condition, String fieldId, String value, String fieldType, String fetchSourceId) {
        Object fixedValue;
        if (WTCStringUtils.isEmpty((String)value) || WTCStringUtils.equals((String)"null", (String)value)) {
            return null;
        }
        if (WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_DATE.getCode(), (String)fieldType)) {
            try {
                if (value.length() == 10) {
                    fixedValue = WTCDateUtils.parseDate((String)value, (String)"yyyy-MM-dd");
                }
                fixedValue = WTCDateUtils.parseDate((String)value, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException exception) {
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_008", RetrievalKDStringHelper.dateTypeParseErr()), new Object[0]);
            }
        } else if (WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)fieldType)) {
            fixedValue = new BigDecimal(value);
        } else if (WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType)) {
            if (WTCStringUtils.equals((String)RuleOperatorEnum.IN.getValue(), (String)condition) || WTCStringUtils.equals((String)RuleOperatorEnum.NOT_IN.getValue(), (String)condition)) {
                String[] tempValues = value.split(";");
                fixedValue = new ArrayList(tempValues.length);
                for (String tempValue : tempValues) {
                    if (!RetrievalDataFromDatabaseCallable.isLong(tempValue)) {
                        String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u5b57\u6bb5\u3010{2}\u3011\u4e3b\u952e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u5b57\u7b26\u4e32\u3002", (String)"RetrievalDataFromDatabaseService_7", (String)"wtc-wtbd-business", (Object[])new Object[]{this.config.getName(), this.config.getNumber(), fieldId});
                        throw new KDBizException(message);
                    }
                    ((ArrayList)fixedValue).add(Long.parseLong(tempValue));
                }
            } else {
                if (!RetrievalDataFromDatabaseCallable.isLong(value)) {
                    String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u4e2d\u7684\u5b57\u6bb5\u3010{2}\u3011\u4e3b\u952e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u5b57\u7b26\u4e32\u3002", (String)"RetrievalDataFromDatabaseService_7", (String)"wtc-wtbd-business", (Object[])new Object[]{this.config.getName(), this.config.getNumber(), fieldId});
                    throw new KDBizException(message);
                }
                fixedValue = Long.parseLong(value);
            }
        } else {
            fixedValue = WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)fieldType) || WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ENUM.getCode(), (String)fieldType) ? (WTCStringUtils.equals((String)RuleOperatorEnum.IN.getValue(), (String)condition) || WTCStringUtils.equals((String)RuleOperatorEnum.NOT_IN.getValue(), (String)condition) ? value.split(";") : value) : value;
        }
        return fixedValue;
    }

    protected void assembleFetchSortInfo(List<String> selectFieldList, StringBuilder sortBuilder, List<RetrievalSortedInfo> sortInfo) {
        for (RetrievalSortedInfo sort : sortInfo) {
            String sortField = sort.getFieldId();
            if (sortField.endsWith(".id")) {
                sortField = sortField.substring(0, sortField.length() - 3);
            }
            if (!selectFieldList.contains(sortField)) {
                selectFieldList.add(sortField);
            }
            if (sortBuilder.length() > 0) {
                sortBuilder.append(',');
            }
            sortBuilder.append(sortField);
            sortBuilder.append(' ');
            String sortType = sort.getSortType();
            if (WTCStringUtils.equals((String)sortType, (String)"0")) {
                sortBuilder.append("asc");
                continue;
            }
            sortBuilder.append("desc");
        }
    }

    protected static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static {
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.EQUAL.getValue(), "in");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.NOT_EQUAL.getValue(), "not in");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.GREATER_THAN.getValue(), ">");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), ">=");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.LESS_THAN.getValue(), "<");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.LESS_OR_EQUAL.getValue(), "<=");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.IN.getValue(), "in");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.NOT_IN.getValue(), "not in");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.IS_NULL.getValue(), "is null");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.IS_NOT_NULL.getValue(), "is not null");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.CONTAINS.getValue(), "like");
        CONDITION_MATCH_MAP.put(RuleOperatorEnum.NOT_CONTAINS.getValue(), "not like");
    }
}

