/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbd.business.retrieval.service.RetrievalDataFromDatabaseCallable;
import kd.wtc.wtbd.business.retrieval.service.RetrievalDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.business.retrieval.service.RetrievalService;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalConfigInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class RetrievalDataFromDatabaseService {
    private static final Log LOGGER = LogFactory.getLog(RetrievalDataFromDatabaseService.class);
    private static final String WTBD_RETRIEVALCONFIG_THREAD_POOL_NAME = "wtbd_retrievalconfig_database";
    private List<RetrievalDimension> dims = new ArrayList<RetrievalDimension>();
    private Map<Long, String> retrievalItemIdUnicodeMap = new HashMap<Long, String>();
    private Set<Long> retrievalItems = new HashSet<Long>();
    private final RetrievalMCConfig mcConfig = RetrievalMCConfig.defaultConfig();

    public <T extends RetrievalDimension> RetrievalDataFromDatabaseService(RetrievalService retrievalService) {
        this.dims = retrievalService.dims;
        this.retrievalItemIdUnicodeMap = retrievalService.retrievalItemIdUnicodeMap;
        this.retrievalItems = retrievalService.retrievalItems;
    }

    public RetrievalDataFromDatabaseService() {
    }

    public void retrievalDataFromDatabase(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        RetrievalConfigInfo config = new RetrievalConfigInfo(dynamicObject);
        if (WTCCollections.isEmpty((Collection)config.getFieldInfoList())) {
            return;
        }
        ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)WTCStringUtils.joinStr((String[])new String[]{WTBD_RETRIEVALCONFIG_THREAD_POOL_NAME, UUID.randomUUID().toString()}), (int)1);
        RetrievalDataFromDatabaseCallable retrievalDataFromDatabaseCallable = new RetrievalDataFromDatabaseCallable(this.dims, this.retrievalItemIdUnicodeMap, this.retrievalItems, this.mcConfig, config);
        Future future = threadPool.submit((Callable)retrievalDataFromDatabaseCallable);
        try {
            if (this.mcConfig.isRetrievalMaxTimeOpen()) {
                future.get(this.mcConfig.getRetrievalMaxTime(), TimeUnit.SECONDS);
            } else {
                future.get();
            }
        }
        catch (TimeoutException e) {
            future.cancel(true);
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u64cd\u4f5c\u8d85\u65f6\uff0c\u4efb\u52a1\u4e2d\u6b62\u3002\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff1a{0}\uff0c{1}\u3002", (String)"RetrievalDataFromDatabaseService_6", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getNumber(), config.getName()});
            throw new KDBizException(message);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("RetrievalDataReaderService.retrievalDataFromDatabase InterruptedException | ExecutionException error", (Throwable)e);
            future.cancel(true);
            if (e.getCause() != null) {
                if (e.getCause() instanceof KDBizException) {
                    throw (KDBizException)e.getCause();
                }
                throw new KDBizException(e.getCause().getMessage());
            }
            throw new KDBizException(e.getMessage());
        }
        finally {
            threadPool.close();
        }
    }
}

