/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class RetrievalDimension {
    protected Map<String, Object> unicodeValues = new HashMap<String, Object>(6);

    Map<String, Object> getUnicodeValues() {
        return this.unicodeValues;
    }

    public Object getValue(String unicode) {
        return this.unicodeValues.get(unicode);
    }

    public boolean isValueExist(String unicode) {
        return this.unicodeValues.containsKey(unicode);
    }

    public Map<String, Boolean> isValuesExist(Set<String> unicodes) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(unicodes.size());
        for (String unicode : unicodes) {
            map.put(unicode, this.isValueExist(unicode));
        }
        return map;
    }

    public Set<String> getKeySet() {
        return Collections.unmodifiableSet(this.unicodeValues.keySet());
    }

    void putValue(String unicode, Object value) {
        this.unicodeValues.put(unicode, value);
    }

    protected abstract String cacheKey();

    public String toJsonString() {
        return JSON.toJSONString(this.unicodeValues, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }
}

