/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.lang.Lang;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalItemConstants;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class RetrievalMCConfig {
    private boolean concurrentRetrieval = WTCAppContextHelper.getProjectParams().getBoolean("kd.wtc.wtbd.retrieval.concurrent", Boolean.valueOf(false));
    private int concurrentThreadPoolSize = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbd.retrieval.concurrentThreadPoolSize", Runtime.getRuntime().availableProcessors() * 2 + 1);
    private int retrievalRoundMax = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbd.retrieval.retrievalRoundMax", 100);
    private String retrievalLang = WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtbd.retrieval.retrievalLang", Lang.zh_CN.toString());
    private int retrievalMaxSize = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbd.retrieval.retrievalMaxSize", 100000);
    private int retrievalMaxTime = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbd.retrieval.retrievalMaxTime", 30);
    private boolean retrievalMaxTimeOpen = WTCAppContextHelper.getProjectParams().getBoolean("kd.wtc.wtbd.retrieval.retrievalMaxTimeOpen", Boolean.valueOf(true));
    private List<Long> hiddenRetrievalGroupIds;
    private List<Long> hiddenRetrievalItemIds;

    public RetrievalMCConfig() {
        String hiddenRetrievalGroupIdsStr = WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtbd.retrieval.hiddenGroupIds", null);
        this.hiddenRetrievalGroupIds = null == hiddenRetrievalGroupIdsStr ? RetrievalItemConstants.HIDDEN_RETRIEVAL_GROUP_IDS : (WTCStringUtils.isNotEmpty((String)hiddenRetrievalGroupIdsStr) ? Arrays.stream(hiddenRetrievalGroupIdsStr.split(",")).filter(WTCStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()) : Collections.emptyList());
        String hiddenRetrievalItemIdsStr = WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtbd.retrieval.hiddenItemIds", null);
        this.hiddenRetrievalItemIds = null == hiddenRetrievalItemIdsStr ? RetrievalItemConstants.HIDDEN_RETRIEVAL_ITEM_IDS : (WTCStringUtils.isNotEmpty((String)hiddenRetrievalItemIdsStr) ? Arrays.stream(hiddenRetrievalItemIdsStr.split(",")).filter(WTCStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()) : Collections.emptyList());
    }

    public static RetrievalMCConfig defaultConfig() {
        return new RetrievalMCConfig();
    }

    public boolean isConcurrentRetrieval() {
        return this.concurrentRetrieval;
    }

    public int getConcurrentThreadPoolSize() {
        return this.concurrentThreadPoolSize;
    }

    public int getRetrievalRoundMax() {
        return this.retrievalRoundMax;
    }

    public String getRetrievalLang() {
        return this.retrievalLang;
    }

    public List<Long> getHiddenRetrievalGroupIds() {
        return this.hiddenRetrievalGroupIds;
    }

    public List<Long> getHiddenRetrievalItemIds() {
        return this.hiddenRetrievalItemIds;
    }

    public int getRetrievalMaxSize() {
        return this.retrievalMaxSize;
    }

    public int getRetrievalMaxTime() {
        return this.retrievalMaxTime;
    }

    public boolean isRetrievalMaxTimeOpen() {
        return this.retrievalMaxTimeOpen;
    }
}

