/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.retrieval.RetrievalKDStringHelper;
import kd.wtc.wtbd.business.retrieval.service.ContextRetrievalExpUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchDimension;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.RuleOperatorEnum;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class RetrievalMatchUtil {
    private static final Log LOG = LogFactory.getLog(RetrievalMatchUtil.class);

    protected static boolean doMatchOneRelationEntry(String filterDataType, Object filterFieldValue, String compareTypeValue, ConditionValueTypeEnum valueTypeEnum, Object compareValueResult) {
        ConditionFieldTypeEnum conditionFieldTypeEnum;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011doMatchOneRelationEntry\u5339\u914d\uff1afilterDataType\uff1a{}\uff0cfilterFieldValue\uff1a{}, valueTypeEnum:{}, compareTypeValue:{}, compareValueResult:{}", new Object[]{filterDataType, filterFieldValue, valueTypeEnum, compareTypeValue, compareValueResult});
        }
        if ((conditionFieldTypeEnum = ConditionFieldTypeEnum.getByCode((String)filterDataType)) == null) {
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_001", RetrievalKDStringHelper.contextRelationEntryTypeErr()), new Object[0]);
        }
        switch (conditionFieldTypeEnum) {
            case TYPE_ID: 
            case TYPE_ENUM: {
                return RetrievalMatchUtil.doMatchIdOrEnum(filterFieldValue, compareValueResult, compareTypeValue);
            }
            case TYPE_TEXT: {
                return RetrievalMatchUtil.doMatchText(filterFieldValue, compareValueResult, compareTypeValue);
            }
            case TYPE_NUM: {
                if (valueTypeEnum == null) {
                    throw new KDBizException(new ErrorCode("ERR_CONTEXT_002", RetrievalKDStringHelper.contextRelationEntryValErr()), new Object[0]);
                }
                return RetrievalMatchUtil.doMatchNum(filterFieldValue, compareValueResult, compareTypeValue);
            }
            case TYPE_DATE: {
                if (valueTypeEnum == null) {
                    throw new KDBizException(new ErrorCode("ERR_CONTEXT_002", RetrievalKDStringHelper.contextRelationEntryValErr()), new Object[0]);
                }
                Date compareValueResultDate = RetrievalMatchUtil.matchDateCompareValueResult(compareValueResult, valueTypeEnum);
                return RetrievalMatchUtil.doMatchDate(filterFieldValue, compareValueResultDate, compareTypeValue);
            }
        }
        LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u672a\u9884\u7f6e\u7684\u5173\u8054\u4fe1\u606f\u5b57\u6bb5\u7c7b\u578b\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002conditionFieldTypeEnum:{}", (Object)conditionFieldTypeEnum.getCode());
        return false;
    }

    private static boolean doMatchIdOrEnum(Object filterFieldValue, Object compareValueResult, String compareTypeValue) {
        boolean isEmpty = filterFieldValue == null;
        String filterFieldStrVal = null;
        if (filterFieldValue != null) {
            boolean boolFilterFieldValue;
            filterFieldStrVal = Boolean.class.isAssignableFrom(filterFieldValue.getClass()) ? ((boolFilterFieldValue = ((Boolean)filterFieldValue).booleanValue()) ? "1" : "0") : filterFieldValue.toString();
        }
        String compareValueStrResult = compareValueResult == null ? null : compareValueResult.toString();
        boolean bl = isEmpty = isEmpty || StringUtils.isEmpty((CharSequence)filterFieldStrVal);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.IS_NULL.getValue())) {
            return isEmpty;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.IS_NOT_NULL.getValue())) {
            return !isEmpty;
        }
        boolean isEquals = Objects.equals(filterFieldStrVal, compareValueStrResult);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.EQUAL.getValue())) {
            return isEquals;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_EQUAL.getValue())) {
            return !isEquals;
        }
        if (compareValueStrResult == null) {
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_003", RetrievalKDStringHelper.contextRelationEntryValNullErr()), new Object[0]);
        }
        if (StringUtils.equalsAny((CharSequence)compareTypeValue, (CharSequence[])new CharSequence[]{RuleOperatorEnum.IN.getValue(), RuleOperatorEnum.NOT_IN.getValue()})) {
            String[] splitRes = compareValueStrResult.split(";");
            String finalFilterFieldStrVal = filterFieldStrVal;
            boolean present = Arrays.stream(splitRes).anyMatch(res -> WTCStringUtils.equals((String)finalFilterFieldStrVal, (String)res));
            if (StringUtils.equalsAny((CharSequence)compareTypeValue, (CharSequence[])new CharSequence[]{RuleOperatorEnum.IN.getValue()})) {
                return present;
            }
            return !present;
        }
        return false;
    }

    private static boolean doMatchText(Object filterFieldValue, Object compareValueResult, String compareTypeValue) {
        boolean isContains;
        boolean isEmpty;
        String filterFieldStr = filterFieldValue == null ? null : filterFieldValue.toString();
        String compareValueResultStr = compareValueResult == null ? null : compareValueResult.toString();
        boolean bl = isEmpty = filterFieldValue == null || StringUtils.isEmpty((CharSequence)filterFieldStr);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.IS_NULL.getValue())) {
            return isEmpty;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.IS_NOT_NULL.getValue())) {
            return !isEmpty;
        }
        boolean isEquals = Objects.equals(filterFieldStr, compareValueResultStr);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.EQUAL.getValue())) {
            return isEquals;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_EQUAL.getValue())) {
            return !isEquals;
        }
        if (compareValueResult == null) {
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_003", RetrievalKDStringHelper.contextRelationEntryValNullErr()), new Object[0]);
        }
        boolean bl2 = isContains = filterFieldStr != null && filterFieldStr.contains(compareValueResultStr);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.CONTAINS.getValue())) {
            return isContains;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_CONTAINS.getValue())) {
            return !isContains;
        }
        return false;
    }

    private static boolean doMatchNum(Object filterFieldValue, Object compareValueResult, String compareTypeValue) {
        BigDecimal compareValueResultNum;
        BigDecimal filterFieldValueNum;
        if (filterFieldValue == null || compareValueResult == null) {
            boolean equals = Objects.equals(filterFieldValue, compareValueResult);
            if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.EQUAL.getValue())) {
                return equals;
            }
            if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_EQUAL.getValue())) {
                return !equals;
            }
            return false;
        }
        try {
            filterFieldValueNum = ContextRetrievalExpUtil.parseToBigDecimal(filterFieldValue);
            compareValueResultNum = ContextRetrievalExpUtil.parseToBigDecimal(compareValueResult);
        }
        catch (Exception ex) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u5173\u8054\u4fe1\u606f\u8f6c\u6362\u4e3a\u6570\u5b57\u7c7b\u578b\u5f02\u5e38.filterFieldValue:{}, compareTypeValue:{}, ex:{}", new Object[]{filterFieldValue, compareValueResult, ex});
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_005", RetrievalKDStringHelper.contextValParseNumberErr()), new Object[0]);
        }
        int compares = filterFieldValueNum.compareTo(compareValueResultNum);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.EQUAL.getValue())) {
            return compares == 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_EQUAL.getValue())) {
            return compares != 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.GREATER_THAN.getValue())) {
            return compares > 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.LESS_THAN.getValue())) {
            return compares < 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.GREATER_OR_EQUAL.getValue())) {
            return compares >= 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.LESS_OR_EQUAL.getValue())) {
            return compares <= 0;
        }
        return false;
    }

    private static boolean doMatchDate(Object filterFieldValue, Date compareValueResult, String compareTypeValue) {
        if (filterFieldValue != null && !Date.class.isAssignableFrom(filterFieldValue.getClass())) {
            LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u3010\u65e5\u671f\u6bd4\u8f83\u3011\u9884\u671f\u662fDATE\uff0c\u4f46\u662f\u53d6\u5230\u7684\u6570\u636e\u7c7b\u578b\u662f\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Object)filterFieldValue.getClass().getName());
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
        }
        boolean isEquals = Objects.equals(filterFieldValue, compareValueResult);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.EQUAL.getValue())) {
            if (filterFieldValue != null && compareValueResult != null) {
                Date filterFieldValueDate = (Date)filterFieldValue;
                int compares = filterFieldValueDate.compareTo(compareValueResult);
                return compares == 0;
            }
            return isEquals;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.NOT_EQUAL.getValue())) {
            if (filterFieldValue != null && compareValueResult != null) {
                Date filterFieldValueDate = (Date)filterFieldValue;
                int compares = filterFieldValueDate.compareTo(compareValueResult);
                return compares != 0;
            }
            return !isEquals;
        }
        if (filterFieldValue == null || compareValueResult == null) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u3010\u65e5\u671f\u6bd4\u8f83\u3011\u53c2\u4e0e\u5339\u914d\u7684\u6570\u636e\u5b58\u5728null\u503c;filterFieldValue:{}\uff0ccompareValueResult:{}, compareTypeValue:{}\u3002", new Object[]{filterFieldValue, compareValueResult, compareTypeValue});
            return false;
        }
        Date filterFieldValueDate = (Date)filterFieldValue;
        int compares = filterFieldValueDate.compareTo(compareValueResult);
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.GREATER_THAN.getValue())) {
            return compares > 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.LESS_THAN.getValue())) {
            return compares < 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.GREATER_OR_EQUAL.getValue())) {
            return compares >= 0;
        }
        if (StringUtils.equals((CharSequence)compareTypeValue, (CharSequence)RuleOperatorEnum.LESS_OR_EQUAL.getValue())) {
            return compares <= 0;
        }
        LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u3010\u65e5\u671f\u6bd4\u8f83\u3011\u672a\u5b9a\u4e49\u7684\u5224\u65ad\u6761\u4ef6\uff1a{}", (Object)compareTypeValue);
        return false;
    }

    private static Date matchDateCompareValueResult(Object compareValueResult, ConditionValueTypeEnum valueTypeEnum) {
        if (compareValueResult == null) {
            throw new KDBizException(new ErrorCode("", ""), new Object[0]);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (ConditionValueTypeEnum.TYPE_FIXED == valueTypeEnum) {
            String pattern = compareValueResult.toString();
            try {
                return simpleDateFormat.parse(pattern);
            }
            catch (ParseException ex) {
                LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u3010\u65e5\u671f\u6bd4\u8f83\u3011\u56fa\u5b9a\u503c\u8f6c\u6362\u5f02\u5e38\uff0c pattern:{}", (Object)pattern);
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_008", RetrievalKDStringHelper.dateTypeParseErr()), new Object[0]);
            }
        }
        if (Date.class.isAssignableFrom(compareValueResult.getClass())) {
            return (Date)compareValueResult;
        }
        LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u3011\u3010\u65e5\u671f\u6bd4\u8f83\u3011\u975e\u56fa\u5b9a\u503c\u8f6c\u6362\u5f02\u5e38\uff0c compareValueResult:{}\uff0c type:{}", compareValueResult, compareValueResult.getClass());
        throw new KDBizException(new ErrorCode("ERR_CONTEXT_008", RetrievalKDStringHelper.dateTypeParseErr()), new Object[0]);
    }

    protected static Object doRetrieveFromContext(DynamicObject context, String fieldProp, String dataType, String propType, String retrievalLang) {
        if (!StringUtils.equals((CharSequence)dataType, (CharSequence)propType)) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u9884\u671f\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", new Object[]{propType, dataType, fieldProp});
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
        }
        try {
            Object fieldValue = context.get(fieldProp);
            if (fieldValue == null) {
                return null;
            }
            if (ConditionFieldTypeEnum.TYPE_NUM.getCode().equals(dataType)) {
                if (Number.class.isAssignableFrom(fieldValue.getClass())) {
                    return fieldValue;
                }
                LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u9884\u671f\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", new Object[]{propType, dataType, fieldProp});
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
            }
            if (ConditionFieldTypeEnum.TYPE_DATE.getCode().equals(dataType)) {
                if (Date.class.isAssignableFrom(fieldValue.getClass())) {
                    return fieldValue;
                }
                LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u9884\u671f\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", new Object[]{propType, dataType, fieldProp});
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
            }
            if (StringUtils.equalsAny((CharSequence)dataType, (CharSequence[])new CharSequence[]{ConditionFieldTypeEnum.TYPE_ID.getCode(), ConditionFieldTypeEnum.TYPE_ENUM.getCode()})) {
                if (Number.class.isAssignableFrom(fieldValue.getClass()) || CharSequence.class.isAssignableFrom(fieldValue.getClass()) || Boolean.class.isAssignableFrom(fieldValue.getClass())) {
                    return fieldValue;
                }
                LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u9884\u671f\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", new Object[]{propType, dataType, fieldProp});
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
            }
            if (ConditionFieldTypeEnum.TYPE_TEXT.getCode().equals(dataType)) {
                if (ILocaleString.class.isAssignableFrom(fieldValue.getClass())) {
                    ILocaleString localeValue = (ILocaleString)fieldValue;
                    return localeValue.get((Object)retrievalLang);
                }
                return context.getString(fieldProp);
            }
            if (ConditionFieldTypeEnum.TYPE_BOOLEAN.getCode().equals(dataType)) {
                if (Boolean.class.isAssignableFrom(fieldValue.getClass())) {
                    return fieldValue;
                }
                return context.getString(fieldProp);
            }
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u9884\u671f\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", new Object[]{propType, dataType, fieldProp});
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
        }
        catch (Exception ex) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u53d6\u6570\u5f02\u5e38\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002\uff1afield:{}\uff0c ex:{}", (Object)fieldProp, (Object)ex);
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_012", RetrievalKDStringHelper.propTypeNotMatched()), new Object[0]);
        }
    }

    protected static Object getCompareValueResult(RetrievalRuleMatchDimension dim, ConditionValueTypeEnum valueTypeEnum, String compareValue, Map<Long, String> ftItemMap) {
        Map<String, Object> unicodeValues = dim.getUnicodeValues();
        if (valueTypeEnum == ConditionValueTypeEnum.TYPE_FTITEM) {
            long ftItemId = 0L;
            if (StringUtils.isNotEmpty((CharSequence)compareValue)) {
                try {
                    ftItemId = Long.parseLong(compareValue);
                }
                catch (NumberFormatException ex) {
                    LOG.warn("\u3010\u53d6\u6570\u3011\u3010\u4ece\u5b57\u6bb5\u53d6\u6570\u3011\u5173\u8054\u4fe1\u606f\u6bd4\u8f83\u503c\u7c7b\u578b\u4e3a\u53d6\u6570\u9879\u76ee\u4f46\u662f\u6bd4\u8f83\u503c\u53d6\u5230\u7ed3\u679c\u4e0d\u662f\u53d6\u6570\u9879\u76eeID\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002");
                    return null;
                }
            }
            String unicode = ftItemMap.get(ftItemId);
            return unicodeValues.get(unicode);
        }
        if (valueTypeEnum == ConditionValueTypeEnum.TYPE_PERSON || valueTypeEnum == ConditionValueTypeEnum.TYPE_AFFILIATION) {
            return unicodeValues.get(compareValue);
        }
        return compareValue;
    }
}

