/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.retrieval.DataReaderHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalKDStringHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMatchUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchType;
import kd.wtc.wtbd.business.retrieval.service.RetrievalService;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalRuleMatchService
extends RetrievalService<RetrievalRuleMatchDimension> {
    private static final Log LOG = LogFactory.getLog(RetrievalRuleMatchService.class);
    private final RetrievalMCConfig mcConfig = RetrievalMCConfig.defaultConfig();

    @Override
    public void retrievalDataFromContext(DynamicObject config) {
        LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u5f00\u59cb\uff0c\u53d6\u6570\u914d\u7f6e\uff1a{}", (Object)config.getLong("id"));
        if (config == null) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u89e3\u6790\u53d6\u6570\u914d\u7f6e\u4e3aNULL\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002");
            return;
        }
        this.beginRetrieve(config);
    }

    private void beginRetrieve(DynamicObject config) {
        List<RetrievalRuleMatchDimension> matchedDims;
        if (WTCCollections.isEmpty((Collection)this.dims)) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u53d6\u6570\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002");
            return;
        }
        DynamicObjectCollection relationEntries = config.getDynamicObjectCollection("relationentry");
        List<RetrievalRuleMatchDimension> filteredNullDims = this.dims.stream().filter(dim -> dim.getContext() != null).collect(Collectors.toList());
        Map<String, Map<String, Map<String, String>>> dynPropertyClassMap = this.getDynPropertyClassMap(filteredNullDims);
        try {
            matchedDims = this.matchRelations(relationEntries, filteredNullDims, dynPropertyClassMap);
        }
        catch (Exception ex) {
            LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010matchRelations\u3011\u51fa\u73b0\u5f02\u5e38\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Throwable)ex);
            throw new KDBizException(RetrievalKDStringHelper.retrievalConfigParseErr(config.getString("name"), config.getString("number")));
        }
        if (WTCCollections.isEmpty(matchedDims)) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u5173\u8054\u4fe1\u606f\u8fc7\u6ee4\u540e\u53d6\u6570\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002");
            return;
        }
        DynamicObjectCollection fetchFieldEntries = config.getDynamicObjectCollection("fetchfieldentry");
        if (WTCCollections.isEmpty((Collection)fetchFieldEntries)) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u89e3\u6790\u53d6\u6570\u914d\u7f6e\u7684\u53d6\u6570\u5b57\u6bb5\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002config:{}", (Object)config.getLong("id"));
            return;
        }
        Map<String, DynamicObject> unicodeMaps = fetchFieldEntries.stream().collect(Collectors.toMap(fetchItem -> fetchItem.getDynamicObject("fetchitem").getString("uniquecode"), fetchItem -> fetchItem));
        try {
            for (RetrievalRuleMatchDimension dim2 : matchedDims) {
                this.doRetrieve(dim2, unicodeMaps, dynPropertyClassMap);
            }
        }
        catch (Exception ex) {
            LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010matchRelations\u3011\u51fa\u73b0\u5f02\u5e38\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Throwable)ex);
            throw new KDBizException(RetrievalKDStringHelper.retrievalContextParseErr(config.getString("name"), config.getString("number")));
        }
    }

    private List<RetrievalRuleMatchDimension> matchRelations(DynamicObjectCollection relationEntries, List<RetrievalRuleMatchDimension> dims, Map<String, Map<String, Map<String, String>>> dynPropertyClassMap) {
        ArrayList matchResult = Lists.newArrayListWithExpectedSize((int)dims.size());
        for (RetrievalRuleMatchDimension dim : dims) {
            boolean isSuccess = this.doMatchOneDim(relationEntries, dim, dynPropertyClassMap);
            if (!isSuccess) continue;
            matchResult.add(dim);
        }
        return matchResult;
    }

    private boolean doMatchOneDim(DynamicObjectCollection relationEntries, RetrievalRuleMatchDimension dim, Map<String, Map<String, Map<String, String>>> dynPropertyClassMap) {
        DynamicObject context = dim.getContext();
        Map<Long, String> ftItemMap = this.getRetrievalItemIdUnicodeMap();
        Map<String, Map<String, String>> propertyClassMap = dynPropertyClassMap.get(context.getDynamicObjectType().getName());
        for (DynamicObject relationEntry : relationEntries) {
            String filterField = relationEntry.getString("filterfield");
            String filterDataType = relationEntry.getString("filterdatatype");
            String compareTypeValue = relationEntry.getString("condition");
            String valueType = relationEntry.getString("valuetype");
            String compareValue = relationEntry.getString("comparevalue");
            String propType = this.getPropType(propertyClassMap, filterField, "relationentry");
            String[] splitFields = WTCStringUtils.split((String)filterField, (String)".");
            boolean matchedOneSuccess = false;
            boolean isEntry = false;
            String entryKey = null;
            String fieldKey = null;
            if (splitFields.length > 1) {
                entryKey = splitFields[0];
                fieldKey = filterField.substring(entryKey.length() + 1);
                DynamicProperty propEntryKey = RetrievalUtil.getProperty(RetrievalUtil.getDataEntityType(context.getDynamicObjectType().getName()), entryKey);
                isEntry = EntryProp.class.isAssignableFrom(propEntryKey.getClass());
            }
            ConditionValueTypeEnum valueTypeEnum = ConditionValueTypeEnum.getEnumByCode((String)valueType);
            Object compareValueResult = RetrievalMatchUtil.getCompareValueResult(dim, valueTypeEnum, compareValue, ftItemMap);
            if (isEntry) {
                DynamicObjectCollection contextEntryDyns = context.getDynamicObjectCollection(entryKey);
                for (DynamicObject contextEntryDyn : contextEntryDyns) {
                    Object filterFieldValue = RetrievalMatchUtil.doRetrieveFromContext(contextEntryDyn, fieldKey, filterDataType, propType, this.mcConfig.getRetrievalLang());
                    boolean matchOneEntrySuccess = RetrievalMatchUtil.doMatchOneRelationEntry(filterDataType, filterFieldValue, compareTypeValue, valueTypeEnum, compareValueResult);
                    if (!matchOneEntrySuccess) continue;
                    matchedOneSuccess = true;
                    break;
                }
            } else {
                Object filterFieldValue = RetrievalMatchUtil.doRetrieveFromContext(context, filterField, filterDataType, propType, this.mcConfig.getRetrievalLang());
                matchedOneSuccess = RetrievalMatchUtil.doMatchOneRelationEntry(filterDataType, filterFieldValue, compareTypeValue, valueTypeEnum, compareValueResult);
            }
            if (matchedOneSuccess) continue;
            return false;
        }
        return true;
    }

    private String getPropType(Map<String, Map<String, String>> propertyClassMap, String fieldName, String entryType) {
        Map<String, String> codeMap = propertyClassMap.get("codeMap");
        Map<String, String> sourceMap = propertyClassMap.get("sourceMap");
        String propType = codeMap.get(fieldName);
        String baseDataType = sourceMap.get(fieldName);
        if (baseDataType != null) {
            propType = ConditionFieldTypeEnum.TYPE_ID.getCode();
        }
        if (propType == null) {
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\u5b57\u6bb5{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Object)fieldName);
            throw new KDBizException(new ErrorCode("ERR_CONTEXT_011", RetrievalKDStringHelper.contextFieldNotFound()), new Object[0]);
        }
        propType = RetrievalConfigHelper.getSwitchDataType(propType, entryType);
        return propType;
    }

    private Map<String, Map<String, Map<String, String>>> getDynPropertyClassMap(List<RetrievalRuleMatchDimension> dims) {
        HashMap dynPropertyClassMap = Maps.newHashMapWithExpectedSize((int)dims.size());
        for (RetrievalRuleMatchDimension dim : dims) {
            DynamicObject context = dim.getContext();
            String dynName = context.getDynamicObjectType().getName();
            dynPropertyClassMap.computeIfAbsent(dynName, key -> {
                MainEntityType mainEntity = RetrievalUtil.getDataEntityType(dynName);
                if (mainEntity instanceof QueryEntityType) {
                    mainEntity = RetrievalUtil.getDataEntityType(((QueryEntityType)mainEntity).getEntityName());
                }
                return DataReaderHelper.getPropertyClassMap(mainEntity.getAllEntities());
            });
        }
        return dynPropertyClassMap;
    }

    private void doRetrieve(RetrievalRuleMatchDimension dim, Map<String, DynamicObject> unicodeMaps, Map<String, Map<String, Map<String, String>>> dynPropertyClassMap) {
        DynamicObject context = dim.getContext();
        String contextName = context.getDynamicObjectType().getName();
        Map<String, Map<String, String>> propertyClassMap = dynPropertyClassMap.get(contextName);
        RetrievalRuleMatchType type = dim.getType();
        unicodeMaps.forEach((unicode, fetchFieldEntry) -> {
            String field = fetchFieldEntry.getString("field");
            String dataType = fetchFieldEntry.getString("datatype");
            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011field:{}", (Object)field);
            String propType = this.getPropType(propertyClassMap, field, "fetchfieldentry");
            if (propType == null) {
                LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011\u4e0a\u4e0b\u6587{}\u4e0d\u5b58\u5728\u5b57\u6bb5{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Object)contextName, (Object)field);
                throw new KDBizException(new ErrorCode("ERR_CONTEXT_011", RetrievalKDStringHelper.contextFieldNotFound()), new Object[0]);
            }
            if (RetrievalRuleMatchType.entry == type) {
                if (WTCStringUtils.isEmpty((String)field)) {
                    LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011\u4e0a\u4e0b\u6587{}\u4e0d\u5b58\u5728\u5b57\u6bb5{}\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002", (Object)contextName, (Object)field);
                    throw new KDBizException(new ErrorCode("ERR_CONTEXT_007", RetrievalKDStringHelper.contextFieldNull()), new Object[0]);
                }
                String[] splitFields = WTCStringUtils.split((String)field, (String)".");
                if (splitFields.length > 1) {
                    String splitField = splitFields[0];
                    DynamicProperty propEntryKey = context.getDynamicObjectType().getProperty(splitField);
                    if (propEntryKey == null) {
                        LOG.warn("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011\u4e0a\u4e0b\u6587{}\u4e0d\u5b58\u5728\u5b57\u6bb5\u5bf9\u5e94\u5206\u5f55\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field:{}", (Object)contextName, (Object)field);
                        throw new KDBizException(new ErrorCode("ERR_CONTEXT_007", RetrievalKDStringHelper.contextFieldNull()), new Object[0]);
                    }
                    boolean isEntry = EntryProp.class.isAssignableFrom(propEntryKey.getClass());
                    if (!isEntry) {
                        Object target = RetrievalMatchUtil.doRetrieveFromContext(context, field, dataType, propType, this.mcConfig.getRetrievalLang());
                        dim.getUnicodeValues().put((String)unicode, target);
                    } else if (WTCStringUtils.equals((String)splitField, (String)dim.getEntryKey())) {
                        DynamicObjectCollection contextEntries = context.getDynamicObjectCollection(dim.getEntryKey());
                        if (dim.getIndex() < 0 || dim.getIndex() >= contextEntries.size()) {
                            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011\u4e0a\u4e0b\u6587{}\u4e0d\u5b58\u5728\u5206\u5f55\u884c\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002index:{}", (Object)contextName, (Object)dim.getIndex());
                            return;
                        }
                        DynamicObject entryEntity = (DynamicObject)contextEntries.get(dim.getIndex());
                        String splitEntryField = field.substring(dim.getEntryKey().length() + 1);
                        if (WTCStringUtils.isEmpty((String)splitEntryField)) {
                            LOG.info("\u3010\u4e0a\u4e0b\u6587\u53d6\u6570\u3011\u3010\u53d6\u6570\u3011\u4e0a\u4e0b\u6587{}\u4e0d\u5b58\u5728\u5206\u5f55\u884c\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002index:{}", (Object)contextName, (Object)dim.getIndex());
                            throw new KDBizException(new ErrorCode("ERR_CONTEXT_009", RetrievalKDStringHelper.entryRetrievalPropErr()), new Object[0]);
                        }
                        Object retrievalResult = RetrievalMatchUtil.doRetrieveFromContext(entryEntity, splitEntryField, dataType, propType, this.mcConfig.getRetrievalLang());
                        dim.getUnicodeValues().put((String)unicode, retrievalResult);
                    } else {
                        LOG.info("\u53d6\u6570\u5b57\u6bb5\u5206\u5f55\u548c\u4f20\u5165\u7684\u5206\u5f55key\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u53d6\u6570\u3002field\uff1a{}", (Object)field);
                    }
                } else {
                    Object target = RetrievalMatchUtil.doRetrieveFromContext(context, field, dataType, propType, this.mcConfig.getRetrievalLang());
                    dim.getUnicodeValues().put((String)unicode, target);
                }
            } else {
                Object target = RetrievalMatchUtil.doRetrieveFromContext(context, field, dataType, propType, this.mcConfig.getRetrievalLang());
                dim.getUnicodeValues().put((String)unicode, target);
            }
            Map codeMap = (Map)propertyClassMap.get("codeMap");
            if (WTCStringUtils.equals((String)((String)codeMap.get(field)), (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode()) && dim.getUnicodeValues().containsKey(unicode)) {
                Map<String, String> comboItemMap = RetrievalUtil.getComboItemMap(contextName, field, this.mcConfig.getRetrievalLang());
                Object target = dim.getUnicodeValues().get(unicode);
                dim.getUnicodeValues().put(unicode + "combo_tag", comboItemMap.get(target));
            }
        });
    }
}

