/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.retrieval.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extension.Holder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.retrieval.service.RetrievalDataFromDatabaseService;
import kd.wtc.wtbd.business.retrieval.service.RetrievalDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.FetchModeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.timewatch.TimeWatchDynamicProxyFactory;

public class RetrievalService<T extends RetrievalDimension> {
    private static final Log LOGGER = LogFactory.getLog(RetrievalService.class);
    private static final Holder<ExecutorService> executorServiceHolder = new Holder();
    private final RetrievalMCConfig mcConfig = RetrievalMCConfig.defaultConfig();
    protected final List<T> dims = new ArrayList<T>();
    private final Set<String> unicodes = new HashSet<String>();
    private final Map<String, Long> needRetrievalItemUnicodeIdMap = new HashMap<String, Long>();
    private final Map<Long, DynamicObject> retrievalConfigMap = new HashMap<Long, DynamicObject>();
    protected final Set<Long> retrievalItems = new HashSet<Long>();
    protected final Map<Long, String> retrievalItemIdUnicodeMap = new HashMap<Long, String>();
    private final Map<String, DynamicObject> retrievalItemMap = new HashMap<String, DynamicObject>();
    private Map<String, WTCDataTypeEnum> unicodeDataTypeMap;
    private RetrievalDataFromDatabaseService retrievalDataFromDatabaseService = (RetrievalDataFromDatabaseService)TimeWatchDynamicProxyFactory.getInstance().createProxy("RetrievalDataFromDatabaseService", RetrievalDataFromDatabaseService.class, new Class[]{RetrievalService.class}, new Object[]{this});
    private HRBaseServiceHelper configHelper = new HRBaseServiceHelper("wtbd_retrievalconfig");
    private HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");

    public void addRetrievalDimension(List<T> dims) {
        this.dims.addAll(dims);
    }

    protected Map<Long, String> getRetrievalItemIdUnicodeMap() {
        return Collections.unmodifiableMap(this.retrievalItemIdUnicodeMap);
    }

    public void addRetrievalUnicode(Set<String> unicodes) {
        this.unicodes.addAll(unicodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (executorServiceHolder.get() == null) {
            Holder<ExecutorService> holder = executorServiceHolder;
            synchronized (holder) {
                if (executorServiceHolder.get() != null) {
                    return (ExecutorService)executorServiceHolder.get();
                }
                executorServiceHolder.set((Object)ThreadPools.newExecutorService((String)"wtc.retrievalservice", (int)this.mcConfig.getConcurrentThreadPoolSize()));
                return (ExecutorService)executorServiceHolder.get();
            }
        }
        return (ExecutorService)executorServiceHolder.get();
    }

    private void checkConfigItemValueEmpty(DynamicObject config, String comparevalue) {
        if (WTCStringUtils.isEmpty((String)comparevalue) || "0".equals(comparevalue)) {
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u5173\u8054\u4fe1\u606f\u4e2d\u53d6\u6570\u9879\u76ee\u4e3a\u7a7a\u3002", (String)"RetrievalService_2", (String)"wtc-wtbd-business", (Object[])new Object[]{config.getString("name"), config.getString("number")});
            throw new KDBizException(message);
        }
    }

    private void backwardSearchConfig(List<DynamicObject> configs) {
        ArrayList<Long> relationItemIds = new ArrayList<Long>(configs.size());
        for (DynamicObject config : configs) {
            DynamicObjectCollection relationEntry = config.getDynamicObjectCollection("relationentry");
            for (DynamicObject entry : relationEntry) {
                String comparevalue = entry.getString("comparevalue");
                if (!ConditionValueTypeEnum.TYPE_FTITEM.getCode().equals(entry.getString("valuetype")) || WTCStringUtils.isEmpty((String)comparevalue)) continue;
                this.checkConfigItemValueEmpty(config, comparevalue);
                long itemId = Long.parseLong(comparevalue);
                if (!this.retrievalItems.contains(itemId)) {
                    relationItemIds.add(itemId);
                }
                this.retrievalItems.add(itemId);
            }
        }
        if (WTCCollections.isEmpty(relationItemIds)) {
            return;
        }
        List<DynamicObject> backLevelConfigs = this.queryConfigByItemId(relationItemIds);
        this.backwardSearchConfig(backLevelConfigs);
    }

    private List<DynamicObject> queryConfigByItemId(List<Long> itemIds) {
        DynamicObject[] configs = this.configHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("fetchfieldentry.fetchitem.id", "in", itemIds)});
        List<DynamicObject> configList = Arrays.asList(configs);
        for (DynamicObject config : configList) {
            long configId = config.getLong("id");
            this.retrievalConfigMap.put(configId, config);
        }
        return configList;
    }

    private void parserReferenceConfig() {
        DynamicObject[] itemDys;
        if (this.unicodes.size() <= 0) {
            return;
        }
        ArrayList<Long> itemIds = new ArrayList<Long>(this.unicodes.size());
        for (DynamicObject dy : itemDys = this.itemHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("uniquecode", "in", this.unicodes)})) {
            String unicode = dy.getString("uniquecode");
            if (!"1".equals(dy.getString("way"))) {
                this.unicodes.remove(unicode);
                continue;
            }
            long id = dy.getLong("id");
            itemIds.add(id);
            this.retrievalItems.add(id);
            this.needRetrievalItemUnicodeIdMap.put(unicode, id);
        }
        if (itemIds.size() <= 0) {
            return;
        }
        List<DynamicObject> configs = this.queryConfigByItemId(itemIds);
        this.backwardSearchConfig(configs);
        itemDys = this.itemHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", this.retrievalItems)});
        HashSet<Long> beforeRetrievalItems = new HashSet<Long>(this.retrievalItems);
        this.retrievalItems.clear();
        for (DynamicObject itemDy : itemDys) {
            long configId = itemDy.getLong("config.id");
            if (configId == 0L) {
                String message = ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u3010{0}_{1}\u3011\u672a\u5173\u8054\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalService_0", (String)"wtc-wtbd-business", (Object[])new Object[]{itemDy.getString("name"), itemDy.getString("number")});
                throw new KDBizException(message);
            }
            long id = itemDy.getLong("id");
            this.retrievalItems.add(id);
            this.retrievalItemIdUnicodeMap.put(id, itemDy.getString("uniquecode"));
            this.retrievalItemMap.put(itemDy.getString("uniquecode"), itemDy);
        }
        beforeRetrievalItems.removeAll(this.retrievalItems);
        if (beforeRetrievalItems.size() > 0) {
            LOGGER.warn("retrieval config relation entry item not exist. id={}", beforeRetrievalItems);
            List names = this.retrievalConfigMap.values().stream().map(object -> object.getString("name") + "_" + object.getString("number")).collect(Collectors.toList());
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}\u3011\u4e2d\u5173\u8054\u53d6\u6570\u9879\u76ee\u53ef\u80fd\u4e0d\u5b58\u5728\u3002", (String)"RetrievalService_7", (String)"wtc-wtbd-business", (Object[])new Object[]{String.join((CharSequence)"\u3011\u3010", names)});
            throw new KDBizException(message);
        }
    }

    private List<Long> roundRetrievalData(List<Long> queriedValueItemIds, Set<Long> needFetchDataConfigs) {
        ArrayList<Long> removeConfigs = new ArrayList<Long>();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (Long l : needFetchDataConfigs) {
            DynamicObject dynamicObject = this.retrievalConfigMap.get(l);
            DynamicObjectCollection relationEntry = dynamicObject.getDynamicObjectCollection("relationentry");
            boolean relationOkFlag = true;
            int index = 0;
            for (DynamicObject entry : relationEntry) {
                ++index;
                String comparevalue = entry.getString("comparevalue");
                if (!ConditionValueTypeEnum.TYPE_FTITEM.getCode().equals(entry.getString("valuetype")) || WTCStringUtils.isEmpty((String)comparevalue)) continue;
                this.checkConfigItemValueEmpty(dynamicObject, comparevalue);
                long itemId = Long.parseLong(comparevalue);
                if (!this.retrievalItems.contains(itemId)) {
                    String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u3010{0}_{1}\u3011\u7b2c{2}\u6761\u5173\u8054\u4fe1\u606f\u53d6\u6570\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"RetrievalService_1", (String)"wtc-wtbd-business", (Object[])new Object[]{dynamicObject.getString("name"), dynamicObject.getString("number"), index});
                    throw new KDBizException(message);
                }
                if (queriedValueItemIds.contains(itemId)) continue;
                relationOkFlag = false;
                break;
            }
            if (!relationOkFlag) continue;
            removeConfigs.add(dynamicObject.getLong("id"));
            runnables.add(() -> {
                if (FetchModeEnum.CONTEXT.getCode().equals(config.getString("fetchmode"))) {
                    this.retrievalDataFromContext(config);
                } else {
                    this.retrievalDataFromDatabase(config);
                }
                DynamicObjectCollection fetchfieldEntry = config.getDynamicObjectCollection("fetchfieldentry");
                for (DynamicObject entry : fetchfieldEntry) {
                    Long itemId = entry.getLong("fetchitem.id");
                    if (itemId == null) continue;
                    queriedValueItemIds.add(itemId);
                }
            });
        }
        if (this.mcConfig.isConcurrentRetrieval()) {
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(runnables.size());
            for (Runnable runnable : runnables) {
                ExecutorService executorService = this.getExecutorService();
                Future<Integer> future = executorService.submit(runnable, 0);
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    if (e.getCause() != null && e.getCause() instanceof KDException) {
                        throw (KDException)e.getCause();
                    }
                    String message = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u5e76\u53d1\u4efb\u52a1\u5f02\u5e38\u6216\u4e2d\u65ad", (String)"RetrievalService_5", (String)"wtc-wtbd-business", (Object[])new Object[0]);
                    throw new KDBizException(message);
                }
            }
        } else {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        }
        return removeConfigs;
    }

    private void printDimLog() {
        if (LOGGER.isDebugEnabled()) {
            for (RetrievalDimension dim : this.dims) {
                LOGGER.debug("retrieval dim, {}", (Object)dim.toJsonString());
            }
        }
    }

    public void retrievalData() {
        try {
            LOGGER.info("retrieval unicodes.size:{}, {}", (Object)this.unicodes.size(), this.unicodes);
            boolean ok = this.retrievalFromCache();
            LOGGER.info("retrieval retrievalFromCache ok:{}", (Object)ok);
            if (!ok) {
                this.retrievalDataFromDBAndContext();
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e1) {
            LOGGER.warn(e1.getMessage(), (Throwable)e1);
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u670d\u52a1\u68c0\u7d22\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalService_8", (String)"wtc-wtbd-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    private boolean retrievalFromCache() {
        return false;
    }

    private void cacheDimension(T dim) {
        String key = ((RetrievalDimension)dim).cacheKey();
        if (WTCStringUtils.isNotEmpty((String)key)) {
            // empty if block
        }
    }

    public void retrievalDataFromDBAndContext() {
        this.parserReferenceConfig();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("retrieval retrievalConfigMap.size:{}, {}", (Object)this.retrievalConfigMap.size(), this.retrievalConfigMap.keySet());
        }
        LOGGER.info("retrieval retrievalItems.size:{}, {}", (Object)this.retrievalItems.size(), this.retrievalItems);
        this.uniformDataType();
        LOGGER.info("retrieval unicodeDataTypeMap.size:{}, {}", (Object)this.unicodeDataTypeMap.size(), this.unicodeDataTypeMap);
        ArrayList<Long> queriedValueItemIds = new ArrayList<Long>();
        HashSet<Long> needFetchDataConfigs = new HashSet<Long>(this.retrievalConfigMap.keySet());
        this.printDimLog();
        long time = System.currentTimeMillis();
        int roundCounter = 0;
        while (!needFetchDataConfigs.isEmpty()) {
            ++roundCounter;
            List<Long> removeConfigs = this.roundRetrievalData(queriedValueItemIds, needFetchDataConfigs);
            needFetchDataConfigs.removeAll(removeConfigs);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("retrieval roundCounter:{}, removeConfigs.size:{}, {}", new Object[]{roundCounter, removeConfigs.size(), removeConfigs});
            }
            if (removeConfigs.size() != 0 || needFetchDataConfigs.size() <= 0) continue;
            String configName = needFetchDataConfigs.stream().map(id -> {
                DynamicObject config = this.retrievalConfigMap.get(id);
                return config.getString("name") + "_" + config.getString("number");
            }).collect(Collectors.joining("\u3011\u3010"));
            LOGGER.warn("retrieval dead round, roundCounter: {}, needFetchDataConfigs configName: {}", (Object)roundCounter, (Object)configName);
            String message = ResManager.loadKDString((String)"\u53d6\u6570\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3010{0}\u3011\u3002", (String)"RetrievalService_6", (String)"wtc-wtbd-business", (Object[])new Object[]{configName});
            throw new KDBizException(message);
        }
        this.printDimLog();
        for (RetrievalDimension dim : this.dims) {
            this.cacheDimension(dim);
        }
        LOGGER.info("retrieval done. time: {}, concurrent: {}", (Object)(System.currentTimeMillis() - time), (Object)this.mcConfig.isConcurrentRetrieval());
    }

    protected void retrievalDataFromDatabase(DynamicObject config) {
        this.retrievalDataFromDatabaseService.retrievalDataFromDatabase(config);
    }

    protected void retrievalDataFromContext(DynamicObject config) {
    }

    private void uniformDataType() {
        if (this.unicodeDataTypeMap == null) {
            this.unicodeDataTypeMap = new HashMap<String, WTCDataTypeEnum>(16);
        }
        for (String unicode : this.needRetrievalItemUnicodeIdMap.keySet()) {
            WTCDataTypeEnum dataType;
            String type;
            DynamicObject item = this.retrievalItemMap.get(unicode);
            switch (type = item.getString("type")) {
                case "string": {
                    dataType = WTCDataTypeEnum.TEXT;
                    break;
                }
                case "dynamicObject": {
                    dataType = WTCDataTypeEnum.NUM;
                    break;
                }
                case "enum": {
                    dataType = WTCDataTypeEnum.TEXT;
                    break;
                }
                case "date": {
                    dataType = WTCDataTypeEnum.DATE;
                    break;
                }
                case "number": {
                    dataType = WTCDataTypeEnum.NUM;
                    break;
                }
                case "boolean": {
                    dataType = WTCDataTypeEnum.BOOLEAN;
                    break;
                }
                case "array": {
                    dataType = WTCDataTypeEnum.ARRAY_OBJECT;
                    break;
                }
                default: {
                    String message = ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u3010{0}_{1}\u3011\u4e3a\u65e0\u6548\u6570\u636e\u7c7b\u578b\u3002", (String)"RetrievalService_4", (String)"wtc-wtbd-business", (Object[])new Object[]{item.getString("name"), item.getString("number")});
                    throw new KDBizException(message);
                }
            }
            this.unicodeDataTypeMap.put(unicode, dataType);
        }
    }

    public Map<String, WTCDataTypeEnum> getUnicodeTypes() {
        return this.unicodeDataTypeMap;
    }

    public Set<String> getConfigRetrievalItem() {
        return Collections.unmodifiableSet(this.needRetrievalItemUnicodeIdMap.keySet());
    }
}

