/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.rulecondition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionEvent;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin;
import kd.sdk.wtc.wtbs.common.access.ConditionDtoExt;
import kd.sdk.wtc.wtes.business.tie.core.chain.PreLimitCondition;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchService;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchType;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.rulecondition.IRuleConditionMatchService;
import kd.wtc.wtbs.business.rulecondition.RuleConditionResultMatchService;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.RuleConditionStandardRetrieval;
import kd.wtc.wtbs.business.rulecondition.ThreeFunction;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.business.util.ext.ConditionDtoExtBridge;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.business.util.ext.PreLimitConditionQueryHelper;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RuleConditionMatchService
implements IRuleConditionMatchService {
    private static final Log LOG = LogFactory.getLog(RuleConditionMatchService.class);
    private static final Map<String, Object> EXTPLUGINMAP = Maps.newHashMapWithExpectedSize((int)1);

    public void matchRuleCondition(List<RuleConditionRetrieval> retrievals) {
        LOG.info("RuleConditionMatchService.matchRuleCondition begin");
        this.retrieval(retrievals);
        for (RuleConditionRetrieval retrieval : retrievals) {
            List conditionList;
            AccessDto accessDto;
            if (!retrieval.isNeedExecuteMatch() || (accessDto = retrieval.getAccessDto()) == null || WTCCollections.isEmpty((Collection)(conditionList = accessDto.getConditionList()))) continue;
            HashMap matchResultMap = Maps.newHashMapWithExpectedSize((int)conditionList.size());
            Map paramResultMap = retrieval.getParamResultMap();
            Map paramValueMap = retrieval.getParamValueMap();
            for (ConditionDto conditionDto : conditionList) {
                String paramKey = conditionDto.getParam();
                String paramType = conditionDto.getParamType();
                String retrievalWay = conditionDto.getRetrievalWay();
                String name = conditionDto.getName();
                Boolean result = (Boolean)paramResultMap.get(RuleConditionCommonService.getConditionParamUniqueKey((ConditionDto)conditionDto));
                if (RetrievalTypeEnum.CUSTOM.getValue().equals(retrievalWay) || result != null) {
                    matchResultMap.put(name, result);
                    continue;
                }
                ThreeFunction func = RuleConditionResultMatchService.getParamMatchFunc((String)paramType);
                if (func != null) {
                    Object value = paramValueMap.get(paramKey);
                    func.apply((Object)conditionDto, value, (Object)matchResultMap);
                    continue;
                }
                matchResultMap.put(name, true);
            }
            boolean matchResult = RuleConditionResultMatchService.getMatchResult((String)accessDto.getConditionExpressStr(), (Map)matchResultMap);
            retrieval.setMatchResult(matchResult);
        }
    }

    private void retrieval(List<RuleConditionRetrieval> retrievals) {
        HashSet uniqueCodes = Sets.newHashSetWithExpectedSize((int)retrievals.size());
        ArrayList<RuleConditionRetrieval> retrievalList = new ArrayList<RuleConditionRetrieval>(retrievals.size());
        int genDimensionKeyLen = 0;
        for (RuleConditionRetrieval retrieval : retrievals) {
            List conditionList;
            if (!retrieval.isNeedExecuteMatch()) continue;
            boolean buildMatchDimension = true;
            List standardRetrievals = retrieval.getStandardRetrievals();
            Map standardRetrievalMap = standardRetrievals.stream().collect(Collectors.toMap(RuleConditionStandardRetrieval::getConditionParamKey, Function.identity(), (o1, o2) -> o2));
            AccessDto accessDto = retrieval.getAccessDto();
            if (accessDto == null || WTCCollections.isEmpty((Collection)(conditionList = accessDto.getConditionList()))) continue;
            for (ConditionDto conditionDto : conditionList) {
                RuleConditionStandardRetrieval standardRetrieval = (RuleConditionStandardRetrieval)standardRetrievalMap.get(conditionDto.getParam());
                String retrievalWay = conditionDto.getRetrievalWay();
                if (RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) {
                    if (buildMatchDimension) {
                        retrievalList.add(retrieval);
                        if (HRStringUtils.isEmpty((String)retrieval.getDimensionKey())) {
                            ++genDimensionKeyLen;
                        }
                        buildMatchDimension = false;
                    }
                    String uniqueCode = conditionDto.getUniqueCode();
                    uniqueCodes.add(uniqueCode);
                    continue;
                }
                if (standardRetrieval == null || RetrievalTypeEnum.CUSTOM.getValue().equals(retrievalWay)) {
                    this.customRetrieval(retrieval, conditionDto);
                    continue;
                }
                this.standardRetrieval(retrieval, conditionDto, standardRetrieval);
            }
        }
        List<RetrievalRuleMatchDimension> matchDimensions = this.buildMatchDimensionList(retrievalList, genDimensionKeyLen);
        LOG.info("RuleConditionMatchService.retrieval\uff0cuniqueCodes.size:{},matchDimensions.size()", (Object)uniqueCodes.size(), (Object)matchDimensions.size());
        this.configRetrieval(retrievals, matchDimensions, uniqueCodes);
    }

    private void configRetrieval(List<RuleConditionRetrieval> retrievals, List<RetrievalRuleMatchDimension> matchDimensions, Set<String> uniqueCodes) {
        LOG.info("RuleConditionMatchService.configRetrieval begin");
        if (WTCCollections.isNotEmpty(matchDimensions)) {
            RetrievalRuleMatchService retrievalService = new RetrievalRuleMatchService();
            retrievalService.addRetrievalDimension(matchDimensions);
            retrievalService.addRetrievalUnicode(uniqueCodes);
            retrievalService.retrievalData();
            Map dimensionResultMap = matchDimensions.stream().collect(Collectors.toMap(RetrievalRuleMatchDimension::getDimensionKey, Function.identity(), (o1, o2) -> o2));
            for (RuleConditionRetrieval retrieval : retrievals) {
                List conditionList;
                String dimensionKey = retrieval.getDimensionKey();
                RetrievalRuleMatchDimension matchDimension = (RetrievalRuleMatchDimension)dimensionResultMap.get(dimensionKey);
                AccessDto accessDto = retrieval.getAccessDto();
                if (accessDto == null || matchDimension == null || WTCCollections.isEmpty((Collection)(conditionList = accessDto.getConditionList()))) continue;
                for (ConditionDto conditionDto : conditionList) {
                    String retrievalWay = conditionDto.getRetrievalWay();
                    if (!RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) continue;
                    String uniqueCode = conditionDto.getUniqueCode();
                    if (matchDimension.isValueExist(uniqueCode)) {
                        Object val = matchDimension.getValue(uniqueCode);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("RuleConditionMatchService.configRetrieval,\u53c2\u6570\uff1a{}\uff0c\u53c2\u6570\u6807\u8bc6\uff1a{}\uff0c\u53d6\u6570\u7ed3\u679c\uff1a{}", new Object[]{conditionDto.getDisplayParam(), conditionDto.getParam(), val});
                        }
                        retrieval.addParamValue(conditionDto.getParam(), val);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("RuleConditionMatchService.configRetrieval,\u53c2\u6570\uff1a{}\u6ca1\u6709\u53d6\u5230\u6570\u636e\uff0c\u9ed8\u8ba4\u7ed3\u679c\u4e3atrue", (Object)conditionDto.getParam());
                    }
                    retrieval.addParamResult(conditionDto.getParam(), null);
                }
            }
        }
    }

    private void standardRetrieval(RuleConditionRetrieval retrieval, ConditionDto conditionDto, RuleConditionStandardRetrieval standardRetrieval) {
        if (standardRetrieval != null) {
            Function retrievalFunc;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RuleConditionMatchService.standardRetrieval standardRetrieval is not null");
            }
            if ((retrievalFunc = standardRetrieval.getRetrievalFunc()) != null) {
                Object value = retrievalFunc.apply(standardRetrieval.getRetrievalObj());
                retrieval.addParamValue(conditionDto.getParam(), value);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RuleConditionMatchService.standardRetrieval,paramName:{},paramKey:{},paramValue:{}", new Object[]{conditionDto.getDisplayParam(), conditionDto.getName(), value});
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionMatchService.standardRetrieval standardRetrieval is null");
        }
        retrieval.addParamResult(RuleConditionCommonService.getConditionParamUniqueKey((ConditionDto)conditionDto), Boolean.valueOf(true));
    }

    private void customRetrieval(RuleConditionRetrieval retrieval, ConditionDto conditionDto) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionMatchService.customRetrieval begin");
        }
        if (UnifyBillEnum.OT.name().equals(retrieval.getBillBusType())) {
            this.otCustomRetrieval(retrieval, conditionDto);
        }
    }

    private void otCustomRetrieval(RuleConditionRetrieval retrieval, ConditionDto conditionDto) {
        boolean cusMatchResult = true;
        LimitConditionExpBundle expDataBundle = retrieval.getExpDataBundle();
        if (expDataBundle == null) {
            expDataBundle = (LimitConditionExpBundle)EXTPLUGINMAP.get(retrieval.getBillBusType());
        }
        if (expDataBundle != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RuleConditionMatchService.customRetrieval otCustomRetrieval \u5b58\u5728\u57cb\u70b9");
            }
            expDataBundle = new LimitConditionExpBundle(expDataBundle.getLimitSource(), expDataBundle.getPluginProxy(), Long.valueOf(retrieval.getAttFileVId()));
            WTCPluginProxy pluginProxy = expDataBundle.getPluginProxy();
            Object extData = retrieval.getExtData();
            if (pluginProxy != null && pluginProxy.hasPlugin() && extData instanceof AttfileLimitScope) {
                OnLimitConditionEvent onLimitConditionEvent = new OnLimitConditionEvent(expDataBundle.getLimitSource(), Long.valueOf(retrieval.getAttFileVId()), (PreLimitCondition)new PreLimitConditionQueryHelper((AttfileLimitScope)extData), (ConditionDtoExt)new ConditionDtoExtBridge(conditionDto));
                pluginProxy.invokeReplace(locationService -> locationService.onLimitConditionEvent(onLimitConditionEvent));
                cusMatchResult = onLimitConditionEvent.getResult();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RuleConditionMatchService.customRetrieval otCustomRetrieval \u57cb\u70b9\u7ed3\u679c\uff1a{}", (Object)cusMatchResult);
                }
            }
        }
        retrieval.addParamResult(RuleConditionCommonService.getConditionParamUniqueKey((ConditionDto)conditionDto), Boolean.valueOf(cusMatchResult));
    }

    private List<RetrievalRuleMatchDimension> buildMatchDimensionList(List<RuleConditionRetrieval> retrievalList, int genDimensionKeyLen) {
        ArrayList<RetrievalRuleMatchDimension> matchDimensions = new ArrayList<RetrievalRuleMatchDimension>(retrievalList.size());
        if (WTCCollections.isNotEmpty(retrievalList)) {
            long[] ids = new long[]{};
            if (genDimensionKeyLen > 0) {
                ids = ID.genLongIds((int)genDimensionKeyLen);
            }
            for (int index = 0; index < retrievalList.size(); ++index) {
                RuleConditionRetrieval retrieval = retrievalList.get(index);
                if (HRStringUtils.isEmpty((String)retrieval.getDimensionKey()) && index < ids.length) {
                    retrieval.setDimensionKey(String.valueOf(ids[index]));
                }
                RetrievalRuleMatchDimension matchDimension = this.buildMatchDimension(retrieval);
                matchDimensions.add(matchDimension);
            }
        }
        return matchDimensions;
    }

    private RetrievalRuleMatchDimension buildMatchDimension(RuleConditionRetrieval retrieval) {
        RetrievalRuleMatchDimension matchDimension = new RetrievalRuleMatchDimension();
        matchDimension.setAttPersonId(retrieval.getAttPersonId());
        matchDimension.setAttFileBoId(retrieval.getAttFileBoId());
        matchDimension.setAttFileId(retrieval.getAttFileVId());
        matchDimension.setEmployeeBoId(retrieval.getEmployeeId());
        matchDimension.setPersonBoId(retrieval.getPersonId());
        matchDimension.setDepempBoId(retrieval.getDempempId());
        matchDimension.setOwnDate(retrieval.getOwnDate());
        matchDimension.setContext(retrieval.getBillDy());
        matchDimension.setType(RetrievalRuleMatchType.entry);
        matchDimension.setEntryKey(retrieval.getEntryKey());
        matchDimension.setIndex(retrieval.getIndex());
        matchDimension.setDimensionKey(retrieval.getDimensionKey());
        return matchDimension;
    }

    static {
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(OnLimitConditionExpPlugin.class, (String)"kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin");
        LimitConditionExpBundle dataBundle = new LimitConditionExpBundle(UnifyBillEnum.OT.name(), pluginProxy, null);
        EXTPLUGINMAP.put(UnifyBillEnum.OT.name(), dataBundle);
    }
}

