/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.scenecfg;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.scenecfg.SceneCfgHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class EntityFieldTreeBuilder {
    private EntityMetadata entityMetadata;
    private MainEntity rootEntity;
    private Map<String, String> entityMap;

    public EntityFieldTreeBuilder(EntityMetadata entityMetadata) {
        this.entityMetadata = entityMetadata;
        this.entityMetadata.createIndex();
        this.rootEntity = this.entityMetadata.getRootEntity();
        this.entityMap = SceneCfgHelper.queryInputEntityNumber(Lists.newArrayList());
    }

    public TreeNode build() {
        TreeNode root = this.buildRootNode();
        for (Entity entity : this.entityMetadata.getEntitys()) {
            if (!(entity instanceof MainEntity)) continue;
            this.buildEntityAndFields(entity, root);
        }
        return root;
    }

    private TreeNode buildRootNode() {
        String text;
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(this.rootEntity.getKey());
        root.setIsOpened(true);
        root.setData((Object)this.rootEntity.getId());
        if (!CollectionUtils.isEmpty(this.entityMap)) {
            text = this.entityMap.get(this.rootEntity.getKey());
            if (HRStringUtils.isEmpty((String)text)) {
                text = this.rootEntity.getName().toString();
            }
        } else {
            text = this.rootEntity.getName().toString();
        }
        root.setText(text);
        root.setLongText(root.getText());
        return root;
    }

    private void buildEntityAndFields(Entity<?, ?> entity, TreeNode root) {
        TreeNode entityNode = this.buildEntityNode(entity);
        String entityText = null;
        List<String> supportFieldKeys = SceneCfgHelper.queryCfgFieldKeysByObj(entity.getKey());
        List supportItems = entity.getItems().stream().filter(item -> supportFieldKeys.contains(item.getKey())).collect(Collectors.toList());
        for (EntityItem entityItem : supportItems) {
            if (!(entityItem instanceof Field)) continue;
            TreeNode mulBDFldNode = this.buildFieldNode(entityItem, entityNode, entityText);
            entityNode.addChild(mulBDFldNode);
        }
        root.addChild(entityNode);
    }

    private TreeNode buildFieldNode(EntityItem<?> field, TreeNode parentNode, String parentText) {
        TreeNode node = new TreeNode();
        node.setParentid(parentNode.getId());
        node.setId(field.getKey());
        node.setData((Object)field.getId());
        node.setType(field.getClass().getSimpleName());
        node.setText(field.getName().toString() + "(" + field.getKey() + ")");
        String longText = node.getText();
        if (HRStringUtils.isNotEmpty((String)parentText)) {
            longText = parentText + "." + longText;
        }
        node.setLongText(longText);
        return node;
    }

    private TreeNode buildEntityNode(Entity<?, ?> entity) {
        TreeNode entityNode = new TreeNode();
        if (entity instanceof MainEntity) {
            entityNode.setParentid(this.rootEntity.getKey());
            entityNode.setId("_headNode_");
            entityNode.setData((Object)this.rootEntity.getId());
            entityNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeBuilder_01", (String)"wtc-wtbd-business", (Object[])new Object[0]));
            entityNode.setLongText(entityNode.getText());
        }
        return entityNode;
    }
}

