/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.business.scenecfg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class SceneCfgHelper {
    private SceneCfgHelper() {
    }

    public static Map<String, String> queryInputEntityNumber(List<String> exNumberList) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        QFilter qFilter = new QFilter("category", "=", (Object)"2");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,name,belongobj", qFilter.toArray());
        return Arrays.stream(dynamicObjects).filter(item -> !exNumberList.contains(item.getString("belongobj"))).collect(Collectors.toMap(item -> item.getString("belongobj"), item -> item.getString("name")));
    }

    public static Map<String, String> queryCfgFieldByObj(String entityNumber) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        QFilter qFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        qFilter.and("category", "=", (Object)"1");
        qFilter.and("belongobj", "=", (Object)entityNumber);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,belongobj,type", qFilter.toArray());
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(item -> item.getString("number"), item -> item.getString("type"), (o1, o2) -> o2));
    }

    public static List<String> queryCfgFieldKeysByObj(String entityNumber) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        QFilter qFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        qFilter.and("belongobj", "=", (Object)entityNumber);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,belongobj,type", qFilter.toArray(), "index asc");
        return Arrays.stream(dynamicObjects).map(item -> item.getString("number")).collect(Collectors.toList());
    }

    public static List<DynamicObject> queryCfgFieldByParentId(long parentId) {
        QFilter qFilter = new QFilter("parent", "=", (Object)parentId);
        qFilter.and("isleaf", "=", (Object)Boolean.TRUE);
        qFilter.and("category", "=", (Object)"1");
        qFilter.or("id", "=", (Object)parentId);
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        Object[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,name,belongobj,isleaf", qFilter.toArray());
        return Lists.newArrayList((Object[])dynamicObjects);
    }

    public static DynamicObject querySceneRuleCfgById(Long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_scenerulecfg");
        return serviceHelper.queryOriginalOne("id,name,number,issyspreset", (Object)pkId);
    }

    public static DynamicObject queryFieldCfgById(long pkId) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        return serviceHelper.queryOriginalOne("id,name,number,belongobj,category,issyspreset", (Object)pkId);
    }

    public static DynamicObject querySceneUseCfgById(long pkId) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_sceneusecfg");
        return serviceHelper.queryOriginalOne("id,name,number,issyspreset", (Object)pkId);
    }

    public static List<DynamicObject> queryRetrievalItemByCode(List<String> unicodes) {
        QFilter qFilter = new QFilter("uniquecode", "in", unicodes);
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");
        Object[] dynamicObjects = serviceHelper.queryOriginalArray("id,way,uniquecode", qFilter.toArray());
        return Lists.newArrayList((Object[])dynamicObjects);
    }
}

